
class MyTable
{
private:
  UINT MyID; // My Chord ID
  UINT Predecessor; // My Predecessor node
  UINT Finger[LOGN]; // Finger Table entries...
  // Finger[i] stores the first existing node starting from MyID + pow(2,i)
  // Finger[0] == MySuccessor

public:

  MyTable(UINT id, UINT helper_id)
  {
    MyID = id;
    Predecessor = helper_id;
    for(int i=0;i < LOGN; i++)
	    Finger[i] = helper_id;
  }

  UINT GetSuccessor()
  {
    return Finger[0];
  }

  UINT GetMyID()
    {
      return MyID;
    }

  UINT GetFinger(int k)
  {
	  if(k < LOGN)
	  	return Finger[k];
	  return 0;
  }
  UINT GetPredecessor()
    {
      return Predecessor;
    }

  void SetFinger(int index, UINT id);

  void SetPredecessor(UINT id);

  void UpdatePredecessor(UINT newpred);

  UINT GetNextHop(UINT id);
  UINT GetClosestPrecedingFinger(UINT id);

  void ReplaceFingerEntries(UINT prev, UINT replacement)
  {
	  if(Predecessor == prev)
		  Predecessor = replacement;
	  for(int i=0;i < LOGN;i++)
		  if(Finger[i] == prev)
			  Finger[i] = replacement;
  }

  void print(int);
};

MyTable *mytable; // My Global Finger Table Object


