// D.Cook 1/03
// added for SOSHelper function - interface to route_module
//#define RTE_MOD_PORT 3456
// ----- end of changes

struct location
{
	UINT id;
	struct in_addr ip;
	in_port_t port;
};


struct Query
{
	// The original sender of this query
	// If I have the answer to this query then I will respond to OrigSrc, else I'll send the query to the appropriate node
	struct location OrigSrc;
	
	// Myself, when I am sending the packet, or the previous hop when I recieve the packet
	struct location From;
	
	// Next Hop or myself when I'm recieving this packet
	struct location To;

	// Final Destination for this packet
	// Usually the ip and port in this wont be filled because the OrigSrc doesn't know them,
	// otherwise it could've sent the packet directly
	struct location FinalDst;

	// QueryID: unique for a query for a node
	UINT QueryID;
	// Type of query
	UINT QueryType;
	
	struct location QueryData;
	struct location ResponseData;
};


void SendQueryData(struct Query q);

void ForwardPacket(struct Query *q_response);

void HandleResponse(struct Query *q_response);

void HandleQuery(struct Query *query);

void *RecvThread(void *arg);

struct Query MakeStandardQuery(UINT to, UINT finaldst, int QueryType);

struct Query SendQueryAndGetResponse(struct Query query);

UINT Remote_AskPredecessor(UINT helper_id);

void Remote_Notify(UINT successor);

