#!/usr/bin/perl

#/*
#---------------------------------------------------
# * Angelos Stavrou 09/03
# * Columbia University Computer Science Department
# * All Rights Reserved
#---------------------------------------------------
#*/
# Modified from the Original Version
# sosctl.pl - used to start and stop WebSOS
# 
# Bill Morein (wgm2001@columbia.edu)
# Last Update: 3/14/2003
#
# ignores the pids for now and just uses killall.  Not optimal but I was having
# problems with the pids not recording the master pid and thus not killing all
# the right processes


# simple, but is overkill
if ($ARGV[0] eq "stop") {
    `killall java`;
    `killall sos-chord`;
}

# if we did not get a stop, we need two or three arguments

# start the processes
# the classpath is set up to have sosProxy in the sosProxy directory

else {
    if ($#ARGV < 3){
	print (
"Usage: 
 To Start the Network we issue:
./sosctl <BootStrap IP ADDR> <BootStrap Port> <targets file|empty file> <Node name e.g sos30.cs.columbia.edu> <Node Port>\n
Please be carefull to give the bootstrap IP Address not the name.
For the first node joining the P2P network give its own ip address as <BootStrap IP ADDR>
Also targets contains the IP Addresses of the hosts we are the secret servlet.\n

 To Stop the Network we issue: ./sosctl stop \n\n");
     exit(0);
     }
    $bootstrap = $ARGV[0];
    $remote_port = $ARGV[1];
    $targets = $ARGV[2];
    $local_name = $ARGV[3];
    $chord_port = $ARGV[4];
    
    my @addr = split(/ /,`host $local_name`);
    my $local_ip = $addr[3];
    chop($local_ip);
    print "$local_name:$local_ip\n";
    # start chord
    $out = `chord/sos-chord $local_ip:$chord_port -j $bootstrap:$remote_port > /dev/null 2>&1 &`;
    print("waiting for chord to start\n");
    sleep(3);
    print("done waiting\n");

    $out = `/usr/java/j2sdk1.4.2_01/bin/java -classpath $CLASSPATH:.:routing/ ShortcutRouter $chord_port $local_name $local_ip $targets> output.chord 2>&1 &`;

    print "done\n";
}
