 /*
  * (C) 2003-2004 Columbia University Departments of Computer Science and
  * Electrical Engineering
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, is permitted provided the original authors give
  * written consent and the following conditions are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above
  *    copyright notice, this list of conditions and the following
  *    disclaimer in the documentation and/or other materials
  *    provided with the distribution.
  *
  * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND
  * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
  * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
  * OF SUCH DAMAGE.
  */
/**
 * Shortcut is used in the version of WebSOS in which the SOAP connects
 * directly to the servlet. This is used to send the UDP messages
 * that contain the requests for servlet information.
 *
 * Part of WebSOS
 *
 * @author     Bill Morein
 * @version    3/9/03
 */

import java.io.*;
import java.net.*;
import java.util.*;

public class ShortcutSender {

    public static final int REQUEST_CODE = 0;
    public static final int RESPONSE_CODE = 1;
    public static final int SERVLET_CODE = 2;

    DatagramSocket socket;

    public ShortcutSender() {
        try {
            socket = new DatagramSocket();
        }
        catch (IOException e) {
            System.err.println("Unable to open socket, exiting: " + e);
            System.exit(0);
        }
    }


    public void sendRequest(String target, String nextIP, int nextPort,
                            String requesterIP, int requesterPort) {
        try {
        InetAddress nextAddr = InetAddress.getByName(nextIP);
        String send = REQUEST_CODE + "," + target + "," +
                      requesterIP + ":" + requesterPort;
        byte[] buf = send.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length,
                                                   nextAddr, nextPort);
        socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }


    public void sendResponse(String servletIP,int servletPort, String targetIP,
                             String requesterIP, int requesterPort) {
        try {
        InetAddress requesterAddr = InetAddress.getByName(requesterIP);
        String send = RESPONSE_CODE + "," + servletIP + ":" + servletPort +
                      "," + targetIP;
        byte[] buf = send.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length,
                                                 requesterAddr, requesterPort);
        socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }

    }

    public void sendServletAnnounce(String servletIP, int servletPort,
                                    String targetIP, String nextIP,
                                    int nextPort) {
        try {
        InetAddress nextAddr = InetAddress.getByName(nextIP);
        String send = SERVLET_CODE + "," + servletIP + ":" + servletPort +
                      "," + targetIP;
        byte[] buf = send.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length,
                                                 nextAddr, nextPort);
        socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }


    /* just for testing */
    public static void main(String[] args) {
        ShortcutSender ss = new ShortcutSender();
        ss.sendRequest("theTarget", "localhost", 4445,
                       "disco.cs.columbia.edu", 4445);
        ss.sendRequest("www.yahoo.com", "localhost", 4445,
                       "disco.cs.columbia.edu", 4445);

        ss.sendResponse("www.serv.com", 1234, "www.target.com", "localhost", 4445);
        ss.sendResponse("www.serv.com", 1234, "www.target2.com", "localhost", 4445);
        ss.sendResponse("www.servlet.com", 1234, "www.target.com", "localhost", 4445);
        ss.sendServletAnnounce("announcedServelet", 1234, "www.announce.com", "localhost", 4445);

    }



}
