

// Hash Table to store chordID to IP:port mappings



struct mapping
{
	UINT id;
	struct in_addr sin_addr;
	in_port_t sin_port;
	struct mapping *next;
};

#define MAX_HASH 100
class HashTable
{
	// The hash table key would be the chord ID
	// and this will be an open hash table
	struct mapping *Hash[MAX_HASH];

public:
	HashTable()
	{
		for(int i=0;i<MAX_HASH;i++)
			Hash[i] = NULL;
	}

	int hash(UINT id);

	void Delete(UINT id);
	UINT FindLowestNode();

	void GetIPFromID(UINT id, char resultIP[]);
	UINT GetIDFromIP(char inputIP[]);
	
	void Update(UINT id, struct in_addr ip, in_port_t port);
	void Update(struct location);

	struct in_addr strTOip(char *IPStr);
	in_port_t strTOport(char *PortStr);
	
	UINT ParseAndAddLocation(char *str);
	struct location GetLocation(UINT);
};

HashTable *hashtable;
