/***************************************************************************
 *  Copyright (C) 2004 Michael E. Locasto
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the:
 *       Free Software Foundation, Inc.
 *       59 Temple Place, Suite 330 
 *       Boston, MA  02111-1307  USA
 *
 * $Id$
 **************************************************************************/
package locasto.test;

import jdbcrand.Keywords;
import locasto.prompt.Prompt;
import locasto.prompt.PromptDataListener;

/**
 *
 * @author mlocasto@acm.org
 */
public class FindTest
   implements PromptDataListener
{

   /**
    * A handle to our prompt.
    */
   private Prompt m_prompt = null;

   //------------------------------------------------------------- methods

   public void init()
   {
      m_prompt = new Prompt(false,"exit","find-keyword> ");
      m_prompt.addPromptDataListener(((PromptDataListener)this));
   }

   public void shutDown()
   {
      if(null!=m_prompt)
         m_prompt.shutdown();
      System.exit(0);
   }

   //---------------------------------------- interface PromptDataListener

   public void processPromptData(String data)
   {
      if("exit".equalsIgnoreCase(data))
         return;
      data = data.trim();

      String result = Keywords.find(data);
      System.out.println(result);
   }

   public void stopProcessingPromptData()
   {
      shutDown();
   }

   //------------------------------------------------------ private

   /**
    * Spit out a usage message.
    */
   private static void doUsage()
   {
      System.err.println("java locasto.test.FindTest");
   }

   /**
    * 
    */
   public static void main(String [] args)
   {
      FindTest application = null;

      if(args.length==0)
      {
         try{
            application = new FindTest();
            application.init();
         }catch(Exception ex){
            System.err.println("("
                               +ex.getClass().getName()
                               +") occurred. Message = "
                               +ex.getMessage());
            application.shutDown();
            System.exit(-2);
         }

      }else{
         doUsage();
         System.exit(-1);
      }

   }
}


