/***************************************************************************
 *  Copyright (C) 2004 Michael E. Locasto
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the:
 *       Free Software Foundation, Inc.
 *       59 Temple Place, Suite 330 
 *       Boston, MA  02111-1307  USA
 *
 * $Id: PromptDataListener.java,v 1.2 2004/08/30 14:56:02 locasto Exp $
 **************************************************************************/
package locasto.prompt;

/** 
 * A listener interface for processing data received from a command prompt.
 * 
 * @author mlocasto@acm.org
 */
public interface PromptDataListener{

   /**
    * Deliver notification of data received at the command prompt.
    *
    * @param  data  the input from the command line
    */
    public void processPromptData(String data);

   /**
    * A callback to let the listener know that it shouldn't block
    * waiting for any more data from the prompt. Basically, the prompt
    * expects that it is going to shut itself down after notifying all
    * its listeners by calling this method.
    */
   public void stopProcessingPromptData();
}
