/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.core.PGStream;
import org.postgresql.jdbc3g.Jdbc3gConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLDriverVersion;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    public static boolean logDebug = false;
    public static boolean logInfo = false;
    private static final Object[][] knownProperties;
    public static final int MAJORVERSION = 8;
    public static final int MINORVERSION = 0;
    private static String[] protocols;

    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = this.parseURL(url, info);
        if (props == null) {
            if (logDebug) {
                Driver.debug("Error in url" + url);
            }
            return null;
        }
        System.out.println("SQL randomization key is: " + this.getSQLRandomizationKey(props));
        try {
            if (logDebug) {
                Driver.debug("connect " + url);
            }
            return new Jdbc3gConnection(this.host(props), this.port(props), this.user(props), this.database(props), props, url);
        }
        catch (PSQLException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            if (logDebug) {
                Driver.debug("error", ex2);
            }
            throw new PSQLException(GT.tr("Something unusual has occured to cause the driver to fail. Please report this exception."), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        this.parseURL(url, copy);
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < knownProperties.length; ++i) {
            String name = (String)knownProperties[i][0];
            props[i] = new DriverPropertyInfo(name, copy.getProperty(name));
            props[i].required = (Boolean)knownProperties[i][1];
            props[i].description = (String)knownProperties[i][2];
            if (knownProperties[i].length <= 3) continue;
            props[i].choices = (String[])knownProperties[i][3];
        }
        return props;
    }

    public int getMajorVersion() {
        return 8;
    }

    public int getMinorVersion() {
        return 0;
    }

    public static String getVersion() {
        return "PostgreSQL 8.0devel JDBC3g with SSL (build " + PSQLDriverVersion.buildNumber + ")";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        int ipv6start = l_urlServer.indexOf("[");
        int ipv6end = l_urlServer.indexOf("]");
        String ipv6address = null;
        if (ipv6start != -1 && ipv6end > ipv6start) {
            ipv6address = l_urlServer.substring(ipv6start + 1, ipv6end);
            l_urlServer = l_urlServer.substring(0, ipv6start) + "ipv6host" + l_urlServer.substring(ipv6end + 1);
        }
        StringTokenizer st = new StringTokenizer(l_urlServer, ":/", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    for (int tmp = 0; tmp < protocols.length; ++tmp) {
                        if (!token.equals(protocols[tmp]) || count != 2 || tmp <= 0) continue;
                        urlProps.put("Protocol", token);
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.put("PGDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.put("PGHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.put("PGPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.put("PGDBNAME", token);
                        state = -2;
                    }
                }
            }
            ++count;
        }
        if (count <= 1) {
            return null;
        }
        if (ipv6address != null) {
            urlProps.put("PGHOST", ipv6address);
        }
        StringTokenizer qst = new StringTokenizer(l_urlArgs, "&");
        count = 0;
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.put(token, "");
            } else {
                urlProps.put(token.substring(0, l_pos), token.substring(l_pos + 1));
            }
            ++count;
        }
        return urlProps;
    }

    public String host(Properties props) {
        return props.getProperty("PGHOST", "localhost");
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PGPORT", "5432"));
    }

    public String user(Properties props) {
        return props.getProperty("user");
    }

    public String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    public String getSQLRandomizationKey(Properties props) {
        return props.getProperty("SQLRandomizationKey", "");
    }

    public static SQLException notImplemented() {
        return new PSQLException(GT.tr("This method is not yet implemented."), PSQLState.NOT_IMPLEMENTED);
    }

    public static void setLogLevel(int logLevel) {
        logDebug = logLevel >= 2;
        logInfo = logLevel >= 1;
    }

    public static void debug(String msg) {
        if (logDebug) {
            DriverManager.println(msg);
        }
    }

    public static void debug(String msg, Exception ex) {
        if (logDebug) {
            DriverManager.println(msg);
            if (ex != null) {
                DriverManager.println(ex.toString());
            }
        }
    }

    public static void info(String msg) {
        if (logInfo) {
            DriverManager.println(msg);
        }
    }

    public static void info(String msg, Exception ex) {
        if (logInfo) {
            DriverManager.println(msg);
            if (ex != null) {
                DriverManager.println(ex.toString());
            }
        }
    }

    public static void makeSSL(PGStream p_stream) throws IOException {
        if (logDebug) {
            Driver.debug("converting regular socket connection to ssl");
        }
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket newConnection = factory.createSocket(p_stream.getSocket(), p_stream.getHost(), p_stream.getPort(), true);
        p_stream.changeSocket(newConnection);
    }

    public static boolean sslEnabled() {
        boolean l_return = false;
        l_return = true;
        return l_return;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        knownProperties = new Object[][]{{"PGDBNAME", Boolean.TRUE, "Database name to connect to; may be specified directly in the JDBC URL."}, {"user", Boolean.TRUE, "Username to connect to the database as.", null}, {"PGHOST", Boolean.FALSE, "Hostname of the PostgreSQL server; may be specified directly in the JDBC URL."}, {"PGPORT", Boolean.FALSE, "Port number to connect to the PostgreSQL server on; may be specified directly in the JDBC URL."}, {"password", Boolean.FALSE, "Password to use when authenticating."}, {"protocolVersion", Boolean.FALSE, "Force use of a particular protocol version when connecting; if set, disables protocol version fallback."}, {"ssl", Boolean.FALSE, "Control use of SSL; any nonnull value causes SSL to be required."}, {"SQLRandomizationKey", Boolean.FALSE, "Control use of SQL randomization. By providing a value for this parameter, randomization is turned on."}, {"logLevel", Boolean.FALSE, "Control the driver's log verbosity: 0 is off, 1 is INFO, 2 is DEBUG.", new String[]{"0", "1", "2"}}, {"prepareThreshold", Boolean.FALSE, "Default statement prepare threshold (numeric)."}, {"charSet", Boolean.FALSE, "When connecting to a pre-7.3 server, the database encoding to assume is in use."}, {"compatible", Boolean.FALSE, "Force compatibility of some features with an older version of the driver.", new String[]{"7.1", "7.2", "7.3"}}};
        protocols = new String[]{"jdbc", "postgresql"};
    }
}

