/*-------------------------------------------------------------------------
 *
 * PSQLException.java
 *     This class extends SQLException, and provides our internationalisation
 *     handling
 *
 * Copyright (c) 2003, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *	  $PostgreSQL: pgsql-server/src/interfaces/jdbc/org/postgresql/util/PSQLException.java,v 1.14 2003/11/29 19:52:11 pgsql Exp $
 *
 *-------------------------------------------------------------------------
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.IOException;
import java.sql.SQLException;
import org.postgresql.Driver;

public class PSQLException extends SQLException
{

	public PSQLException(String msg, PSQLState state, Throwable cause)
	{
		super(addCauseToMessage(msg, cause), state == null ? null : state.getState());                
		initCause(cause); // Calls either the 1.4 Throwable impl or our impl below.
		if (Driver.logDebug)
			Driver.debug("Exception: " + this);
		
	}

	public PSQLException(String msg)
	{
		this(msg, null, null);
	}
	
	public PSQLException(String msg, PSQLState state)
	{
		this(msg, state, null);
	}
	
	private static String addCauseToMessage(String msg, Throwable cause) {
		boolean hasInitCause = true;
//	hasInitCause = false;
		if (!hasInitCause && cause != null) {
			try {
				ByteArrayOutputStream baos = new ByteArrayOutputStream();
				PrintWriter pw = new PrintWriter(baos);
				pw.println();
				pw.println(GT.tr("Exception: {0}", cause.toString()));
				pw.println(GT.tr("Stack Trace:"));
				cause.printStackTrace(pw);
				pw.println(GT.tr("End of Stack Trace"));
				pw.flush();
				msg = msg + baos.toString();
				pw.close();
				baos.close();
			} catch (IOException ioe) {
				msg = msg + GT.tr("Exception generating stacktrace for: {0} encountered: {1}", new Object[] { cause.toString(), ioe.toString() });
			}
		}
		return msg;
	}
	
		// Dummy initCause() for pre-1.4 JVMs
//	public void initCause(Throwable cause) {}


}
