package org.postgresql.test.jdbc3;

import org.postgresql.jdbc3.Jdbc3ConnectionPool;
import org.postgresql.jdbc3.Jdbc3PooledConnection;
import org.postgresql.test.TestUtil;
import org.postgresql.test.jdbc2.optional.ConnectionPoolTest;
import java.sql.SQLException;

import javax.sql.PooledConnection;

/**
 * Tests JDBC3 implementation of ConnectionPoolDataSource.
 *
 * @author Aaron Mulder (ammulder@chariotsolutions.com)
 * @version $Revision: 1.4 $
 */
public class Jdbc3ConnectionPoolTest extends ConnectionPoolTest
{
    public Jdbc3ConnectionPoolTest(String name)
    {
        super(name);
    }

    /**
     * Creates and configures a Jdbc3ConnectionPool
     */
    protected void initializeDataSource()
    {
        if (bds == null)
        {
            bds = new Jdbc3ConnectionPool();
            bds.setServerName(TestUtil.getServer());
            bds.setPortNumber(TestUtil.getPort());
            bds.setDatabaseName(TestUtil.getDatabase());
            bds.setUser(TestUtil.getUser());
            bds.setPassword(TestUtil.getPassword());
        }
    }

    /**
     * Makes sure this is a JDBC 3 implementation producing JDBC3
     * connections.  Depends on toString implementation of
     * connection wrappers.
     */
    public void testConfirmJdbc3Impl() throws SQLException
    {
            initializeDataSource();
            assertTrue("Wrong ConnectionPool impl used by test: " + bds.getClass().getName(), bds instanceof Jdbc3ConnectionPool);
            PooledConnection pc = ((Jdbc3ConnectionPool) bds).getPooledConnection();
            assertTrue("Wrong PooledConnection impl generated by JDBC3 ConnectionPoolDataSource: " + pc.getClass().getName(), pc instanceof Jdbc3PooledConnection);
            assertTrue("Wrong Connnection class used in JDBC3 ConnectionPoolDataSource's PooledConnection impl: " + pc.getConnection().toString(), pc.getConnection().toString().indexOf("Jdbc3") > -1);
            pc.close();
    }
}
