/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private final String creatingURL;
    private final ProtocolConnection protoConnection;
    private final String compatible;
    private final String dbVersionNumber;
    private final String sqlRandomizationKey;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private Hashtable oidTypeCache = new Hashtable();
    private Hashtable typeOidCache = new Hashtable();
    protected int prepareThreshold;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public SQLWarning firstWarning = null;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private final HashMap objectTypes = new HashMap();
    private static final Object[][] defaultObjectTypes = new Object[][]{{"box", PGbox.class}, {"circle", PGcircle.class}, {"line", PGline.class}, {"lseg", PGlseg.class}, {"path", PGpath.class}, {"point", PGpoint.class}, {"polygon", PGpolygon.class}, {"money", PGmoney.class}, {"interval", PGInterval.class}};
    protected DatabaseMetaData metadata;
    static final String[] jdbc2Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "timetz", "abstime", "timestamp", "timestamptz", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea"};
    static final int[] jdbc2Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, -7, 91, 92, 92, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003};

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    protected AbstractJdbc2Connection(String host, int port, String user, String database, Properties info, String url) throws SQLException {
        this.creatingURL = url;
        int logLevel = 0;
        try {
            logLevel = Integer.parseInt(info.getProperty("loglevel", "0"));
            if (logLevel > 2 || logLevel < 1) {
                logLevel = 0;
            }
        }
        catch (Exception l_e) {
            // empty catch block
        }
        if (logLevel > 0) {
            Driver.setLogLevel(logLevel);
            this.enableDriverManagerLogging();
        }
        this.prepareThreshold = 0;
        try {
            this.prepareThreshold = Integer.parseInt(info.getProperty("prepareThreshold", "0"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.prepareThreshold < 0) {
            this.prepareThreshold = 0;
        }
        if (Driver.logInfo) {
            Driver.info(Driver.getVersion());
        }
        this.protoConnection = ConnectionFactory.openConnection(host, port, user, database, info);
        this.dbVersionNumber = this.protoConnection.getServerVersion();
        this.compatible = info.getProperty("compatible", "8.0");
        this.sqlRandomizationKey = info.getProperty("SQLRandomizationKey", "");
        if (Driver.logDebug) {
            Driver.debug("    compatible = " + this.compatible);
            Driver.debug("    loglevel = " + logLevel);
            Driver.debug("    prepare threshold = " + this.prepareThreshold);
        }
        this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
        this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
        this.initObjectTypes();
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    public ResultSet execSQLQuery(String s) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement();
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results where returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."));
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getSQLRandomizationKey() {
        return this.sqlRandomizationKey;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String type, String value) throws SQLException {
        SQLData d;
        if (this.typemap != null && (d = (SQLData)this.typemap.get(type)) != null) {
            throw Driver.notImplemented();
        }
        PGobject obj = null;
        if (Driver.logDebug) {
            Driver.debug("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class klass;
            HashMap hashMap = this.objectTypes;
            synchronized (hashMap) {
                klass = (Class)this.objectTypes.get(type);
            }
            if (klass != null) {
                obj = (PGobject)klass.newInstance();
                obj.setType(type);
                obj.setValue(value);
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataType(String type, Class klass) throws SQLException {
        if (!PGobject.class.isAssignableFrom(klass)) {
            throw new PSQLException(GT.tr("The class {0} does not implement org.postgresql.util.PGobject.", klass.toString()), PSQLState.INVALID_PARAMETER_TYPE);
        }
        HashMap hashMap = this.objectTypes;
        synchronized (hashMap) {
            this.objectTypes.put(type, klass);
        }
    }

    private void initObjectTypes() throws SQLException {
        for (int i = 0; i < defaultObjectTypes.length; ++i) {
            this.addDataType((String)defaultObjectTypes[i][0], (Class)defaultObjectTypes[i][1]);
        }
    }

    public void close() {
        this.protoConnection.close();
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning newWarnings = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."));
        }
        if (this.haveMinimumServerVersion("7.4") && readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        this.getQueryExecutor().execute(query, null, (ResultHandler)new TransactionCommandHandler(), 0, 0, 22);
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            SQLWarning saveWarnings = this.getWarnings();
            this.clearWarnings();
            this.execSQLUpdate("SHOW TRANSACTION ISOLATION LEVEL");
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
            if (saveWarnings != null) {
                this.addWarning(saveWarnings);
            }
        }
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase()).indexOf("READ COMMITTED") != -1) {
            return 2;
        }
        if (level.indexOf("READ UNCOMMITTED") != -1) {
            return 1;
        }
        if (level.indexOf("REPEATABLE READ") != -1) {
            return 4;
        }
        if (level.indexOf("SERIALIZABLE") != -1) {
            return 8;
        }
        return 2;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."));
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", new Integer(level)), PSQLState.TRANSACTION_STATE_INVALID);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
    }

    protected String getIsolationLevelName(int level) {
        boolean pg80 = this.haveMinimumServerVersion("8.0");
        if (level == 2) {
            return "READ COMMITTED";
        }
        if (level == 8) {
            return "SERIALIZABLE";
        }
        if (pg80 && level == 1) {
            return "READ UNCOMMITTED";
        }
        if (pg80 && level == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.protoConnection.getDatabase();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            versionTokens.nextToken();
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public boolean haveMinimumServerVersion(String ver) {
        return this.dbVersionNumber.compareTo(ver) >= 0;
    }

    public boolean haveMinimumCompatibleVersion(String ver) {
        return this.compatible.compareTo(ver) >= 0;
    }

    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPGType(String typeName) throws SQLException {
        if (typeName == null) {
            return 0;
        }
        AbstractJdbc2Connection abstractJdbc2Connection = this;
        synchronized (abstractJdbc2Connection) {
            Integer oidValue = (Integer)this.typeOidCache.get(typeName);
            if (oidValue != null) {
                return oidValue;
            }
            int oid = 0;
            PreparedStatement query = this.haveMinimumServerVersion("7.3") ? this.prepareStatement("SELECT oid FROM pg_catalog.pg_type WHERE typname=?") : this.prepareStatement("SELECT oid FROM pg_type WHERE typname=?");
            query.setString(1, typeName);
            if (!((BaseStatement)((Object)query)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results where returned by the query."), PSQLState.NO_DATA);
            }
            ResultSet result = query.getResultSet();
            if (result.next()) {
                oid = result.getInt(1);
                this.oidTypeCache.put(new Integer(oid), typeName);
            }
            this.typeOidCache.put(typeName, new Integer(oid));
            result.close();
            return oid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        AbstractJdbc2Connection abstractJdbc2Connection = this;
        synchronized (abstractJdbc2Connection) {
            String cachedValue = (String)this.oidTypeCache.get(new Integer(oid));
            if (cachedValue != null) {
                return cachedValue;
            }
            String typeName = null;
            PreparedStatement query = this.haveMinimumServerVersion("7.3") ? this.prepareStatement("SELECT typname FROM pg_catalog.pg_type WHERE oid=?") : this.prepareStatement("SELECT typname FROM pg_type WHERE oid=?");
            query.setInt(1, oid);
            if (!((BaseStatement)((Object)query)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results where returned by the query."), PSQLState.NO_DATA);
            }
            ResultSet result = query.getResultSet();
            if (result.next()) {
                typeName = result.getString(1);
                this.typeOidCache.put(typeName, new Integer(oid));
            }
            this.oidTypeCache.put(new Integer(oid), typeName);
            result.close();
            return typeName;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    public void cancelQuery() throws SQLException {
        this.protoConnection.sendQueryCancel();
    }

    public PGNotification[] getNotifications() {
        PGNotification[] notifications = this.protoConnection.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold <= 0 ? 0 : newThreshold;
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out));
        }
    }

    public int getSQLType(String pgTypeName) {
        if (pgTypeName == null) {
            return 1111;
        }
        for (int i = 0; i < jdbc2Types.length; ++i) {
            if (!pgTypeName.equals(jdbc2Types[i])) continue;
            return jdbc2Typei[i];
        }
        return 1111;
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Connection.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

