/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this software; If not, write to the Free Software Foundation,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include <stdio.h>
#include <regex.h>
#include <keynote.h>
#include <ar.h>
#include <fcntl.h>
#include <stdlib.h>

#include "dava.h"

/*
 * read characters until you hit ifs, a '\n' or an EOF
 * return string in supplied buffer.
 * In order not to overflow tha string buffer, the routine
 * stores at most maxlen-1 characters and null terminates string
 * Return values:
 *	-1 -> end of file reached before ifs or '\n'
 *	-2 -> string buffer overflow
 *	n>=0 -> read n characters (token ended with ifs or '\n')
 */
int read_token(FILE *fd, char *buf, int maxlen, char ifs)
{
	int c;
	int i = 0;
	char *vp = buf;

	while (((c = getc(fd)) != EOF) && (c != '\n') && (c != ifs)) {
		if (maxlen-- > 0) {
			i++;
			*vp++ = c;
		}
	}
	*vp= '\0';
	if (c == EOF)
		return(-1);
	if (maxlen < 0)
		return(-2);
	return(i);
}

FILE *open_temp()
{
        char sfn[15] = "";
        FILE *sfp;
        int fd = -1;

        strcpy(sfn, "/tmp/ed.XXXXXX");
        if ((fd = mkstemp(sfn)) == -1 ||
                (sfp = fdopen(fd, "w+")) == NULL) {
                if (fd != -1) {
//FIX                   unlink(sfn);
                        close(fd);
                }
                fprintf(stderr, "%s: %s\n", sfn, strerror(errno));
                return (NULL);
        }
        return (sfp);
}

FILE *call_server(char *hostname, int port)
{
	int s0;
	struct sockaddr_in server;
	struct hostent *hp, *gethostbyname();
	FILE *fd;

	/* Create socket */
	if ((s0 = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("opening stream socket");
		return(NULL);
	}
	/* Connect socket using name specified by command line. */
	server.sin_family = AF_INET;
	if ((hp = gethostbyname(hostname)) == 0) {
		fprintf(stderr, "%s: unknown host\n", hostname);
		return(NULL);
	}
	bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
	server.sin_port = htons(port);

	if (connect(s0, (struct sockaddr *) & server, sizeof(server)) < 0) {
		perror("connecting stream socket");
		return(NULL);
	}

	/* convert file descriptor to stream */
	if ((fd = fdopen(s0, "r+")) == NULL) {
                perror("fdopen");
                return(NULL);
        }
	return(fd);
}

static char *pr_type(int ar_type)
{
	switch (ar_type) {
	case AR_CREDENTIALS:
		return("CREDENTIALS");
	case AR_REQUESTER:
		return("REQUESTER");
	case AR_REQUEST:
		return("REQUEST");
	default:
		return("-----");
	}
}

int send_file(FILE *fd_io, char *fname, int ar_type, long offset)
{
	FILE *fd_file;
	struct stat fileinfo;
	int iolen;
	int c;

	if ((fd_file = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "cannot open %s file (%s)\n", pr_type(ar_type), fname);
		perror("open");
		return(-1);
	}
        if (fstat(fileno(fd_file), &fileinfo) < 0) {
                fprintf(stderr, "cannot stat %s file", fname);
		perror("fstat");
                return(-2);
        }
	iolen = fileinfo.st_size;
	if (offset != -1L) {
		iolen -= offset;
	}
	c = send_file2(fd_io, fd_file, fname, ar_type, offset, iolen);
	fclose(fd_file);
	return(c);
}


int send_file2(FILE *fd_io, FILE *fd_file, char *fname, int ar_type, long offset, int iolen)
{
	struct ar_hdr arf_header;
#define BUF_SIZE	1024
	static char iobuf[BUF_SIZE];
	char *tname;
	int c;

	tname = pr_type(ar_type);

	if (offset != -1L) {
		if (fseek(fd_file, offset, SEEK_SET) < 0) {
			fprintf(stderr, "cannot stat %s file", fname);
			perror("fseek");
			return(-3);
		}
	}
// fprintf(stderr, "file %s, offset %d, iosize %d\n", fname, offset, iolen);

	/*
	 * construct ar file header
	 */

	/* fill header with spaces */
	memset(&arf_header, ' ', sizeof(struct ar_hdr));

	memcpy(&arf_header.ar_name, tname, strlen(tname));
	memcpy(&arf_header.ar_date, "1015672178", strlen("1015672178"));
	memcpy(&arf_header.ar_uid, "0", strlen("0"));
	memcpy(&arf_header.ar_gid, "0", strlen("0"));
	memcpy(&arf_header.ar_mode, "100444", strlen("100444"));
	/* we specify ar_size+1 because we will strip the terminating NULL */
	snprintf(iobuf, sizeof(arf_header.ar_size)+1, "%o", iolen);
	memcpy(&arf_header.ar_size, iobuf, strlen(iobuf));
	memcpy(&arf_header.ar_fmag, ARFMAG, strlen(ARFMAG));

	fwrite(&arf_header, sizeof(struct ar_hdr), 1, fd_io);
	while ((c = getc(fd_file)) != EOF)
		putc(c, fd_io);
	/* if file size is odd, append a single NEWLINE */
	if ((iolen % 2) != 0)
		putc('\n', fd_io);
	return(0);
}

/*
 * pack_string -- removes spaces, and \<lf>'s etc from strings. Used to convert 
 *	multiline keys to single line
 *
 *	Returns point to SUPPLIED buffer. I.e. this routine MODIFIES supplied buffer,
 *	It does not allocate new memory.
 */
char *pack_string(char *vp)
{
	char *sp, *dp;

	for (sp=dp=vp; *sp!='\0'; sp++) {
		if (*sp == ' ')
			continue;
		if (*sp == '\\')
			if (*++sp != '\\')
				continue;
			else
				*dp++ = '\\';
		*dp++ = *sp;
	}
	*dp = '\0';
	return(vp);
}

/*
 * copy_file - allocates a buffer and reads named file into it.
 *	TODO error code return values.
 */

char *copy_file(char *fname, int *length)
{
	int fd, len;
        struct stat fileinfo;
	char *vp;

	/*
	 * open named file
	 */
	if ((fd = open(fname, O_RDONLY)) < 0) {
		fprintf(stderr, "cannot open file (%s)\n", fname);
		perror("open");
		exit(1);
	}
	if (fstat(fd, &fileinfo) < 0) {
		perror("cannot stat file");
		exit(1);
	}
	/* allocate buffer for file contents */
	len = fileinfo.st_size;
	if (length != NULL)
		*length = len;
	if ((vp = malloc(len+1)) == NULL) {
		fprintf(stderr, "malloc(%d) failed\n", len+1);
		exit(1);
	}

	/* read file contents into buffer */
	if (read(fd, vp, len) < 0) {
		perror("read file contents");
		exit(1);
	}
// fprintf(stderr, "file %s  = <<<%s>>>\n", fname, vp);
	close(fd);
	if (vp[len-1] == '\n')		/* zap trailing LF */
		vp[len-1] = '\0';
	vp[len] = '\0';	/* NULL terminate the string */
	return(vp);
}

char *pr_keynote_error(int kn_errno) {
	switch (kn_errno)
	{
	case ERROR_SYNTAX:
		return("Invalid name action attribute name");
	case ERROR_MEMORY:
		return("Out of memory adding action attribute");
	case ERROR_NOTFOUND:
		return("Not found");
	default:
		return("Unspecified error %d (shouldn't happen)");
	}
}

