/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this software; If not, write to the Free Software Foundation,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <regex.h>
#include <keynote.h>
#include <ar.h>
#include <fcntl.h>
#include <stdlib.h>

#include "dava.h"

void usage(int d) {
	fprintf(stderr, "usage(%d): send [-h hostname] [-p port] payment credentials requester filename\n", d);
	exit(1);
}

/* 

 */

main(int argc, char **argv)
{
	int port;
	int c;
	char *hostname = NULL;
	char *cred_file = NULL;
	char *data_file = NULL;
	FILE *fd_file = NULL;
	FILE *fd_in = stdin;
	FILE *fd_out = stdout;
	FILE *fd_cred;
	FILE *fd_bank;
	struct stat fileinfo;
#define IOBUFSIZE 10240
	static char iobuf[IOBUFSIZE];
	static char iobuf2[IOBUFSIZE];
	static char iobuf3[IOBUFSIZE];

	#define FT_CRED_PATH "./ft-facs"
	int iolen;
	char *vp;
	char *cred_hostname;
	char *cred_port;
	char *cred_amount;
	char *cred_flen;
	char *cred_handle;
	char *server_key;
	char *server_key_enc;
	char cred_name[MAXPATHLEN];
	char *req_price;
	char *my_public_key;
	char *my_private_key;
	char *priv_key;
	char *pub_key;
	char *signature;
	int flen;
	int priv_key_len;
	char *req_nonce;
	char *pmt_csr;
	int pmt_csr_len;
	FILE *cred_fd;

	while (argc > 1) {
	    if (argv[1][0] == '-') {
		switch (argv[1][1]) {
		case 'h':
			argv++ ; argc--;
			hostname = argv[1];
			break;
		case 'p':
			argv++ ; argc--;
			port = atoi(argv[1]);
			break;
                case 'f':
                        argv++ ; argc--;
                        data_file = argv[1];
                        break;
                case 'r':
                        argv++ ; argc--;
                        my_private_key = argv[1];
                        break;
                case 'u':
                        argv++ ; argc--;
                        my_public_key = argv[1];
                        break;
		default:
			usage(1);
		}
	    } else {
#ifdef XX
		if (argc < 4)
			usage(2);
		cred_file = argv[1];
		argv++ ; argc--;
		data_file = argv[1];
		argv++ ; argc--;
#endif
		if (argc > 1)
			usage(3);
	    }
	    argv++ ; argc--;
	}

if (strcmp(hostname, "test") != 0) {
	if ((fd_in = fd_out = call_server(hostname, port)) == NULL) {
		fprintf(stderr, "call_server: connection to server %s:%d failed\n",
			hostname, port);
		exit(1);
	}
}
	/*
	 * open data file and get its length
	 */
	if ((fd_file = fopen(data_file, "r")) == NULL) {
		fprintf(stderr, "cannot open data file (%s)\n", data_file);
		perror("open");
		exit(1);
	}
        if (fstat(fileno(fd_file), &fileinfo) < 0) {
                fprintf(stderr, "cannot stat %s file", data_file);
		perror("fstat");
                exit(1);
        }

	/*
	 * send request
	 */
	/* we send a message to the server the file info... */
	fprintf(fd_out, "110 PUT:%d:%s\n", (int)fileinfo.st_size, data_file); /*XX what about files with extents > 2^31? */

	/* and the server responds with an offer */
	/* with the format 210 <price>:<nonce>:<server-key> */
        /* read message id */
        if ((c = read_token(fd_out, iobuf, IOBUFSIZE, ' ')) < 0) {
                fprintf(stderr, "Offer request returned: %d (did other side hang up?)\n", c);
                exit(1);
        }
        if (strncmp(iobuf, "210", 3) != 0) {
                fprintf(stderr, "Offer request returned: %s - bad message id\n", iobuf);
                exit(1);
        }
 /* -------------------------------------------*/
#define READ_VALUE(FIELD, FD, PTR, LEN, CH) \
if ((c = read_token(FD, PTR, LEN, CH)) < 0) { \
        fprintf(stderr, "\nFailed to read %s (%d), got [%s]\n", FIELD, c, PTR); \
        exit(1); \
} else {\
        PTR += (c + 1) ; LEN -= (c + 1); \
}
/* -------------------------------------------*/
 
	vp = iobuf3; iolen = IOBUFSIZE;
	/* read price */
	req_price = vp; READ_VALUE("price", fd_in, vp, iolen, ':');
	/* read nonce */
	req_nonce = vp; READ_VALUE("nonce", fd_in, vp, iolen, ':');
        /* get encoding of server public key */
        server_key = vp; READ_VALUE("server-key", fd_in, vp, iolen, ' ');

fprintf(stderr, "210 %s:%s:%s\n", req_price, req_nonce, server_key);

/*
 * ASK USER WHETHER THE SUPPLIED PRICE IS ACCEPTABLE (TODO)
 */

	/* we then extract the price from the offer and construct a payment credential */

        if ((fd_cred = open_temp()) == NULL) {
                fprintf(stderr, "Can't open temp file, abort\n");
                exit(1);
        }

        /* bank cred to credential file */
        if ((fd_bank = fopen(BANK_FILE, "r")) == NULL) {
                fprintf(stderr, "cannot open FAC file (%s)\n", BANK_FILE);
                perror("open");
                exit(1);
        }
        while ((c = getc(fd_bank)) != EOF)
                putc(c, fd_cred);
        fclose(fd_bank);
        // putc('\n', fd_cred);
        /*
         * Prepare payment credential
         */

        /* need to read in users's public key */
        pub_key = copy_file(my_public_key, NULL);
        /* ... and the private key */
        priv_key = copy_file(my_private_key, &priv_key_len);


        snprintf(iobuf2, IOBUFSIZE, "KeyNote-Version: 2\n\
Comment: Payment credential\n\
Local-Constants:\n    AUTH_KEY = %s\n    LIC_KEY = %s\n\
Authorizer: AUTH_KEY\n\
Licensees:  LIC_KEY\n\
Conditions: app_domain == \"FileTellerPay\" && currency == \"USD\" && @amount == %s \
&& nonce == \"%s\" -> \"true\";\n\
Signature: ", pub_key, server_key, req_price, req_nonce);

        pmt_csr = iobuf2;
        pmt_csr_len = strlen(iobuf2+1);

        if ((signature = kn_sign_assertion(pmt_csr, pmt_csr_len,
	    priv_key, SIG_RSA_SHA1_PKCS1_HEX, 0)) == NULL) {
		fprintf(stderr, "kn_sign_assertion failed, abort\n");
		exit(1);
	}
// fprintf(stderr, "%s \"%s\"\n\n", pmt_csr, signature);
        fprintf(fd_cred, "%s \"%s\"\n\n", pmt_csr, signature);

	/* send ar file header */
	fwrite(ARMAG, SARMAG, 1, fd_out);
        /*
         * send credentials, user key and request
         */

        flen = ftell(fd_cred);
        send_file2(fd_out, fd_cred, "temp-file", AR_CREDENTIALS, 0L, flen);
        fclose(fd_cred);
        send_file(fd_out, my_public_key, AR_REQUESTER, -1L);
	
	/* wait for response. If response is an ACK we send the file,
	 * otherwise we terminate, and report the error on stderr
	 */
	read_token(fd_in, iobuf, IOBUFSIZE, ' ');
	if (strncmp(iobuf, "230", 3) != 0) {
		fprintf(stderr, "File upload request REFUSED\nReturned: %s.", iobuf);
		while (((c = getc(fd_in)) != EOF) && (c != '\n'))
			putc(c, stderr);
		putc('\n', stderr);
		exit(1);
	}
	/* read in rest of string */
	while (((c = getc(fd_in)) != EOF) && (c != '\n'))
		;
			;
	if (c != '\n') { /* connection closed */
		fprintf(stderr, "Connection closed unexepectedly\n");
		exit(1);
	}

	/* send file */
	
	while ((c = getc(fd_file)) != EOF)
		putc(c, fd_out);
	fclose(fd_file);

	/* upon successful receipt of the file, the remote system sends
	 * a file credential preceded by a file information header
	 * 240 HANDLE:<hostname>:<port>:<payment-amount>:<file-length>:<file-handle>:<key>
	 * e.g.
	 * 240 HANDLE:nick.fileteller.org:1722:0.002:12345:055D7233E050E484:"rsa-base64:MIG..."<lf>
	 * This information is also contained in the credential and is
	 * copied in the header for ease.
	 */
	
	if ((c = read_token(fd_in, iobuf, IOBUFSIZE, ':')) < 0) {
		fprintf(stderr, "Handle request returned: %d (did other side hang up?)\n", c);
		exit(1);
	}
	if (strncmp(iobuf, "240 HANDLE", 3) != 0) {
		fprintf(stderr, "File upload FAILED\nReturned: %s\n", iobuf);
		exit(1);
	}

	vp = iobuf; iolen = IOBUFSIZE;
	/* read hostname */
	cred_hostname = vp; READ_VALUE("hostname", fd_in, vp, iolen, ':');
	/* read port */
	cred_port = vp; READ_VALUE("port", fd_in, vp, iolen, ':');
	/* read price */
	cred_amount = vp; READ_VALUE("price", fd_in, vp, iolen, ':');
	/* read file length */
	cred_flen = vp; READ_VALUE("file-length", fd_in, vp, iolen, ':');
	/* read file handle */
	cred_handle = vp; READ_VALUE("file-handle", fd_in, vp, iolen, ':');
	/* get encoding of server public key */
	server_key_enc = vp; READ_VALUE("server-key-enc", fd_in, vp, iolen, ':');
	/* get encoding of server public key */
	server_key = vp; READ_VALUE("server-key", fd_in, vp, iolen, ':');

	
	/* open file in ft-creds/<handle> and save incoming credential */
	snprintf(cred_name, MAXPATHLEN, "%s/ft%s", FT_CRED_PATH, cred_handle);
        if ((cred_fd = fopen(cred_name, "w")) == NULL) {
fprintf(stderr, "can't open file [%s] for writing\n", cred_name);
                exit(1);
        }
	/* save file request */
	fprintf(cred_fd, "%s:%s:%s:%s:%s:%s:%s\n", cred_hostname, cred_port,
		cred_amount, cred_flen, cred_handle, server_key_enc, server_key);

        while ((c = getc(fd_in)) != EOF)
                putc(c, cred_fd);
        fclose(cred_fd);

#ifdef XX
	/* read closing 250 and exit */
	read_token(fd_in, iobuf, IOBUFSIZE, ' ');
	if (strncmp(iobuf, "250", 3) != 0) {
		fprintf(stderr, "Transaction failed, Returned: %s.", iobuf);
		exit(1);
	}
	/* read in rest of string */
	while (((c = getc(fd_in)) != EOF) && (c != '\n'))
#endif /*XX*/
	exit(0);
}
