/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this software; If not, write to the Free Software Foundation,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <errno.h>

#include <stdio.h>
#include <regex.h>
#include <keynote.h>
#include <ar.h>
#include <fcntl.h>
#include <stdlib.h>

#include "dava.h"

#define MAX_CREDENTIAL 1024000
#define CREDENTIALS	"CREDENTIALS"
#define MAX_REQUESTER	10240
#define REQUESTER	"REQUESTER"
#define MAX_REQUEST	102400
#define REQUEST		"REQUEST"

void usage(int d) {
	fprintf(stderr, "usage(%d): get [-h hostname] [-p port] -f fac-file  -u public-key -r private-key\n", d);
	exit(1);
}

/* 
 */

main(int argc, char **argv)
{
	char *fac_file = NULL;
	char *my_public_key;
	char *my_private_key;
	char *pub_key;
	char *priv_key;
	int priv_key_len;
	char *server_key;
	char *pmt_csr;
	int pmt_csr_len;
	char *signature;

	char *req_handle;
	char *req_price;
	char *req_nonce;

	int c;
	char *cred_file = NULL;
	char *data_file = NULL;
	char *user_file = NULL;
	FILE *fd_bank = NULL;
	FILE *fd_fac = NULL;
	FILE *fd_cred = NULL;
	FILE *fds;
	struct stat fileinfo;
#define IOBUFSIZE 10240
	static char iobuf[IOBUFSIZE];
	static char iobuf1[IOBUFSIZE];
	static char iobuf2[IOBUFSIZE];
	static char iobuf3[IOBUFSIZE];

	int iolen;
	char *vp;
	char *cred_hostname;
	char *cred_port;
	char *cred_amount;
	char *cred_flen;
	char *cred_handle;
	char *srv_hostname = NULL;
	int srv_port = -1;
	int flen;

	while (argc > 1) {
	    if (argv[1][0] == '-') {
		switch (argv[1][1]) {
		case 'h':
			argv++ ; argc--;
			srv_hostname = argv[1];
			break;
		case 'p':
			argv++ ; argc--;
			srv_port = atoi(argv[1]);
			break;
		case 'f':
			argv++ ; argc--;
			fac_file = argv[1];
			break;
		case 'r':
			argv++ ; argc--;
			my_private_key = argv[1];
			break;
		case 'u':
			argv++ ; argc--;
			my_public_key = argv[1];
			break;
		default:
			usage(1);
		}
	    } else {
		if (argc > 1)
			usage(3);
	    }
	    argv++ ; argc--;
	}

	/*
	 * Open FAC file and extract the file access information
	 */
	if ((fd_fac = fopen(fac_file, "r")) == NULL) {
		fprintf(stderr, "cannot open FAC file (%s)\n", fac_file);
		perror("open");
		exit(1);  
	}
	if (fstat(fileno(fd_fac), &fileinfo) < 0) {
		fprintf(stderr, "cannot stat %s file", fac_file);
		perror("fstat");
		exit(1);
	}


	/*
	 * get request header from FAC file
	 */
/* -------------------------------------------*/
#define READ_VALUE(FIELD, FD, PTR, LEN, CH) \
if ((c = read_token(FD, PTR, LEN, CH)) < 0) { \
	fprintf(stderr, "\nFailed to read %s (%d), got [%s]\n", FIELD, c, PTR); \
	exit(1); \
} else {\
	PTR += (c + 1) ; LEN -= (c + 1); \
}
/* -------------------------------------------*/

        vp = iobuf1; iolen = IOBUFSIZE;
        /* read hostname */
        cred_hostname = vp; READ_VALUE("hostname", fd_fac, vp, iolen, ':');
	if (srv_hostname == NULL)
		srv_hostname = cred_hostname;
        /* read port */
        cred_port = vp; READ_VALUE("port", fd_fac, vp, iolen, ':');
	if (srv_port == -1)
		srv_port = atoi(cred_port);
        /* read download cost */
        cred_amount = vp; READ_VALUE("payment", fd_fac, vp, iolen, ':');
        /* read file length */
        cred_flen = vp; READ_VALUE("file-length", fd_fac, vp, iolen, ':');
        /* read file handle */
        cred_handle = vp; READ_VALUE("file-handle", fd_fac, vp, iolen, ':');
        server_key = vp; READ_VALUE("server-key", fd_fac, vp, iolen, ' ');

	if ((fd_cred = open_temp()) == NULL) {
                fprintf(stderr, "Can't open temp file, abort\n");
                exit(1);
        }
	while ((c = getc(fd_fac)) != EOF)
		putc(c, fd_cred);
	fclose(fd_fac);
	putc('\n', fd_cred);

	/*
	 * open connection to server
	 */
	if ((fds = call_server(srv_hostname, srv_port)) == NULL) {
		fprintf(stderr, "call_server: connection to server %s:%d failed\n",
			cred_hostname, srv_port);
		exit(1);
	}

	/*
	 * send request
	 */
	fprintf(fds, "111 GET:%s\n", cred_handle); 

	/*
	 * the server sends a message of the folloowing type
	 * 320 <handle>:<price>:<nonce>
	 */

	/* read message id */
	if ((c = read_token(fds, iobuf, IOBUFSIZE, ' ')) < 0) {
		fprintf(stderr, "Handle request returned: %d (did other side hang up?)\n", c);
		exit(1);
	}
        if (strncmp(iobuf, "320", 3) != 0) {
		fprintf(stderr, "Handle request returned: %s - bad message id\n", iobuf);
		exit(1);
	}

        /* read handle */   
	vp = iobuf3; iolen = IOBUFSIZE;
        req_handle = vp; READ_VALUE("handle", fds, vp, iolen, ':');
	/* sanity check */
	if (strncmp(cred_handle, req_handle, strlen(cred_handle)) != 0) {
		fprintf(stderr, "server's offer has a different handle (%s != %s)\n",
			cred_handle, req_handle);
		exit(1);
	}
        /* read price */
        req_price = vp; READ_VALUE("price", fds, vp, iolen, ':');
        /* read nonce */
        req_nonce = vp; READ_VALUE("nonce", fds, vp, iolen, ':');
fprintf(stderr, "320 %s:%s:%s\n", req_handle, req_price, req_nonce); 
/*
 * ASK USER WHETHER THE SUPPLIED PRICE IS ACCEPTABLE (TODO)
 */

	/*
	 * Copy bank (check guarantor) credential
	 */
	/* bank cred to credential file */
	if ((fd_bank = fopen(BANK_FILE, "r")) == NULL) {
		fprintf(stderr, "cannot open FAC file (%s)\n", BANK_FILE);
		perror("open");
		exit(1);  
	}
	while ((c = getc(fd_bank)) != EOF)
		putc(c, fd_cred);
	fclose(fd_bank);
	// putc('\n', fd_cred);

	
	/*
	 * Prepare payment credential
	 */

	/* need to read in users's public key */
	pub_key = copy_file(my_public_key, NULL);
	/* ... and the private key */
	priv_key = copy_file(my_private_key, &priv_key_len);

/*

*/
	snprintf(iobuf2, IOBUFSIZE, "KeyNote-Version: 2\n\
Comment: Payment credential\n\
Local-Constants:\n    AUTH_KEY = %s\n    LIC_KEY = %s\n\
Authorizer: AUTH_KEY\n\
Licensees:  LIC_KEY\n\
Conditions: app_domain == \"FileTellerPay\" && currency == \"USD\" && @amount == %s \
&& nonce == \"%s\" -> \"true\";\n\
Signature: ", pub_key, server_key, cred_amount, req_nonce);
	pmt_csr = iobuf2;
	pmt_csr_len = strlen(iobuf2+1);

	if ((signature = kn_sign_assertion(pmt_csr, pmt_csr_len,
		priv_key, SIG_RSA_SHA1_PKCS1_BASE64, 0)) == NULL)
	{
		switch (keynote_errno)
		{
		    case ERROR_SYNTAX:
			fprintf(stderr, "Invalid algorithm, key, or assertion while signing "
				"<<<%s>>>\n", pmt_csr);
			break;

		    case ERROR_MEMORY:
			fprintf(stderr, "Out of memory while signing "
				"<<<%s>>>\n", pmt_csr);
			break;

		    case ERROR_NOTFOUND:
			fprintf(stderr, "Argument missing while signing  "
				"<<<%s>>>\n", pmt_csr);
			break;

		    default:
			fprintf(stderr, "Unspecified error %d (shouldn't happen) while signing "
				"<<<%s>>>\n", keynote_errno, pmt_csr);
			break;
		}
	}
//fprintf(stderr, "%s \"%s\"\n\n", pmt_csr, signature);
	fprintf(fd_cred, "%s \"%s\"\n\n", pmt_csr, signature);



/*
 * -------> ASSEMBLE CREDENTIALS
 *
 *   1) creds in fac file
 *   2) SIGNED cred for payment
probably the easiest thing to do is to copy the rest of the fac into a new file,
assemble the payment cred and stuff it into the same file and then call "send_file"
to put it into the CRED-archive.
 */

// FFFFF fds = stdout;
	/* send ar file header */
	fwrite(ARMAG, SARMAG, 1, fds);
	/*
	 * send credentials, user key and request
	 */
	
	flen = ftell(fd_cred);
	send_file2(fds, fd_cred, "temp-file", AR_CREDENTIALS, 0L, flen);
	fclose(fd_cred);
	send_file(fds, my_public_key, AR_REQUESTER, -1L);
	
/*
 * upon successful receipt of the file request, the remote system sends
 * a response. A response "360 Ready to send", means the the file will follow.
 * otherwise an error message is sent with the reason for the failure
 */

        if ((c = read_token(fds, iobuf, IOBUFSIZE, '\n')) < 0) {
            fprintf(stderr, "Handle request returned: %d (did other side hang up?)\n", c);
                exit(1);
        }
        if (strncmp(iobuf, "360", 3) != 0) {
                fprintf(stderr, "File download FAILED\nReturned: %s\n", iobuf);
                exit(1);
        }
printf("---------------------------------------------------------------------\n");
        while ((c = getc(fds)) != EOF)
                putchar(c);
        fclose(fds);
printf("---------------------------------------------------------------------\n");
	exit(0);
}

