

#ifndef _PEPLLIB_H_
#define _PEPLLIB_H_

#include "pepl.h"

void *
geometric_realloc(void *ptr, long cur_num, int type_size); 

void
pplerror(const char *s, ...);

int
namespace_add(struct namespace_t *ns, char *s, void *node);

int
namespace_append(struct namespace_t *from, struct namespace_t *onto);

int
namespace_lookup(struct namespace_t *ns, char *s, void **node);

int
namespace_destroy(struct namespace_t *ns);

struct namespace_enum_t *
namespace_enum_new(struct namespace_t *ns);

int
namespace_enum_has_more(struct namespace_enum_t *nse);

struct namespace_node_t *
namespace_enum_next(struct namespace_enum_t *nse);

int 
parse_tree_add(struct parse_tree_t *pt, int type, void *data);

int
pos_in_str_list(char *s, struct str_list *list);

char *
get_nth_str_list(int n, struct str_list *list);

struct sysloc_t *
get_nth_attr_list(int n, struct attr_list *list);

struct str_list *
str_list_add(struct str_list *list, char *s);

struct attr_list *
attr_list_add(struct attr_list *list, char *name, struct sysloc_t *sysloc);

struct typedef_t *
get_type_ref(char *typename);

struct sysloc_t *
get_attr_loc(struct typedef_t *type, char *attr);

char *
string_merge(char *a, char *b);

int
psprintf(char **ret, const char *format, ...);

#endif // _PEPLLIB_H_
