
#include <stdio.h>
#include <stdarg.h>
#include "pepl.h"
#include "pepllib.h"

extern struct parse_tree_t tree[5];

void *
geometric_realloc(void *ptr, long cur_num, int type_size)
{
  int n = 1;
  void *newptr = ptr;
  void *oldptr;
  
  while (n <= (cur_num+1))
    {
      n *= 2;
    }

  if (newptr==NULL)
    {
      newptr = (void*)malloc(n*type_size);
    } else {
      if (n >= ((cur_num+1)*2))
	{
	  oldptr = ptr;
	  newptr = (void*)realloc(ptr, n*type_size);
	  if (oldptr == newptr)
	    {
	      fprintf(stderr, "\n XXX DANGER \n");
	    }
	}
    }
  return newptr;

};


void 
pplerror(const char *s, ...)
{
  va_list ap;

  fprintf(stderr, "\n\n**Error: ");
  va_start(ap, s);
  vfprintf(stderr, s, ap);
  va_end(ap);
  fprintf(stderr, "\n\n");
  exit(1);
};


int
namespace_add(struct namespace_t *ns, char *s, void *node)
{
  if (namespace_lookup(ns, s, NULL)==NULL)
    {
      int i;

      ns->names = geometric_realloc(ns->names, ns->size, sizeof(struct namespace_node_t));

      ns->names[ns->size].name = s;
      ns->names[ns->size].node = node;

      ns->size++;

      return 1;
    } else {
      return 0;
    }
  
};

int
namespace_append(struct namespace_t *from, struct namespace_t *onto)
{
  struct namespace_enum_t *nse;
  struct namespace_node_t *node;

  int count = 0;

  // this is necessary to maintain uniqueness
  // of elements

  nse = namespace_enum_new(from);

  while (namespace_enum_has_more(nse))
    {
      node = namespace_enum_next(nse);

      if (namespace_add(onto, node->name, node->node))
	count++;
    }
  
  return count;
};

int
namespace_lookup(struct namespace_t *ns, char *s, void **node)
{
  int j;
 
  for(j=0;j<ns->size;j++)
    {
      if (strcmp(ns->names[j].name,s)==0)
	{
	  if (node != NULL)
	    (*node) = ns->names[j].node;
	  return 1;
	}
    }

  return 0;
};

int
namespace_destroy(struct namespace_t *ns)
{
  if (ns->names)
    free(ns->names);
  ns->size = 0;

  return 1;
};

int 
parse_tree_add(struct parse_tree_t *pt, int type, void *data)
{
  struct parse_node_t *new_node = MALLOC(struct parse_node_t,1);

  new_node->type = type;
  new_node->data = data;

  pt->stmt_arr = geometric_realloc(pt->stmt_arr, pt->num_stmts, sizeof(struct parse_node_t));
  
  pt->stmt_arr[pt->num_stmts] = new_node;
  pt->num_stmts++;
  
  return 1;
};

int
pos_in_str_list(char *s, struct str_list *list)
{
  struct str_list *itr;
  int count;

  itr = list;

  if (itr == NULL)
    pplerror("Fatal string search error");
  
  count = 1;

  while (itr != NULL)
    {
      if (strcmp(itr->str, s)==0)
	return count;
      
      count++;
      itr = itr->next;	  
    };

  return 0;

};

char *
get_nth_str_list(int n, struct str_list *list)
{
  struct str_list *itr;
  int count;

  itr = list;

  if (itr == NULL)
    pplerror("Fatal string retreival error");
  
  count = 1;

  while (itr != NULL)
    {
      if (count==n)
	return itr->str;
      
      count++;
      itr = itr->next;	
    };

  return NULL;
};

int
pos_in_attr_list(char *s, struct attr_list *list)
{
  struct attr_list *itr;
  int count;

  itr = list;

  if (itr == NULL)
    pplerror("Fatal attribute search error");
  
  count = 1;

  while (itr != NULL)
    {
      if (strcmp(itr->name, s)==0)
	return count;
      
      count++;
      itr = itr->next;	  
    };

  return 0;

};

struct sysloc_t *
get_nth_attr_list(int n, struct attr_list *list)
{
  struct attr_list *itr;
  int count;

  itr = list;

  if (itr == NULL)
    pplerror("Fatal attribute retreival error");
  
  count = 1;

  while (itr != NULL)
    {
      if (count==n)
	return itr->sysloc;
      
      count++;
      itr = itr->next;	
    };

  return NULL;
};


struct str_list *
str_list_add(struct str_list *list, char *s)
{
  struct str_list *itr;
  struct str_list *newstr = MALLOC(struct str_list, 1);

  newstr->str = s;
  newstr->next = NULL;

  if (list==NULL)
    return newstr;

  itr = list;

  while (itr->next !=NULL)
    itr=itr->next;

  itr->next = newstr;

  return list;
};

struct attr_list *
attr_list_add(struct attr_list *list, char *name, struct sysloc_t *sysloc)
{
  struct attr_list *itr;
  struct attr_list *newattr = MALLOC(struct attr_list, 1);

  newattr->name = name;
  newattr->sysloc = sysloc;
  newattr->next = NULL;

  if (list==NULL)
    return newattr;

  itr = list;

  while (itr->next !=NULL)
    itr=itr->next;

  itr->next = newattr;

  return list;
};

struct typedef_t *
get_type_ref(char *typename)
{
  struct parse_node_t **td = TREE(TD_NODE).stmt_arr;
  long num_td = TREE(TD_NODE).num_stmts;  
  
  int i;
  for (i=0;i<num_td;i++)
    {
      if (strcmp(typename,TD(td[i]->data)->name)==0)
	{
	  return TD(td[i]->data);
	}
      
    }

  return NULL;
};


struct namespace_enum_t *
namespace_enum_new(struct namespace_t *ns)
{
  struct namespace_enum_t *nse;

  nse = MALLOC(struct namespace_enum_t, 1);
  
  nse->pos = 0;
  nse->ns = ns;

  return nse;
};

int
namespace_enum_has_more(struct namespace_enum_t *nse)
{
  return (nse->pos < nse->ns->size);
};

struct namespace_node_t *
namespace_enum_next(struct namespace_enum_t *nse)
{
  struct namespace_node_t *ret;

  ret = &nse->ns->names[nse->pos];

  nse->pos++;

  return ret;
};

struct sysloc_t *
get_attr_loc(struct typedef_t *type, char *attr)
{
  struct typedef_t *td;
  struct attr_list *al;

  td = type;

  while (td != NULL)
    {
      al = td->attrs;
      
      while (al != NULL)
	{
	  if (strcmp(al->name, attr)==0)
	    {
	      return al->sysloc;
	    }
	  al=al->next;
	}
      
      td = td->supertype_ref;
    }
  
  return NULL;
};

char *
string_merge(char *a, char *b)
{
  char *ret;

  if (a==NULL)
    return b;

  if (b==NULL)
    return a;

  asprintf(&ret, "%s%s", a,b);

  free(a);
  free(b);

  return ret;

};

int
psprintf(char **ret, const char *format, ...)
{
  va_list ap;
  char *temp=NULL;
  char *temp2=NULL;

  va_start(ap, format);

  if (*ret != NULL)
    {
      asprintf(&temp2, "%s%s", *ret, format);
      vasprintf(&temp, temp2, ap);
      free(temp2);
    } else {
      vasprintf(&temp, format, ap);
    }

  va_end(ap);

  free(*ret);

  *ret = temp;

};
