%{
/*
 *
 * Parser for the PEPL grammar
 *
 */

#include <stdio.h>
#include <string.h>
#include "pepl.h"

struct parse_tree_t tree[6];

int next_arr_size(int i);
int get_next_arr_loc();
void add_node(void *ptr, int type);
%}

%union {
	char *string;
	int ival;
	float fpval;
	void *ptr;
}

/* PEPL */
%token ON BY IF OR AND SET OF PREDICATE QUERY
%token <ival> ALLOW 
%token <ival> DENY
%token <string> NAME 
%token <string> INTNUM 
%token <string> STRING

%left UNION
%left INTERSECT
%left OR
%left AND
%left <string> COMPARISON
%left NOT
%left IN
%left IS

%type <string> literal
%type <ival> action
%type <ptr> agent
%type <ptr> object
%type <string> operation
%type <string> scalarexp
%type <ptr> binary_exp
%type <ptr> conditions
%type <ptr> ifclause
%type <ptr> string_list
%type <ptr> typedef_key
%type <ptr> typedef_attrs
%type <ptr> opdef_key
%type <ptr> opdef_agents
%type <ptr> opdef_subjects
%type <ptr> name_list
%type <ptr> set_stmt
%type <ptr> object_list
%type <ptr> predicate_stmt
%type <ptr> set_expr
%type <ptr> system_loc

/* DePEPL */
%token TYPE ATTRIBUTE KEY OPERATION AGENTS SUBJECTS MATCH


%%

stmt_list:
	stmt ';'
	| stmt_list stmt ';' 
	;
	

stmt:
	pepl_stmt
	| typedef_stmt 
	| opdef_stmt 
	| match_stmt 
	| set_stmt
	| predicate_stmt
	;

pepl_stmt: 
	action operation ON object BY agent ifclause
	{ 
		struct statement_t *this_stmt = (struct statement_t *)malloc(
			sizeof(struct statement_t));

		this_stmt->allow = $1;
		this_stmt->operation = $2;
		this_stmt->subject = $4;
		this_stmt->agent = $6;
		this_stmt->ifclause = $7;
		

		add_node(this_stmt, STMT_NODE);
	}
	;

action: 
	ALLOW
	| DENY
	;

operation: 
	NAME
	;

object: 
	NAME {
		struct object_t *this_obj = (struct object_t *)malloc(
			sizeof(struct object_t));
		
		this_obj->type = NULL;
		this_obj->name = $1;

		$$ = this_obj;
	}
	| NAME OF NAME {
		struct object_t *this_obj = (struct object_t *)malloc(
			sizeof(struct object_t));
		
		this_obj->type = $3;
		this_obj->name = $1;
		
		$$ = this_obj;
	}
	;

agent: 
	object
	;

ifclause: 
	/* empty */ { $$ = NULL; }
	| IF conditions { $$ = $2; }
	;

conditions: 
	conditions OR conditions {
		struct ifclause_ext *clause = 
		 	(struct ifclause_ext *)malloc(sizeof(struct ifclause_ext));
		clause->op = BOR;
		clause->lval = $1;
		clause->rval = $3;
	
		$$ = (void *)clause;
	}
	| conditions AND conditions {
		struct ifclause_ext *clause = 
		 	(struct ifclause_ext *)malloc(sizeof(struct ifclause_ext));
		clause->op = BAND;
		clause->lval = $1;
		clause->rval = $3;
		
		$$ = (void *)clause;
	}
	| NOT conditions {
		struct ifclause_ext *clause = 
		 	(struct ifclause_ext *)malloc(sizeof(struct ifclause_ext));
		clause->op = BNOT;
		clause->lval = NULL;
		clause->rval = $2;

		$$ = (void *)clause;
	}
	| '(' conditions ')'  { $$ = (void *)$2; }
	| binary_exp { $$ = (void *)$1; }
	;

binary_exp:
	NAME COMPARISON literal {
		struct ifclause_str *clause = 
		 	(struct ifclause_str *)malloc(sizeof(struct ifclause_str));
		// determine the operator
		switch ($2[0])
		{	
		case '=': clause->op = EQ;
		break;
		case '>':
			if ($2[1] == '=')
				clause->op = GEQ;
			else clause->op = GT;
		break;
		case '<':
			if ($2[1] == '=')
			{
				clause->op = LEQ;
			} else if ($2[1] == '>') {
				clause->op = NEQ;
			} else clause->op = LT;
		break;
		};
			
		clause->lval = $1;
		clause->rval = $3;
		
		$$ = (void *)clause;
	}
	| literal COMPARISON NAME {
		struct ifclause_str *clause = 
		 	(struct ifclause_str *)malloc(sizeof(struct ifclause_str));
		// determine the operator
		switch ($2[0])
		{	
		case '=': clause->op = EQ;
		break;
		case '>':
			if ($2[1] == '=')
				clause->op = GEQ;
			else clause->op = GT;
		break;
		case '<':
			if ($2[1] == '=')
			{
				clause->op = LEQ;
			} else if ($2[1] == '>') {
				clause->op = NEQ;
			} else clause->op = LT;
		break;
		};
			
		clause->lval = $1;
		clause->rval = $3;
		
		$$ = (void *)clause;
	}
	| NAME COMPARISON NAME {
		struct ifclause_str *clause = 
		 	(struct ifclause_str *)malloc(sizeof(struct ifclause_str));
		// determine the operator
		switch ($2[0])
		{	
		case '=': clause->op = EQ;
		break;
		case '>':
			if ($2[1] == '=')
				clause->op = GEQ;
			else clause->op = GT;
		break;
		case '<':
			if ($2[1] == '=')
			{
				clause->op = LEQ;
			} else if ($2[1] == '>') {
				clause->op = NEQ;
			} else clause->op = LT;
		break;
		};
			
		clause->lval = $1;
		clause->rval = $3;
		
		$$ = (void *)clause;
	}	
	| NAME IN NAME {
		struct ifclause_str *clause = 
		 	(struct ifclause_str *)malloc(sizeof(struct ifclause_str));

		clause->op = BIN;
			
		clause->lval = $1;
		clause->rval = $3;
		
		$$ = (void *)clause;
	}
	| object_list IS NAME {
		struct ifclause_ext *clause = 
		 	(struct ifclause_ext *)malloc(sizeof(struct ifclause_ext));

		clause->op = BIS;
			
		clause->lval = (void*)$1;
		clause->rval = (void*)$3;
		
		$$ = (void *)clause;
	}
	;

scalarexp:
	NAME
	| literal
	;

literal:
	STRING 
	| INTNUM
	;



typedef_stmt:
	TYPE NAME ':' NAME '{' typedef_attrs typedef_key '}' 
	{
		struct typedef_t *this_stmt = (struct typedef_t *)malloc(
			sizeof(struct typedef_t));

		this_stmt->name = $2;
		this_stmt->supertype = $4;
		this_stmt->attrs = $6;
		this_stmt->key = $7;
		this_stmt->supertype_ref = NULL;
		this_stmt->key_attr_vals = NULL;
		bzero(&this_stmt->match_refs, sizeof(struct namespace_t));
		add_node(this_stmt, TD_NODE);
	}
	;

typedef_key:
	KEY '(' name_list ')' ';' { $$ = $3; }
	;

typedef_attrs:
	/* empty */  { $$ = NULL; }
	| ATTRIBUTE NAME system_loc ';' { 
		struct attr_list *a = (struct attr_list *)malloc(
			sizeof(struct attr_list));

		a->name = $2;
		a->sysloc = $3;
		a->next = NULL;

		$$ = a;

	}
	| typedef_attrs ATTRIBUTE NAME system_loc ';' { 
		struct attr_list *a = (struct attr_list *)malloc(
			sizeof(struct attr_list));

		struct attr_list *itr;
		
		a->name = $3;
		a->sysloc = $4;
		a->next = NULL;

		itr = $1;
	
		while (itr->next != NULL)
			itr = itr->next;

		itr->next = a;

		$$ = $1;

	}
	;

system_loc:
	STRING {
		struct sysloc_t *s = (struct sysloc_t *)malloc(sizeof(struct sysloc_t));
		struct str_list *str = (struct str_list *)malloc(sizeof(struct str_list));
		str->str = $1;
		str->next = NULL;

		s->type = SYSLOCAL;
		s->value = str;

		$$ = s;
	}
	| QUERY '(' string_list ')' {
		struct sysloc_t *s = (struct sysloc_t *)malloc(sizeof(struct sysloc_t));	

		s->type = SYSREMOTE;
		s->value = $3;

		$$ = s;
	}
	;

string_list:
	STRING {
		struct str_list *s = (struct str_list *)malloc(sizeof(struct str_list));
		s->str = $1;
		s->next = NULL;
		$$ = s;
	}
	| string_list ',' STRING {
		struct str_list *itr;
		struct str_list *s = (struct str_list *)malloc(sizeof(struct str_list));
		s->str = $3;
		s->next = NULL;

		itr = ((struct str_list *)$1);
		while (itr->next != NULL)
			itr = itr->next;

		itr->next = s;
		$$ = $1;
	}
	;

opdef_stmt:
	OPERATION NAME '{' opdef_key opdef_agents opdef_subjects '}'
	{
		struct opdef_t *this_stmt = (struct opdef_t *)malloc(
			sizeof(struct opdef_t));

		this_stmt->name = $2;
		this_stmt->key = $4;
		this_stmt->agents = $5;
		this_stmt->subjects = $6;
		bzero(&this_stmt->agent_refs, sizeof(struct namespace_t));
		bzero(&this_stmt->subject_refs, sizeof(struct namespace_t));
	
		add_node(this_stmt, OP_NODE);
	}
	;

opdef_key:
	KEY '(' string_list ')' ';' { $$ = $3; }
	;

opdef_agents:
	AGENTS '(' name_list ')' ';' { $$ = $3; }
	;

opdef_subjects:
	SUBJECTS '(' name_list ')' ';' { $$ = $3; }
	;

name_list:
	NAME  {
		struct str_list *s = (struct str_list *)malloc(sizeof(struct str_list));
		s->str = $1;
		s->next = NULL;
		$$ = s;
	}
	| name_list ',' NAME  {
		struct str_list *itr;
		struct str_list *s = (struct str_list *)malloc(sizeof(struct str_list));
		s->str = $3;
		s->next = NULL;

		itr = ((struct str_list *)$1);
		while (itr->next != NULL)
			itr = itr->next;

		itr->next = s;
		$$ = $1;
	}
	;

match_stmt:
	MATCH NAME NAME '(' string_list ')' {
		struct match_t *this_stmt = (struct match_t *)malloc(
			sizeof(struct match_t));

		this_stmt->name = $2;
		this_stmt->type = $3;
		this_stmt->key = $5;
		this_stmt->type_ref = NULL;
		add_node(this_stmt, MATCH_NODE);
	}

set_stmt:
	SET NAME set_expr  {
		struct set_t *this_stmt = (struct set_t *)malloc(
			sizeof(struct set_t));
		this_stmt->name = $2;
		this_stmt->expr = $3;
		bzero(&this_stmt->member_refs, sizeof(struct namespace_t));
		add_node(this_stmt, SET_NODE);	

	}
	;

set_expr:
	'{' name_list '}' {
		struct set_expr_t *this_expr = (struct set_expr_t *)malloc(
			sizeof(struct set_expr_t));
		this_expr->op = SNOP;
		this_expr->lval = $2;
		this_expr->rval = NULL;
		
		$$ = this_expr;
	}
	| NAME {
		struct set_expr_t *this_expr;
		struct str_list *s = (struct str_list *)malloc(sizeof(struct str_list));
		s->str = $1;
		s->next = NULL;

		this_expr = (struct set_expr_t *)malloc(
			sizeof(struct set_expr_t));
		this_expr->op = SNOP;
		this_expr->lval = s;
		this_expr->rval = NULL;
		
		$$ = this_expr;
	}
	| '(' set_expr ')' {
		$$ = $2;
	}	
	| set_expr INTERSECT set_expr {
		struct set_expr_t *this_expr = (struct set_expr_t *)malloc(
			sizeof(struct set_expr_t));
		this_expr->op = SISECT;
		this_expr->lval = $1;
		this_expr->rval = $3;
		
		$$ = this_expr;
	}
	| set_expr UNION set_expr {
		struct set_expr_t *this_expr = (struct set_expr_t *)malloc(
			sizeof(struct set_expr_t));
		this_expr->op = SUNION;
		this_expr->lval = $1;
		this_expr->rval = $3;
		
		$$ = this_expr;
	}
	;


object_list:
	object {
		struct object_list *o = (struct object_list *)malloc(sizeof(struct object_list));
		o->object = $1;
		o->next = NULL;
		$$ = o;
	}
	| object_list ',' object {
		struct object_list *itr;
		struct object_list *o = (struct object_list *)malloc(sizeof(struct object_list));
		o->object = $3;
		o->next = NULL;

		itr = ((struct object_list *)$1);
		while (itr->next != NULL)
			itr = itr->next;

		itr->next = o;
		$$ = $1;
	}
	| '(' object_list ')' {
		$$ = $2;
	}
	;


predicate_stmt:
	PREDICATE NAME '(' object_list ')' '=' conditions {
		struct pred_t *this_stmt = (struct pred_t *)malloc(
			sizeof(struct pred_t));
		this_stmt->name = $2;
		this_stmt->params = $4;
		this_stmt->ifclause = $7;

		add_node(this_stmt, PRED_NODE);		
	}
	;


%%

void
add_node(void *ptr, int type)
{
	parse_tree_add(&TREE(type), type, ptr);
};