%{
/* 
 * Lexer for PEPL
 *
 * Adapted from the SQL example from Levine, Mason & Brown
 */

#include "y.tab.h"
#include "pepl.h"
#include <string.h>
#include <stdio.h>

  int lineno = 1;

  void yyerror(char *s);

  extern long num_stmt_nodes;
  extern struct parse_node_t **stmt_arr;
  void debug_ops();

  extern struct parse_tree_t tree[6];
%}

%x COMMENT

%%


allow { 
  yylval.ival = 1;
  return ALLOW;  
}
deny  { 
  yylval.ival = 0;
  return DENY; 
}
on  { return ON; }
by  { return BY; }
if  { return IF; }
or { return OR; }
and { return AND; }
not { return NOT; }
of { return OF; }

type { return TYPE; }
attribute { return ATTRIBUTE; }
key { return KEY; }
operation { return OPERATION; }
agents { return AGENTS; }
subjects { return SUBJECTS; }
match { return MATCH; }
set { return SET; }
in { return IN; }
is { return IS; }
predicate { return PREDICATE; }
union { return UNION; }
intersect { return INTERSECT; }
query { return QUERY; }


"=" { return yytext[0]; }

"==" |
"<>" |
"<" |
">" |
">=" |
"<=" { 
  yylval.string = strdup(yytext);
  return COMPARISON; 
}

[(){,}:;] { return yytext[0]; }

[A-Za-z_][A-Za-z0-9&$\^~@:=\._-]* { 
   yylval.string = strdup(yytext);
   return NAME; 
}

[0-9]+ |
[0-9]+"."[0-9]* |
"."[0-9]* { 
  yylval.string = strdup(yytext);
  return INTNUM; 
}


'[^']*' {  
//   yylval.string = strdup(yytext+1);
//   yylval.string[strlen(yytext+1)-1] = '\0';
   yylval.string = strdup(yytext+1);
   return STRING; 
}

'[^'\n]*$  { yyerror("Unterminated String"); }

\"[^\"]*\" { 
//   yylval.string = strdup(yytext+1);
//   yylval.string[strlen(yytext+1)-1] = '\0';
   yylval.string = strdup(yytext);
   return STRING; 
}

\"[^\"\n]*$  { yyerror("Unterminated String"); }

"/*".*"*/" ;
"/*" { BEGIN COMMENT; }
<COMMENT>"*/" { BEGIN 0; }
<COMMENT>. ;
<COMMENT>[\n\r] { lineno++; }
<COMMENT>[.\n\t\r]$ { yyerror("Unterminated comment"); }

"//".*\n  lineno++;

\n   lineno++;

[ \t\r]+   ;

.   yyerror("Invalid Character");
%%

void
yyerror(char *s)
{
  fprintf(stderr, "%d: %s at %s\n", lineno, s, yytext);
}

void debug_ops()
{
  int i,j;

  fprintf(stderr, "Parse Tree Results:\n\n");

  for(i=0;i<6;i++)
   for (j=0;j<tree[i].num_stmts;j++)
    {
      switch(tree[i].stmt_arr[j]->type)
	{
	case STMT_NODE: fprintf(stderr, "\t- PEPL statement\n");
	  break;
	case TD_NODE: fprintf(stderr, "\t- DePEPL typedef\n");
	  break;
	case OP_NODE: fprintf(stderr, "\t- DePEPL operation\n");
	  break;
	case MATCH_NODE: fprintf(stderr, "\t- DePEPL match statement\n");
	  break;
	case SET_NODE: fprintf(stderr, "\t- DePEPL set statement\n");
	  break;
	case PRED_NODE: fprintf(stderr, "\t- DePEPL predicate statement\n");
	  break;
	default: fprintf(stderr, "\t- Unknown... DOH!");
	}
     }
};

main(int ac, char **av)
{
  if (ac > 1)
    { 
      int j,b;
      for (j=1; j<ac; j++)
	{ 
	  if ((yyin = fopen(av[j], "r")) == NULL) 
	    {
	      perror(av[j]);
	      exit(1);
	    }
	  b = yyparse();
	  if (b)
	    break;
	}
      if (!b)
	fprintf(stderr, "\n\nPEPL Syntax Check Complete\n\n");
      else
	{
	  fprintf(stderr, "\n\n** PEPL Syntax Check Failed\n\n");
	  exit(1);
	}
    } else {
      if (!yyparse())
	fprintf(stderr, "\n\nPEPL Syntax Check Complete\n\n");
      else
	{
	  fprintf(stderr,"\n\n** PEPL Syntax Check Failed\n\n");
	  exit(1);
	}
    }
  debug_ops();

  generate_keynote();
};
