
#ifndef PEPL_H
#define PEPL_H

/* comparison ops */
#define EQ 50
#define LT 51
#define LEQ 52
#define GT 53
#define GEQ 54
#define NEQ 55
/* logical ops */
#define BIN 56
#define BIS 57
#define BOR 58
#define BAND 59
#define BNOT 60
/* system loc types */
#define SYSLOCAL 61
#define SYSREMOTE 62
/* node types */
#define STMT_NODE 65
#define TD_NODE 66
#define OP_NODE 67
#define MATCH_NODE 68
#define SET_NODE 69
#define PRED_NODE 70
/* set inclusion ops */
#define SNOP 80
#define SUNION 81
#define SISECT 82

#define TREE(a) (tree[a-65])

#define TD(a) ((struct typedef_t *)a)
#define M(a) ((struct match_t *)a)
#define OP(a) ((struct opdef_t *)a)
#define PPL(a) ((struct statement_t *)a)
#define S(a) ((struct set_t *)a)
#define PRED(a) ((struct pred_t *)a)

#define MALLOC(a,b) (a*)malloc(b*sizeof(a))

struct parse_node_t {
  int type;
  void *data;
};

struct parse_tree_t {
  long num_stmts;
  struct parse_node_t **stmt_arr;
};

struct namespace_node_t {
  char *name;
  void *node;
};

struct namespace_t {
  long size;
  struct namespace_node_t *names;
};

struct namespace_enum_t {
  long pos;
  struct namespace_t *ns;
};

struct ifclause_str {
  int op;
  char *lval;
  char *rval;
};

struct ifclause_ext {
  int op;
  struct ifclause_ext *lval;
  struct ifclause_ext *rval;
};

struct object_t {
  char *type;
  char *name;
};

struct object_list {
  struct object_t *object;
  struct object_list *next;
};

struct statement_t {
  int allow; // boolean
  char *operation;
  struct object_t *subject;
  struct object_t *agent;
  struct ifclause_ext *ifclause;
};

typedef struct statement_t * statement;

struct str_list {
  char *str;
  struct str_list *next;
};

struct sysloc_t {
  char type;
  struct str_list *value;
};

struct attr_list {
  char *name;
  struct sysloc_t *sysloc;
  struct attr_list *next;
};

struct typedef_t {
  char *name;
  char *supertype;
  struct attr_list *attrs;
  struct str_list *key;
  
  struct typedef_t *supertype_ref;
  struct attr_list *key_attr_vals;
  struct namespace_t match_refs;
};

typedef struct typedef_t * typestmt;

struct opdef_t {
  char *name;
  struct str_list *key;
  struct str_list *agents;
  struct str_list *subjects;

  struct namespace_t agent_refs;
  struct namespace_t subject_refs;

};

typedef struct opdef_t *opstmt;

struct match_t {
  char *name;
  char *type;
  struct str_list *key;
  
  struct typedef_t *type_ref;
};

struct set_expr_t {
  int op;

  void *lval;
  void *rval;
};

struct set_t {
  char *name;
  struct set_expr_t *expr;


  struct namespace_t member_refs;
 
  //NOT AVAILABLE YET
  struct typedef_t *equiv_type_ref;
};

struct pred_t {
  char *name;
  struct object_list *params;
  struct ifclause_ext *ifclause;
};

void
generate_keynote();


#endif /* PEPL_H */

