
#include <stdio.h>
#include "pepl.h"
#include "pepllib.h"

#define TREE(a) (tree[a-65])

#define TD(a) ((struct typedef_t *)a)
#define M(a) ((struct match_t *)a)
#define OP(a) ((struct opdef_t *)a)
#define PPL(a) ((struct statement_t *)a)
#define SET(a) ((struct set_t *)a)

FILE *outputfd;
FILE *configfd;

int current_query;
int last_query;
int querynum=0;


extern struct parse_tree_t tree[6];

struct namespace_t namespace;

////////////////////////////////////////////////
//////////////////// Verifying DePEPL Statements
////////////////////////////////////////////////
struct sysloc_t *
attr_in_supertype(char *attr, char *supertype)
{
  int j;
  struct parse_node_t **td = TREE(TD_NODE).stmt_arr;
  long num_td = TREE(TD_NODE).num_stmts;  
  
  if (strcmp(supertype, "Object")==0)
    return 0;

  for (j=0;j<num_td; j++)
    {
      struct typedef_t *typenode = TD(td[j]->data);
      if (strcmp(typenode->name,supertype)==0)
	{
	  int n;
	  if ((n=pos_in_attr_list(attr, typenode->attrs))>0)
	    return get_nth_attr_list(n,typenode->attrs);
	  else
	    return attr_in_supertype(attr, typenode->supertype);
	}
    }

  return NULL;
}; 

int
check_attrs(struct typedef_t *type)
{
  struct attr_list *itr;
  struct attr_list *itr2;
  struct str_list *sitr;
  struct sysloc_t *sl;
  char *str;

  ////////////////////////// check attributes ///////////////

  itr = type->attrs;


  while (itr != NULL)
    {
      itr2 = type->attrs;
      while (itr2 != NULL)
	{
	  if ((itr != itr2)&&(strcmp(itr->name, itr2->name)==0))
	    pplerror("There are more than one attributes named %s in the declaration of type %s", itr->name, type->name);

	  itr2 = itr2->next;

	}

      if (itr->sysloc == NULL)
	pplerror("Attribute %s has no system definition(1)", itr->name);

      if (itr->sysloc->type == SYSREMOTE)
	{

	  if ((itr->sysloc->value == NULL)||(itr->sysloc->value->str == NULL))
	    pplerror("Attribute %s has no system definition(2)", itr->name);

	  if ((itr->sysloc->value->next == NULL)||(itr->sysloc->value->next->str == NULL))
	    pplerror("Attribute %s has no remote PDP associated with the query", itr->name);

	

	} else {
	  if ((itr->sysloc->value == NULL)||(itr->sysloc->value->str == NULL))
	    pplerror("Attribute %s has no system definition(2)", itr->name);
	}
      
      itr = itr->next;
    }
  
  sitr = type->key;
  
  if (sitr == NULL)
    pplerror("Type %s has no key attributes", type->name);
  
  //////////////////// check keys ////////////////////

  while (sitr != NULL)
    {
      itr2 = type->attrs;
      while (itr2 != NULL)
	{
	  if (strcmp(sitr->str, itr2->name)==0)
	    {
	      
	      type->key_attr_vals = attr_list_add(type->key_attr_vals, sitr->str, itr2->sysloc);


	      break;
	    }

	  itr2=itr2->next;
	}
      
      if (itr2 == NULL)
      {
	if((sl=attr_in_supertype(sitr->str, type->supertype))==NULL) // no match
	  {
	    pplerror("Key attribute %s in type declaration %s undeclared", sitr->str, type->name);
	  } else {
	 
	    type->key_attr_vals = attr_list_add(type->key_attr_vals, sitr->str, sl);
	    
	  }
      }

      sitr = sitr->next;
    }

  return 1;
};

void
add_object_type()
{
  struct typedef_t *o;
  struct sysloc_t *sl;
  char *s;

  sl = MALLOC(struct sysloc_t, 1);
  sl->type = SYSLOCAL;
  sl->value = str_list_add(NULL,(char*)strdup("\"identifier\""));

  o = MALLOC(struct typedef_t, 1);

  o->name = (char*)strdup("Object");
  o->supertype = NULL;
  o->attrs = attr_list_add(NULL,(char*)strdup("identifier"), sl);
  o->key = str_list_add(NULL,(char*)strdup("identifier"));;
  
  parse_tree_add(&TREE(TD_NODE), TD_NODE, o);
};

void
check_typedefs()
{
  int j;
  struct parse_node_t **td; 
  long num_td; 

  add_object_type();
  
  td = TREE(TD_NODE).stmt_arr;
  num_td = TREE(TD_NODE).num_stmts; 

  for (j=0;j<num_td-1; j++)
    {
      struct typedef_t *st_ref;
      char *st = TD(td[j]->data)->supertype;
      char *t = TD(td[j]->data)->name;

      if (((st_ref=get_type_ref(st))== NULL)&&(strcmp(st,"Object")!=0))
	{
	  pplerror("Super-type '%s' for type '%s' undeclared", st,TD(td[j]->data)->name);
	} else {
	  TD(td[j]->data)->supertype_ref = st_ref;
	}

      if (strcmp(st, t)==0)
	{
	  pplerror("Type name '%s' matches supertype name", st);
	}
 
      check_attrs(TD(td[j]->data));
      
      if (!(namespace_add(&namespace, t, td[j])))
	{
	  pplerror("Type name '%s' is not unique", t);
	}
    }
 
};

void
check_matches()
{
  int j;
  struct parse_node_t **td = TREE(MATCH_NODE).stmt_arr;
  long num_td = TREE(MATCH_NODE).num_stmts;  
  struct parse_node_t *node;

  for (j=0;j<num_td; j++)
    {
      
      char *name = M(td[j]->data)->name;
      char *type = M(td[j]->data)->type;

      if (!(namespace_lookup(&namespace,type,(void**)&node)))
	{
	  pplerror("Type '%s' in match decl '%s' not defined", type, name);
	}

      M(td[j]->data)->type_ref = TD(node->data);

      namespace_add(&TD(node->data)->match_refs, name, td[j]->data);
      
      if (!(namespace_add(&namespace, name, td[j])))
	{
	  pplerror("Name '%s' used in match decl defined elsewhere", name);
	}

    }

};

void 
check_operations()
{
  int j;
  struct parse_node_t **td = TREE(OP_NODE).stmt_arr;
  long num_td = TREE(OP_NODE).num_stmts;
  struct parse_node_t *node;
  struct typedef_t *type;

  for (j=0;j<num_td; j++)
    {
      char *name = OP(td[j]->data)->name;
      struct str_list *agents = OP(td[j]->data)->agents;
      struct str_list *subjects = OP(td[j]->data)->subjects;
      
      struct str_list *itr;

      itr = agents;
      while (itr != NULL)
	{
	  if (!(namespace_lookup(&namespace, itr->str,(void**)&node)))
	    {
	      pplerror("Agent '%s' in operation decl '%s' not defined", itr->str, name);
	    }

	  if (node->type==TD_NODE)
	    {
	      struct typedef_t *type=TD(node->data);
	      while (type != NULL)
		{
		  namespace_append(&(OP(td[j]->data)->agent_refs), 
				   &type->match_refs);
	          type=type->supertype_ref;
	        };
	    } else {
	      namespace_add(&(OP(td[j]->data)->agent_refs), itr->str, node);
	    }
	  
	  itr = itr->next;
	}

      itr = subjects;
      while (itr != NULL)
	{
	  if (!(namespace_lookup(&namespace, itr->str,(void**)&node)))
	    {
	      pplerror("Subject '%s' in operation decl '%s' not defined", itr->str, name);
	    }

	  if (node->type==TD_NODE)
	    {
	      struct typedef_t *type = TD(node->data);
	      while (type!=NULL)
		{
		  namespace_append(&(OP(td[j]->data)->agent_refs), 
			       &type->match_refs);
	          type=type->supertype_ref;
	        };
	      
	    } else {
	      namespace_add(&(OP(td[j]->data)->subject_refs), itr->str, node);
	    }
	  
	  itr = itr->next;
	  
	}

      if (!(namespace_add(&namespace, name, td[j])))
	{
	  pplerror("Name '%s' used in operation decl defined elsewhere", name);
	}
    }
};

int
add_strlist_to_namespace(struct set_t *set, struct namespace_t *ns, struct str_list *str)
{
  char *name;
  struct str_list *itr;
  struct parse_node_t *node;
  int finished=1;

  itr = str;
	  
  while (itr != NULL)
    {
      if (!(namespace_lookup(&namespace, itr->str,(void**)&node)))
	{
	  pplerror("Member '%s' of set '%s' not defined", itr->str, set->name);
	}
      
      
      switch(node->type)
	{
	case TD_NODE:
	  {
	    struct typedef_t *type = TD(node->data);
	    while (strcmp(type->name, "Object")!=0)
	      {
		
		if (namespace_append(ns, 
				     &type->match_refs))
		  {
		    finished = 0;
		  }
		
		type=type->supertype_ref;
	      };
	  }
	  break;
	case MATCH_NODE:
	  {
	    if (namespace_add(ns, itr->str, node->data))
	      {
		finished=0;
	      }
	  }
	  break;
	case SET_NODE:
	  {
	    
	    if ((set != SET(node->data))&&(namespace_append(ns,&SET(node->data)->member_refs)))
	      {
		finished=0;
	      }
	  }
	  break;
	}
      itr = itr->next;
    }
  return finished;
};

int
update_set_aux(struct set_t *set, struct namespace_t *ns, struct set_expr_t *expr)
{
  struct namespace_t nstemp;
  int finished=1;

  switch(expr->op)
    {
    case SNOP:
      {
	if (add_strlist_to_namespace(set,ns,(struct str_list *)expr->lval))
	  {
	    finished = 0;
	  }
      }
      break;
    case SUNION:
      {
	bzero(&nstemp, sizeof(struct namespace_t));

	if (update_set_aux(set, ns, (struct set_expr_t *)expr->lval))
	  {
	    finished = 0;
	  }

	update_set_aux(set, &nstemp, (struct set_expr_t *)expr->rval);
	
	if (namespace_append(&nstemp, ns))
	  {
	    finished = 0;
	  }

	namespace_destroy(&nstemp);

      }
      break;
    case SISECT:
      {
	struct namespace_t nstemp2;
	struct namespace_enum_t *nse;
	struct namespace_node_t *node;

	bzero(&nstemp, sizeof(struct namespace_t));
	bzero(&nstemp2, sizeof(struct namespace_t));

	update_set_aux(set, &nstemp2, (struct set_expr_t *)expr->lval);

	update_set_aux(set, &nstemp, (struct set_expr_t *)expr->rval);

	nse = namespace_enum_new(&nstemp2);

	while (namespace_enum_has_more(nse))
	  {
	    node = namespace_enum_next(nse);

	    if (namespace_lookup(&nstemp, node->name, (void **)NULL))
	      {
		if (namespace_add(ns, node->name, node->node))
		  {
		    finished = 0;
		  }
	      }
	  }
      
	namespace_destroy(&nstemp2);
	namespace_destroy(&nstemp);

      }
      break;
      
    };

  return finished;
};



int 
update_set(struct set_t *set)
{
  return update_set_aux(set, &set->member_refs, set->expr);
};


void 
check_sets()
{
  int j, firstpass;
  struct parse_node_t **td = TREE(SET_NODE).stmt_arr;
  long num_td = TREE(SET_NODE).num_stmts;
  struct parse_node_t *node;
  int finished = 0;
  struct set_t *sd;
  struct str_list *itr;
  struct typedef_t *equivtd;
  struct namespace_enum_t *nse;
  struct match_t *m;

  firstpass=1;
  while (!(finished))
    {
      finished=1;
      
      for(j=0;j<num_td;j++)
	{
	  sd = SET(td[j]->data);

	  finished = update_set(sd);

	  if (firstpass)
	    namespace_add(&namespace, sd->name, td[j]);
	}
      firstpass=0;
    }

  
  for(j=0;j<num_td;j++)
    {
      sd = SET(td[j]->data);
      
      if (sd->member_refs.size == 0)
	{
	  pplerror("Set '%s' is empty!", sd->name);
	}

      nse = namespace_enum_new(&sd->member_refs);
      
      m=M(namespace_enum_next(nse)->node);

      equivtd = m->type_ref;
    
      while (namespace_enum_has_more(nse))
	{
	  if (strcmp(equivtd->name, "Object")==0)
	    break;

	  m=M(namespace_enum_next(nse)->node);
	  
	  if (strcmp(m->type_ref->name, equivtd->name)!=0)
	    {
	      while (strcmp(equivtd->name,"Object") != 0)
		{

		  struct typedef_t *temp = m->type_ref;
		  while (strcmp(temp->name, "Object") != 0)
		    {
		      if (strcmp(temp->name, equivtd->name)==0)
			{
			  break;
			}
		      temp = temp->supertype_ref;
		    }

		  if (strcmp(temp->name, equivtd->name)==0)
		    {
		      break;
		    }
		  equivtd = equivtd->supertype_ref;
		}
	    }

	}      
      
      sd->equiv_type_ref = equivtd;
    }
  
};


int
validate_pred_is_expr(struct pred_t *pred, struct ifclause_ext *ifclause)
{
  struct parse_node_t *pnode;
  struct object_t *refobj;
  struct object_list *params;
  struct object_list *input;
  struct typedef_t *td;
  struct object_list *oitr;

  if (!(namespace_lookup(&namespace, (char*)ifclause->rval,(void**)&pnode)))
    {
      pplerror("Identifier '%s' does not exist in predicate expression (1)", (char*)ifclause->rval);
    }

  if (pnode->type != PRED_NODE)
    {
      pplerror("Identifier '%s' is not a predicate, and should not be used after the 'is' keyword", ifclause->rval);
    }

  input = (struct object_list *)ifclause->lval;
  params = PRED(pnode->data)->params;

  if (params == NULL)
    {
      pplerror("No input parameters to predicate '%s' in 'is' expression", (char*)ifclause->rval);
    }

  while (input != NULL)
    {
      if (params == NULL)
	{
	  pplerror("Too many input parameters to predicate '%s'", (char*)ifclause->rval);
	}

      if (strchr(ifclause->lval, (int)'.') != NULL)
	{
	  pplerror("Expression '%s' referrs to an attribute in a predicate expression", ifclause->lval);
	}
      
      oitr = pred->params;
      while (oitr != NULL)
	{
	  if (strcmp(oitr->object->name, input->object->name)==0)
	    {
	      refobj = oitr->object;
	      break;
	    } 
	  oitr = oitr->next;
	}
      if (oitr == NULL)
	{
	  pplerror("Undefined variable '%s' in an 'is' expression");
	}

      td = get_type_ref(refobj->type);
      
      while (td != NULL)
	{
	  if (strcmp(td->name, params->object->type)==0)
	    {
	      break;
	    }
	  td = td->supertype_ref;
	}
      if (td == NULL)
	{
	  pplerror("Variable '%s' of type '%s' is not a valid input for predicate '%s' which is expecting a variable of type '%s'", input->object->name, refobj->type, (char*)ifclause->rval, params->object->type);
	}

      input = input->next;
      params = params->next;
    }
};

int
validate_pred_in_expr(struct pred_t *pred, struct ifclause_str *ifclause)
{
  struct parse_node_t *pnode;
  struct object_list *oitr;

  if (!(namespace_lookup(&namespace, (char*)ifclause->rval,(void**)&pnode)))
    {
      pplerror("Identifier '%s' does not exist in set inclusion expression", (char*)ifclause->rval);
    }

  if (pnode->type != SET_NODE)
    {
      pplerror("Identifier '%s' is not a set, and should not be used after the 'in' keyword", ifclause->rval);
    }
  
  if (strchr(ifclause->lval, (int)'.') != NULL)
    {
      pplerror("Expression '%s' referrs to an attribute in a set inclusion expression", ifclause->lval);
    }

  oitr = pred->params;

  while (oitr != NULL)
    {
      if (strcmp(oitr->object->name, ifclause->lval)==0)
	{
	  break;
	}
      oitr = oitr->next;
    }
  
  if (oitr == NULL)
    {
      pplerror("Undefined variable '%s' in an 'in' expression", ifclause->lval);
    }
  
  return 1;
};

int
validate_pred_name(struct pred_t *pred, char *name)
{
  struct object_list *oitr;
  struct parse_node_t *node;
  char *dot;

  if ((dot=(char*)strchr(name, (int)'.'))== (char*)NULL)
    {
      if (namespace_lookup(&namespace, name,(void**)&node))
	{
	  return 1;
	  
	} else {
	  oitr = pred->params;
	  
	  while (oitr != NULL)
	    {
	      if (strcmp(oitr->object->name, name)==0)
		{
		  break;
		}
	      oitr = oitr->next;
	    }
	  
	  if (oitr == NULL)
	    {
	      pplerror("Name '%s' in predicate '%s' is not declared and is not a parameter to '%s' (1)", name, pred->name, pred->name);
	    } else {
	      return 1;
	    }
	}	
    } else {
      *dot = '\0';
      oitr = pred->params;
      
      while (oitr != NULL)
	{
	  if (strcmp(oitr->object->name,name)==0)
	    {
	      struct parse_node_t *node;
	      
	      if (oitr->object->type == NULL)
		{
		  pplerror("Variable %s not bound to anything", oitr->object->name);
		}
	      namespace_lookup(&namespace, oitr->object->type,(void**) &node);
	      
	      switch (node->type)
		{
		case TD_NODE:
		  {
		    struct typedef_t *td = TD(node->data);
		    
		    if (get_attr_loc(td, (dot+1))==NULL)
		      {
			*dot = '.';
			pplerror("Attribute %s not a member of %s %s in conditional statement", (dot+1), td->name,oitr->object->name);
			return 0;
		      }
		    break;
		  }
		case MATCH_NODE:
		  {
		    struct match_t *td = M(node->data);
		    
		    
		    if (get_attr_loc(td->type_ref, (dot+1))==NULL)
		      {
			*dot = '.';
			pplerror("Attribute %s not a member of %s %s in conditional statement", (dot+1),td->type, oitr->object->name);
			return 0;
		      }
		    break;
		  }
		case SET_NODE:
		  {
		    struct set_t *typeset = SET(node->data);

		    if (get_attr_loc(typeset->equiv_type_ref, (dot+1))==NULL)
			  {
			    *dot = '.';
			    pplerror("Attribute %s does not exist for set %s in conditional statement containing %s", (dot+1),typeset->name,name );
			    return 0;
			  }
			
		      
		  }
		}
	      break;
	    }

	  oitr = oitr->next;
	}
      *dot = '.';
      
      if (oitr == NULL)
	{
	  pplerror("Name '%s' in predicate '%s' is not declared (2)", name, pred->name, pred->name);
	  return 0;
	}
    }
  return 0;
};

int
validate_pred_conditions(struct pred_t *pred, struct ifclause_ext *ifclause)
{
  int have_var = 0;
  struct ifclause_ext *ifc = ifclause;
  struct ifclause_str *sif;

  if (ifc == NULL)
    {
      return 1;
    }

  // Call the function recursively with the right & left exprs
  if (ifc->op >= 58)
    {
      return (validate_pred_conditions(pred,ifc->lval)&&validate_pred_conditions(pred,ifc->rval));
    }

  sif = (struct ifclause_str *)ifc;

  if (sif->op <= 55)
    {
      //standard conditional

      if (sif->lval != NULL)
	{
	  if (is_name(sif->lval))
	    {
	      have_var=1;
	      validate_pred_name(pred, sif->lval);
	    }
	}  
      
      if (sif->rval != NULL)
	{
	  if (is_name(sif->rval))
	    {
	      have_var=1;
	      validate_pred_name(pred, sif->rval);
	    }
	}
      
      if (have_var==0)
	{
	  pplerror("Neither '%s' nor '%s' are variable references in conditional clause of predicate '%s'", (sif->lval==NULL ? "n/a": sif->lval),(sif->rval==NULL ? "n/a": sif->rval), pred->name );
	}
      
    }

  if (sif->op == BIS)
    {
      validate_pred_is_expr(pred, ifc);
    }

  if (sif->op == BIN)
    {
      validate_pred_in_expr(pred, sif);
    }

    return 1;
};


void 
check_predicates()
{
  int j;
  struct parse_node_t **td = TREE(PRED_NODE).stmt_arr;
  long num_td = TREE(PRED_NODE).num_stmts;
  struct parse_node_t *node;
  struct pred_t *pd;
  struct object_list *oitr;

  for (j=0;j<num_td; j++)
    {
      pd = PRED(td[j]->data);


      //make sure name for predicate is not already taken
      
      if (namespace_lookup(&namespace, pd->name,(void**)&node))
	    {
	      pplerror("Predicate name '%s' already exists in namespace", pd->name);
	    }

      // make sure parameter types exist
      oitr = pd->params;
      while (oitr != NULL)
	{
	  if (!(namespace_lookup(&namespace, oitr->object->type,(void**)&node)))
	    {
	      pplerror("Type '%s', a parameter to predicate '%s' does not exist (1)", oitr->object->type,pd->name);
	    }
	  
	  if (node->type != TD_NODE)
	    {
	      pplerror("Type '%s', a parameter to predicate '%s' does not exist (2)", oitr->object->type,pd->name);
	    }
	  
	  oitr = oitr->next;
	}
      

      //check conditional statement
      
      validate_pred_conditions(pd, pd->ifclause);


      namespace_add(&namespace, pd->name, td[j]);
    }
};


int
is_name(char *s)
{

  
  if ((s[0] != '\0')&&(s[0] != '\'')&&
      (s[0] != '\"')) // not string
    {
      if ((s[0] < '0')||(s[0] > '9')) //not a number
	return 1; // a name!!
      else 
	return 0;
    } else return 0;
};

int
validate_name(struct statement_t *stmt, char *name)
{
  char *dot;
  if ((dot=(char*)strchr(name, (int)'.'))== (char*)NULL)
    {
      if ((!(namespace_lookup(&namespace, name,NULL)))&&
	  ((strcmp(stmt->agent->name,name)!=0)&&
	   (strcmp(stmt->subject->name,name)!=0)))
	{
	  pplerror("Name '%s' in conditional statement not defined (1)", name);
	} else {
	  return 1;
	}
      
    } else {
      *dot = '\0';
      ////////////// agent ///////////////
      if (strcmp(stmt->agent->name,name)==0)
	{
	  struct parse_node_t *node;

	  if (stmt->agent->type == NULL)
	    {
	      pplerror("Variable %s not bound to anything", stmt->agent->name);
	    }
	  namespace_lookup(&namespace, stmt->agent->type,(void**) &node);

	  switch (node->type)
	    {
	    case TD_NODE:
	      {
		struct typedef_t *td = TD(node->data);
		
		if (get_attr_loc(td, (dot+1))==NULL)
		  {
		    *dot = '.';
		    pplerror("Attribute %s not a member of %s %s in conditional statement", (dot+1), td->name,stmt->agent->name);
		    return 0;
		  }
		break;
	      }
	    case MATCH_NODE:
	      {
		struct match_t *td = M(node->data);
		

		if (get_attr_loc(td->type_ref, (dot+1))==NULL)
		  {
		    *dot = '.';
		    pplerror("Attribute %s not a member of %s %s in conditional statement", (dot+1),td->type, stmt->agent->name);
		    return 0;
		  }
		break;
	      }
	    case SET_NODE:
	      {
		struct set_t *typeset = SET(node->data);
		
		if (get_attr_loc(typeset->equiv_type_ref, (dot+1))==NULL)
		  {
		    *dot = '.';
		    pplerror("Attribute %s does not exist for set %s in conditional statement containing %s", (dot+1),typeset->name,name );
		    return 0;
		  }

	      }
	    }
	} else {
	  ////////////// subject ///////////////
	  if (strcmp(stmt->subject->name,name)==0)
	    {
	      struct parse_node_t *node;
	      
	      if (stmt->subject->type == NULL)
		{
		  pplerror("Variable %s not bound to anything", stmt->subject->name);
		}
	      namespace_lookup(&namespace, stmt->subject->type,(void**)  &node);
	      
	      switch (node->type)
		{
		case TD_NODE:
		  {
		    struct typedef_t *td = TD(node->data);
		    
		    if (get_attr_loc(td, (dot+1))==NULL)
		      {
			*dot = '.';
			pplerror("Attribute %s not a member of %s in conditional statement", (dot+1), stmt->subject->name);
			return 0;
		      }
		    break;
		  }
		case MATCH_NODE:
		  {
		    struct match_t *td = M(node->data);
		    
		    
		    if (get_attr_loc(td->type_ref, (dot+1))==NULL)
		      {
			*dot = '.';
			pplerror("Attribute %s not a member of %s %s in conditional statement", (dot+1),td->type, stmt->subject->name);
			return 0;
		      }
		    break;
		  }
		case SET_NODE:
		  {
		    struct set_t *typeset = SET(node->data);
		    
		    if (get_attr_loc(typeset->equiv_type_ref, (dot+1))==NULL)
		      {
			*dot = '.';
			pplerror("Attribute %s does not exist for set %s in conditional statement containing %s", (dot+1),typeset->name,name );
			return 0;
		      }
			
		  
		  }
		}
	    } else {
	      *dot = '.';
	      
	      pplerror("%s is not bound to the agent or subject of that statement", name);
	    }
	}
    }
  *dot = '.';
  return 1;
};

int
validate_is_expr(struct statement_t *stmt, struct ifclause_ext *ifclause)
{
  struct parse_node_t *pnode;
  struct object_t *refobj;
  struct object_list *params;
  struct object_list *input;
  struct typedef_t *td;

  if (!(namespace_lookup(&namespace, (char*)ifclause->rval,(void**)&pnode)))
    {
      pplerror("Identifier '%s' does not exist in predicate expression (2)", (char*)ifclause->rval);
    }

  if (pnode->type != PRED_NODE)
    {
      pplerror("Identifier '%s' is not a predicate, and should not be used after the 'is' keyword", ifclause->rval);
    }

  input = (struct object_list *)ifclause->lval;
  params = PRED(pnode->data)->params;

  if (params == NULL)
    {
      pplerror("No input parameters to predicate '%s' in 'is' expression", (char*)ifclause->rval);
    }

  while (input != NULL)
    {
      if (params == NULL)
	{
	  pplerror("Too many input parameters to predicate '%s'", (char*)ifclause->rval);
	}

      if (strchr(ifclause->lval, (int)'.') != NULL)
	{
	  pplerror("Expression '%s' referrs to an attribute in a predicate expression", ifclause->lval);
	}
      
      if (strcmp(stmt->agent->name, input->object->name)==0)
	{
	  refobj = stmt->agent;
	} else {
	  if (strcmp(stmt->subject->name, input->object->name)==0)
	    {
	      refobj = stmt->subject;
	    } else {
	      pplerror("Undefined variable '%s' in an 'is' expression");
	    }
	  
	}

      td = get_type_ref(refobj->type);
      
      while (td != NULL)
	{
	  if (strcmp(td->name, params->object->type)==0)
	    {
	      break;
	    }
	  td = td->supertype_ref;
	}
      if (td == NULL)
	{
	  pplerror("Variable '%s' of type '%s' is not a valid input for predicate '%s' which is expecting a variable of type '%s'", input->object->name, refobj->type, (char*)ifclause->rval, params->object->type);
	}

      input = input->next;
      params = params->next;
    }
};

int
validate_in_expr(struct statement_t *stmt, struct ifclause_str *ifclause)
{
  struct parse_node_t *pnode;

  if (!(namespace_lookup(&namespace, (char*)ifclause->rval,(void**)&pnode)))
    {
      pplerror("Identifier '%s' does not exist in set inclusion expression", (char*)ifclause->rval);
    }

  if (pnode->type != SET_NODE)
    {
      pplerror("Identifier '%s' is not a set, and should not be used after the 'in' keyword", ifclause->rval);
    }
  
  if (strchr(ifclause->lval, (int)'.') != NULL)
    {
      pplerror("Expression '%s' referrs to an attribute in a set inclusion expression", ifclause->lval);
    }

  if ((!(strcmp(stmt->agent->name, ifclause->lval)==0))&&
      (!(strcmp(stmt->subject->name, ifclause->lval)==0)))
    {
      pplerror("Undefined variable '%s' in an 'in' expression");
    }
  
  return 1;
};


int
validate_ifclause(struct statement_t *stmt, struct ifclause_ext *ifclause)
{

  int have_var = 0;
  struct ifclause_ext *ifc = ifclause;
  struct ifclause_str *sif;

  if (ifc == NULL)
    {
      return 1;
    }

  // Call the function recursively with the right & left exprs
  if (ifc->op >= 58)
    {
      //extended op

      return (validate_ifclause(stmt,ifc->lval)&&validate_ifclause(stmt,ifc->rval));
    }

  sif = (struct ifclause_str *)ifc;

  if (sif->op <= 55)
    { 

      // comparison operator

      if (sif->lval != NULL)
	{
	  if (is_name(sif->lval))
	    {
	      have_var=1;
	      validate_name(stmt, sif->lval);
	    }
	}  
      
      if (sif->rval != NULL)
	{
	  if (is_name(sif->rval))
	    {
	      have_var=1;
	      validate_name(stmt, sif->rval);
	    }
	}
      
      if (have_var==0)
	{
	  pplerror("Neither %s nor %s are variable references in conditional clause", (sif->lval==NULL ? "n/a": sif->lval),(sif->rval==NULL ? "n/a": sif->rval) );
	}
      

      return 1;
    }

  if (sif->op == BIS)
    {
      validate_is_expr(stmt, ifc);
    }

  if (sif->op == BIN)
    {
      validate_in_expr(stmt, sif);
    }

  return 0;
};


void
check_pepl_statements()
{
  int j;
  struct parse_node_t **td = TREE(STMT_NODE).stmt_arr;
  long num_td = TREE(STMT_NODE).num_stmts;

  for (j=0;j<num_td; j++)
    {
      struct parse_node_t *opnode;
      struct parse_node_t *subnode;
      struct parse_node_t *agnode;
      int allow = PPL(td[j]->data)->allow;
      char *operation = PPL(td[j]->data)->operation;
      struct object_t *subject = PPL(td[j]->data)->subject;
      struct object_t *agent = PPL(td[j]->data)->agent;
      struct ifclause_ext *ifclause = PPL(td[j]->data)->ifclause;

      if (!(namespace_lookup(&namespace, operation,(void**)  &opnode)))
	{
	  pplerror("Cannot find operation '%s' in PEPL statement", operation);
	};
      
      if (!(namespace_lookup(&namespace, (subject->type==NULL ? subject->name : subject->type),(void**)  &subnode)))
	{
	  pplerror("Cannot find subject '%s' in PEPL statement (1)",(subject->type==NULL ? subject->name : subject->type) );
	};

      if (!(namespace_lookup(&namespace, (agent->type==NULL ? agent->name : agent->type),(void**)  &agnode)))
	{
	  pplerror("Cannot find agent '%s' in PEPL statement", (agent->type==NULL ? agent->name : agent->type));
	};

      if (!(agent_in_op(OP(opnode->data),agnode)))
	{
	  pplerror("Agent '%s' cannot execuate operation '%s'", agent->name, operation);
	};

      if (!(subject_in_op(OP(opnode->data),subnode)))
	{
	  pplerror("Subject '%s' cannot receive operation '%s'", subject->name, operation);
	};

      validate_ifclause(PPL(td[j]->data),ifclause);
    }

};

////////////////////////////////////////////////////////
/////////////////// Verifying / Printing PEPL Statements
/////////////////// from here down
////////////////////////////////////////////////////////


int
agent_in_op(struct opdef_t *opd, struct parse_node_t *agent)
{
  struct str_list *itr = opd->agents;
  struct parse_node_t *node;
  char *type;
  
  while (itr!=NULL)
    {
      switch (agent->type)
	{
	case MATCH_NODE:
	  if (strcmp(itr->str, M(agent->data)->name)==0)
	    return 1;
	  namespace_lookup(&namespace, itr->str,(void**) &node);
	  if (node->type==TD_NODE)
	    {
	      if (ancestor_of(M(agent->data)->type_ref,TD(node->data)->name))
		return 1;
	    }
	   break;
	case TD_NODE:
	  if (strcmp(itr->str, TD(agent->data)->name)==0)
	    return 1;
	  namespace_lookup(&namespace, itr->str,(void**)  &node);
	  if (node->type==TD_NODE)
	    {
	      if (ancestor_of(TD(agent->data),TD(node->data)->name))
		return 1;
	    }
	} 
      itr = itr->next;
    }

  return 0;
};



int
subject_in_op(struct opdef_t *opd,struct parse_node_t *subject)
{
  struct str_list *itr = opd->subjects;
  struct parse_node_t *node;
  char *type;
  
  while (itr!=NULL)
    {
      switch (subject->type)
	{
	case MATCH_NODE:
	  if (strcmp(itr->str, M(subject->data)->name)==0)
	    return 1;
	  namespace_lookup(&namespace, itr->str,(void**)  &node);
	  if (node->type==TD_NODE)
	    {
	      if (ancestor_of(M(subject->data)->type_ref,TD(node->data)->name))
		return 1;
	    }
	  break;
	case TD_NODE:
	  if (strcmp(itr->str, TD(subject->data)->name)==0)
	    return 1;
	  namespace_lookup(&namespace, itr->str,(void**)  &node);
	  if (node->type==TD_NODE)
	    {
	      if (ancestor_of(TD(subject->data),TD(node->data)->name))
		return 1;
	    }
	  break;
	case SET_NODE:
	  {
	    struct namespace_enum_t *nse;
	    struct namespace_node_t *nsnode;
	    struct match_t *m;
	    int except = 0;
	    nse = namespace_enum_new(&SET(subject->data)->member_refs);

	    while (namespace_enum_has_more(nse))
	      {
		nsnode = namespace_enum_next(nse);
		
		if (strcmp(itr->str, nsnode->name)==0)
		  goto found;

		namespace_lookup(&namespace, itr->str,(void**)  &node);
		if (node->type==TD_NODE)
		  {
		    if (ancestor_of(M(nsnode->node)->type_ref,TD(node->data)->name))
		      goto found;
		  }

		
		except=1;
		break;

	      found:
	      }

	    if (!except)
	      return 1;

	  }
	  break;
	}
      itr = itr->next;
    }

  return 0;
};

char *
print_op(struct opdef_t *opd)
{
  char *temp=NULL;
  struct str_list *itr = opd->key;
  psprintf(&temp, "((operation == ");
  while(itr->next != NULL)
    {
      psprintf(&temp, "%s)&&(operation == ", itr->str);
      itr = itr->next;
    }
  if (itr != NULL)
    {
      psprintf(&temp, "%s))", itr->str);
    }
  return temp;
};

char *
print_attr(struct sysloc_t *sl)
{
  char *temp=NULL;
  char *ret=NULL;
  int quote;

  if (sl->type == SYSLOCAL)
    {
      temp = (sl->value->str);
    } else {
      
      // sl->type == SYSREMOTE
      
      current_query++;
      
      if (last_query >= current_query)
	{
	  
	  temp = (sl->value->str);
	  
	} else if (last_query+1 == current_query)
	  {
	    struct str_list *itr = sl->value;
	    
	    querynum++;
	    
	    fprintf(configfd, "%d,", querynum);
	    
	    while(itr->next !=NULL)
	      {
		fprintf(configfd, "%s,", itr->str);
		itr = itr->next;
	      }
	    
	    fprintf(configfd, "%s", itr->str);
	    
	    fprintf(configfd, "\n");
	    
	    return NULL;
	  } else {
	    return NULL;
	  }
    }
  
  
  if (temp!=NULL)
	{
	  quote=0;
	  if (temp[0]=='\"')
	    {
	      quote=1;
	      temp = temp+1;
	      temp[strlen(temp)-1]='\0';
	    }

	  ret = (char*)strdup(temp);
	  
	  if (quote)
	    {
	      temp = temp-1;
	      temp[strlen(temp)]='\"';
	    }

	}

  return ret;
};

char *
print_match(struct match_t *m)
{
  char *temp=NULL;
  struct parse_node_t *node;
  struct str_list *itr = m->key;
  struct attr_list *typekey;
  int closeparen;
  
  typekey = m->type_ref->key_attr_vals;

  if (!((typekey->sysloc->type == SYSREMOTE)&&(last_query < current_query+1)))
    {
      psprintf(&temp, "(");
      closeparen=1;
    } else {
      closeparen=0;
    }
  
  while(itr->next != NULL)
    {
      char * temp2 = print_attr(typekey->sysloc);
      int quote=0;

      if (temp2!=NULL)
	{
	  if (!closeparen)
	    {
	      psprintf(&temp, "(");
	      
	      closeparen=1;
	    }

	  psprintf(&temp,"(%s == %s)&&",temp2, itr->str);
	  
	  free(temp2);
	  temp2=NULL;
	}
      
      itr = itr->next;
      typekey = typekey->next;
    }

  if (itr!=NULL)
    {
      char * temp2 = print_attr(typekey->sysloc);
      int quote=0;

      if (temp2!=NULL)
	{
	  if (!closeparen)
	    {
	      psprintf(&temp, "(");
	      
	      closeparen=1;
	    }

	  psprintf(&temp,"(%s == %s)",temp2, itr->str);
	  
	  free(temp2);
	  temp2=NULL;
	}
    }
  if (closeparen)
    psprintf(&temp, ")");

  return temp;
};

int
ancestor_of(struct typedef_t *test, char *ancestor)
{
  struct typedef_t *td;

  td = test;

  while (td != NULL)
    {
      if (strcmp(td->name, ancestor)==0)
	return 1;
      td=td->supertype_ref;
    };

	  return 0;
};

char *
print_type(char *attrname, struct typedef_t *chktd)
{
  char *temp=NULL;
  char *temp2=NULL;
  int j,exist;
  struct typedef_t *type;
  struct parse_node_t **td = TREE(TD_NODE).stmt_arr;
  long num_td = TREE(TD_NODE).num_stmts;  

  exist=0;
  psprintf(&temp, "(");
  for (j=0;j<num_td; j++)
    {
      type = TD(td[j]->data);
      if (ancestor_of(type,chktd->name))
	{
	  if (!(exist))
	    {
	      exist=1;
	      psprintf(&temp, "(%s == \"%s\")", attrname, type->name);
	    } else {
	      psprintf(&temp, "||(%s == \"%s\")", attrname, type->name);
	    }
	}
    }

  psprintf(&temp,")");
  
  return temp;
};


char *
print_set(struct set_t *s)
{
  char *temp=NULL;
  char *temp2;
  int havematch=0;
  struct namespace_enum_t *nse;
  struct namespace_node_t *nsnode;


  nse = namespace_enum_new(&(s->member_refs));
  
  psprintf(&temp,"(");
  while (namespace_enum_has_more(nse))
    {
      nsnode = namespace_enum_next(nse);

      
      temp2 = print_match(M(nsnode->node));
      if (temp2!=NULL)
	havematch=1;

      if ((temp2!=NULL)&&(namespace_enum_has_more(nse)))
	{
	  psprintf(&temp,"%s || ", temp2);
	  free(temp2);
	  temp2=NULL;
	}
    }
  if (temp2!=NULL)
    {
      psprintf(&temp,"%s)", temp2);
      free(temp2);
    }
  if (havematch)
    return temp;
  else
    return NULL;
};

char *
print_pred(struct pred_t *p);

char *
print_pred_name(struct pred_t *pred, char *name)
{
  char *temp=NULL;
  struct sysloc_t *sl;
  struct parse_node_t *pnode;
  char *dot;
  struct object_list *oitr;

  if ((dot=(char*)strchr(name, (int)'.'))== (char*)NULL)
    {
      if (!(namespace_lookup(&namespace, name,(void**)&pnode)))
	{
	  oitr = pred->params;
	  
	  while (oitr != NULL)
	    {
	      if (strcmp(oitr->object->name, name)==0)
		{
		  break;
		}
	      oitr = oitr->next;
	    }
	  
	  if (oitr == NULL)
	    {
	      pplerror("Name '%s' in predicate '%s' is not declared and is not a parameter to '%s' (1)", name, pred->name, pred->name);
	    } else {
	      
	      namespace_lookup(&namespace, oitr->object->type,(void**)&pnode);

	      switch(pnode->type)
		{
		case MATCH_NODE:
		  temp = string_merge(temp,print_match(M(pnode->data)));
		  break;
		case TD_NODE:
		  psprintf(&temp,"(");
		  temp= string_merge(temp,print_type("agent",TD(pnode->data)));
		  psprintf(&temp,"||");
		  temp= string_merge(temp,print_type("subject",TD(pnode->data)));
		  psprintf(&temp,")");
		  break;
		case SET_NODE:
		  temp= string_merge(temp,print_set(SET(pnode->data)));
		  break;
		case PRED_NODE:
		  temp= string_merge(temp,print_pred(PRED(pnode->data)));
		  break;
		};
	    }
	} 
    } else {
      *dot = '\0';

            oitr = pred->params;
      
      while (oitr != NULL)
	{
	  if (strcmp(oitr->object->name,name)==0)
	    {
	      struct parse_node_t *node;
	      
	      namespace_lookup(&namespace, oitr->object->type,(void**) &node);
	      
	      switch (node->type)
		{
		case TD_NODE:
		  {
		    struct typedef_t *td = TD(node->data);

		    sl = get_attr_loc(td, (dot+1));
		    
		    temp = string_merge(temp, print_attr(sl));
		    
		    break;
		  }
		case MATCH_NODE:
		  {
		    struct match_t *td = M(node->data);

		    sl = get_attr_loc(td->type_ref, (dot+1));

		    temp = string_merge(temp, print_attr(sl));
		    
		    break;
		  }
		case SET_NODE:
		  {
		    struct set_t *typeset = SET(node->data);
		    struct namespace_enum_t *nse;
		    struct match_t *m;
		    
		    nse = namespace_enum_new(&typeset->member_refs);
		    
		    while (namespace_enum_has_more(nse))
		      {
			m=M(namespace_enum_next(nse)->node);
			
			sl = get_attr_loc(m->type_ref, (dot+1));

			temp = string_merge(temp, print_attr(sl));
		      }
		  }
		}
	      break;
	    }
	  oitr = oitr->next;
	}
      
      *dot = '.';
      
    }
  return temp;
}

char *
print_pred_cond(struct pred_t *pred, struct ifclause_ext *ifc)
{
  char *temp=NULL;
  char *temp2=NULL;

  psprintf(&temp,"(");

  if (ifc->op >= 58)
    {
      temp2 = print_pred_cond(pred, ifc->lval);
      
      if (temp2 != NULL)
	{
	  
	  if (ifc->op == BNOT)
	    psprintf(&temp,"!");

	  temp = string_merge(temp, temp2);
	
	  temp2=NULL;
  
	  switch(ifc->op)
	    {
	    case BOR:
	      psprintf(&temp," || ");
	      break;
	    case BAND:
	      psprintf(&temp," && ");
	      break;
	    };
	  
      
	  if (ifc->op != BNOT)
	    {
	      temp2 = print_pred_cond(pred, ifc->rval);

	      if (temp2==NULL)
		{
		  free(temp);
		  temp=NULL;
		} else {
		  temp = string_merge(temp,temp2);
		  
		  temp2=NULL;
		}
	      
	    }
	}
    } else {
      struct ifclause_str *sif;
      
      sif = (struct ifclause_str *)ifc;
      
      if (sif->op <= 55)
	{
	  //standard conditional statement
	  
	  if (sif->lval != NULL)
	    {
	      if (is_name(sif->lval))
		{
		  temp2 = print_pred_name(pred, sif->lval);
		  
		} else {
		  psprintf(&temp2,"%s", sif->lval);
		}
	    }  
	  
	  if (temp2!=NULL)
	    {
	      temp = string_merge(temp,temp2);
	      
	      temp2=NULL;
	      
	      switch(sif->op)
		{
		case EQ:
		  psprintf(&temp," == ");
		  break;
		case LT:
		  psprintf(&temp," < ");
		  break;
		case LEQ:
		  psprintf(&temp," <= ");
		  break;
		case GT:
		  psprintf(&temp," > ");
		  break;
		case GEQ:
		  psprintf(&temp," >= ");
		  break;
		case NEQ:
		  psprintf(&temp," != ");
		  break;
		};
	  
	      if (sif->rval != NULL)
		{
		  if (is_name(sif->rval))
		    {
		      temp2=print_pred_name(pred, sif->rval);
		      
		    } else {
		      psprintf(&temp2,"%s", sif->rval);
		    }
		 
		}
	      if (temp2 == NULL)
		{
		  free(temp);
		  temp=NULL;
		} else {
		  temp = string_merge(temp,temp2);
		  temp2=NULL;
		}

	    }
	} else {
	      
	  if (sif->op == BIN)
	    {
	      struct parse_node_t *node;
	      
	      namespace_lookup(&namespace, sif->rval, (void**)&node);
	      
	      temp=string_merge(temp,print_set(SET(node->data)));
	      
	    } 
	  
	  if (sif->op == BIS)
	    {
	      struct parse_node_t *node;
	      
	      namespace_lookup(&namespace, sif->rval, (void**)&node);
	      
	      temp=string_merge(temp,print_pred(PRED(node->data)));
	      
	    }
	}
      
      
    }
  
  if (temp==NULL)
    return NULL;

  if (strcmp(temp,"(")!=0)
    {
      psprintf(&temp,")");
    } else {
     
      free(temp);
      temp=NULL;
    }
  
  return temp;
  
};



char *
print_pred(struct pred_t *p)
{
  return print_pred_cond(p, p->ifclause);
};

char *
print_name(struct statement_t *stmt, char *name)
{
  char *temp=NULL;
  struct sysloc_t *sl;

  struct parse_node_t *pnode;


  char *dot;
  if ((dot=(char*)strchr(name, (int)'.'))== (char*)NULL)
    {
      if (!(namespace_lookup(&namespace, name,(void**)&pnode)))
	{
	  if ((strcmp(stmt->agent->name,name)!=0))
	    {
	      switch(pnode->type)
	      {
	      case MATCH_NODE:
		temp=string_merge(temp,print_match(M(pnode->data)));
		break;
	      case TD_NODE:
		temp=string_merge(temp,print_type("agent",TD(pnode->data)));
		break;
	      case SET_NODE:
		temp=string_merge(temp,print_set(SET(pnode->data)));
		break;
	      case PRED_NODE:
		temp=string_merge(temp,print_pred(PRED(pnode->data)));
		break;
	      }
	    } else if (strcmp(stmt->subject->name,name)!=0) {
	    switch(pnode->type)
	      {
	      case MATCH_NODE:
		temp=string_merge(temp,print_match(M(pnode->data)));
		break;
	      case TD_NODE:
		temp=string_merge(temp,print_type("subject",TD(pnode->data)));
		break;
	      case SET_NODE:
		temp=string_merge(temp,print_set(SET(pnode->data)));
		break;
	      case PRED_NODE:
		temp=string_merge(temp,print_pred(PRED(pnode->data)));
		break;
	      }
	    } else {
	      pplerror("Name '%s' in conditional statement not defined (2)", name);
	    };
	  
	}
      
    } else {
      *dot = '\0';
      ////////////// agent ///////////////
      if (strcmp(stmt->agent->name,name)==0)
	{
	  struct parse_node_t *node;

	  namespace_lookup(&namespace, stmt->agent->type,(void**) &node);

	  switch (node->type)
	    {
	    case TD_NODE:
	      {
		struct typedef_t *td = TD(node->data);
		
		sl = get_attr_loc(td, (dot+1));

		temp = string_merge(temp, print_attr(sl));

		break;
	      }
	    case MATCH_NODE:
	      {
		struct match_t *td = M(node->data);
		
		sl = get_attr_loc(td->type_ref, (dot+1));

		temp = string_merge(temp, print_attr(sl));

		break;
	      }
	    case SET_NODE:
	      {
		struct set_t *typeset = SET(node->data);
		struct namespace_enum_t *nse;
		struct match_t *m;

		nse = namespace_enum_new(&typeset->member_refs);

		while (namespace_enum_has_more(nse))
		  {
		    m=M(namespace_enum_next(nse)->node);

		    sl = get_attr_loc(m->type_ref, (dot+1));

		    temp = string_merge(temp, print_attr(sl));
		  }
	      }
	    }
	} else {
	  ////////////// subject ///////////////
	  if (strcmp(stmt->subject->name,name)==0)
	    {
	      struct parse_node_t *node;
	      
	      namespace_lookup(&namespace, stmt->subject->type,(void**)  &node);
	      
	      switch (node->type)
		{
		case TD_NODE:
		  {
		    struct typedef_t *td = TD(node->data);
		    
		    sl = get_attr_loc(td, (dot+1));

		    temp = string_merge(temp, print_attr(sl));

		    break;
		  }
		case MATCH_NODE:
		  {
		    struct match_t *td = M(node->data);
		    
		    sl = get_attr_loc(td->type_ref, (dot+1));
		    
		    temp = string_merge(temp, print_attr(sl));
		   
		    break;
		  }
		case SET_NODE:
		  {
		    struct set_t *typeset = SET(node->data);
		    struct namespace_enum_t *nse;
		    struct match_t *m;
		    
		    nse = namespace_enum_new(&typeset->member_refs);
		    
		    while (namespace_enum_has_more(nse))
		      {
			m=M(namespace_enum_next(nse)->node);

			sl = get_attr_loc(m->type_ref, (dot+1));

			temp = string_merge(temp, print_attr(sl));
		      }
		  }
		}
	    } else {
	      *dot = '.';
	      
	      pplerror("%s is not bound to the agent or subject of that statement", name);
	    }
	}
      *dot = '.';
    }
  return temp;
};

char *
print_if_clause(struct statement_t *stmt, struct ifclause_ext *ifc)
{
  char *temp=NULL;
  char *temp2=NULL;

  psprintf(&temp,"(");

  if (ifc->op >= 58)
    {
     
      temp2 = print_if_clause(stmt, ifc->rval);
      
      
      if (temp2!=NULL)
	{
	  
	  if (ifc->op == BNOT)
	    psprintf(&temp,"!");

	  temp = string_merge(temp, temp2);

	  temp2=NULL;

	  switch(ifc->op)
	    {
	    case BOR:
	      psprintf(&temp," || ");
	      break;
	    case BAND:
	      psprintf(&temp," && ");
	      break;
	    };

	  if (ifc->op != BNOT)
	    {
	      temp2 = print_if_clause(stmt, ifc->rval);

	      if (temp2==NULL)
		{
		  free(temp);
		  temp=NULL;
		}else {
		  temp = string_merge(temp,temp2);
		}
	      
	    }
	}
    } else {
      struct ifclause_str *sif;

      sif = (struct ifclause_str *)ifc;

      if (sif->op <= 55)
	{
	  //standard conditional statement

	  if (sif->lval != NULL)
	    {
	      if (is_name(sif->lval))
		{
		  temp2 = print_name(stmt, sif->lval);
		  
		} else {
		  psprintf(&temp2,"%s", sif->lval);
		}
	    }  
	  
	  if (temp2!=NULL)
	    {

	      temp = string_merge(temp, temp2);
	      
	      temp2=NULL;

	      switch(sif->op)
		{
		case EQ:
		  psprintf(&temp," == ");
		  break;
		case LT:
		  psprintf(&temp," < ");
		  break;
		case LEQ:
		  psprintf(&temp," <= ");
		  break;
		case GT:
		  psprintf(&temp," > ");
		  break;
		case GEQ:
		  psprintf(&temp," >= ");
		  break;
		case NEQ:
		  psprintf(&temp," != ");
		  break;
		};
	      
	      if (sif->rval != NULL)
		{
		  if (is_name(sif->rval))
		    {
		      temp2 = print_name(stmt, sif->rval);
		      
		    } else {
		      psprintf(&temp2,"%s", sif->rval);
		    }
		}

	      if (temp2==NULL)
		{
		  free(temp);
		  temp=NULL;
		} else {
		  temp = string_merge(temp,temp2);
		  temp2=NULL;
		}

	    }
	} else {

	  if (sif->op == BIN)
	    {
	      struct parse_node_t *node;

	      namespace_lookup(&namespace, sif->rval, (void**)&node);

	      temp=string_merge(temp,print_set(SET(node->data)));
	     
	    } 

	  if (sif->op == BIS)
	    {
	      struct parse_node_t *node;

	      namespace_lookup(&namespace, sif->rval, (void**)&node);

	      temp=string_merge(temp,print_pred(PRED(node->data)));
	      
	    }
	}


    }
 
  if (temp==NULL)
    return NULL;

  if (strcmp(temp,"(")!=0)
    {
      psprintf(&temp,")");
    } else {
      free(temp);
      temp=NULL;
    }

  return temp;
};



char *
print_keynote_header()
{
  char *temp=NULL;
  psprintf(&temp, "Keynote-Version:  2\n");
  psprintf(&temp,"Authorizer:  \"POLICY\"\nConditions: ");
  return temp;
};

#include <sys/types.h>
#include <sys/stat.h>

void
print_logic()
{
  char *temp=NULL;
  char *temp2;
  int j;
  struct parse_node_t **td = TREE(STMT_NODE).stmt_arr;
  long num_td = TREE(STMT_NODE).num_stmts;
  char *path = (char*)getwd(NULL);
  char *newpath;
  char *fn = MALLOC(char, 25);
  char *query = MALLOC(char, 10);
  int crednum = 0;
  
  newpath = MALLOC(char, strlen(path) + 13);

  strcpy(newpath, path);
  strcat(newpath, "/credentials");

  mkdir(newpath, S_IRWXU);

  free(newpath);
  free(path);

  sprintf(fn, "credentials/queries", j);
  configfd = fopen(fn, "w+");
  outputfd = fopen("credentials/policy", "w+");

  for (j=0;j<num_td; j++)
    {
      struct parse_node_t *opnode;
      struct parse_node_t *subnode;
      struct parse_node_t *agnode;
      int allow = PPL(td[j]->data)->allow;
      char *operation = PPL(td[j]->data)->operation;
      struct object_t *subject = PPL(td[j]->data)->subject;
      struct object_t *agent = PPL(td[j]->data)->agent;
      struct ifclause_ext *ifclause = PPL(td[j]->data)->ifclause;

      last_query = 0;

      do {

	temp=NULL;

	current_query = 0;

	fprintf(outputfd, "\n\n");
	
	if (outputfd == NULL)
	  pplerror("Error openning file %s", fn);
	
	if (!(namespace_lookup(&namespace, operation,(void**)  &opnode)))
	  {
	    pplerror("Cannot find operation '%s' in PEPL statement", operation);
	  };
	
	if (!(namespace_lookup(&namespace, (subject->type==NULL ? subject->name : subject->type),(void**)  &subnode)))
	  {
	    pplerror("Cannot find subject '%s' in PEPL statement (2)", subject);
	  };
	
	if (!(namespace_lookup(&namespace, (agent->type==NULL ? agent->name : agent->type),(void**)  &agnode)))
	  {
	    pplerror("Cannot find agent '%s' in PEPL statement", agent);
	  };
	
	if (!(agent_in_op(OP(opnode->data),agnode)))
	  {
	    pplerror("Agent '%s' cannot execuate operation '%s'", agent->name, operation);
	  };
	
	if (!(subject_in_op(OP(opnode->data),subnode)))
	  {
	    pplerror("Subject '%s' cannot receive operation '%s'", subject->name, operation);
	  };
	
	
	temp = string_merge(temp,print_keynote_header());
	
	
	psprintf(&temp,"(");
	temp = string_merge(temp,print_op(OP(opnode->data)));
	
		
	switch(agnode->type)
	  {
	  case TD_NODE:	    
	    temp2 = print_type("agent", TD(agnode->data));
	    break;
	  case MATCH_NODE:
	    temp2 = print_match(M(agnode->data));
	    break;
	  case SET_NODE:
	    temp2 = print_set(SET(subnode->data));
	    break;
	  }; 
	
	if (temp2 != NULL)
	  {
	    psprintf(&temp, " && %s", temp2);
	    free(temp2);
	    temp2=NULL;
	  }
	
	
	switch(subnode->type)
	  {
	  case TD_NODE:
	    temp2 = print_type("subject", TD(subnode->data));
	    break;
	  case MATCH_NODE:
	    temp2 = print_match(M(subnode->data));
	    break;
	  case SET_NODE:
	    temp2 = print_set(SET(subnode->data));
	    break;
	  }
	
	if (temp2!=NULL)
	  {
	    psprintf(&temp, " && %s", temp2);
	    free(temp2);
	    temp2=NULL;
	  }

	if (ifclause!=NULL)
	  {
	    temp2 = print_if_clause(PPL(td[j]->data), PPL(td[j]->data)->ifclause);
	    if (temp2!=NULL)
	      {
		psprintf(&temp, " && %s", temp2);
		free(temp2);
		temp2=NULL;
	      }
	    
	  }
	
	psprintf(&temp,") -> ");
	
	last_query++;

	if (allow)
	  {
	    if (last_query <= current_query) 
	      {
		sprintf(query, "\"_%d\"", querynum);
		psprintf(&temp, query);
	      } else {
		psprintf(&temp,"_MAX_TRUST");
	      }
	  } else{ 
	    psprintf(&temp,"_MIN_TRUST");
	  }

	psprintf(&temp,";\n");

	crednum++;
	
	fprintf(outputfd, "%s", temp);

	free(temp);

      } while (last_query <= current_query);
      
      
    }
  
  free(fn);
  free(query);

  fclose(outputfd);
  fclose(configfd);
};


///////////////////////////////////////////////////
///////////////////////////////////////////////////
///////////////////////////////////////////////////

void
generate_keynote()
{
  

  check_typedefs();

  check_matches();

  check_operations();

  check_sets();

  check_predicates();

  check_pepl_statements();

  print_logic();


};



