/*
 * This is the header file for the policy device driver
 *
 */

#ifndef _POLICY_H_
#define _POLICY_H_

#define POLICY_ENABLED 1

#include <sys/types.h>
#include <sys/conf.h>
#include <sys/systm.h>
#include <sys/exec.h>
#include <sys/lkm.h>
#include <sys/time.h>

#define POL_REMOTEPORT 2

#define	POLICY_DATA_SIZE	((u_int32_t) (256 - sizeof(int) - sizeof(policy_mbuf *)))


enum plc_type {PLC_FILESYSTEM=0, PLC_INET_IN, PLC_INET_OUT};

struct policy_filesystem_t {
	struct vnode *vp;
	int mode;
	struct ucred *cred;
	struct proc *p;	
};

struct policy_inet_in_t {
  struct mbuf *m;
};

struct policy_inet_out_t {
  struct mbuf *m;
  struct socket *so;
};

struct policy_check_t{
  enum plc_type type;
  void *data;
};

typedef	struct	policy_mbuf	policy_mbuf;
struct	policy_mbuf	{
	policy_mbuf	*next;
	int		length;
	char		data[POLICY_DATA_SIZE];
};

typedef struct policy_mbuf_hdr policy_mbuf_hdr;
struct policy_mbuf_hdr {
  u_int32_t       seq_num;    
  uid_t           uid;
  u_int32_t       num_elems;
};

typedef	struct	policy_context	policy_context;
struct	policy_context	{
	policy_mbuf	*p_mbuf;
  
        enum plc_type   pc_type;
        void *          pc_data;

        u_int32_t        sequence;
        char 	        *reply;
	policy_context	*policy_context_next;
        int             session_id;
  int             sleep_id;
};

extern volatile struct timeval time;

extern   int	policy_in_use;

extern   u_int32_t    sequence_number;

policy_context	*policy_context_head;
policy_context	*policy_context_tail;
policy_context  *policy_context_waiting;

extern int     policy_in_use;
 
extern int     (*policy_check_filter)     __P((struct policy_check_t *));
extern int     (*policy_check_cache)      __P((struct policy_check_t *));

#endif // _POLICY_H_



