/* 
 * This is part of the loadable kernel module for 
 * Security Policy Driver
 *
 * Maintained by: Tom Langan (tlangan@dsl.cis.upenn.edu)
 *
 * Original Implementation: Sotiris Ioannidis (sotiris@dsl.cis.upenn.edu)
 *
 */

#ifndef _POLICY_ROUTINES_H_
#define _POLICY_ROUTINES_H_


#include	<sys/param.h>
#include	<sys/mbuf.h>
#include	<sys/ioctl.h>
#include	<sys/systm.h>
#include	<sys/malloc.h>
#include	<sys/types.h>
#include	<sys/uio.h>
#include	<sys/proc.h>
#include	<sys/socket.h>
#include        <sys/protosw.h>

#include	<net/if.h>
#include	<net/if_dl.h>
#include	<net/route.h>
#include	<net/netisr.h>

#include	<netinet/in.h>
#include	<netinet/in_systm.h>
#include	<netinet/if_ether.h>
#include	<netinet/ip.h>
#include	<netinet/tcp.h>
#include	<netinet/udp.h>
#include	<netinet/in_pcb.h>
#include	<netinet/in_var.h>
#include	<netinet/ip_var.h>
#include	<netinet/ip_icmp.h>
#include	<netinet/ip_ipsp.h>

#include        <policy/policy.h>

typedef	struct	policy_request_entry	policy_request_entry_t;
struct	policy_request_entry	{
        policy_request_entry_t	*next;
	struct in_addr  		src;
	struct in_addr  		dst;
	u_short			data[2];	/* TCP/UDP ports, ICMP code/type */
	u_char			protocol;
	u_short			ip_id;		/* IP id */

	/* more shit from the other headers, like tcp syn or ack flags? */
};

struct ip_cache_entry_t {
  u_int32_t key;
  
  u_int32_t ip_src;
  u_int32_t ip_dst;
  u_int8_t ip_p;
  int decision;

  //optional
  u_int16_t sport;
  u_int16_t dport;

  //struct ip_cache_entry_t *next;
};

typedef struct ip_cache_entry_t * ip_cache_entry;

struct fs_cache_entry_t {
  u_int32_t key; // xor inode and uid

  ino_t inode;
  dev_t device;
  uid_t uid;

  int decision;

  //struct fs_cache_entry_t *next;
};

typedef struct fs_cache_entry_t * fs_cache_entry;

#define	POLICYIOR	0
#define	POLICYIOW	1
#define	POLICYIOF	2

extern int		(*policy_check_filter)	__P((struct policy_check_t *));
extern int		(*policy_check_cache)	__P((struct policy_check_t *));

extern int              policy_in_use;


extern   struct protosw inetsw[];

#define CACHE_DENY 1
#define CACHE_ACCEPT 0
#define CACHE_UNKNOWN -1


#define MAX_POLICY_CONTEXTS 256
#define POLICY_SESSION_EXP_USEC 0 
#define POLICY_SESSION_EXP_SEC 5

typedef struct  context_session_t  context_session_t;
struct  context_session_t {
  policy_context *context;
  pid_t proc;
  int index;
  struct timeval expiretime; // for use in the future?
  //debug from here down
  policy_mbuf_hdr hdr;
  u_int32_t       *lengths;

  int reads;
  int bytesread;
  int totalbytes;
};

context_session_t context_session[MAX_POLICY_CONTEXTS];

void init_context_session(int freecontexts);
policy_context *get_context_session(int);
int create_context_session(policy_context *);
void free_context_session(int);
int lookup_context_session(pid_t);
int assign_context_session(pid_t);
pid_t assigned_context_session(policy_context *);

char *my_inet_ntop4(in_addr_t *src, char *dst, int normalize);
policy_context	*policy_create_context(void);
void policy_commit_context(policy_context *context);
void policy_destroy_context(policy_context *context);
void policy_add_int(policy_context *context, char *name, int value);
void policy_add_string(policy_context *context, char *name, char *value);
void policy_add_ipv4address(policy_context *context, char *name, in_addr_t *value);

int policy_consistent(policy_context *context);

int policy_check_inet_in(struct policy_inet_in_t *pi);
int policy_check_inet_out(struct policy_inet_out_t *pi);
int policy_check_filesystem(struct policy_filesystem_t *pf);

int policy_cache_inet_in(struct policy_inet_in_t *pi);
int policy_cache_inet_out(struct policy_inet_out_t *pi);
int policy_cache_filesystem(struct policy_filesystem_t *pf);

int policy_check_cache_impl(struct policy_check_t *pc);
int policy_check_filter_impl(struct policy_check_t *pc);
int add_to_cache(enum plc_type type, void *data, int decision);


int inet_in_add_to_cache(struct policy_inet_in_t *pi, int decision);
int inet_out_add_to_cache(struct policy_inet_out_t *pi, int decision);
int filesystem_add_to_cache(struct policy_filesystem_t *pf, int decision);

int
policy_inet_out_deliver(struct mbuf *m0, 
			struct mbuf *opt,
			struct route *ro,
			int flags,
			struct ip_moptions *imo
#ifdef IPSEC
			, struct inpcb *inp
#endif
			);
int
policy_inet_out_supress(struct mbuf *m0);

int
policy_inet_in_deliver(struct mbuf *m0);
int
policy_inet_in_supress(struct mbuf *m0);

#endif




