
#include "policy_routines.h"
#include "btree.h"
#include "pdphack.h"

#define POLICYPORT 3232

long ip_in_packet_count = 0;

extern u_char ip_protox[];

extern int policy_queue_length;

extern long CACHE_SIZE;

btree inet_in_cache_tree = NULL;

struct pdphack_t *pdphack_in = NULL;

int
policy_inet_in_deliver(struct mbuf *m0)
{
  struct  ip  *ip;
  ip = mtod(m0, struct ip *);
  
  ipstat.ips_delivered++;
  //inet_wake_all();
  (*inetsw[ip_protox[ip->ip_p]].pr_input)(m0,(ip->ip_hl<<2), NULL, 0);

};


int
policy_inet_in_supress(struct mbuf *m0)
{
  //do nothing

  return 0;
};

int
policy_check_inet_in(struct policy_inet_in_t *pi)
{
     struct mbuf *m;
     struct  ip  *ip;
     int spl;
     struct mbuf **mp;
     struct  tcphdr *tcp;
     struct  udphdr *udp;
     int pass;
     register long space, len;
     register quad_t resid;
     policy_context	*context;
     policy_request_entry_t *newnode;
     int hlen;
     char tomtemp[20];
     
     m = pi->m;
     
     ip = mtod(m, struct ip *);

     //XXX HACK HACK HACK
     /*     if ((ip->ip_p == IPPROTO_ICMP)||(ip->ip_p == IPPROTO_IGMP) || ( ip->ip_p == IPPROTO_RAW))
       return(0);
     */
     hlen = ip->ip_hl << 2;
     
     
     spl = splhigh();
     
     //pdp hack
     if (ip->ip_p==6)
       {
	 //tcp
	 char *ipaddr;
	 struct pdphack_t *pdptmp;
	 int hackallow=0;
	 int sport,dport;
	 int nofree=0;
	 
	 tcp = (struct tcphdr *)(mtod(m, caddr_t) + hlen);
	 
	 sport = ntohs(tcp->th_sport);
	 dport = ntohs(tcp->th_dport);
	 
	 MALLOC(ipaddr, char*,sizeof(char)*20,M_TEMP,M_WAITOK);
	 
	 my_inet_ntop4((in_addr_t *) &ip->ip_src, ipaddr, 0);
	 
	 pdptmp = pdphack_lookup(&pdphack_in,ipaddr);
	 
	 if (sport == POLICYPORT)
	   {
	     if (pdptmp == NULL)
	       {
		 pdphack_add(&pdphack_in,ipaddr);
		 nofree=1;
	       }
	     hackallow=1;
	   } else {
	     if (pdptmp != NULL)
	       {
		 if (pdptmp->port == 0)
		   {
		     if (sport != POLICYPORT)
		       pdptmp->port = sport;
		     inet_in_add_to_cache(pi, CACHE_ACCEPT);
		     hackallow=1;
		   } else {
		     if (pdptmp->port == sport)
		       {
			 hackallow=1;
		       }
		   }
	       }
	     
	   }
	 
	 if ((!hackallow)&&(dport == POLICYPORT))
	   {
	     if (pdptmp == NULL)
	       {
		 pdphack_add(&pdphack_in,ipaddr);
		 nofree=1;
	       } 
	     hackallow=1;
	   } else {
	     if (pdptmp != NULL)
	       {
		 if (pdptmp->port == 0)
		   {
		     if (dport != POLICYPORT)
		       pdptmp->port = dport;
		     inet_in_add_to_cache(pi, CACHE_ACCEPT);
		     hackallow=1;
		   } else {
		     if (pdptmp->port == dport)
		       {
			 hackallow=1;
		       }
		   }
	       }
	   }
	 if (!nofree)
	   {
	     FREE(ipaddr, M_TEMP);
	   }
	 
	 if (hackallow)
	   {
	     struct mbuf *m;
	     struct  ip  *ip;
	     
	     splx(spl);
	     
	     m = pi->m;
	     ip = mtod(m, struct ip *);
	     
	     ipstat.ips_delivered++;
	     (*inetsw[ip_protox[ip->ip_p]].pr_input)(m,(ip->ip_hl<<2), NULL, 0);
	   } 

       }

     splx(spl);
     
     if (hlen < sizeof(struct ip))
       {
	 printf("HLEN == %d!!!", hlen);
	 hlen = sizeof(struct ip);
       };
     
     ip_in_packet_count++;
     
     
     context = policy_create_context();
     if (context == NULL) {
       printf("context was null !!!\n");
       
       //our fault -- jump to bottom and deal with it XXX
       goto bad;
     }
     
     policy_add_string(context, "app_domain", "dist_firewall");
     policy_add_string(context, "agent", "Agent");
     policy_add_string(context, "operation", "ipv4connect");
     policy_add_int(context, "family", ip->ip_p);
     policy_add_ipv4address(context, "dst_addr", (in_addr_t *) &ip->ip_dst);
     policy_add_ipv4address(context, "src_addr", (in_addr_t *) &ip->ip_src);
     
     if (ip->ip_p==6)
       {
	 //tcp
	 tcp = (struct tcphdr *)(mtod(m, caddr_t) + hlen);
	 
	 policy_add_string(context, "subject", "level2_protocol");
	 policy_add_string(context, "l2protocol_name", "tcp_ip");
	 policy_add_int(context, "dst_port", (int)ntohs(tcp->th_dport));
	 policy_add_int(context, "src_port", (int)ntohs(tcp->th_sport));
       } else if (ip->ip_p==17) {
	 //udp
	 udp = (struct udphdr *)(mtod(m, caddr_t) + hlen);
	 
	 policy_add_string(context, "subject", "level2_protocol");
	 policy_add_string(context, "l2protocol_name", "udp_ip");
	 policy_add_int(context, "dst_port", (int)ntohs(udp->uh_dport));
	 policy_add_int(context, "src_port", (int)ntohs(udp->uh_sport));
       } else {
	 policy_add_string(context, "subject", "level1_protocol");
	 policy_add_string(context, "l1protocol_name", "ip");
       }
     
     context->pc_type = PLC_INET_IN;
     context->pc_data = pi; 
     
     context->session_id = 0;
     
     spl = splhigh();
     
     create_context_session(context);
     
     policy_commit_context(context);
     
     policy_queue_length++;
     
     splx(spl);
     
     // we intercepted the packet.  Now tell the ip stack to return
     // without doing anything; we'll take it from here to demux
     // if it passes thru the firewall
     
     
     return(-1);
     
 bad:
     //we fucked up -- network dies!
     printf("Problem with IP network filter! (mem error in policy filter)");
     return(1);
     
};
      
int policy_cache_inet_in(struct policy_inet_in_t *pi)
{
  struct mbuf *m = pi->m;
  struct	ip		*ip = mtod(m, struct ip *);
  ip_cache_entry     ce;
  struct  tcphdr  *th;
  struct  udphdr  *uh;
  
  if (inet_in_cache_tree == NULL)
    {
      return(-1);
    } else {
      u_int32_t key;
      int pass = 0;
  
      key = ip->ip_src.s_addr;

      switch (ip->ip_p) {
	case    IPPROTO_TCP:
	  {
	    th = (struct tcphdr *) (mtod(m, caddr_t) + sizeof(struct ip));
	    key ^= th->th_sport;
	  }
	  break;
	case    IPPROTO_UDP:
	  {
	    uh = (struct udphdr *) (mtod(m, caddr_t) + sizeof(struct ip));
	    key ^= uh->uh_sport;
	  }
      };


      ce = bt_lookup(inet_in_cache_tree,key);
      
      if (ce == (ip_cache_entry)-1)
	{
	  return(-1);
	}
      
      if ((ip->ip_src.s_addr == ce->ip_src) &&
	  (ip->ip_p == ce->ip_p)) {
	switch (ip->ip_p) {
	case    IPPROTO_ICMP:
	  pass = 1;
	  break;
	case    IPPROTO_TCP:
	  {
	    if ((th->th_sport == ce->sport) &&
		(th->th_dport == ce->dport))
	      pass = 1;
	    
	  }
	  break;
	case    IPPROTO_UDP:
	  {
	    if ((uh->uh_sport == ce->sport) &&
		(uh->uh_dport == ce->dport))
	      pass = 1;
	  }
	  break;
	};
      }
      
      if (pass)
	{
	  return ce->decision;
	} else {
	  return(CACHE_UNKNOWN);
	}
    };
};

void
inet_in_reset_cache() 
{
  if (inet_in_cache_tree != NULL)
    {
      bt_destroy(inet_in_cache_tree,1);
    }
    
  inet_in_cache_tree = bt_create_tree(CACHE_SIZE);
};

void
inet_in_clear_cache()
{
  if (inet_in_cache_tree != NULL)
    {
      bt_destroy(inet_in_cache_tree,1);
    }
}


int inet_in_add_to_cache(struct policy_inet_in_t *pi, int decision)
{
  struct mbuf *m = pi->m;

  ip_cache_entry ce;
  ip_cache_entry old_ce;
  long key;
  struct  udphdr  *uh;
  struct  tcphdr  *th;
  struct ip *ip;

  ip = mtod(m, struct ip *);

  MALLOC(ce, ip_cache_entry, sizeof(struct ip_cache_entry_t), M_TEMP,M_WAITOK);

  ce->ip_p = ip->ip_p;
  
  ce->ip_src = ip->ip_src.s_addr;

  ce->key = ce->ip_src;

  switch (ip->ip_p) {
  case    IPPROTO_ICMP:
    ce->ip_src = ip->ip_src.s_addr;
    ce->sport = 0;
    ce->dport = 0;
    break;
  case    IPPROTO_TCP:
    
    th = (struct tcphdr *) (mtod(m, caddr_t) + sizeof(struct ip));
    ce->ip_src = ip->ip_src.s_addr;
    ce->sport = th->th_sport;
    ce->dport = th->th_dport;
    ce->key ^= ce->sport;
    break;
  case    IPPROTO_UDP:
    
    uh = (struct udphdr *) (mtod(m, caddr_t) + sizeof(struct ip));
    
    ce->ip_src = ip->ip_src.s_addr;
    ce->sport = uh->uh_sport;
    ce->dport = uh->uh_dport;
    ce->key ^= ce->sport;
    break;
  default:
    ce->ip_src = ip->ip_src.s_addr;
    ce->sport = 0;
    ce->dport = 0;
  };

  ce->decision = decision;
  key = ce->key;
  
  if (inet_in_cache_tree == NULL)
    {
      inet_in_cache_tree = bt_create_tree(CACHE_SIZE);
      bt_insert(inet_in_cache_tree, key, ce);
    } else {
      old_ce = bt_lookup(inet_in_cache_tree, key);
      if (old_ce == (ip_cache_entry)-1)
	{
	  bt_insert(inet_in_cache_tree, key, ce);
	} else {
	  ip_cache_entry tmp;

	  if ((old_ce->ip_src != ce->ip_src)||(old_ce->ip_p!=ce->ip_p)||(old_ce->decision!=ce->decision)||(old_ce->sport != ce->sport)||(old_ce->dport != ce->dport))
	    {
	      tmp = bt_remove(inet_in_cache_tree, key);
	      FREE(tmp, M_TEMP);
	      bt_insert(inet_in_cache_tree, key, ce);
	    } else {
	      FREE(ce, M_TEMP);
	    }
	}
    };
  
  return(1);

};
