/*
 * This is the header file for the policy device driver
 *
 */

#ifndef _POLICY_DRV_H_
#define _POLICY_DRV_H_

#define NameValPrs 8
#define SessionArraySize 64

#define PLC_NewSession _IOW('C', 100, struct policy_params_t) 
#define PLC_AddVal _IOWR('C', 101, struct policy_params_t)
#define PLC_SessionResult _IOR('C', 102, struct policy_params_t)
#define PLC_Attr_Len _IOWR('C', 103, struct policy_params_t)
#define PLC_Get_Attr _IOWR('C', 104, struct policy_params_t)
#define PLC_Get_Query _IOWR('C', 105, struct policy_params_t)
#define PLC_Print_Time _IOR('C',106, NULL)
#define PLC_Flush_Queue _IOR('C',107, NULL)

#include "policy_routines.h"

void
set_cache_size(long size);

void
inet_reset_cache();

void
filesystem_reset_cache();

void
filesystem_clear_cache();

void  
inet_clear_cache();


extern	int	policyopen(dev_t dev, int oflags, int devtype, struct proc *p);
extern	int	policyclose(dev_t dev, int oflags, int devtype, struct proc *p);
extern	int	policyread(dev_t dev, struct uio *uio, int ioflag);
extern	int	policywrite(dev_t dev, struct uio *uio, int ioflag);
extern	int	policyioctl(dev_t dev, u_long cmd, caddr_t data, int fflag, struct proc *p);

struct policy_params_t {
  char attrname[16];
  char attrval[16];
};
/*
struct namevalpr_t {  // attribute name, value pairs added in PLC_AddVal
  char attrname[16];
  char attrval[16];
};
*/
struct session_t {
  pid_t caller;
  struct policy_params_t a[NameValPrs];
};

static	struct	cdevsw	newdev	=
	{
		policyopen,
		policyclose,
		policyread,
		policywrite,
		policyioctl,
		(dev_type_stop((*))) enodev,
		0,
		seltrue,
		(dev_type_mmap((*))) enodev,
		0
	};

MOD_DEV("policy", LM_DT_CHAR, -1, &newdev)


#endif /* _POLICY_DRV_H_ */
