#!/usr/bin/perl -Tw
require 5.002;
#use strict;
BEGIN { $ENV{PATH} = '/usr/ucb:/bin' }
use Socket;
use Carp;

# $multiuser = 0;

sub spawn;
sub logmsg { print "$0 $$: @_ at ", scalar localtime, "\n" }

my $port = shift || 8080;
my $proto = getprotobyname('tcp');
socket(Server, AF_INET, SOCK_STREAM, $proto) or die "socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, pack("l", 1))
                                             or die "setsockopt: $!";
bind(Server, sockaddr_in($port, INADDR_ANY)) or die "bind: $!";
listen(Server, SOMAXCONN)                    or die "listen: $!";

logmsg "server started on port $port";

my $waitedpid = 0;
my $paddr;

sub REAPER {
    $SIG{CHLD} = \&REAPER;
    $waitedpid = wait;
    logmsg "reaped $waitedpid" . ($? ? " with exit $?" : "");
}

$SIG{CHLD} = \&REAPER;

for ( ; $paddr = accept(Client, Server); close Client) {
    my($port,$iaddr) = sockaddr_in($paddr);

    spawn sub {
	# serve
	$port = <Client>;
	chomp $port;
	$req = <Client>;
	chomp $req;
#	if ($multiuser){
#	    if (call setuid in c?) {
#		`useradd -u $port $port`;
#		setuid($port);
#	    }
#	}
	open(FILE, $req) or open(FILE, "/root/canon/webdemo/index.html");
	while (read(FILE, $buf, 4096)) {
	    print Client $buf;
	}
    };
}

sub spawn {
    my $coderef = shift;
    unless (@_ == 0 && $coderef && ref($coderef) eq 'CODE') {
	confess "usage: spawn CODEREF";
    }

    my $pid;
    if (!defined($pid = fork)) {
	logmsg "cannot fork: $!";
	return;
    } elsif ($pid) {
	logmsg "begat $pid";
	return;
    }

    open(STDIN, "<&Client") or die "can't dup client to stdin";
    open(STDOUT, ">&Client") or die "can't dup client to stdout";
    exit &$coderef();
}
    
