#include <sys/types.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <regex.h>
#include <keynote.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <varargs.h>
#include <stdio.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/time.h>

#define SA struct sockaddr
#define LISTENQ 128 // max number of clients to be queued
#define PORTNUM 8080  // listening port
#define PLC_NewSession _IOW('C', 100, struct policy_params_t)

struct childpid_t {
  pid_t p;
  struct childpid_t *next;
};

void accepttimeout();

struct childpid_t *children = NULL;

void add_child(pid_t p) {
  struct childpid_t *temp;
  temp = (struct childpid_t *)malloc(sizeof(struct childpid_t));

  temp->p = p;
  temp->next = children;

  children = temp;
};

void kill_children() {
  struct childpid_t *temp;
  struct childpid_t *temp2;

  temp = children;
  while (temp != NULL)
    {
      temp2 = temp->next;
      kill(temp->p, SIGINT);
      free(temp);
      temp = temp2;
    }
};

void sig_chld(int signo) {
  int stat;
  while (waitpid(-1, &stat, WNOHANG) > 0)
    ;
  return;
}

int main(int argc, char **argv) {
  pid_t pid;
  int listenfd, connfd, incoming;
  struct sockaddr_in servaddr, cliaddr;
  char *buf;
  socklen_t clilen;
  void sig_chld(int);
  char recvreq[256];
  int fd, data, count;
  int multiuser = 0;
  fd_set rset, aset;
  int flags;

  struct sigaction sigalm;
  struct policy_params_t {
    char attrname[16];
    char attrval[16];
  };
  struct policy_params_t pdata;

  if (argc > 2) {
   if (!(fd = open("/dev/policy", O_RDWR))) {
      printf("\nerror on /dev/policy open");
      return 0;
    }
    strcpy(pdata.attrname, "cache");
    strcpy(pdata.attrval, argv[2]);
    ioctl(fd, PLC_NewSession, &data);
    close(fd);
  } else if (argc > 1) {
    multiuser = atoi(argv[1]);
  }

  sigalm.sa_handler = accepttimeout;
  sigemptyset(&sigalm.sa_mask);
  sigalm.sa_flags = 0;

  sigaction(SIGALRM,&sigalm, NULL);

  fd = 0;
  buf = (char *)malloc(sizeof(char) * 4096);
  listenfd = socket(AF_INET, SOCK_STREAM, 0);
  if (listenfd < 0)
    printf("socket error");
    /*
  if ((flags = fcntl(listenfd, F_GETFL, 0)) < 0)
    {
      syslog(LOG_ERR, "Error getting fcntl");
      exit(-1);
    }
  flags |= O_NONBLOCK;
  if (fcntl(listenfd, F_SETFL, flags) < 0)
    {
      syslog(LOG_ERR, "Error setting fcntl");
      exit(-1);
    }
    */
  bzero(&servaddr, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port = htons(PORTNUM);
  if (bind(listenfd, (SA *) &servaddr, sizeof(servaddr)) < 0) {
    printf("\nbind error\n");
    exit(-1);
  }
  if (listen(listenfd, LISTENQ) < 0)
    printf("\nlisten error");
  if (signal(SIGCHLD, sig_chld) < 0)
    printf("\nsignal error");	
  printf("\nServer started on port %D", PORTNUM);
  fflush(stdout);

  

  for( ; ; ){
    clilen = sizeof(cliaddr);
    connfd = 0;
    /*
    while (connfd == 0)
      {
	FD_ZERO(&aset);
	FD_SET(listenfd, &aset);
	select(listenfd+1, &aset, NULL, NULL, NULL);
	*/
	connfd = accept(listenfd, (SA *) &cliaddr, &clilen);
	if (connfd < 0) {
	  syslog(LOG_ERR, "accept errno = %d", errno);
	  connfd = 0;
	}
     // }
  
    //    printf("\nconnection established");
    if ((pid = fork()) == 0) {
      if (close(listenfd) < 0)
	syslog(LOG_ERR, "listen close error");
      // connection established with client
      bzero(&recvreq, sizeof(recvreq));
      /*
      FD_ZERO(&rset);
      FD_SET(connfd, &rset);
      select(connfd+1, &rset, NULL, NULL, NULL);
      */
      while ((incoming = read(connfd, &recvreq, sizeof(recvreq))) <= 0){
	if (incoming <0) {
	  syslog(LOG_ERR, "receive error");
	  exit(-1);
	}
      }
      if (multiuser) {
	//if (setuid(atoi(recvreq))) {
	// syslog(LOG_ERR, "setuid error");
	// exit(-1);
	//}
	// fprintf(stderr, "\nUID after setuid() is %d", (int)getuid());
      } else {
	if (setuid(1002)||seteuid(1002)) {
	 syslog(LOG_ERR, "setuid error");
	 exit(-1);
	}	
      }
      bzero(&recvreq, sizeof(recvreq));
      //select(connfd+1, &rset, NULL, NULL, NULL);
      while ((incoming = read(connfd, &recvreq, sizeof(recvreq))) <= 0){
	if (incoming <0) {
	  syslog(LOG_ERR, "receive error");
	  exit(-1);
	}
      }
      //fprintf(stderr, "\n%s ", recvreq);
      if ((fd = open(recvreq, O_RDONLY, 0))<0) {
	syslog(LOG_ERR, "file open error");
	exit(-1);
      }
      count = 0;
      while ((data = read(fd, buf, 4096)) > 0) {
	select(connfd+1, NULL, &rset, NULL, NULL);
	count += write(connfd, buf, data);
      }
      if (data < 0)
	syslog(LOG_ERR, "file read error");
      if (close(fd))
	syslog(LOG_ERR, "socket close error");

      exit(0);
    }  
    if (close(connfd) < 0)
      syslog(LOG_ERR, "connection close error");
      
    
  }
  kill_children();
  return 0;
}

void accepttimeout()
{
  printf("\n\n\nTIMED OUT TIMED OUT TIMED OUT\n\n\n");
  sleep(20);
  exit(1);
};
	
