// #includes...
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <regex.h>
#include <keynote.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <varargs.h>
#include <stdio.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#define SA struct sockaddr
#define MAXLINE 16  // max size of return from query (attribute value)
#define PORTNUM 3232  // listening port of pdp for remote queries
#define LISTENQ 128 // max number of clients to be queued

#define PLC_Print_Time _IOR('C',106,NULL)
#define PLC_Flush_Queue _IOR('C',107,NULL)

struct policy_header
{
    u_int32_t  pol_seq;
    u_int32_t  pol_uid;
    u_int32_t  pol_num;
};

struct policy_params_t {
  char attrname[16];
  char attrval[16];
};

struct pkt {
  u_long cmd;
  struct policy_params_t params;
};

#define PLC_NewSession _IOW('C', 100, struct policy_params_t) 
#define PLC_AddVal _IOWR('C', 101, struct policy_params_t)
#define PLC_SessionResult _IOR('C', 102, struct policy_params_t)
#define PLC_Attr_Len _IOWR('C', 103, struct policy_params_t)
#define PLC_Get_Attr _IOWR('C', 104, struct policy_params_t)
#define PLC_Get_Query _IOWR('C', 105, struct policy_params_t)
