#!/usr/bin/perl
require 5.002;
use Socket;
use String::CRC;
use Cwd 'chdir';

my ($line, $file, $buf, $temp, @path, $i);
my ($remote, $port, $iaddr, $paddr, $proto);

$remote = shift or die "enter hostname as argument";
$port = shift || 31415;
if ($port =~ /\D/) { $port = getservbyname($port, 'tcp') }
die "no port" unless $port;
$iaddr = inet_aton($remote) or die "no host: $remote";
$paddr = sockaddr_in($port, $iaddr);

$proto = getprotobyname('tcp');

open(TRACE, "./trace") or die "Can't open trace: $!\n";

while (($line = <TRACE>) && ($i<10)) {
    $nofile = 0;
    $i++;
    if ($i % 1000 == 0) {
	print STDOUT "**** On line $i of the trace file ****\n";
    }
    ($site, $file) = split("   ", $line);
    chomp $file;
    ($foo, $bar) = split("~", $file);
    if (!$bar) {
	($foo, $bar) = split("%7E", $file);
    }
    if (!$bar) {
	$bar = $foo;
    }
    @path = split("/", $bar);
    ($y, $z) = split('\.', $path[@path-1]);
    if (!$z) {
	$nofile = 1;
    }
    if ($nofile) {
	$bar = join '', $bar,"/index.html";
    }
    $filepathandname = sprintf("../files/%s", $bar);    
    $oport = 1000 + (crc($site)%64000);
    socket(SOCK, AF_INET, SOCK_STREAM, $proto) or die "socket: $!";
#   bind(SOCK, sockaddr_in($oport, INADDR_ANY)) or die "bind: $!";
    connect(SOCK, $paddr) or die "connect: $!";
    send SOCK, "$oport\n", 0;
    send SOCK, "$filepathandname", 0;
    while ($data = read(SOCK, $buf, 4096)) {
	;
    }
    close SOCK;
}

close TRACE;




