#include "pdp.h"

//#define VERBOSITY 1

#define TMOUTSECS 1
#define PDPPORT 3232

//#define NOKEYNOTE 1

//#define NODEVICE 1

#define DEFAULT_POLICY_FILE "./sample.policy"
#define DEFAULT_DEVICE      "/dev/policy"


#define TS(a) {  gettimeofday(&a,&tz);  }
#define TE(a,b) {  gettimeofday(&temp,&tz);  addtimeofday(&b, &a, &temp); }
struct timeval temp;
struct timezone tz;
struct timeval ctv;
struct timeval ktv;
struct timeval ttv;
struct timeval comm;
struct timeval kn;
struct timeval tot;

struct timeval t1;
struct timeval t2;

void 
addtimeofday(struct timeval *dest, struct timeval *start, struct timeval *finish)
{
  struct timeval t;   

  timerclear(&t);

 timersub(finish, start, &t);

   dest->tv_sec += t.tv_sec;
   dest->tv_usec += t.tv_usec; 


  if (dest->tv_usec >= 1000000) 
	{
		dest->tv_sec += 1;
		dest->tv_usec -=  1000000;
}
/*  
  dest->tv_sec += finish->tv_sec - start->tv_sec;
  
  temp = finish->tv_usec - start->tv_usec;
  
  if (temp >= 0)
    {
      dest->tv_usec += temp;
      if (dest->tv_usec >= 1000000)
	{
	  dest->tv_usec -= 1000000;
	  dest->tv_sec += 1;
	}

    } else {
      
      dest->tv_sec -=1;
      dest->tv_usec += (1000000 - temp);

    }

*/
};

/* Default values */
char *default_return_values[] = { "deny", "succ"};
int default_retnum = 2;

int docleanup=0;

char usage_message[] = "[-h] [-f] [-n] [-d device] [-p policy]\n"
                       "\t-h:\t This message\n"
                       "\t-f:\t Stay in the foreground\n"
                       "\t-n:\t Don't read the default policy file\n"
                       "\t-d:\t Alternate policy device name\n"
                       "\t-p:\t Policy files to read\n\n"
                       "Multiple -p flags may be issued; all the policy files "
                       "will be read and parsed. Only the last -d flag has "
                       "effect. At least one policy file containing at least "
                       "one valid policy assertion must be specified.\n";

extern char *__progname;  /* from crt0.o */

struct childpid_t {
  pid_t p;
  struct childpid_t *next;
};

struct childpid_t *children = NULL;

void
add_child(pid_t p)
{
  struct childpid_t *temp;
  temp = (struct childpid_t *)malloc(sizeof(struct childpid_t));

  temp->p = p;
  temp->next = children;

  children = temp;
};

void
kill_children()
{
  struct childpid_t *temp;
  struct childpid_t *temp2;

  temp = children;
  while (temp != NULL)
    {
      temp2 = temp->next;
      kill(temp->p, SIGINT);
      free(temp);
      temp = temp2;
    }
};

struct query_t {
  char *target;
  char *host;
  char **attrs;
  int numattrs;
};

struct query_t *queries=NULL;
int numqueries=0;

int
Load_query_config(char *filename)
{
  FILE *qfd;
  char c;
  char *temp;
  char *temp2;
  int at;
  
  qfd = fopen(filename, "r+");

  while (!feof(qfd))
    {
      // create a new query entry
      numqueries++;
      queries = (struct query_t *)realloc(queries,numqueries*sizeof(struct query_t));
      queries[numqueries-1].attrs=NULL;
      queries[numqueries-1].numattrs=0;

      c = 'a';

      //remove initial characters
      while ((!feof(qfd))&&(c!=','))
	c = fgetc(qfd);
      
      at = 0;

      while ((c!='\n')&&(!feof(qfd)))
	{
	  //we're at a new comma-seperated string

	  temp = (char*)malloc(2);
	  temp[0] = '\0';
	  c = fgetc(qfd);
	  //put the chars in a string one by one
	  while ((c != ',')&&(c != '\n')&&(!feof(qfd)))
	    {
	      asprintf(&temp2, "%s%c", temp, c);
	      free(temp);
	      temp = temp2;
	      c = fgetc(qfd);
	    }

	  // depending on where we are, assign the string
	  if (at==0)
	  {
	    queries[numqueries-1].target = temp;
	  } else if (at==1)
	    {
	      queries[numqueries-1].host = temp;
	    } else if (at>1)
	      {
		queries[numqueries-1].numattrs++;
		queries[numqueries-1].attrs = (char **)realloc(queries[numqueries-1].attrs,queries[numqueries-1].numattrs*sizeof(char*));
		queries[numqueries-1].attrs[queries[numqueries-1].numattrs-1] = temp;
	      }
	  at++;
	}
    }

}

void
usage(int pr)
{
    if (pr)
      fprintf(stdout, "%s: %s", __progname, usage_message);
    else
      syslog(LOG_ERR, usage_message);
}

/*
 * Send a one-string message to the kernel. This should be made more generic,
 * to handle multiple strings in the respond, but it'll do for now.
 */
int
sendreply(int fd, u_int32_t seq, u_int32_t uid, const char *reply)
{
    u_int32_t length = strlen(reply);
    struct policy_header hdr;
    struct iovec iov[3];
    int sum, ret;

    hdr.pol_seq = seq;
    hdr.pol_uid = uid;
    hdr.pol_num = 1;
    
    iov[0].iov_base = (void *) &hdr;
    iov[0].iov_len = sizeof(hdr);
    iov[1].iov_base = (void *) &length;
    iov[1].iov_len = sizeof(length);
    iov[2].iov_base = (void *) reply;
    iov[2].iov_len = length;

    /* Add up sizes */
    for (sum = 0, ret = 0; ret < 3; ret++)
      sum += iov[ret].iov_len;

    alarm(TMOUTSECS);
    TS(ctv);
    if ((ret = writev(fd, iov, 3)) != sum)
    {
      alarm(0);
      if (docleanup)
	{
	  docleanup=0;
	  goto skipwrite;
	}
	syslog(LOG_ERR, "bad message to kernel (wrote %d bytes, trying to send %d bytes", ret, sum);
	return -1;
    }
    TE(ctv,comm);
    alarm(0);

 skipwrite:

    return 0;
}


#define DEBUGFILE "/dfwout.txt"

/*
 * Read all (policy) assertions from file, add them to the KeyNote session
 * specified. The third argument is non-zero if these are policy assertions
 * (as opposed to credential assertions).
 */
int
read_policy(char *file, int session, int policy)
{
    int fd, num, error = -1, flag = 0;
    char *buf, **assertions;
    struct stat sb;

    if (policy)
      flag |= ASSERT_FLAG_LOCAL;

    syslog(LOG_ERR, 
	   "Openning policy file %s\n", file); 


    if ((fd = open(file, O_RDONLY, 0)) < 0)
    {
	syslog(LOG_ERR,
	       "failed to open(\"%s\"), skipping over [%s]",
	       file, strerror(errno));
	return -1;
    }

    if (fstat(fd, &sb) < 0)
    {
	syslog(LOG_ERR, "failed to fstat(\"%s\"), skipping over [%s]",
	       file, strerror(errno));
	return -1;
    }

    if (sb.st_size == 0)
    {
	syslog(LOG_ERR, "zero-sized assertion file \"%s\", skipping over",
	       file);
	return -1;
    }

    buf = mmap(NULL, sb.st_size, PROT_READ, MAP_FILE | MAP_COPY, fd, 0);
    if (buf == NULL)
    {
	syslog(LOG_ERR, "failed to mmap(\"%s\"), skipping over [%s]",
	       file, strerror(errno));
	return -1;
    }

    assertions = kn_read_asserts(buf, sb.st_size, &num);
    if ((assertions == NULL) || (num <= 0))
    {
	syslog(LOG_ERR, "failed parsing assertion file \"%s\", skipping over",
	       file);
	goto done;
    }

    /* Loop over all assertions, adding them to the session */
    while (num--)
      {
	if (kn_add_assertion(session, assertions[num], 
			     strlen(assertions[num]), flag) == -1)
	  syslog(LOG_ERR, "failed to add assertion %d from file \"%s\", ignoring assertion", num, file);
	else
	  error = 0; /* We managed to add at least one policy successfully */
	/* Free as we go */
	free(assertions[num]);
      }

    free(assertions);

 done:
    munmap(buf, sb.st_size);
    close(fd);

    return error;
}

#include <signal.h>

int forkilling;
int forkilling2;

void poll();
void die();
void timeout();

int totalread = 0;
int supposedtoread = 0;

void sig_chld(int signo)
{
  int stat;
  while (waitpid(-1, &stat, WNOHANG) > 0)
    ;
  return;
}

int cli(char *host, char **retval, char *target, char **attrs, int num)
{
  int sockfd, error, i, j;
  char buff[16];
  struct sockaddr_in servaddr;  
  struct pkt req;
  
  error = 0;
  
  if (num % 2 == 1){
    // odd number of attribute name/value strings, i.e. they don't pair up
    error = -1;
    return error;
  }
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd <= 0){
    error = -2;
    syslog(LOG_ERR, "socket error %d", errno);
    return error;
  }
  bzero(&servaddr, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons((int)PORTNUM);
  if (inet_pton(AF_INET, host, &servaddr.sin_addr) <= 0){
    error = -3;
    syslog(LOG_ERR, "inet_pton error; errno: %d", errno);
    return error;
  }
  if (connect(sockfd, (SA *) &servaddr, sizeof(servaddr)) < 0){
    error = -4;
    syslog(LOG_ERR, "connect error: %d", errno);
    return error;
  }
  // connection established.  send request.
  req.cmd = PLC_NewSession;
  strcpy(req.params.attrname, target);
  if (write(sockfd, &req, sizeof(req)) <= 0){
    error = -5;
    syslog(LOG_ERR, "client data send error");
    return error;
  }
  req.cmd = PLC_AddVal;
  for (i=0; i<num; i+=2){
    strcpy(req.params.attrname, attrs[i]);
    strcpy(req.params.attrval, attrs[i+1]);
    if (write(sockfd, &req, sizeof(req)) <= 0){
      error = -5;
      syslog(LOG_ERR, "client data send error");
      return error;
    }
    for (j=0; j<16; j++){
      req.params.attrname[j] = '\0';
      req.params.attrval[j] = '\0';
    }
  }
  req.cmd = PLC_SessionResult;
  if (write(sockfd, &req, sizeof(req)) <= 0){
    error = -5;
    syslog(LOG_ERR, "client data send error");
    return error;
  }

  if (read(sockfd, &req, sizeof(req)) <= 0){
    error = -6;
    syslog(LOG_ERR, "client data receive error");
    return error;
  }
  *retval = (char*)strdup(req.params.attrval);
  
  return error;
}


main(int argc, char **argv)
{
    int daemonize = 1, defpolicy = 1, policyspecified = 0;
    char *device = DEFAULT_DEVICE, **return_values;
    int fd,ch, session, retnum, sum, test;
    struct policy_header hdr;
    u_int32_t *lengths;
    struct passwd *pwd;
    struct iovec *iov;
    struct sigaction inthdl;
    struct sigaction alarmhdl;
    int dfd;  // DEBUG
    FILE* pidfd;
    // server variables
    pid_t pid;
    int listenfd, connfd, incoming;
    struct sockaddr_in servaddr, cliaddr;
    char buff[MAXLINE];
    socklen_t clilen;
    void sig_chld(int);
    struct pkt recvreq;
    // end server variables

    inthdl.sa_handler = die;
    sigemptyset(&inthdl.sa_mask);
    inthdl.sa_flags=0;
    
    alarmhdl.sa_handler = timeout;
    sigemptyset(&alarmhdl.sa_mask);
    alarmhdl.sa_flags = 0;

    bzero(&tz, sizeof(struct timezone));


	timerclear(&tot);
	timerclear(&comm);
	timerclear(&kn);
    /* Initialize logging facility (syslog) */
    openlog(__progname, LOG_CONS | LOG_PERROR | LOG_PID, LOG_DAEMON);

    fprintf(stderr, "\n\nPOLICYD: RUNNING ON PID %u\n\n", getpid());

    //load_query_config("./queries");

    /* Initialize return values from default */
    retnum = default_retnum;
    retnum += numqueries;
    
    
    return_values = (char **) malloc(retnum * sizeof(char *));
    if (return_values == NULL)
    {
	syslog(LOG_ERR,
	       "failed to allocate %d bytes for return values, exiting",
	       retnum * sizeof(char *));
	exit(-1);
    }
    return_values[0] = strdup(default_return_values[0]);
    return_values[retnum-1] = strdup(default_return_values[1]);

    /* Copy over the default return values */
    for (ch = 1; ch < retnum-1; ch++)
    {
      asprintf(&return_values[ch], "_Q%d", ch);

      if (return_values[ch] == NULL)
      {
	syslog(LOG_ERR, "failed to allocate %d bytes for return value \"%s\", exiting", strlen(default_return_values[ch]) + 1, default_return_values[ch]);
	exit(-1);
      }
    }

    /* Initialize KeyNote session */
    if ((session = kn_init()) < 0)
    {
	syslog(LOG_ERR, "failed to initialize KeyNote session, exiting");
	exit(-1);
    }
    
    forkilling2 = session;

    //goto foo;
    /* Parse options */
    while ((ch = getopt(argc, argv, "hfnd:p:")) != -1)
    {
	switch (ch)
	{
	    case 'h':
		usage(1);
		exit(0);

	    case 'd':
		device = optarg;
		break;

	    case 'f':
		daemonize = 0;
		break;

	    case 'n':
		defpolicy = 0;
		break;

	    case 'p':
		if (read_policy(optarg, session, 1) == 0)
		  policyspecified = 1;
		break;

	    default:
		usage(0);
		syslog(LOG_ERR, "unknown option '%c', exiting", ch);
		exit(-1);
	}
    }

    argc -= optind;
    argv += optind;
    optind = 1;

    //foo:
    /* Read default policy file, if not instructed otherwise */
    if ((defpolicy) && (read_policy(DEFAULT_POLICY_FILE, session, 1) == 0))
      policyspecified = 1;

    if (!policyspecified)
    {
	syslog(LOG_ERR,
	       "failed to include at least one correct policy, exiting");
	exit(-1);
    }

    /* Open policy device */

#ifndef NODEVICE
    if ((fd = open(device, O_RDWR, 0)) < 0)
    {
	syslog(LOG_ERR, "failed to open(\"%s\"), exiting [%s]", device,
	       strerror(errno));
	exit(-1);
    }
#endif

    forkilling = fd;
    if (sigaction(SIGINT, &inthdl, NULL) == -1)
      {
	printf("Could not install SIGINT signal handler\n");
	exit(1);
      }
    
    if (sigaction(SIGALRM, &alarmhdl, NULL) == -1)
      {
	printf("Could not install SIGALARM signal handler\n");
	exit(1);
      }

#ifdef VERBOSITY
    daemonize=0;
#endif

    if (daemonize)
    {
	if (daemon(0, 0) != 0)
	{
	    syslog(LOG_ERR, "failed to daemonize: %s", strerror(errno));
	    exit(-1);
	}
    }

    // ********************
    // *** Query Server ***
    // ********************
    // fork server process
    pid = fork();
    if (pid != 0)
      add_child(pid);

    if (pid == 0){ // child process (server)
      listenfd = socket(AF_INET, SOCK_STREAM, 0);
      if (listenfd < 0)
	printf("socket error");
      bzero(&servaddr, sizeof(servaddr));
      servaddr.sin_family = AF_INET;
      servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
      servaddr.sin_port = htons(PORTNUM);
      if (bind(listenfd, (SA *) &servaddr, sizeof(servaddr)) < 0)
	printf( "bind error");
      if ((listen(listenfd, LISTENQ)) < 0)
	printf("listen error");
      if (signal(SIGCHLD, sig_chld) < 0)
	printf("signal error");	

      for( ; ; ){
	clilen = sizeof(cliaddr);
	fflush(stdout);
	connfd = accept(listenfd, (SA *) &cliaddr, &clilen);
	if (connfd < 0){
	  if (errno == EINTR){
	    syslog(LOG_ERR, "errno = %d", errno);
	    continue;
	  }
	  else
	    syslog(LOG_ERR, "accept error");
	}
	if ((pid = fork()) == 0){
	  if (close(listenfd) < 0)
	    syslog(LOG_ERR, "listen close error");
	  // connection established with client
	  if ((incoming = read(connfd, &recvreq, sizeof(recvreq))) <= 0){
	    if (incoming == 0)
	      syslog(LOG_ERR, "no data received");
	    else
	      syslog(LOG_ERR, "receive error");
	  }
	  add_child(pid);

#ifndef NODEVICE
	  while (recvreq.cmd != PLC_SessionResult) {

	    ioctl(fd, recvreq.cmd, &recvreq.params);
	    if (read(connfd, &recvreq, sizeof(recvreq)) < 0)
	      syslog(LOG_ERR, "receive error");
	  }
	  ioctl(fd, recvreq.cmd, &recvreq.params);
	  // write answer
	  if (write(connfd, &recvreq, sizeof(recvreq)) < 0)
	    syslog(LOG_ERR, "write error");
	  //}
#endif //NODEVICE 
	  exit(0);
	}
	if (close(connfd) < 0)
	  syslog(LOG_ERR, "connection close error");
      }
    } // end server
    
#ifdef NODEVICE
    exit(0);
#endif

	gettimeofday(&t1,&tz);
    /* Main loop */
    for (;;)
      {
      
      //POLLING TILL DATA EXISTS

#ifdef VERBOSITY
      printf("\n(0) Waiting for successful read");
#endif
      
      alarm(TMOUTSECS);
      while ((ch = read(fd, (void *) &hdr, sizeof(hdr))) != sizeof(hdr))
	{
	  alarm(0);
	  if (docleanup)
	    {
	      docleanup=0;
	      goto cleanups;
	    }
	  if (ch==-1)
	    {
	      syslog(LOG_ERR, "Bad response from /DEV/POLICY.. killing policyd");
	      syslog(LOG_ERR, "Errno:  %d", errno);
	      die();
	    }
	  usleep(1);
	}
	 alarm(0);
	 TS(ttv);
	 
#ifdef VERBOSITY
	printf("\n(1) Data Exists - %d Entries", hdr.pol_num);
#endif 


	/* Check for even number of entries */
	if (hdr.pol_num % 2)
	{
	    syslog(LOG_ERR, "bad message(2) from kernel, odd number of entries specified (%d, expecting even number), exiting", hdr.pol_num);
	    exit(-1);
	}


	/* Allocate space for lengths array */
	lengths = (u_int32_t *) malloc(hdr.pol_num * sizeof(u_int32_t));

	if (lengths == NULL)
	{
	    syslog(LOG_ERR, "failed to allocate %d bytes for incoming message(2), exiting", hdr.pol_num * sizeof(u_int32_t));
	    exit(-1);
	}


#ifdef VERBOSITY
	printf("\n(2) Allocated Lengths Array");
#endif 

	/* Read lengths array */
	alarm(TMOUTSECS);
	TS(ctv);
	if ((ch = read(fd, (void *) lengths, hdr.pol_num * sizeof(u_int32_t)))
	    != hdr.pol_num * sizeof(u_int32_t))
	{
	  alarm(0);
	  if (docleanup)
	    {
	      docleanup=0;
	      goto cleanups;
	    }
	    syslog(LOG_ERR, "bad message(2) from kernel, read %d bytes (expecting %d bytes), exiting", ch, hdr.pol_num * sizeof(u_int32_t));
	    exit(-1);
	}
	TE(ctv,comm);
	alarm(0);

#ifdef VERBOSITY
	printf("\n(3) Read Lengths Array from /dev/policy");
	for (ch=0; ch<hdr.pol_num; ch++)
	  {
	    printf("\n(3.%d) %d", ch+1, lengths[ch]);
	  }
#endif 

	/* Allocate space for incoming message */
	iov = (struct iovec *) malloc(hdr.pol_num * sizeof(struct iovec));
	if (iov == NULL)
	{
	    syslog(LOG_ERR, "failed to allocate %d bytes for incoming message(3), exiting", hdr.pol_num * sizeof(struct iovec));
	    exit(-1);
	}

	/* Initialize strings */
	for (sum = 0, ch = 0; ch < hdr.pol_num; ch++)
	{
	    iov[ch].iov_base = calloc(lengths[ch] + 1, sizeof(char));
	    if (iov[ch].iov_base == NULL)
	    {
		syslog(LOG_ERR, "failed to allocate %d bytes for string %d in incoming message(3), exiting", lengths[ch] + 1, ch);
		exit(-1);
	    }

	    iov[ch].iov_len = lengths[ch];
	    sum += lengths[ch];
	}


	/* Don't need this anymore */
	free(lengths);

#ifdef VERBOSITY
	printf("\n(4) Ready to receive actual data");
#endif 
	
	alarm(TMOUTSECS);
	TS(ctv);
	/* Read the action environment */
	if ((ch = readv(fd, iov, hdr.pol_num)) != sum)
	{
	  alarm(0);
	  if (docleanup)
	    {
	      docleanup=0;
	      goto cleanups;
	    }
	    syslog(LOG_ERR, "bad message(3) from kernel, read %d bytes (expecting %d bytes), denying request", ch, sum);
	    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
	    goto cleanups;
	}
	TE(ctv,comm);
	alarm(0);
#ifdef VERBOSITY
	printf( "\n(5) Read Action Environment");
#endif 

	/* Initialize action environment */
	for (ch = 0; ch < hdr.pol_num; ch += 2)
	{
#ifdef VERBOSITY
	  printf("\n(5.%d) Adding (\"%s\" == \"%s\")...",ch+1, iov[ch].iov_base, iov[ch+1].iov_base);
#endif	  

#ifndef NOKEYNOTE
	  TS(ktv);
	    if (kn_add_action(session, iov[ch].iov_base, iov[ch + 1].iov_base,
			      0) != 0)
	    {
		syslog(LOG_ERR,
		       "failed to add action \"%s\"=\"%s\", denying request",
		       iov[ch].iov_base, iov[ch + 1].iov_base);
		sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
		goto cleanups;
	    }
	    TE(ktv,kn);
#endif //NOKEYNOTE

#ifdef VERBOSITY
	    printf("Done");
#endif
	}
#ifdef VERBOSITY
	printf("\n(5.5) Have strings -- Adding to KeyNote session");
	fflush(stdout);
#endif

	/* Find the username, add as authorizer */

	/* XXX Adding Authorizer causes policyd to freak out */
	/* XXX Due to getpwid for some reason!!!             */
	//	pwd = getpwuid(hdr.pol_uid);

#ifdef VERBOSITY
	printf("\n(5.6) Got pwd");
	fflush(stdout);
#endif
	/*
	 * XXX See above
	 *

	if ((pwd == NULL) || (pwd->pw_name == NULL))
	{
	    syslog(LOG_ERR,
		   "unknown uid %d specified by kernel, denying request",
		   hdr.pol_uid);
	    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
	    goto cleanups;
	}

	*
	*
	*/

#ifdef VERBOSITY
	printf("\n(5.75) Adding Authorizer");
#endif

	/* Add authorizer */

#ifndef NOKEYNOTE
	TS(ktv);
	if (kn_add_authorizer(session, "POLICY") != 0)
	  {
	    syslog(LOG_ERR, "failed to add authorizer POLICY");
	    //syslog(LOG_ERR, "failed to add authorizer \"%s\" in session, denying request", pwd->pw_name);
	    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
	    goto cleanups;
	  }
	TE(ktv,kn);
#endif //NOKEYNOTE
	
#ifdef VERBOSITY
	printf("\n(6) Performing KeyNote Query");
#endif 

	/* Make the query */
      query:
#ifndef NOKEYNOTE
	TS(ktv);
	ch = kn_do_query(session, return_values, retnum);
	TE(ktv, kn);
	if ((ch < 0) || (ch > retnum))
	{
	    syslog(LOG_ERR, "query failed (returned %d) -- errorno(%d), denying request - %x,%s,%d", ch, keynote_errno, return_values,return_values[retnum-1], retnum);
	    
	    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
	    goto cleanups;
	} else {
	  char *retval;
	  // "Real" response from KeyNote 
	  if ((ch > 0)&&(ch<retnum-1)){
	    // let's say _Q1 = 1, _Q2 = 2, etc.
	    if (cli(queries[ch].host, &retval, queries[ch].target, 
		    queries[ch].attrs, queries[ch].numattrs) < 0)
	      {
		syslog(LOG_ERR, "remote query error");
		// error so deny
		sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
	      } else {
		// how do i make the new keynote query?
		// this can't be right
		
		if (kn_add_action(session,queries[ch-1].target, retval, 0) != 0)
		  {
		    syslog(LOG_ERR, "failed to add action \"%s\"=\"%s\",
 denying request", queries[ch-1].target, retval);
		    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[0]);
		    goto cleanups;
		  };
		free(retval);
		goto query;
	      }
	  } else {
#ifdef VERBOSITY
	    printf("(7.00) Sending Return Value %s", return_values[ch]);
#endif
	    sendreply(fd, hdr.pol_seq, hdr.pol_uid, return_values[ch]);
	  }

	}
#else //NOKEYNOTE
	sendreply(fd, hdr.pol_seq, hdr.pol_uid, "succ");
#endif //NOKEYNOTE

#ifdef VERBOSITY
	printf("\n(7) Reply Written to /dev/policy");
#endif 

#ifndef NOKEYNOTE
	{
	  int assertid;
	  TS(ktv);
	  while ((assertid = kn_get_failed(session,KEYNOTE_ERROR_ANY,0)) != -1)
	    {
#ifdef VERBOSITY
	      printf("\n(!!!!!) Assertion %d had errors", assertid);
#endif
	      kn_remove_assertion(session,assertid);
	      kill(getpid(),SIGINT);
	    }
	  TE(ktv,kn);
	}
#endif //NOKEYNOTE

cleanups:
	for (ch = 0; ch < hdr.pol_num; ch++)
	  free(iov[ch].iov_base);
	free(iov);
	iov = NULL;

#ifdef VERBOSITY
	printf("\n(8) Cleaning Up Action Environment");
#endif

#ifndef NOKEYNOTE
	TS(ktv);
	kn_cleanup_action_environment(session);

	kn_remove_authorizer(session, "POLICY");
	TE(ktv,kn);
	TE(ttv, tot);
#endif //NOKEYNOTE
    }

    /* Unreachable */
    close(fd);
    closelog();
    kn_close(session);
    exit(0);
}

void printstats()
{
  gettimeofday(&t2, &tz);
	syslog(LOG_ERR, "TOM TOM TOM %ld  %d", t2.tv_sec-t1.tv_sec, t2.tv_sec-t1.tv_sec); 
  syslog(LOG_ERR, "TIME IN KEYNOTE: %ld:%ld s:ms", kn.tv_sec, kn.tv_usec);
  syslog(LOG_ERR, "TIME COMMUNICATING: %ld:%ld s:ms", comm.tv_sec, comm.tv_usec);
  syslog(LOG_ERR, "TOTAL TIME AUTHORIZING: %ld:%ld s:ms", tot.tv_sec, tot.tv_usec);
  ioctl(forkilling, PLC_Print_Time,NULL);

};


void die()
{
  printstats();
  ioctl(forkilling, PLC_Flush_Queue, NULL);
  close(forkilling);
  closelog();
  kn_close(forkilling2);
  kill_children();
  exit(0);
}

void timeout()
{
  syslog(LOG_ERR, "(!) policyd: timeout()");
  docleanup=1;
}
