/*
 * This is the file that includes the device driver include
 *
 */

#include "policy_drv.h"
#include "btree.h"
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/file.h>
#include <sys/filedesc.h>
#include <sys/queue.h>
#include <sys/socket.h>
#include <sys/socketvar.h>

#define PLCFS 1
#define PLCIO 1
#define PLCII 1

//#define VERBOSEREAD 1
//#define VERBOSEWRITE 1

int policy_queue_length = 0;

policy_request_entry_t	*policy_request_dummy;

extern u_char ip_protox[];

long CACHE_SIZE = 8*4096;

#define TS(a) {  microtime(&a);  }
#define TE(a,b) {  microtime(&temp);  addtimeofday(&b, &a, &temp); }
struct timeval temp;
struct timeval ct;
struct timeval cachet;


void
inet_wake_all()
{
  struct proc *itr;
  struct socket *so;
  int k;
  int spl;

  spl = splhigh();
  
  LIST_FOREACH(itr,&allproc,p_list)
    {
      for (k=0; k < itr->p_fd->fd_lastfile; k++){
	if ((itr->p_fd->fd_ofiles != NULL) && 
	    (itr->p_fd->fd_ofiles[k] != NULL) &&
	    (itr->p_fd->fd_ofiles[k]->f_type == DTYPE_SOCKET)){

	  so = (struct socket *)(itr->p_fd->fd_ofiles[k]->f_data);
	  
	  wakeup((caddr_t)&so->so_timeo);
	  
	}
      } // end for 
    }

  splx(spl);
};

void 
addtimeofday(struct timeval *dest, struct timeval *start, struct timeval *finish)
{
  long temp;
  
  dest->tv_sec += finish->tv_sec - start->tv_sec;
  
  temp = finish->tv_usec - start->tv_usec;
  
  if (temp >= 0)
    {
      dest->tv_usec += temp;
      if (dest->tv_usec >= 1000000)
	{
	  dest->tv_usec -= 1000000;
	  dest->tv_sec += 1;
	}

    } else {
      
      dest->tv_sec -=1;
      dest->tv_usec += (1000000 - temp);

    }


};

void
set_cache_size(long size)
{
  CACHE_SIZE=size;
  filesystem_reset_cache();
  inet_in_reset_cache();
  inet_out_reset_cache();
};

void
free_memory()
{

  filesystem_clear_cache();
  inet_in_clear_cache();
  inet_out_clear_cache();

};


/*
 *  0 accept
 *  1 reject
 * -1 not in cache
 */
int
policy_check_cache_impl(struct policy_check_t *pc)
{
  int result = CACHE_UNKNOWN;

  switch(pc->type)
    {
    case PLC_INET_IN:
#ifdef PLCII
      result = policy_cache_inet_in((struct policy_inet_in_t *)pc->data);
      break;
#else
      result = CACHE_ACCEPT;
      break;
#endif /* PLCII */
    case PLC_INET_OUT:
#ifdef PLCIO
      result = policy_cache_inet_out((struct policy_inet_out_t *)pc->data);
      break;
#else
      result = CACHE_ACCEPT;
      break;
#endif /* PLCIO */
    case PLC_FILESYSTEM:
#ifdef PLCFS
      result = policy_cache_filesystem((struct policy_filesystem_t *)pc->data);
      break;
#else 
      result = CACHE_ACCEPT;
      break;
#endif /* PLCFS */
    default:
      result = CACHE_UNKNOWN;
    }


 // 0 == accept
  return result;

};

int 
policy_check_filter_impl(struct policy_check_t *pc)
{
  int result = 1;

  int pass;

  TS(ct);
  pass = policy_check_cache_impl(pc);
  TE(ct, cachet);

  if (pass == CACHE_UNKNOWN)	    
    {
      switch(pc->type)
	{
#ifdef PLCII
	case PLC_INET_IN:
	  result = policy_check_inet_in((struct policy_inet_in_t *)pc->data);
	  break;
#endif
#ifdef PLCIO
	case PLC_INET_OUT:
	  result = policy_check_inet_out((struct policy_inet_out_t *)pc->data);
	  FREE(pc->data,M_TEMP);
	  break;
#endif
#ifdef PLCFS
	case PLC_FILESYSTEM:
	  result = policy_check_filesystem((struct policy_filesystem_t *)pc->data);
	  break;
#endif
	default:
	  printf("\n\nSHOULD NEVER GET HERE\n\n");
	  return(0);
	}
      
       return result;
    } else {
      
      switch (pass)
	{
	case CACHE_ACCEPT:
	  if ((pc->type == PLC_INET_IN)||(pc->type==PLC_INET_OUT))
	    {
	      FREE(pc->data,M_TEMP);
	    }
	  return 0;	  
	case CACHE_DENY:
	  if (pc->type == PLC_INET_IN || pc->type == PLC_INET_OUT)
	    {
	      FREE(pc->data,M_TEMP);
	    }	  
	  return 1;
	default:
	  if (pc->type == PLC_INET_IN || pc->type == PLC_INET_OUT)
	    {
	      FREE(pc->data,M_TEMP);
	    }
	  return 1;
	}
    }
  
};
	


static	int
policy_load(struct lkm_table *lkmtp, int cmd)
{
	printf("POLICY Load\n");

	bzero(&cachet, sizeof(struct timeval));

	policy_in_use = 0;

	policy_check_filter = NULL;

	policy_check_cache = NULL;

	return(0);
};

static	int
policy_unload(struct lkm_table *lkmtp, int cmd)
{
	printf("POLICY Unload\n");

	printf("Time Spent in Cache: %d:%d s:ms", cachet.tv_sec, cachet.tv_usec);

	free_memory();

	policy_queue_length=0;

	policy_context_head = NULL;
	policy_context_waiting=NULL;

	policy_in_use = 0;

	return(0);
};

static	int
policy_stat(struct lkm_table *lkmtp, int cmd)
{
	printf("POLICY Stat\n");

	return(0);
};

int
policy(struct lkm_table *lkmtp, int cmd, int ver)
{
  DISPATCH(lkmtp, cmd, ver, policy_load, policy_unload, policy_stat)
};


int
add_to_cache(enum plc_type type, void *data, int decision)
{

  switch(type)
    {
    case PLC_INET_IN:
      return inet_in_add_to_cache((struct policy_inet_in_t *)data, decision);
    case PLC_INET_OUT:
      return inet_out_add_to_cache((struct policy_inet_out_t *)data, decision);
    case PLC_FILESYSTEM:
      return filesystem_add_to_cache((struct policy_filesystem_t *)data, decision);
    default: 
      return 0;
    }
  
  
};

int
policyopen(dev_t dev, int oflags, int devtype, struct proc *p)
{

	printf("policy open()");

	bzero(&cachet, sizeof(struct timeval));

	policy_in_use = 1;

	policy_check_filter = policy_check_filter_impl;

	policy_check_cache = policy_check_cache_impl;

	bzero((void *) &policy_request_dummy, sizeof(policy_request_dummy));

	return(0);
}

void
free_context_vars(policy_context *context)
{
  if (context->pc_type == PLC_INET_OUT)
    {
      m_freem(((struct policy_inet_out_t *)context->pc_data)->m);
    };

};

int
policyclose(dev_t dev, int oflags, int devtype, struct proc *p)
{



  printf("policy close");

  printf("Time Spent in Cache: %d:%d s:ms", cachet.tv_sec, cachet.tv_usec);

 
  policy_in_use = 0;
 


  return(0);
}

#include <sys/systm.h>

extern int hz;

int
remove_from_list(policy_context **list, policy_context *elem)
{
  policy_context *itr;
  
  if (*list == elem)
    {
      *list = elem->policy_context_next;
      return 1;
    } else {
      for (itr = *list; itr != NULL; itr = itr->policy_context_next)
	{
	  if (itr->policy_context_next == elem) 
	    {
	      itr->policy_context_next = elem->policy_context_next;
	      return 1;		    
	    }
	}
    }

  return 0;
};

int
policyread(dev_t dev, struct uio *uio, int ioflags)
{

	int				ret, i, tcount, count = 0;
	struct          policy_mbuf	*pbuf;
	struct          policy_context	*polc;
	int *index;
	struct policy_context *context;
	int spl;
	int j,iovcount;
	int decremented;
	struct	ip  *ip; 
	int session_id;


	//turn off network interrupts
	/* XXX - Do we need to turn off all interrupts? */
	spl = splhigh();

	if (policy_queue_length == 0)
	  {
	    uiomove(NULL, 0, uio);
	    splx(spl);
	    return (0);
	  }

	if ((session_id = lookup_context_session(uio->uio_procp->p_pid))==0)
	  {
	    //not assigned a session yet
	    if ((session_id = assign_context_session(uio->uio_procp->p_pid))==0)
	      {
		if (policy_context_head == NULL)
		  printf(",");
		else
		  printf(";");
		//no waiting sessions
		uiomove(NULL,0,uio);
		splx(spl);
		return(0);
	      }
	  } 
#ifdef VERBOSEREAD
	printf("\n{1} Getting Context");
#endif
	context = get_context_session(session_id);

	if (context == NULL)
	  {
	    
	    //probably really really bad
	    uiomove(NULL, 0, uio);
	    splx(spl);
	    return(0);
	  }

	/* XXX DEBUG */

	context_session[session_id-1].reads++;

#ifdef VERBOSEREAD
	printf("\n{2} Context found - Going ahead with read");
#endif


	if ((pbuf = context->p_mbuf) == NULL)
		panic("policy context without data (1) !?"); /* XXX */


	ret = 0;
	decremented = 0;

	index = &context_session[session_id-1].index;

	iovcount = 0;
	for (j=0;j<uio->uio_iovcnt;j++)
	  iovcount += uio->uio_iov[j].iov_len;

#ifdef VERBOSEREAD
	printf("\n{3} Entering UIOMOVE zone");
#endif
	
	do {
	  while (pbuf->length > *index && uio->uio_resid)
	    {
	      tcount = min(pbuf->length - *index, uio->uio_resid);
	      ret = uiomove(pbuf->data + *index, tcount, uio);

#ifdef VERBOSEREAD
	      printf("\n{4} UIOMOVE returned %d", ret);
#endif
	      /* XXX DEBUG */
	      
	      context_session[session_id-1].bytesread += tcount;

	      /*  */

	      if (ret != 0)
		{
		  printf("\nPossible error condition -- uiomove returned %d", ret);
		  splx(spl);
		  return(0);
		}
	      //*index += tcount;
	      context_session[session_id-1].index += tcount;
	      count += tcount;
	      
	    }

#ifdef VERBOSEREAD
	  printf("\n{5} No more reading to be done");
#endif
	  
	  while (*index >= pbuf->length) 
	    {
	      //(*index) = 0;
	      context_session[session_id-1].index = 0;
	      context->p_mbuf = pbuf->next;
	      FREE(pbuf, M_TEMP);
	      pbuf = context->p_mbuf;
	      
	      
	      if (pbuf == NULL) {

		//fresh out of data
		//free_context_session(context->session_id);
		
		polc = NULL;
		
		if (remove_from_list(&policy_context_head, context))
		  policy_queue_length--;
		
		if (policy_context_head != NULL)
		  {
		    for(polc=policy_context_head;polc->policy_context_next != NULL; polc=polc->policy_context_next)
		    ;
		    policy_context_tail = polc;
		  }

		
		


		/* Move over to the waiting queue */
		decremented = 1;
		context->policy_context_next = policy_context_waiting;
		policy_context_waiting = context;
		
		if (policy_context_tail == context)
		  policy_context_tail = polc;
		
		/* DONE */
#ifdef VERBOSEREAD
		printf("\n{6} READ DONE -- CONTEXT FREED");
#endif
		splx(spl);
		return(0);
	      }
	    }
	} while (uio->uio_resid);

#ifdef VERBOSEREAD
 printf("\n{6} Finished Interim Read");
#endif
 
// done writing 
 
//resore network interrupts
 splx(spl);
 
 
 return(0);
}
 



int
policywrite(dev_t dev, struct uio *uio, int ioflags)
{
	policy_context	*tmp = policy_context_waiting, *tmp2, *polc;
	u_int32_t policy_header[3]; /* XXX need proper structure */
	u_int32_t replen;
	int ret;
	int j, i,sum;
	struct	ip  *ip;
	enum plc_type temp_type;
	void *temp_data;
	int spl;

	//turn off network interrupts
	/* XXX - Do we need to turn off all interrupts? */
	spl = splhigh();

	ret = uiomove((void *) policy_header, 3 * sizeof(u_int32_t), uio);
	if (ret)
	  {
	    printf("Error in dfwwrite getting data from uiomove(1)");
	    goto dfwwrite_error_nofind;
	  }

	/* Find the relevant policy context */
	tmp = get_context_session(policy_header[0]);

#ifdef VERBOSEWRITE
	printf("\n[0] A Write Attempt was Made");
#endif	

	if (tmp == NULL)
	  {
	    splx(spl);
	    return(ESRCH);
	  }

#ifdef VERBOSEWRITE
	printf("\n[1] Got Applicable Context");
	printf("\n[1.1] Context Type: ");
	switch(tmp->pc_type)
	  {
	  case PLC_FILESYSTEM:
	    printf("PLC_FILESYSTEM");
	    break;
	  case PLC_INET_IN:
	    printf("PLC_INET_IN");
	    break;
	  case PLC_INET_OUT:
	    printf("PLC_INET_OUT");
	  };
#endif
	

	/* Get the reply string length */
	ret = uiomove((void *) &replen, sizeof(replen), uio);
	if (ret)
	  {
	    printf("Error in dfwwrite getting data from uiomove(2)");
	    goto dfwwrite_error;
	  }

	/* XXX do some sanity checking on the string length */

#ifdef VERBOSEWRITE
	printf("\n[2] Got Reply Length");
#endif

	/*** do we still need to do this??? XXX ***/
	/* allocate the string */
	MALLOC(tmp->reply, char *, replen + 1, M_TEMP, M_WAITOK);
	bzero(tmp->reply, replen + 1);
	ret = uiomove(tmp->reply, replen, uio);
	if (ret)
	  {
	    printf("Error in dfwwrite getting data from uiomove(3)");
	    goto dfwwrite_error;
	  }

#ifdef VERBOSEWRITE
	printf("\n[3] Got Reply: %s", tmp->reply);
#endif


	// just in case its mbuf wasn't empty or something

	if(remove_from_list(&policy_context_head, tmp))
	  policy_queue_length--;

	if (policy_context_head != NULL)
	  {
	    for(polc=policy_context_head;polc->policy_context_next != NULL; polc=polc->policy_context_next)
	      ;
	    policy_context_tail = polc;
	  }


	if (strncmp(tmp->reply, "succ", 4) == 0) {

#ifdef VERBOSEWRITE
	printf("\n[4] Adding Success to Cache");
#endif

	  add_to_cache(tmp->pc_type, tmp->pc_data, CACHE_ACCEPT);

#ifdef VERBOSEWRITE
	printf("\n[4.5] Done Adding To Cache");
#endif

	  if (tmp->pc_type == PLC_INET_IN)
	    {
#ifdef VERBOSEWRITE
	printf("\n[4.6] Delivering Incoming Packet");
#endif
	      policy_inet_in_deliver(((struct policy_inet_in_t *)tmp->pc_data)->m);
	      FREE(tmp->pc_data, M_TEMP);
	    } 
	  
#ifdef VERBOSEWRITE
	printf("\n[4.9] Done Delivering and Whatnot");
#endif  


	} else {



#ifdef VERBOSEWRITE
	printf("\n[4] Adding Failure to Cache");
#endif
	  add_to_cache(tmp->pc_type, tmp->pc_data,CACHE_DENY);


	  if (tmp->pc_type == PLC_INET_IN)
	    {
	      policy_inet_in_supress(((struct policy_inet_in_t *)tmp->pc_data)->m);
	      FREE(tmp->pc_data, M_TEMP);
	    } 

	  
	}

	remove_from_list(&policy_context_waiting, tmp);


#ifdef VERBOSEWRITE
	printf("\n[5] Waiting for Other Thread");
#endif



#ifdef VERBOSEWRITE
	printf("\n[6] Destroying Context Session");
#endif
	if ((tmp->pc_type != PLC_INET_IN) && (tmp->pc_type != PLC_INET_OUT) && (tmp->pc_type != PLC_FILESYSTEM))
	  panic("pre-free context sessin");

	free_context_session(policy_header[0]);

#ifdef VERBOSEWRITE
	printf("\n[7] Destroying Context");
#endif

	tmp->sleep_id=0;

	if (tmp->pc_type == PLC_INET_IN)
	  {
	    policy_destroy_context(tmp);
	  } else if (tmp->pc_type == PLC_FILESYSTEM || tmp->pc_type == PLC_INET_OUT ) {
	    wakeup(&tmp->sleep_id);
	  } else {
	    panic("whoa!");
	  }
	
	//restoring network
	splx(spl);

#ifdef VERBOSEWRITE
	printf("\n[8] Finished");
#endif

	return(0);

 dfwwrite_error_nofind:
	printf("We did not find the session specified -- looking up by client pid");
	
	if ((tmp = get_context_session(lookup_context_session(uio->uio_procp->p_pid)))==NULL)
	  {
	    printf("Could not find calling process in pending packet list");
	    //restoring network
	    splx(spl);

	    return(ESRCH);
	  }
 dfwwrite_error:
	//re-enqueue packet
	printf("Error processing packet ID %d - re-enqueuing", tmp->session_id);

	temp_type = tmp->pc_type;
	temp_data = tmp->pc_data;

	/* remove context from waiting queue */
	if (tmp == policy_context_waiting) 
	  {
	    policy_context_waiting = tmp->policy_context_next;
	  } else {
	    for (tmp2 = policy_context_waiting; tmp2; tmp2 = tmp2->policy_context_next)
	      {
		if (tmp2->policy_context_next == tmp) 
		  {
		    tmp2->policy_context_next = tmp->policy_context_next;
		    
		    break;
		  }
	      }
	  }
	

	/*  make sure tmp is no longer active -- else, we have an error */
	tmp2 = NULL;
	if (tmp == policy_context_head)
	  {
	    policy_context_head = tmp->policy_context_next;
	  } else if (policy_context_head != NULL) {
	    tmp2 = policy_context_head;
	    while ((tmp2->policy_context_next != NULL)&&(tmp2->policy_context_next != tmp))
	      tmp2 = tmp2->policy_context_next;
	    
	    if (tmp2->policy_context_next == tmp)
	      {
		tmp2->policy_context_next = tmp->policy_context_next;
		policy_queue_length--;
		
	      }
	  }

	free_context_session(tmp->session_id);
	policy_destroy_context(tmp);
	
	{
	  struct policy_check_t * temp_pc;

	  MALLOC(temp_pc, struct policy_check_t *, sizeof(struct policy_check_t), M_TEMP, 0);
	  
	  temp_pc->type = temp_type;
	  temp_pc->data = temp_data;

	  policy_check_filter_impl(temp_pc);

      	  FREE(temp_pc, M_TEMP);	  

	}
	//restoring network
	splx(spl);

	return(EPROTOTYPE);
}

int policyioctl(dev_t dev, u_long cmd, caddr_t data, int fflag, struct proc *p)
{
  struct session_t session[SessionArraySize]; 
  // session is an array of name-value pair arrays (array of arrays of structs)
  extern volatile struct timeval time;
  int nextfree = 0;
  int error = 0;
  int i = 0;
  int spl;
  int sid;
  struct policy_params_t *params;
  int j;
  policy_context *itr;
  policy_context *temp;


  spl= splhigh();

  if (cmd==PLC_Flush_Queue)
    {
  
      init_context_session(0);
      
      if ((temp=policy_context_head) != NULL)
	{
	  for(itr=policy_context_head->policy_context_next; itr!=NULL; itr = itr->policy_context_next)
	    {
	      free_context_vars(temp);
	      FREE(temp, M_TEMP);
	      temp = itr;
	    }
	  free_context_vars(temp);
	  FREE(temp, M_TEMP);
	}
      
      if ((temp=policy_context_waiting) != NULL)
	{
	  for(itr=policy_context_waiting->policy_context_next; itr!=NULL; itr = itr->policy_context_next)
	    {
	      free_context_vars(temp);
	      FREE(temp, M_TEMP);
	      temp = itr;
	    }
	  free_context_vars(temp);
	  FREE(temp, M_TEMP);
	}
      
      policy_context_waiting=NULL;
      policy_context_head=NULL;
      policy_queue_length=0;
      
      splx(spl);
      return(0);
    }

  if (cmd==PLC_Print_Time)
    {
      printf("\nTime Spent in Cache: %ld:%ld s:ms", cachet.tv_sec, cachet.tv_usec);
      splx(spl);
      return(0);

    }

  params = (struct policy_params_t *)data;
  //  printf("\nIOCTL\n");

  if (cmd != PLC_NewSession){
    // find session associated with this calling pid
    i = 0;
    while ((session[i].caller != p->p_pid)&&(i<SessionArraySize))
      i++;
    if (i == SessionArraySize){
      printf("\nNo session for proc: %d", p->p_pid);
      splx(spl);
     
      return -1;
    }
    sid = i;
  }
  
  switch(cmd)
    {
    case PLC_NewSession:
      // find next free spot in session array
      //      printf("\nin NewSession");
      if (!strcmp(params->attrname, "cache")) {
        // change the cache size to params->attrval
        set_cache_size(*params->attrval);
      splx(spl);
     
        return(0);
      }
      nextfree = 0;
      while (session[nextfree++].caller != 0)
	;
      nextfree--;
      // create new session with ID nextfree
      // add attribute name request as a[0]
      strcpy(session[nextfree].a[0].attrname, params->attrname);
      //      printf("\nset attrname in session array as %s", session[nextfree].a[0].attrname);
      session[nextfree].caller = p->p_pid;
      //      printf("\ndone with NewSession call\n");
      break;

    case PLC_AddVal:
      i = 0;
      while (session[sid].a[++i].attrname != NULL)
	// *** if (i == NameValPrs - 1)
	// double array size
	// *** where is geometric_realloc?
	;
      strcpy(session[sid].a[i].attrname, params->attrname);
      strcpy(session[sid].a[i].attrval, params->attrval);
      break;

    case PLC_SessionResult:
      // figure out the value for a[0] using a[1] through a[n]
      //      printf("\nin SessionResult");  
      if (strcmp((session[sid].a[0].attrname), "owner") == 0){
	// if "owner" is requested then look for "pid" or "filename"
	i = 0;
	while ((strcmp((session[sid].a[i].attrname), "pid") != 0) && 
	       (*(session[sid].a[i].attrname) != NULL))
	  i++;
	if (strcmp((session[sid].a[i].attrname), "pid") == 0){
	  // get owner of process
	  sprintf((char *)session[sid].a[i].attrval, "%d", p->p_cred->p_ruid);
	}
        // 	  else 
        // {
        //    i = 0;
        //     while ((strcmp((session[sid].a[i].attrname), "filename") != 0)
	//	     && (*(session[sid].a[i].attrname) != NULL))
	//	i++;
        //     if (strcmp((session[sid].a[i].attrname), "filename") == 0)
	//	{
	//	  // get owner of file (make sure filename includes full path)
	//	  MALLOC(sb, struct stat *, sizeof(struct stat), M_TEMP, 0);
	//	  stat(*(session[sid].a[i].attrval), *sb);
	//	  *(params->attrname) = session[sid].a[0].attrname;
	//	  session[sid].a[0].attrval = (char *)sb->st_uid;
	//	  *(params->attrval) = (char *)sb->st_uid;
	//	  FREE(sb, M_TEMP);
	//	}
	// }
      }
      else if (strcmp(session[sid].a[0].attrname, "time") == 0){
	sprintf(params->attrval, "%d", time.tv_sec);
      }
      // else if...
      session[sid].caller = 0;
      //      printf("\ndone with sessionresult call");      
      break;
      /*
    case PLC_Attr_Len:  // stores length of attribute (for memory allocation)
                        // in the *(data->length) field
      if (strcmp(params->attrname, "timeofday") == 0)
	{
	  params->length = sizeof(struct timeval);
	}
      else if (strcmp(params->attrname, "owner") == 0)
	{
	  params->length = 31 * sizeof(char); 
	  // 31 character limit on logon name
	}
      break;
      */  
    case PLC_Get_Attr:
      i = 0;
      while (strcmp(session[sid].a[i].attrname, params->attrname) != 0)
	i++;
      // if i=0, should we make the caller do a PLC_SessionResult instead?
      // if so, turn PLC_SessionResult into a function and call it here also
      strcpy(params->attrval, session[sid].a[i].attrval);
      break;



   // case PLC_Get_Query:
   //  ...
   // break; 

    default:
      // bad request; error
      splx(spl);
     
      return -1;
    }
  
      splx(spl);
     
  //  printf("\ndone with ioctl\n");
  return(0);  
}
