

#ifndef _BTREE_H_
#define _BTREE_H_


struct btree_node {
  long key;
  void *data;
  struct btree_node *lchild;
  struct btree_node *rchild;
  long age;
};

struct btree_t {
  struct btree_node *nodes;
  struct btree_node *root;
  long size;
};

typedef struct btree_t * btree;

btree bt_create_tree(long size);

int bt_insert(btree tree, int key, void *data);

struct btree_node *bt_nextfree(btree tree);

void *bt_remove(btree tree, int key);

//returns data or -1 if not found
void *bt_lookup(btree tree, int key);

void bt_destroy(btree tree, int destroy_ptrs);

#endif /* _BTREE_H_ */
