#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <sys/proc.h>
#include <ufs/ufs/quota.h>
#include <ufs/ufs/inode.h>
#include <sys/stat.h>

//#define FSVERBOSE 1

#include <policy/policy.h>

#include "policy_routines.h"
#include "btree.h"


struct timeval tmp;

#define TS(a) {  microtime(&a);  }
#define TE(a,b) {  microtime(&tmp);  addtimeofday(&b, &a, &tmp); }

void 
addtimeofday(struct timeval *dest, struct timeval *start, struct timeval *finish);

struct stat devpol;

extern int hz;

extern int policy_queue_length;

unsigned long filesystem_call_count = 0;

extern long CACHE_SIZE;

btree fs_cache_tree = NULL;

long sleepingguys = 0;

int policy_check_filesystem(struct policy_filesystem_t *pf)
{
	int pass;
	int spl;
	policy_context	*context;
	policy_request_entry_t *newnode;
	int hlen;
	int j;
	char *temp;
	struct	inode	*ip;
	int policyres;

	ip = (struct inode *)VTOI(pf->vp);

	// root -> ALLOW (else /dev/policy access creates livelock)

	// if ((pf->p->p_cred->p_ruid == 0)||(pf->p->p_cred->p_svuid == 0))
	//  return(0);
	

	filesystem_call_count++;
	
	context = policy_create_context();
	if (context == NULL) {
	  printf("context was null !!!\n");
	  
	  //our fault -- jump to bottom and deal with it XXX
	  goto bad;
	}

	
	/*
	 * Took this stuff out to get something more simple to work
	 *

	
	//these need to be changed
	policy_add_string(context, "machine_name", "localhost");
	policy_add_string(context, "authenticated", "YES");
	policy_add_string(context, "consolelogin", "NO");
	policy_add_string(context, "secure", "YES");
	policy_add_string(context, "commingfrom", "the_west_side");

	policy_add_int(context, "filemode", pf->mode);

	policy_add_int(context, "p_priority", pf->p->p_priority);
	policy_add_int(context, "p_pid", pf->p->p_pid);
	
	policy_add_int(context, "u_ruid", pf->p->p_cred->p_ruid);
	policy_add_int(context, "u_rgid", pf->p->p_cred->p_rgid);
	policy_add_int(context, "u_effuid", pf->cred->cr_uid);
	policy_add_int(context, "u_effgid", pf->cred->cr_gid);
	
	 *
	 */
	policy_add_string(context,"operation", "file_access");
	policy_add_string(context,"subject", "File");
	policy_add_string(context,"agent", "Agent");


	policy_add_int(context, "uid", pf->p->p_cred->p_ruid);
	policy_add_int(context, "gid", pf->p->p_cred->p_rgid);

	policy_add_int(context, "file_inode", ip->i_number);

	policy_add_int(context, "file_device", ip->i_dev);

	policy_add_string(context, "Exec_name", "*");
	

	context->pc_type = PLC_FILESYSTEM;
	context->pc_data = pf; 

	context->session_id = 0;

	context->sleep_id = 1;

	if (!(policy_in_use))
	  {
	    policy_destroy_context(context);
	    return(0);
	  }

#ifdef FSVERBOSE 
	printf("\n<1> Context Created.. Enqueuing");
#endif
	    
	spl = splhigh();

	create_context_session(context);
	    
	policy_commit_context(context);
	
	policy_queue_length++;

	sleepingguys++;
	
	splx(spl);

#ifdef FSVERBOSE 
	printf("\n<2> Context Enqueued.. Sleeping [%d]", sleepingguys);
#endif
	
	//all we can do now is wait for the call to complete and find out
	//if we are allowed to perform the operation or not

	policyres = tsleep(&context->sleep_id, PUSER | PCATCH , 0, /* (int)(hz / 2) */ 0 );

	spl = splhigh();

	sleepingguys--;

	if (context->sleep_id)
	  {
	    if (policyres==0)
	      panic("Why did we stop here??");

	    // sleep was killed because the system call was interrupted

	    free_context_session(context->session_id);
	    
	    if (remove_from_list(&policy_context_head, context))
	      policy_queue_length--;

	    remove_from_list(&policy_context_waiting, context);
	    
	    policy_destroy_context(context);
	    
	    return(1);
	  }
	

	splx(spl);

#ifdef FSVERBOSE 
	printf("\n<3> Woken up from sleep.. Checking Result");
#endif


	{
	  int a;
	  for(a=0;a<MAX_POLICY_CONTEXTS;a++)
	    if (context == context_session[a].context)
	      panic("SESSION SHOULD BE FREE MOFO!!!");
	  
	  if ((context == policy_context_head)||(context==policy_context_waiting))
	    panic("thats not it!!");
	}
	
	if (!(policy_in_use))
	  {
	    policy_destroy_context(context);
	    return(0);
	  }

	if (context->reply == NULL)
	  {
	    printf("\nNULL REPLY FROM POLICY DAEMON!!");
	  }

	if ((context->reply!=NULL)&&(context->reply[0] == 's'))
	  {
#ifdef FSVERBOSE 
	    printf("\n<4> ALLOW!  Waking up policywrite()");
#endif
	    policy_destroy_context(context);
	    return(0);
	  }	
	else 
	  {
#ifdef FSVERBOSE 
	    printf("\n<4> DENY!  Waking up policywrite()");
#endif
	    policy_destroy_context(context);
	    return(1);
	  }
	
	

 bad:
	//we fucked up -- no filesystem access!
	printf("Problem with Filesystem call filter! (mem error in policy filter)");
	policy_destroy_context(context);
	return(1);

};



int policy_cache_filesystem(struct policy_filesystem_t *pf)
{
  struct	inode	*ip;
  fs_cache_entry     ce;

  ip = (struct inode *)VTOI(pf->vp);

  if (fs_cache_tree == NULL)
    {
      return(CACHE_UNKNOWN);
    } else {
      int key;
      int pass = 0;

      key = (ip->i_number ^ pf->p->p_cred->p_ruid);

      ce = bt_lookup(fs_cache_tree,key);

      if (ce == (fs_cache_entry)-1)
	{
	  return(CACHE_UNKNOWN);
	}
      
      if ((ce->inode == ip->i_number)&&(ce->device == ip->i_dev)&&(ce->uid == pf->p->p_cred->p_ruid))
	{
	  return ce->decision;
	} else {
	  return(CACHE_UNKNOWN);
	}
    };

};

void
filesystem_reset_cache() 
{
  if (fs_cache_tree != NULL)
    {
      bt_destroy(fs_cache_tree, 1);
    }
    
  fs_cache_tree = bt_create_tree(CACHE_SIZE);
};

void
filesystem_clear_cache()
{
  if (fs_cache_tree != NULL)
    {
      bt_destroy(fs_cache_tree,1);
    }
}


int filesystem_add_to_cache(struct policy_filesystem_t *pf, int decision)
{
  struct	inode	*ip;
  int key;
  fs_cache_entry ce;
  fs_cache_entry old_ce;

  if ((pf->vp == (void*)0xdeadbeef)||(pf->vp == (void*)0xdeadb000))
    {
      printf("\nThe VP expired");
      return(0);
    }

  ip = (struct inode *)VTOI(pf->vp);

  if (ip==NULL)
    panic("inode should never be null");

  MALLOC(ce, fs_cache_entry, sizeof(struct fs_cache_entry_t), M_TEMP,M_WAITOK);

  ce->inode = ip->i_number;
  ce->device = ip->i_dev;
  ce->uid = pf->p->p_cred->p_ruid;
  ce->key = (ce->inode ^ ce->uid);
  key = ce->key;

  ce->decision = decision;

  if (fs_cache_tree == NULL)
    {
      fs_cache_tree = bt_create_tree(CACHE_SIZE);
      bt_insert(fs_cache_tree, key, ce);
    } else {
      old_ce = bt_lookup(fs_cache_tree, key);
      if (old_ce == (fs_cache_entry)-1)
	{
	  bt_insert(fs_cache_tree, key, ce);
	} else {
	  fs_cache_entry tmp;
	  
	  if ((old_ce->inode != ce->inode)||(old_ce->device!=ce->device)||(old_ce->uid!=ce->uid)||(old_ce->decision!=ce->decision))
	    {
	      tmp = bt_remove(fs_cache_tree, key);
	      FREE(tmp, M_TEMP);
	      bt_insert(fs_cache_tree, key, ce);
	    } else {
	      FREE(ce, M_TEMP);
	    }
	}
    };
  
  return(1);
};
