
#include "btree.h"
#include <sys/types.h>
#include <sys/malloc.h>
#include <sys/param.h>

btree bt_create_tree(long size)
{
  btree tmp;
  int j;

  if (size == 0)
    return NULL;

  MALLOC(tmp, btree, sizeof(struct btree_t), M_TEMP, M_WAITOK);

  tmp->size=size;

  MALLOC(tmp->nodes, struct btree_node *,sizeof(struct btree_node) * size, M_TEMP, M_WAITOK);

  for(j=0;j<size;j++)
    {
      tmp->nodes[j].key=0;
      tmp->nodes[j].data=NULL;
      tmp->nodes[j].lchild=NULL;
      tmp->nodes[j].rchild=NULL;
      tmp->nodes[j].age=0;
    }

  tmp->root = NULL;

  return tmp;

};

int bt_insert(btree tree, int key, void *data)
{
  int j;
  struct btree_node *tmp;
  struct btree_node *next;
  
  next = tree->root;
  tmp = NULL;

  while (next != NULL)
    {
      tmp = next;
      if (tmp->key > key)
	{
	  next = tmp->lchild;
	} else if (tmp->key < key)
	  {
	    next = tmp->rchild;
	  } else {
	    return 0;
	  }
    }
  
  next = bt_nextfree(tree);
  next->key = key;
  next->data = data;
  next->lchild = NULL;
  next->rchild = NULL;
  
  for(j=0;j<tree->size;j++)
    if (tree->nodes[j].age != 0)
      tree->nodes[j].age++;
  
  next->age = 1;

  if (tree->root==NULL)
    {
      tree->root = next;
      return 1;
    }

  if (tmp->key > key)
    {
      tmp->lchild = next;
    } else {
      tmp->rchild = next;
    };

  return 1;

};

struct btree_node *bt_nextfree(btree tree)
{
  int j;
  struct btree_node *tmp;

  for(j=0;j<tree->size;j++)
    {
      if (tree->nodes[j].age==0)
	{
	  return &tree->nodes[j];
	}

      if (tree->nodes[j].age==tree->size)
	{
	  bt_remove(tree, tree->nodes[j].key);
	  return &tree->nodes[j];
	}
    }
  
  printf("\nThe cache is FUCKED!\n");
  
  return NULL;
};

struct btree_node *bt_remove_aux(btree tree, int key)
{
  struct btree_node *tmp;
  struct btree_node *next;
  
  next = tree->root;
  
  while ((next != NULL)&&(next->key != key))
    {
      tmp = next;
      if (tmp->key > key)
	{
	  next = tmp->lchild;
	} else if (tmp->key < key)
	  {
	    next = tmp->rchild;
	  } else {
	    //we messed up...
	    printf("\nCache removal messed up (1)\n");
	    return NULL;
	  }
    }

  if (next == tree->root)
    tmp=NULL;

  if (next == NULL)
    {
      printf("\nCache removal messed up (2)\n");
      return NULL;
    }
  
  if (next->lchild == NULL)
    {
      struct btree_node *itr;

      if (next->rchild==NULL)
	{
	  //LEAF
	  if (tmp==NULL)
	    {
	      //deleting root
	      tree->root = NULL;
	    } else {
	      if (tmp->key > key)
		{
		  tmp->lchild = NULL;
		} else {
		  tmp->rchild = NULL;
		}
	    }
	} else {
      

	  //there is a right child

	  itr = next->rchild;
	  
	  //find the minimum element of the right subtree
	  while (itr->lchild != NULL)
	    {
	      itr = itr->lchild;
	    }
	  
	  itr = bt_remove_aux(tree, itr->key);
	  
	  itr->lchild = NULL;
	  itr->rchild = next->rchild;
	  
	  if (tmp==NULL)
	    {
	      
	      //deleting root
	      
	      tree->root = itr;
	    }else {
	     
	      if (tmp->key > key)
		{
		  tmp->lchild = itr;
		} else {
		  tmp->rchild = itr;
		}
	    }
	}

    } else {

      //there is an lchild

      struct btree_node *itr;
      

      itr = next->lchild;
      
      //find the maximum element of the left subtree
      while (itr->rchild != NULL)
	  {
	    itr = itr->rchild;
	  }
	
      
	itr = bt_remove_aux(tree, itr->key);

	itr->rchild = next->rchild;
	itr->lchild = next->lchild;
	
	if (tmp==NULL)
	  {
	    //deleting root
	    tree->root = itr;
	  } else {
	    if (tmp->key > key)
	      {
		tmp->lchild = itr;
	      } else {
		tmp->rchild = itr;
	      }
	  }
      }

  return next;

};

void *bt_remove(btree tree, int key)
{
  struct btree_node *tmp;
  void *data;

  tmp = bt_remove_aux(tree, key);

  if (tmp==tree->root)
    {
      panic("Tried to remove root binary tree entry in cache");
    }

  tmp->age=0;
  tmp->key=0;
  tmp->lchild=NULL;
  tmp->rchild=NULL;
  data = tmp->data;
  tmp->data = NULL;
  
  return data;
};

void *bt_lookup(btree tree,int key)
{
  struct btree_node *tmp;
  struct btree_node *next;

  next = tree->root;
  
  while (next != NULL)
    {
      tmp = next;
      if (tmp->key > key)
	{
	  next = tmp->lchild;
	} else if (tmp->key < key)
	  {
	    next = tmp->rchild;
	  } else {
	    return tmp->data;
	  }
    }
  
  return (btree)-1;
};

void bt_destroy(btree tree, int destroy_ptrs)
{
  if (tree==NULL)
    return;
  
  if (tree->nodes!=NULL)
    {
      if (destroy_ptrs)
	{
	  int j;
	  for(j=0;j<tree->size;j++)
	    {
	      if (tree->nodes[j].data != NULL)
		FREE(tree->nodes[j].data, M_TEMP);
	    }
	}

      FREE(tree->nodes,M_TEMP);
    }

  FREE(tree,M_TEMP);

};


