#define _LARGEFILE_SOURCE

#define _LARGEFILE64_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include "cmgfs.h"

/** 
 * given a char* key, a source file, and a target 
 * filename, read in the source file, encrypt it,
 * and write it to the target file.
 * Note that we simply read in the "source" file
 * and instruct the OS to write to the "target"
 * file. The source file is unchanged, the target
 * file becomes a CMGFS file. We could do this
 * without involving 2 files, by simply appending
 * data from the command line to a CMGFS file or
 * providing a really simple editor utility.
 * However, this tool is more like cp or mv.
 * As a favor ;) we could delete the source file.
 * We could make these tools even easier to use
 * by saying that the user should have a file
 * '/home/user/.camouflage_key' that should be
 * read-only for the owner.
*/
int main( int argc, char* argv[] ){
  int fin=0;
  int fout=0;
  int len=0;
  char buf[4096]={0};
  int result;
  int magic=0;
  struct filekey_struct* key=NULL;
  char* keyMaterial=NULL;
  char* seedMaterial=NULL;
  int i=0;
  int keyLength=0;
  int seedLength=0;

  if( argc!=5 ){
    printf( "\nError: invalid args.\n");
    printf( "\tUsage: writefile [srcfile] [destfile] [key] [seed_key]\n" );
    return -1;
  }else{

    key = (struct filekey_struct*)
            malloc( sizeof( struct filekey_struct ) );

    keyLength = strlen( argv[3] );
    if( keyLength<16 ){
	printf( "\nKey must be at least 16 bytes.\n" );
	return -2;
    }

    seedLength = strlen( argv[4] );
    if( seedLength!=16 ){
	printf( "\nSeed must be exactly 16 bytes.\n" );
	return -7;
    }

    keyMaterial = (char*)malloc( (keyLength+1) );
    seedMaterial = (char*)malloc( 17 /*16+1*/ );

    if( NULL==key || NULL==keyMaterial || NULL==seedMaterial ){
      printf( "\nCould not malloc() for key, seed, or key material.\n" );  
      return -5;
    }

    for( i=0;i<keyLength;i++ ){
      keyMaterial[i]=argv[3][i];
    }

    for( i=0;i<16;i++ ){
      seedMaterial[i]=argv[4][i];
    }

    keyMaterial[keyLength]='\0';
    seedMaterial[16]='\0';

    key->key=keyMaterial;
    key->seed=seedMaterial;
    key->s_sched_seed=100;
    key->keyLength=keyLength; //does not include null terminator

    //open the source file for input
    fin = open( argv[1], O_RDONLY | O_LARGEFILE );
    fout = open( argv[2], O_WRONLY | O_LARGEFILE | O_CREAT | O_TRUNC, 0600 );

    if( fin<0 ){
      printf( "\nCould not open input file.\n" );
      return -4;
    }
    if( fout<0 ){
      printf( "\nCould not open output file.\n" );
      return -3;
    }

    //send ioctl to turn fout into a CMGFS file
    result = ioctl( fout, EXT2_IOC_ENABLE_CAMOUFLAGE, &magic );
    if( result<0 )
       printf( "\n enable cmgfs for fd[%d]: result=%d error=%s", 
                fout, result, strerror(errno));
    errno=0;

    //send ioctl to set the key for fout
    result=ioctl( fout, EXT2_IOC_SHOW_KEY_MATERIAL, ((int)&key) );
    if( result<0 )
       printf( "\n set key: result=%d error=%s", result, strerror(errno));
    errno=0;

    do{
       len = read(fin,buf,4096);
       write(fout,buf,len);
    }while(len>0);

    close(fin);
    close(fout);
  }

  printf( "\n" );
  return 0;
}
