
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "cmgfs.h"

extern int errno;

/** 
 * testkey.c -- see how the pointer for the key shapes up
*/
int main( int argc, char* argv[] ){
 
  struct filekey_struct* key=NULL;
  int *key_ptr;

    key = (struct filekey_struct*)malloc( sizeof(struct filekey_struct) );
    if( NULL==key ){
      printf( "\nCould not malloc() for key.\n" );
      return -3;
    }

    key->s_sched_seed=200;
    key->keyLength=5;
    key->key="hello\0";
    key->seed="abcdefghijklmnop";

    key_ptr = (int *)key;
    
    printf( "\nkey->s_sched_seed = %d", key->s_sched_seed );
    printf( "\nkey->keyLength = %d", key->keyLength );
    printf( "\nkey->key = %s",key->key );
    printf( "\nkey->seed = %s",key->seed );

    printf( "\n--- Using Pointer ---\n" );
   
    printf( "\nkey->s_sched_seed = %d", (*key_ptr) );
    printf( "\nkey->keyLength = %d", (*(key_ptr+1)) );
    printf( "\nkey->key = %s", (char*)(*(key_ptr+2)) );
    printf( "\nkey->seed = %s", (char*)(*(key_ptr+3)) );

  printf( "\n" );
  return 0;
}
