#define _LARGEFILE_SOURCE

#define _LARGEFILE64_SOURCE

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

extern int errno;

int main(){
	int myfile=0;
	off_t result=0;
	errno=0;

	printf( "sizeof(off_t) = %d\n", sizeof(off_t) );

	unlink( "foo" );

	myfile = open( "foo", O_RDWR | O_CREAT | O_LARGEFILE, S_IRWXU );

	result = lseek( myfile, ((u_int64_t)1) << 40, SEEK_CUR );

	printf( "result of lseek64 = %lld\n", result );

	if( -1==result ){
		printf( "errno=%d : %s\n", errno, strerror(errno) );
		perror("foo");
		close(myfile);
		return -1;
	}else{
		write(myfile, "x", 1);
		close(myfile);
	}

  return 0;
}
