#define _LARGEFILE_SOURCE

#define _LARGEFILE64_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "cmgfs.h"

extern int errno;

/** 
 * given a char* key and a filename,
 * dump the file to stdout using the key.
 * readfile [filename] [key] [seed_key]
*/
int main( int argc, char* argv[] ){
  int fin=0;
  int len=0;
  char buf[4096]={0};
  struct filekey_struct* key=NULL;
  char* keyMaterial=NULL;
  char* seedMaterial=NULL;
  int keyLength=0;
  int seedLength=0;
  int result=0; 
  int i=0;

  key = (struct filekey_struct*)
              malloc( sizeof( struct filekey_struct ) );
  if( NULL==key ){
	printf( "\nCould not malloc() for key.\n" );
	return -1;
  }

  if( argc!=4 ){
    printf( "\nError: invalid args.\n");
    printf( "\tUsage: readfile [filename] [key] [seed_key]\n" );
    return -1;
  }else{

    //open the file for input
    fin = open( argv[1], O_RDONLY | O_LARGEFILE );
    if( fin<0 ){
      printf( "\nThe file could not be opened.\n" );
      return -4;
    }
 
    keyLength=strlen(argv[2]);
    if( keyLength<16 ){
	printf( "\nKey must be at least 16 bytes.\n" );
	return -6;
    }

    seedLength=strlen(argv[3]);
    if( seedLength!=16 ){
	printf( "\nSeed must be exactly 16 bytes.\n" );
	return -7;
    }   

    //key->s_sched_seed=atoi(argv[3]);

    key->s_sched_seed=100;
    key->keyLength=keyLength;

    keyMaterial = (char*)malloc( keyLength+1 );
    if( NULL==keyMaterial ) {
      printf( "\nCould not malloc() for key material.\n" );   
      return -3;
    }
    for( i=0;i<keyLength;i++ ){
     keyMaterial[i]=argv[2][i];
    }
    keyMaterial[keyLength]='\0';
    key->key=keyMaterial;

    seedMaterial = (char*)malloc( 17 /*16+1*/ );
    if( seedMaterial==NULL ) {
      printf( "\nCould not malloc() for seed material.\n" );   
      return -8;
    }
    for( i=0;i<16;i++ ){
     seedMaterial[i]=argv[3][i];
    }
    seedMaterial[16]='\0';
    key->seed=seedMaterial;

    result = ioctl( fin, EXT2_IOC_SHOW_KEY_MATERIAL, ((int)&key) );
    if( result<0 )
      printf( "\nresult=%d error=%s", result, strerror(errno) );

    //while you still have data, dump it to stdout
    do{
       len = read( fin, buf, 4096 );
       write(1,buf,len);
    }while(len>0);

    close(fin);

  }
  printf( "\n" );
  return 0;
}
