#define _LARGEFILE_SOURCE

#define _LARGEFILE64_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "cmgfs.h"

extern int errno;

/** 
 * given a filename, mark that file's inode
 * as camouflaged or not.
 * We assume that the first 'magic' is like a secret IV
 * that a qualified user supplies. No key is necessary, but
 * to 'unmark' a file, you need to supply the key you've
 * been using to read and write to it, otherwise we can't
 * decrypt the data or put the i_data[] pointers back in
 * the correct place.
 *
 * cmark [filename] = mark a file as camouflaged.
 * cmark -u [filename] [key] [seed] = unmark the file
*/
int main( int argc, char* argv[] ){
  int fin=0;
  int result=0; 
  int magic = 0;
  char* seedMaterial=NULL;
  char* keyMaterial=NULL;
  struct filekey_struct* key=NULL;
  int seedLength=0;
  int keyLength=0;
  int i=0;

  if( argc==2 ){

    //open the file for input
    fin = open( argv[1], O_RDONLY | O_LARGEFILE );
    if( fin<0 ){
      printf( "\nThe file could not be opened.\n" );
      return -1;
    }
    result = ioctl( fin, EXT2_IOC_ENABLE_CAMOUFLAGE, &magic );
    if( result<0 )
       printf( "\nresult=%d error=%s", result, strerror(errno) );
    close(fin); 

  }else if( argc==5 && (argv[1][0]=='-') && (argv[1][1]=='u') ){
    //open the file for input
    fin = open( argv[2], O_RDONLY );
    if( fin<0 ){
      printf( "\nThe file could not be opened.\n" );
      return -1;
    }
    seedLength = strlen( argv[4] );
    if( seedLength!=16 ){
      printf( "\nSeed must be exactly 16 bytes." );
      return -6;
    }
    seedMaterial = (char*)malloc( 17 /*16+1*/ );
    if( NULL==seedMaterial ) {
      printf( "\nCould not malloc() for seed material.\n" );
      return -4;
    }
    seedMaterial[16]='\0';
    for( i=0;i<16;i++ ){
      seedMaterial[i]=argv[4][i];
    }

    keyLength = strlen( argv[3] );
    if( keyLength<16 ){
       printf( "\nKey must be at least 16 bytes.\n" );
       return -2;       
    }
 
    keyMaterial = (char*)malloc( keyLength+1 );
    if( keyMaterial==NULL ){
      printf( "\nCould not malloc() for key material.\n" );
      return -5;
    }
    keyMaterial[keyLength]='\0';
    for( i=0;i<keyLength;i++ ){
      keyMaterial[i]=argv[3][i];
    }
    key = (struct filekey_struct*)malloc( sizeof(struct filekey_struct) );
    if( NULL==key ){
      printf( "\nCould not malloc() for key.\n" );
      return -3;
    }
    key->s_sched_seed=100;
    key->keyLength=keyLength;
    key->key=keyMaterial;
    key->seed=seedMaterial;

    result = ioctl( fin, EXT2_IOC_DISABLE_CAMOUFLAGE, ((int)&key) );
    if( result<0 )
       printf( "\nresult=%d error=%s", result, strerror(errno) );
    close(fin);

  }else{
    printf( "\nError: invalid args.\n" );
    printf( "\tUsage: cmark [filename]\n" );
    printf( "\tUsage: cmark [-u] [filename] [key] [seed]\n" );
    return -1;
  }  
  printf( "\n" );
  return 0;
}
