#define _LARGEFILE_SOURCE

#define _LARGEFILE64_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "cmgfs.h"

extern int errno;

/** 
 * given a filename,
 * simpley invoke the ioctl to get the inode info.
 *
 * cinfo [filename] 
*/
int main( int argc, char* argv[] ){
  int fin=0;
  int result=0; 
  int i=1000;

  if( argc==2 ){

    //open the file for input
    fin = open( argv[1], O_RDONLY | O_LARGEFILE );
    if( fin<0 ){
      printf( "\nThe file could not be opened.\n" );
      return -1;
    }
    result = ioctl( fin, EXT2_IOC_SHOW_INFO, &i );
    if( result<0 )
       printf( "\nresult=%d error=%s", result, strerror(errno) );
    close(fin);
  }else{
    printf( "\nError: invalid args. Usage: cinfo [filename]\n" );
    return -1;
  }  
  printf( "\n" );
  return 0;
}
