// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// xslamcb.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module frontend
//   
// ----------------------------------------------------------------------------
 
#define NO_XMSTRINGS

#include <X11/Intrinsic.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "xslam.h"

unsigned short icon[] = {
  /* Format_version=1, Width=128, Height=128, Depth=1, Valid_bits_per_item=16
   */
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xfeaa,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xfbdb,0x5fff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xed55,0x6fff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xf6aa,0xaaff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0x5aaa,0xab7f,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xaaaa,0xa95f,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xfffd,0x6aa4,0x954b,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xfff6,0xaa52,0x52a4,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xfffb,0x552a,0x8a52,0x5fff,0xffff,0xffff,0xffff,
  0xffff,0xffed,0x5291,0x5109,0x2fff,0xffff,0xffff,0xffff,
  0xffff,0xffd5,0x54a4,0x4aa4,0x81ff,0xffff,0xffff,0xffff,
  0xffff,0xffb5,0x524a,0x9049,0x283f,0xffff,0xffff,0xffff,
  0xffff,0xffda,0xaa91,0x2522,0x0547,0xffff,0xffff,0xffff,
  0xffff,0xfeaa,0x8924,0x9208,0x5013,0xffff,0xffff,0xffff,
  0xffff,0xff55,0x5492,0x44a1,0x0100,0x3fff,0xffff,0xffff,
  0xffff,0xfdaa,0x4249,0x1008,0x0824,0x07ff,0xffff,0xffff,
  0xffff,0xfd55,0x2924,0x4542,0x4080,0x90ff,0xffff,0xffff,
  0xffff,0xfaa8,0xaa41,0x1010,0x0400,0x020f,0xffff,0xffff,
  0xffff,0xf6a5,0x1114,0x4502,0x2008,0x0842,0xffff,0xffff,
  0xffff,0xfaaa,0xa4a2,0x2048,0x0041,0x2010,0x2fff,0xffff,
  0xffff,0xeaa9,0x1209,0x0900,0x8900,0x0004,0x82ff,0xffff,
  0xffff,0xea94,0xa950,0xa022,0x0000,0x0080,0x292f,0xffff,
  0xffff,0xd54a,0x4404,0x0a00,0x0000,0x0012,0x04ab,0xffff,
  0xffff,0xaaa1,0x22a2,0x4090,0x2008,0x8400,0xa12a,0xffff,
  0xffff,0xd494,0x9410,0x8802,0x0220,0x0000,0x0895,0x7fff,
  0xffff,0x5555,0x2144,0x2100,0x0000,0x0044,0x224a,0xafff,
  0xffff,0x5522,0x4811,0x0420,0x4000,0x0000,0x812a,0xdfff,
  0xfffe,0xaa94,0x9284,0x4004,0x0000,0x4400,0x0892,0xb7ff,
  0xfffe,0xa449,0x0850,0x1100,0x0442,0x0012,0x222a,0xafff,
  0xfffd,0x5552,0x5202,0x8020,0x1000,0x0000,0x0085,0x5bff,
  0xfffd,0x5288,0x8148,0x1202,0x4000,0x0080,0x9454,0xafff,
  0xfffa,0xaa52,0x2811,0x0008,0x0000,0x0802,0x0125,0x55ff,
  0xfffa,0x9489,0x4540,0x4880,0x0010,0x8008,0x0895,0x6fff,
  0xfff5,0x5252,0x1009,0x0000,0x0080,0x0000,0x4249,0x55ff,
  0xfffa,0xa924,0x8520,0x0200,0x0000,0x0040,0x1125,0x5bff,
  0xffea,0x4488,0x5004,0x9021,0x0402,0x0402,0x0455,0x56ff,
  0xfff5,0x2a52,0x84a0,0x0000,0x1000,0x1000,0x410a,0xbbff,
  0xffe9,0x5108,0x2209,0x0884,0x0008,0x0011,0x14aa,0xaeff,
  0xffd5,0x4aa2,0x9080,0x4000,0x0020,0x0000,0x0252,0xb5ff,
  0xffe4,0xa448,0x4424,0x0000,0x0000,0x0084,0xa88a,0xdfff,
  0xffd5,0x1292,0x1101,0x1210,0x0080,0x4000,0x0255,0x55ff,
  0xffaa,0xa844,0x8448,0x0000,0x4400,0x0412,0x492a,0xdf7f,
  0xffd1,0x4511,0x2000,0x8000,0x0000,0x0000,0x12ab,0x6bff,
  0xffaa,0x2948,0x4a92,0x0881,0x0002,0x0089,0x4455,0x5fff,
  0xffaa,0xa425,0x0000,0x2004,0x0008,0x1000,0x12ab,0x7bff,
  0xff52,0x5290,0x5248,0x8000,0x0420,0x0025,0x4955,0xafff,
  0xffa9,0x0845,0x0002,0x0010,0x0000,0x0200,0x252d,0xffff,
  0xffaa,0xa520,0x4a90,0x0200,0x1000,0x084a,0x92b6,0xbbff,
  0xff55,0x5295,0x1000,0x1000,0x0000,0x4000,0x4aab,0xefff,
  0xff52,0x2840,0x4124,0x8000,0x4080,0x012a,0x255d,0x7fff,
  0xff55,0x4515,0x0800,0x0042,0x0004,0x0401,0x54ab,0xffff,
  0xff6a,0xa8a0,0x4248,0x0200,0x0000,0x4054,0x8b7e,0xdfff,
  0xffaa,0x250a,0x1001,0x2000,0x0210,0x0902,0x5557,0xffff,
  0xfeaa,0x9241,0x4490,0x0008,0x0000,0x2054,0xaafb,0xffff,
  0xffd5,0x5494,0x0002,0x0400,0x2002,0x0482,0x55af,0xffff,
  0xff6a,0xa241,0x2a40,0x2040,0x8040,0x812a,0xab7f,0xffff,
  0xffb5,0x1494,0x0010,0x8000,0x0100,0x2849,0x56fd,0xffff,
  0xffda,0xd241,0x4904,0x0000,0x0009,0x0525,0x5bdf,0xffff,
  0xff6a,0x4928,0x2040,0x0408,0x0400,0x4895,0x6f7f,0xffff,
  0xffdb,0x5485,0x0408,0x4080,0x8024,0x2255,0xbbff,0xffff,
  0xffed,0x5250,0x4121,0x0000,0x0081,0x1556,0xdfff,0xffff,
  0xffd5,0x4a8a,0x1400,0x0804,0x1208,0xa2aa,0xf7ff,0xffff,
  0xfffa,0xaa51,0x4084,0x0040,0x4022,0x1497,0x5eff,0xffff,
  0xffde,0xa924,0x1210,0x4100,0x0089,0x4a81,0xffff,0xffff,
  0xfff5,0xaa91,0x0001,0x0809,0x0a04,0xaa00,0x0aff,0xffff,
  0xfffe,0xaaa4,0xa944,0x0000,0x2052,0x2b05,0x6fff,0xffff,
  0xffd5,0xaa92,0x0010,0x0240,0x0109,0x5410,0xbbff,0xffff,
  0xffef,0x6a48,0xaa00,0x9009,0x2454,0xaa4b,0x5fff,0xffff,
  0xfffd,0xaaa5,0x0092,0x0020,0x0242,0xa825,0xffff,0xffff,
  0xfff7,0x7554,0x5400,0x2482,0x512a,0xad56,0xffff,0xffff,
  0xfffe,0xd6a9,0x0148,0x8008,0x0a55,0x589b,0xbfff,0xffff,
  0xffff,0xdaa5,0x5422,0x0921,0x4495,0x626f,0xffff,0xffff,
  0xfffd,0x7554,0x9280,0x4004,0x2955,0xa9b7,0xffff,0xffff,
  0xffff,0xddaa,0x482a,0x1291,0x2556,0xcadf,0xffff,0xffff,
  0xffff,0xf6aa,0xa500,0x8424,0x9255,0x577f,0xffff,0xffff,
  0xffff,0xbaa9,0x28aa,0x5082,0x4aaf,0xaaff,0xffff,0xffff,
  0xffff,0xef6a,0xa521,0x0454,0xaada,0x5fff,0xffff,0xffff,
  0xffff,0xfaaa,0x9494,0xa912,0x556d,0x6bff,0xffff,0xffff,
  0xffff,0xffda,0xaa4a,0x12a9,0x56b6,0xbfff,0xffff,0xffff,
  0xffff,0xfab5,0x5551,0x4925,0x5bdb,0xefff,0xffff,0xffff,
  0xffff,0xffdb,0x5555,0x54aa,0xad75,0x7fff,0xffff,0xffff,
  0xffff,0xff6d,0xaaaa,0xaaab,0x77df,0xffff,0xffff,0xffff,
  0xffff,0xfff6,0xdaaa,0xaaad,0xad77,0xffff,0xffff,0xffff,
  0xffff,0xffbd,0x6aaa,0xaad6,0xffdf,0xffff,0xffff,0xffff,
  0xffff,0xfff7,0xbdaa,0xad7b,0x56ff,0xffff,0xffff,0xffff,
  0xffff,0xfffd,0xd6f7,0x77ad,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0x7b5a,0xdadf,0xfbff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xefef,0x6df6,0xdfff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xbd7b,0xdf7f,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffde,0xfbff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xeff7,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xfffb,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
  0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff};

char *copyright = "COLUMBIA UNIVERSITY\nSLAM 1.x Software License\n\nThe user of the software herein referred to as \"You\", and Columbia University in the City of New York, herein referred to as \"Us\", or \"We\", regarding the SLAM 1.0 software and any future versions designated 1.x (1.1 etc.). This includes all programs, code and associated documentation you receive from us and all modified versions or extensions that you may produce. Herein, this is all referred to as \"the software and its derivatives\".\n\n(1.) You agree that you will not sell or otherwise distribute the software and its derivatives;\n\n(2.) You acknowledge the confidential and valuable nature of the software and its derivatives. You will not divulge or distribute the software and its derivatives to third parties, nor allow any part of the software and its derivatives to be so divulged or distributed, unless express written permission is given by us. You will instruct your employees, students or other persons authorized to have access to the software and its derivatives not to divulge or distribute it to third parties, unless express written permission is given by us;\n\n(3.) The software and its derivatives will be used only on computers you control;\n\n(4.) Nothing in this agreement gives you the right to sell, lease, distribute, transfer, sublicense, or otherwise dispose of the software and its derivatives, in whole or in part, or to make any commercial use of it whatsoever;\n\n(5.) Title and copyright of the software and its derivatives will remain with us and shall at no point transfer to you. You may make copies only for backup purposes, and they shall\
 contain the original copyright notices we inserted;\n\n(6.) Official publications such as manuals, technical reports and articles in journals or conference proceedings that are based on the ideas of SLAM research group, its software or its derivatives will give proper recognition to the SLAM research group of the Department of Computer Science at Columbia University and the people who worked on it;\n\n(7.) You acknowledge that the software and its derivatives are being supplied \"as-is\" without any support services or future updates or releases. We may or may not make future updates and releases designated SLAM 1.x available to you under this same licensing agreement, but we are in no way obligated to do so. If you discover any error in the software or its derivatives, we encourage you to inform us. We are not obligated to acknowledge or repair any such error thus reported;\n\n(8.) We make no warranties or representations of any kind, either expressed or implied, as to any matter whatsoever, including merchantability or fitness for any particular purpose. You agree that we shall not be held to any liability with respect to any claim by you or a third party arising from or on account of the use of the software and its derivatives, regardless of the form of action; whether in contract or tort, including negligence. In no event will we be liable for consequential or incidental damages of any nature whatsoever;\n\n(9.) The user of the software and its derivatives will make sure that all potential users in his/her environment are aware of this agreement and of the terms for using the provided software and producing derived software.";

void launchXimgtool_cb(Widget, XtPointer, XtPointer)
{
  if(fork() == 0)
    execlp("ximgtool", 0);
}

void launchXeigen_cb(Widget, XtPointer, XtPointer)
{
  if(fork() == 0)
    execlp("xeigen", 0);
}

void launchXmanifold_cb(Widget, XtPointer, XtPointer)
{
  if(fork() == 0)
    execlp("xmanifold", 0);
}

void launchXmksrchtbl_cb(Widget, XtPointer, XtPointer)
{
  if(fork() == 0)
    execlp("xmksrchtbl", 0);
}

void exit_cb(Widget, XtPointer, XtPointer)
{
  exit(0);
}

void destroy3_cb(Widget w, XtPointer, XtPointer)
{
  XtDestroyWidget(XtParent(XtParent(XtParent(w))));
}

void draw(MainCbLocal *data)
{
  static int xpos, xoffset, charWidth;
  static XFontStruct *font1, *font2;
  
  switch(data -> d_state) {
  case 0:
    {
      Pixel fg;
      XtVaGetValues(data -> d_darea, XmNforeground, &fg, NULL);
      XSetForeground(data -> d_dpy, data -> d_gc, fg);
      data -> d_fontInfo_p = XLoadQueryFont(data -> d_dpy, "-*-utopia-bold-i-*-*-60-*-*-*-*-*-*-*");
      if(data -> d_fontInfo_p == 0)
	data -> d_fontInfo_p = XLoadQueryFont(data -> d_dpy, "-*-new century schoolbook-bold-i-*-*-60-*-*-*-*-*-*-*");
      XSetFont(data -> d_dpy, data -> d_gc, data -> d_fontInfo_p -> fid);
      data -> d_state = 1;
    }
    break;
  case 1:
    switch(data -> d_substate) {
    case 0:
      charWidth = XTextWidth(data -> d_fontInfo_p, "S", 1) + 10;
      xpos = (data -> d_winWidth / 20) * 20;
      xoffset = charWidth - 10;
      data -> d_substate = 1;
      break;
    default:
      if(xpos > 0) {
	XClearArea(data -> d_dpy, data -> d_win, xpos, 0, charWidth, data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent, False);
	xpos -= 20;
	XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, xpos,
		    data -> d_fontInfo_p -> ascent, "S", 1);
	XFlush(data -> d_dpy);
      }
      else {
	data -> d_state = 2;
	data -> d_substate = 0;
      }
    }
    break;
  case 2:
    switch(data -> d_substate) {
    case 0:
      charWidth = XTextWidth(data -> d_fontInfo_p, "L", 1) + 10;
      xpos = ((data -> d_winWidth - xoffset) / 20) * 20 + xoffset;
      data -> d_substate = 1;
      break;
    default:
      if(xpos > xoffset) {
	XClearArea(data -> d_dpy, data -> d_win, xpos, 0, charWidth, data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent, False);
	xpos -= 20;
	XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, xpos,
		    data -> d_fontInfo_p -> ascent, "L", 1);
	XFlush(data -> d_dpy);
      }
      else {
	data -> d_state = 3;
	data -> d_substate = 0;
      }
    }
    break;
  case 3:
    switch(data -> d_substate) {
    case 0:
      charWidth = XTextWidth(data -> d_fontInfo_p, "A", 1) + 10;
      xoffset = XTextWidth(data -> d_fontInfo_p, "SL", 2);
      xpos = ((data -> d_winWidth - xoffset) / 20) * 20 + xoffset;      
      data -> d_substate = 1;
      break;
    default:
      if(xpos > xoffset) {
	XClearArea(data -> d_dpy, data -> d_win, xpos, 0, charWidth, data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent, False);
	xpos -= 20;
	XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, xpos,
		    data -> d_fontInfo_p -> ascent, "A", 1);
	XFlush(data -> d_dpy);
      }
      else {
	data -> d_state = 4;
	data -> d_substate = 0;
      }
    }
    break;
  case 4:
    switch(data -> d_substate) {
    case 0:
      charWidth = XTextWidth(data -> d_fontInfo_p, "M", 1) + 10;
      xoffset = XTextWidth(data -> d_fontInfo_p, "SLA", 3);
      xpos = ((data -> d_winWidth - xoffset) / 20) * 20 + xoffset;
      data -> d_substate = 1;
      break;
    default:
      if(xpos > xoffset) {
	XClearArea(data -> d_dpy, data -> d_win, xpos, 0, charWidth, data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent, False);
	xpos -= 20;
	XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, xpos,
		    data -> d_fontInfo_p -> ascent, "M", 1);
	XFlush(data -> d_dpy);
      }
      else {
	data -> d_state = 5;
	data -> d_substate = 0;
      }
    }
    break;
  case 5:
    switch(data -> d_substate) {
    case 0:
      charWidth = XTextWidth(data -> d_fontInfo_p, "!", 1) + 10;
      xoffset = XTextWidth(data -> d_fontInfo_p, "SLAM", 4);
      xpos = ((data -> d_winWidth - xoffset) / 20) * 20 + xoffset;
      data -> d_substate = 1;
      break;
    default:
      if(xpos > xoffset) {
	XClearArea(data -> d_dpy, data -> d_win, xpos, 0, charWidth, data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent, False);
	xpos -= 20;
	XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, xpos,
		    data -> d_fontInfo_p -> ascent, "!", 1);
	XFlush(data -> d_dpy);
      }
      else {
	data -> d_state = 6;
	data -> d_substate = 0;
      }
    }
    break;
  case 6:
    if(data -> d_substate < 50)
      ++(data -> d_substate);
    else {
      int i, j, k, t, depth;
      Pixel bg, fg;
      data -> d_state = 7;
      data -> d_substate = 0;
      XtVaGetValues(data -> d_darea, XmNdepth, &depth, NULL);
      bg = BlackPixelOfScreen(XtScreen(data -> d_darea));
      fg = WhitePixelOfScreen(XtScreen(data -> d_darea));
      data -> d_surf = XCreatePixmap(data -> d_dpy, data -> d_win, 128, 128,
				     depth);
      for(i = 0; i < 128; ++i)
	for(j = 0; j < 8; ++j) {
	  t = icon[(i << 3) + j];
	  for(k = 0; k < 16; ++k) {
	    if((t & (0x8000 >> k)) != 0)
	      XSetForeground(data -> d_dpy, data -> d_gc, bg);
	    else
	      XSetForeground(data -> d_dpy, data -> d_gc, fg);
	    XDrawPoint(data -> d_dpy, data -> d_surf, data -> d_gc,
		       (j << 4) + k, i);
	  }
	}
      font1 = XLoadQueryFont(data -> d_dpy, "-adobe-new century schoolbook-medium-r-*-*-18-*-*-*-*-*-*-*");
      XtVaGetValues(data -> d_darea, XmNforeground, &fg, NULL);
      XSetForeground(data -> d_dpy, data -> d_gc, fg);
    }
    break;
  case 7:
    {
      int base;
      XSetFont(data -> d_dpy, data -> d_gc, data -> d_fontInfo_p -> fid);
      XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, 0,
		  data -> d_fontInfo_p -> ascent, "SLAM!", 5);

      base = data -> d_fontInfo_p -> ascent + data -> d_fontInfo_p -> descent;
      XCopyArea(data -> d_dpy, data -> d_surf, data -> d_win, data -> d_gc, 0,
		0, 128, 128, 5, base);
      
      XSetFont(data -> d_dpy, data -> d_gc, font1 -> fid);
      base += font1 -> ascent + 5;
      XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, 143, base,
		  "Software Library for Appearance Matching (Version 1.1)", 54);
      base += font1 -> ascent + font1 -> descent; 
      XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, 143, base,
		  "Copyright \xA9 Columbia University, 1994", 37);
      base += font1 -> ascent + font1 -> descent;
      XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, 143, base,
		  "All Rights Reserved.", 20);
      base += font1 -> ascent + font1 -> descent + 15;
      XDrawString(data -> d_dpy, data -> d_win, data -> d_gc, 143, base,
		  "Sameer A. Nene, Shree K. Nayar, Hiroshi Murase", 46);
    }
  }
}

void timer_cb(XtPointer p1, unsigned long*)
{
  MainCbLocal *data = (MainCbLocal*)p1;

  draw(data);
  if(data -> d_state != 7)
    data -> d_timer = XtAppAddTimeOut(data -> d_app, (unsigned long)25,
				      timer_cb, data);
  else
    draw(data);
}

void copyright_cb(Widget w, XtPointer, XtPointer)
{
  Widget topshell, topwin, button1, text1, form1, sep1;
  Arg args[8];
  
  topshell = XtVaCreatePopupShell("License...", xmDialogShellWidgetClass,
				  XtParent(XtParent(w)), NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 8,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 5,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 7,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, destroy3_cb, NULL);
  XtManageChild(form1);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNshadowType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form1,
				 NULL);

  XtSetArg(args[0], XmNeditable, False);
  XtSetArg(args[1], XmNeditMode, XmMULTI_LINE_EDIT);
  XtSetArg(args[2], XmNscrollHorizontal, False);
  XtSetArg(args[3], XmNwordWrap, True);
  XtSetArg(args[4], XmNrows, 12);
  XtSetArg(args[5], XmNcolumns, 40);
  XtSetArg(args[6], XmNvalue, copyright);
  XtSetArg(args[7], XmNcursorPositionVisible, False);
  
  text1 = XmCreateScrolledText(topwin, "text", args, 8);
  XtVaSetValues(XtParent(text1),
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 15,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 15,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 15,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, sep1,
		XmNbottomOffset, 15,
		NULL);
  XtManageChild(text1);

  XtManageChild(topwin);
  XtManageChild(topshell);
}

void expose_cb(Widget, XtPointer p1, XtPointer)
{
  draw((MainCbLocal*)p1);
}
