// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xslam.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module frontend
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/PushBG.h>
#include "xslam.h"

extern void launchXimgtool_cb(Widget, XtPointer, XtPointer);
extern void launchXeigen_cb(Widget, XtPointer, XtPointer);
extern void launchXmanifold_cb(Widget, XtPointer, XtPointer);
extern void launchXmksrchtbl_cb(Widget, XtPointer, XtPointer);
extern void exit_cb(Widget, XtPointer, XtPointer);
extern void expose_cb(Widget, XtPointer, XtPointer);
extern void timer_cb(XtPointer, unsigned long*);
extern void copyright_cb(Widget, XtPointer, XtPointer);

int main(int argc, char **argv)
{
  static MainCbLocal data;
  Widget topshell, topwin, buttons, button1, button2, button3, button4,
  button5, button6, darea, frame2;

  topshell = XtAppInitialize(&data.d_app, "xslam", NULL, 0, &argc, argv, NULL,
			     (ArgList)NULL, (Cardinal)0);

  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    NULL);

  buttons = XtVaCreateWidget("buttons", xmFormWidgetClass, topwin,
			     XmNfractionBase, 6,
			     XmNheight, 64,
			     XmNorientation, XmHORIZONTAL,
			     XmNleftAttachment, XmATTACH_FORM,
			     XmNleftOffset, 10,
			     XmNrightAttachment, XmATTACH_FORM,
			     XmNrightOffset, 10,
			     XmNtopAttachment, XmATTACH_FORM,
			     XmNtopOffset, 10,
			     NULL);

  button1 = XtVaCreateManagedWidget("Images",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 0,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 1,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, launchXimgtool_cb, 0);
  
  button2 = XtVaCreateManagedWidget("Eigenvectors",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 2,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, launchXeigen_cb, 0);
  
  button3 = XtVaCreateManagedWidget("Manifolds",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button3, XmNactivateCallback, launchXmanifold_cb, 0);
  
  button4 = XtVaCreateManagedWidget("Search",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button4, XmNactivateCallback, launchXmksrchtbl_cb, 0);
  
  button5 = XtVaCreateManagedWidget("Quit",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 4,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 5,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button5, XmNactivateCallback, exit_cb, 0);
  
  button6 = XtVaCreateManagedWidget("License",
				    xmPushButtonGadgetClass, buttons,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 5,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 6,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    NULL);
  XtAddCallback(button6, XmNactivateCallback, copyright_cb, &data);

  XtManageChild(buttons);

  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, topwin,
			    XmNshadowType, XmSHADOW_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, buttons,
			    XmNtopOffset, 10,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNleftOffset, 10,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNrightOffset, 10,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNbottomOffset, 10,
			    NULL);
  darea = XtVaCreateManagedWidget("draw", xmDrawingAreaWidgetClass, frame2,
				  XmNwidth, 640,
				  XmNheight, 205,
				  NULL);
  XtAddCallback(darea, XmNexposeCallback, expose_cb, &data);
  data.d_darea = darea;
  XtManageChild(frame2);

  XtManageChild(topwin);
  XtRealizeWidget(topshell);

  data.d_dpy = XtDisplay(darea);
  data.d_win = XtWindow(darea);
  data.d_gc = XCreateGC(data.d_dpy, data.d_win, 0, 0);

  XtVaGetValues(darea, XmNwidth, &data.d_winWidth, NULL);
  
  data.d_timer = XtAppAddTimeOut(data.d_app, (unsigned long)25, timer_cb,
				 &data);
  data.d_state = data.d_substate = 0;

  XtAppMainLoop(data.d_app);

  return 0;
}
