// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// xmanifold.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// Notes:
//   X module for visualization/manipulation of manifolds/projections
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <iostream.h>
#include <math.h>
#include <stdlib.h>
#include <X11/PEX5/PEXlib.h>
#include <X11/Xatom.h>
extern "C" {
  Status XmuLookupStandardColormap(Display*            /* dpy */,
				   int                 /* screen */,
				   VisualID            /* visualid */,
				   unsigned int        /* depth */,
				   Atom                /* property */,
				   Bool                /* replace */,
				   Bool                /* retain */);
}
#include <Xm/ArrowBG.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>
#include "errorscope.h"
#include "fileiter.h"
#include "list.h"
#include "vector.h"
#include "ndataset.h"
#include "ninterpolation.h"
#include "xmanifold.h"

extern void objectSearchProc(Widget w, XtPointer p1, XtPointer);
extern void fillList(Widget listbox, const List<NamedDataSet* > &list);
extern void fillList(Widget listbox, const List<NamedInterpolation* > &list);
extern void change_view(Widget w, XButtonEvent *event, String *args);
extern int compute_view(double theta, double phi, double alpha, double tx,
			double ty, double tz, PEXMatrix ori);
extern void fillListWithVisible(Widget list);
extern void fillListWithInvisible(Widget list);
extern void createAxis(const PEXStructure &sid);
extern void createLabels(const PEXStructure &sid);
extern void redraw();
extern void pulldown_cb(Widget w, XtPointer, XtPointer);
extern void pulldownSense_cb(Widget w, XtPointer, XtPointer);
extern void pulldown3_cb(Widget w, XtPointer, XtPointer);
extern void destroy_cb(Widget w, XtPointer, XtPointer);
extern void destroy3_cb(Widget w, XtPointer, XtPointer);
extern void new_toggled_cb(Widget w, XtPointer p1, XtPointer);
extern void load_toggled_cb(Widget w, XtPointer p1, XtPointer);
extern void save_toggled_cb(Widget w, XtPointer p1, XtPointer);
extern void printBoxToggle_cb(Widget w, XtPointer p1, XtPointer);
extern void labelToggle_cb(Widget w, XtPointer p1, XtPointer);
extern void smenu_cb(Widget, XtPointer, XtPointer);
extern void paint_cb(Widget, XtPointer, XtPointer p2);
extern void resize_cb(Widget, XtPointer, XtPointer);
extern void loadbox_ok_cb(Widget w, XtPointer p3, XtPointer p1);
extern void savebox_ok_cb(Widget w, XtPointer p4, XtPointer p1);
extern void printbox_ok_cb(Widget w, XtPointer p1, XtPointer);
extern void orthobox_ok_cb(Widget w, XtPointer p1, XtPointer);
extern void fmenu_cb(Widget w, XtPointer p1, XtPointer);
extern void smenu_cb(Widget, XtPointer, XtPointer);
extern void selnomatch_cb(Widget w, XtPointer, XtPointer);
extern void project_cb(Widget w, XtPointer p1, XtPointer p2);
extern void arrow_down_cb(Widget, XtPointer p1, XtPointer);
extern void arrow_up_cb(Widget, XtPointer p1, XtPointer);
extern void listsel_cb(Widget, XtPointer p1, XtPointer p2);
extern void listselLabel_cb(Widget, XtPointer p1, XtPointer p2);
extern void listselLabelSense_cb(Widget, XtPointer p1, XtPointer p2);
extern void fitmfold_cb(Widget w, XtPointer p1, XtPointer);
extern void sample_cb(Widget w, XtPointer p1, XtPointer);
extern void omenu_cb(Widget w, XtPointer p1, XtPointer);
extern void hmenu_cb(Widget w, XtPointer, XtPointer);
extern void typeoptionB_cb(Widget, XtPointer p1, XtPointer);
extern void typeoptionT_cb(Widget, XtPointer p1, XtPointer);
extern void showAllProj_cb(Widget w, XtPointer, XtPointer);
extern void hideAllProj_cb(Widget w, XtPointer, XtPointer);
extern void showAllMfold_cb(Widget w, XtPointer, XtPointer);
extern void hideAllMfold_cb(Widget w, XtPointer, XtPointer);
extern void showListSel_cb(Widget w, XtPointer, XtPointer);
extern void hideListSel_cb(Widget w, XtPointer, XtPointer);
extern void prefListSel_cb(Widget w, XtPointer, XtPointer);
extern void loadVectorSet_cb(Widget w, XtPointer p1, XtPointer);
extern void loadVector_cb(Widget, XtPointer, XtPointer);
extern void loadEigenVector_cb(Widget, XtPointer, XtPointer);
extern void saveEigenVector_cb(Widget, XtPointer, XtPointer);
extern void loadVectorSetOk_cb(Widget w, XtPointer p3, XtPointer p1);
extern void loadVectorOk_cb(Widget w, XtPointer p3, XtPointer p1);
extern void loadEigenVectorOk_cb(Widget w, XtPointer p3, XtPointer p1);
extern void saveEigenVectorOk_cb(Widget w, XtPointer p3, XtPointer p1);
extern void pref_arrow_down_cb(Widget, XtPointer p1, XtPointer);
extern void pref_arrow_up_cb(Widget, XtPointer p1, XtPointer);
extern void mparChange_cb(Widget w, XtPointer p1, XtPointer);
extern void axisChange_cb(Widget w, XtPointer p1, XtPointer);
     
Boolean Global::d_pexavail = True;
char *Global::d_text1, *Global::d_text2, *Global::d_text3_p[3];
int Global::d_numeigen = 10, Global::d_dim1 = 0, Global::d_dim2 = 1,
Global::d_dim3 = 2, Global::d_sfreq[3], Global::d_typesel = 0,
Global::d_colIndex = 0, Global::d_vaindex = 0, Global::d_ftype = 0;
Widget Global::d_darea, Global::d_label1, Global::d_label2, Global::d_label3,
Global::d_loadbox, Global::d_savebox, Global::d_loadVectorSetBox,
Global::d_loadVectorBox, Global::d_loadEigenVectorBox, Global::d_prefbox,
Global::d_printBox, Global::d_menubar, Global::d_text4[3],
Global::d_saveEigenVectorBox, Global::d_topshell, Global::d_projbox,
Global::d_fitbox, Global::d_samplebox, Global::d_orthobox;
Window Global::d_drawin;
char *Global::d_name = 0, *Global::d_dir = 0;
Display *Global::d_display;
XVisualInfo Global::d_vinfo;
RadioBoxLocal *Global::d_sbdata;
FileList *Global::d_fl = 0;
FileListIter *Global::d_flit = 0;
Vector *Global::d_avg = 0;
VectAry *Global::d_va_p[2] = {0, 0};
PEXColorRGB Global::d_stColors[Global::NUM_STATIC_COLORS] = {{1., 0., 0.},
							     {0., 1., 0.},
							     {0., 0., 1.},
							     {1., 0., 1.},
							     {0., 1., 1.},
							     {.627, .322, .176},
							     {1., .647, 0.},
							     {1., .498, .314}};
List<NamedDataSet* > Global::d_proj;
List<NamedInterpolation* > Global::d_manifold;

void err_dlg(Widget parent, const char *s)
{
  XmString mesg = XmStringCreateSimple((char *)s);
  Widget dlg;

  dlg = XmCreateErrorDialog(parent, "Error", NULL, 0);
  XtVaSetValues(dlg,
		XmNmessageString, mesg,
		XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		NULL);
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_HELP_BUTTON));

  XmStringFree(mesg);
  XtManageChild(dlg);
}

Widget create_load_dialog(Widget w)
{
  RadioBoxLocal *data = new RadioBoxLocal;
  XmString str1, str2;
  Widget topshell, topwin, label1, frame1, radiobox, filesb, optionMenu,
  optionType, type1, type2, form1;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Load...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNfractionBase, 2,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  
  label1 = XtVaCreateManagedWidget("Entity:", xmLabelGadgetClass, form1,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   NULL);
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form1,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    NULL);
  str1 = XmStringCreateSimple("Projections");
  str2 = XmStringCreateSimple("Manifold");
  radiobox = XmVaCreateSimpleRadioBox(frame1, "radiobox", 0, new_toggled_cb,
				      XmVaRADIOBUTTON, str1, NULL, NULL, NULL,
				      XmVaRADIOBUTTON, str2, NULL, NULL, NULL,
				      NULL);
  XtManageChild(radiobox);
  XmStringFree(str1);
  XmStringFree(str2);
  XtManageChild(frame1);

  label1 = XtVaCreateManagedWidget("File type:", xmLabelGadgetClass, form1,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 1,
				   NULL);
  optionType = XmCreatePulldownMenu(form1, "options", NULL, 0);
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[3], XmNtopWidget, label1);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_POSITION);
  XtSetArg(args[5], XmNleftPosition, 1);
  optionMenu = XmCreateOptionMenu(form1, "typeoption", args, 6);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &(data -> d_typesel));
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &(data -> d_typesel));
  XtManageChild(optionMenu);
  XtManageChild(form1);

  str1 = XmStringCreateSimple("*.prj");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, form1,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, loadbox_ok_cb, radiobox);
  XtAddCallback(filesb, XmNcancelCallback, pulldownSense_cb, NULL);
  data -> d_fileSelBox = filesb;
  data -> d_sel = 0;
  data -> d_type1 = optionMenu;
  data -> d_type2 = type2;
  data -> d_typesel = 0;
  XtVaSetValues(radiobox, XmNuserData, data, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));

  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

Widget create_loadVectorSet_dialog(Widget w)
{
  XmString str1;
  Widget topshell, topwin, filesb, optionMenu, optionType, type1, type2;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Vector Set...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			    NULL);

  optionType = XmCreatePulldownMenu(topwin, "options", NULL, 0);
  str1 = XmStringCreateSimple("File Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNtopOffset, 10);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNleftOffset, 10);
  optionMenu = XmCreateOptionMenu(topwin, "typeoption", args, 6);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &Global::d_typesel);
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &Global::d_typesel);

  str1 = XmStringCreateSimple("*.vec");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   XmNfileSearchProc, objectSearchProc,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, loadVectorSetOk_cb, &Global::d_typesel);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtSetSensitive(XmFileSelectionBoxGetChild(filesb, XmDIALOG_FILTER_TEXT), False);
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

Widget create_loadVector_dialog(Widget w)
{
  static int ftype = 0;
  XmString str1;
  Widget topshell, topwin, filesb, optionMenu, optionType, type1, type2;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Average Vector...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			    NULL);

  optionType = XmCreatePulldownMenu(topwin, "options", NULL, 0);
  str1 = XmStringCreateSimple("File Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNtopOffset, 10);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNleftOffset, 10);
  optionMenu = XmCreateOptionMenu(topwin, "typeoption", args, 6);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &ftype);
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &ftype);

  str1 = XmStringCreateSimple("*.vec");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, loadVectorOk_cb, &ftype);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

Widget create_loadEigenVector_dialog(Widget w)
{
  static int ftype = 0;
  XmString str1;
  Widget topshell, topwin, filesb, optionMenu, optionType, type1, type2;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Eigenvector...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			    NULL);

  optionType = XmCreatePulldownMenu(topwin, "options", NULL, 0);
  str1 = XmStringCreateSimple("File Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNtopOffset, 10);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNleftOffset, 10);
  optionMenu = XmCreateOptionMenu(topwin, "typeoption", args, 6);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &ftype);
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &ftype);

  str1 = XmStringCreateSimple("*.evc");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, loadEigenVectorOk_cb, &ftype);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

Widget create_saveEigenVector_dialog(Widget w)
{
  static int ftype = 0;
  XmString str1;
  Widget topshell, topwin, filesb, optionMenu, optionType, type1, type2;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Eigenvector...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			    NULL);

  optionType = XmCreatePulldownMenu(topwin, "options", NULL, 0);
  str1 = XmStringCreateSimple("File Type:");
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, str1);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNtopOffset, 10);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNleftOffset, 10);
  optionMenu = XmCreateOptionMenu(topwin, "typeoption", args, 6);
  XtManageChild(optionMenu);
  XmStringFree(str1);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &ftype);
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &ftype);

  str1 = XmStringCreateSimple("*.evc");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, optionMenu,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, saveEigenVectorOk_cb, &ftype);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

Widget create_save_dialog(Widget w)
{
  RadioBoxLocal *data = new RadioBoxLocal;
  XmString str1, str2;
  Widget topshell, topwin, label1, label2, frame1, frame2, radiobox, filesb,
  form1, button, listbox, form2, type1, type2, optionType, optionMenu;
  Arg args[6];
  
  topshell = XtVaCreatePopupShell("Save...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 2,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);

  label1 = XtVaCreateManagedWidget("Entity:", xmLabelGadgetClass, form1,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   NULL);
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form1,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 0,
			    NULL);
  str1 = XmStringCreateSimple("Projections");
  str2 = XmStringCreateSimple("Manifold");
  radiobox = XmVaCreateSimpleRadioBox(frame1, "radiobox", 0, save_toggled_cb,
				      XmVaRADIOBUTTON, str1, NULL, NULL, NULL,
				      XmVaRADIOBUTTON, str2, NULL, NULL, NULL,
				      NULL);
  XtManageChild(radiobox);
  XmStringFree(str1);
  XmStringFree(str2);
  XtManageChild(frame1);

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNtopAttachment, XmATTACH_POSITION,
			   XmNtopPosition, 1,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 0,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 1,
			   XmNbottomAttachment, XmATTACH_POSITION,
			   XmNbottomPosition, 2,
			   NULL);
  label1 = XtVaCreateManagedWidget("File type:", xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  optionType = XmCreatePulldownMenu(form2, "options", NULL, 0);
  XtSetArg(args[0], XmNsubMenuId, optionType);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[3], XmNtopWidget, label1);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  optionMenu = XmCreateOptionMenu(form2, "typeoption", args, 5);
  type1 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoptionB_cb, &(data -> d_typesel));
  type2 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  optionType,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoptionT_cb, &(data -> d_typesel));
  XtManageChild(optionMenu);
  XtManageChild(form2);

  label2 = XtVaCreateManagedWidget("Select:", xmLabelGadgetClass, form1,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 1,
				   XmNleftOffset, 10,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form1,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label2,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 1,
			    XmNleftOffset, 10,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNrightPosition, 2,
			    XmNbottomAttachment, XmATTACH_POSITION,
			    XmNbottomPosition, 2,
			    NULL);
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, frame2, NULL);
  button = XtVaCreateManagedWidget("Combine", xmToggleButtonGadgetClass, form2,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNleftOffset, 5,
				   NULL);
  listbox = XmCreateScrolledList(form2, "list", NULL, 0);
  XtVaSetValues(listbox,
		XmNvisibleItemCount, 7,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNselectionPolicy, XmEXTENDED_SELECT,
		NULL);
  XtVaSetValues(XtParent(listbox),
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, button,
		XmNtopOffset, 2,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 7,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 7,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 7,
		NULL);
  XtManageChild(listbox);
  XtManageChild(form2);
  XtManageChild(frame2);

  XtManageChild(form1);
  
  str1 = XmStringCreateSimple("*.prj");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNmustMatch, False,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, form1,
				   XmNtopOffset, 10,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, savebox_ok_cb, radiobox);
  XtAddCallback(filesb, XmNcancelCallback, pulldownSense_cb, NULL);
  data -> d_fileSelBox = filesb;
  data -> d_toggleb = button;
  data -> d_list = listbox;
  data -> d_sel = 0;
  data -> d_type1 = optionMenu;
  data -> d_type2 = type2;
  data -> d_typesel = 0;
  XtVaSetValues(radiobox, XmNuserData, data, NULL);
  Global::d_sbdata = data;
  XmStringFree(str1);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  
  XtManageChild(topwin);

  return topshell;
}

Widget create_project_dialog(Widget w)
{
  char buf[256];
  static ProjectCbLocal data;
  XmString str1, str2;
  Widget topshell, topwin, form1, form2, form3, text1, arrow1, arrow2, selbox,
  label1, button1, sep1;

  topshell = XtVaCreatePopupShell("Project...", xmDialogShellWidgetClass, w,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNfractionBase, 3,
			   NULL);
  label1 = XtVaCreateManagedWidget("Vector Set:", xmLabelGadgetClass, form1,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form1,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text1,
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, loadVectorSet_cb, 0);
  XtManageChild(form1);
  Global::d_label1 = text1;

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form1,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNfractionBase, 3,
			   NULL);
  label1 = XtVaCreateManagedWidget("Average Vector:", xmLabelGadgetClass, form2,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form2,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form2,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text2,
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, loadVector_cb, 0);
  XtManageChild(form2);
  Global::d_label2 = text1;

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form2,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNfractionBase, 3,
			   NULL);
  label1 = XtVaCreateManagedWidget("Eigenvectors:", xmLabelGadgetClass, form3,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text3_p[0],
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, loadEigenVector_cb, 0);
  XtManageChild(form3);
  Global::d_text4[0] = text1;

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, form3,
				 XmNtopOffset, 10,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, sep1,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("Number of Eigenvectors:",
				   xmLabelGadgetClass, form1,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_numeigen);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form1,
				  XmNvalue, buf,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1000,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label1,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_numVectorText = text1;
  arrow1 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form1,
				   XmNarrowDirection, XmARROW_UP,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, text1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow1, XmNarmCallback, arrow_up_cb, &data);
  arrow2 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form1,
				   XmNarrowDirection, XmARROW_DOWN,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, arrow1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow2, XmNarmCallback, arrow_down_cb, &data);
  XtManageChild(form1);

  button1 = XtVaCreateManagedWidget("Use Average Vector",
				    xmToggleButtonGadgetClass, topwin,
				    XmNset, True,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, form1,
				    XmNtopOffset, 10,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNleftOffset, 10,
				    NULL);
  data.d_useAvgBtn = button1;

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, button1,
				 XmNtopOffset, 10,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 NULL);

  str1 = XmStringCreateSimple("Projections in Memory");
  str2 = XmStringCreateSimple("Selection");
  selbox = XtVaCreateManagedWidget("selbox", xmSelectionBoxWidgetClass, topwin,
				   XmNlistLabelString, str1,
				   XmNselectionLabelString, str2,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, sep1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  fillList(XmSelectionBoxGetChild(selbox, XmDIALOG_LIST),
	   Global::d_proj);
  
  XtUnmanageChild(XmSelectionBoxGetChild(selbox, XmDIALOG_HELP_BUTTON));
  XtAddCallback(selbox, XmNokCallback, project_cb, &data);
  XtAddCallback(selbox, XmNcancelCallback, destroy_cb, NULL);

  XtManageChild(topwin);
  XtManageChild(topshell);

  return topshell;
}

Widget create_interpolate_dialog(Widget w)
{
  char buf[256];
  static FitManifoldCbLocal data;
  Widget topshell, topwin, form1, form2, form3, form4, list1, list2, text1,
  text2, button1, button2, label1, label2, label3, label4, sep1, form5;

  topshell = XtVaCreatePopupShell("Interpolate...", xmDialogShellWidgetClass, XtParent(w),
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 7,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button2 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form4,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, destroy3_cb, NULL);
  XtManageChild(form4);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form4,
				 NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   XmNbottomOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Projections in Memory", xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form2,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text1 = text1;
  label3 = XtVaCreateManagedWidget("Selection", xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, text1,
				   NULL);
  list1 = XmCreateScrolledList(form2, "list", NULL, 0);
  XtVaSetValues(list1,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list1, XmNbrowseSelectionCallback, listsel_cb, text1);
  XtVaSetValues(XtParent(list1),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label1,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, label3,
		XmNbottomOffset, 10,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillList(list1, Global::d_proj);
  XtManageChild(list1);
  XtManageChild(form2);
    
  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  label2 = XtVaCreateManagedWidget("Manifolds in Memory",
				   xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  text2 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text2 = text2;
  label4 = XtVaCreateManagedWidget("Selection", xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, text2,
				   NULL);
  list2 = XmCreateScrolledList(form3, "list", NULL, 0);
  XtVaSetValues(list2,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list2, XmNbrowseSelectionCallback, listsel_cb, text2);
  XtVaSetValues(XtParent(list2),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label2,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, label4,
		XmNbottomOffset, 10,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillList(list2, Global::d_manifold);
  data.d_list = list2;
  XtManageChild(list2);
  XtManageChild(form3);

  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 7,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_WIDGET,
			   XmNleftWidget, form2,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_WIDGET,
			   XmNrightWidget, form3,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget(">>> Interpolate >>>",
				    xmPushButtonGadgetClass, form5,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 0,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 3,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 7,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, fitmfold_cb, &data);
  XtManageChild(form5);

  XtManageChild(form1);

  XtManageChild(topwin);
  XtManageChild(topshell);

  return topshell;
}

Widget create_sample_dialog(Widget w)
{
  char buf[256];
  static FitManifoldCbLocal data;
  Widget topshell, topwin, form1, form2, form3, form4, form5, form6, form7,
  form8, list1, list2, text1, text2, text3, text4, text5, button1, button2,
  label1, label2, label3, label4, label5, label6, frame2, sep1, form9;
    
  topshell = XtVaCreatePopupShell("Sample Manifold...",
				  xmDialogShellWidgetClass, XtParent(w),
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 7,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button2 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form4,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, destroy3_cb, NULL);
  XtManageChild(form4);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form4,
				 NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   XmNbottomOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Manifolds in Memory",
				   xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form2,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text2 = text1;
  label3 = XtVaCreateManagedWidget("Selection", xmLabelGadgetClass, form2,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, text1,
				   NULL);
  list1 = XmCreateScrolledList(form2, "list", NULL, 0);
  XtVaSetValues(list1,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list1, XmNbrowseSelectionCallback, listselLabelSense_cb, &data);
  XtVaSetValues(XtParent(list1),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label1,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, label3,
		XmNbottomOffset, 10,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  XtManageChild(list1);
  fillList(list1, Global::d_manifold);
  XtManageChild(form2);
  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  label2 = XtVaCreateManagedWidget("Projections in Memory",
				   xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);    
  text2 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text1 = text2;
  label4 = XtVaCreateManagedWidget("Selection", xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_WIDGET,
				   XmNbottomWidget, text2,
				   NULL);
  list2 = XmCreateScrolledList(form3, "list", NULL, 0);
  XtVaSetValues(list2,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list2, XmNbrowseSelectionCallback, listsel_cb, text2);
  XtVaSetValues(XtParent(list2),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label2,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, label4,
		XmNbottomOffset, 10,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillList(list2, Global::d_proj);
  data.d_list = list2;
  XtManageChild(list2);
  XtManageChild(form3);

  form9 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 7,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_WIDGET,
			   XmNleftWidget, form2,
			   XmNrightAttachment, XmATTACH_WIDGET,
			   XmNrightWidget, form3,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget(">>> Sample >>>",
				    xmPushButtonGadgetClass, form9,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 5,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 2,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, sample_cb, &data);
  label6 = XtVaCreateManagedWidget("Sampling Frequency",
				   xmLabelGadgetClass, form9,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 1,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 6,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 2,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form9,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 1,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNtopPosition, 3,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNrightPosition, 6,
			    NULL);
  form5 = XtVaCreateWidget("form", xmFormWidgetClass, frame2,
			   NULL);
  form6 = XtVaCreateWidget("form", xmFormWidgetClass, form5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 5,
			   NULL);
  label3 = XtVaCreateManagedWidget("Parameter 1:", xmLabelGadgetClass, form6,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_sfreq[0]);
  text3 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form6,
				  XmNvalue, buf,
				  XmNsensitive, False,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1500,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label3,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text[0] = text3;
  XtManageChild(form6);
  form7 = XtVaCreateWidget("form", xmFormWidgetClass, form5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form6, 
			   NULL);
  label4 = XtVaCreateManagedWidget("Parameter 2:", xmLabelGadgetClass, form7,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_sfreq[1]);
  text4 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form7,
				  XmNvalue, buf,
				  XmNsensitive, False,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1500,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label4,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text[1] = text4;
  XtManageChild(form7);
  form8 = XtVaCreateWidget("form", xmFormWidgetClass, form5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form7,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNbottomOffset, 5,
			   NULL);
  label5 = XtVaCreateManagedWidget("Parameter 3:", xmLabelGadgetClass, form8,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_sfreq[2]);
  text5 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form8,
				  XmNvalue, buf,
				  XmNsensitive, False,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1500,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label5,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text[2] = text5;
  XtManageChild(form8);
  XtManageChild(form5);
  XtManageChild(frame2);
  XtManageChild(form9);
  
  XtManageChild(form1);

  XtManageChild(topwin);
  XtManageChild(topshell);

  return topshell;
}

void create_view_dialog(Widget w)
{
  Widget topshell, form1, form2, form3, form4, form5, buttons, button1,
  button2, button3, button4, sep1, label1, label2, list1, list2;
  ListSelCbLocal *data = new ListSelCbLocal;
  
  topshell = XtVaCreatePopupShell("Show/Hide...",
				  xmDialogShellWidgetClass, XtParent(w),
				  NULL);
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 7,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form5,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, destroy3_cb, 0);
  XtManageChild(form5);
  
  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form5,
				 NULL);

  buttons = XtVaCreateWidget("form", xmRowColumnWidgetClass, form1,
			     XmNorientation, XmHORIZONTAL,
			     XmNtopAttachment, XmATTACH_FORM,
			     XmNtopOffset, 10,
			     XmNleftAttachment, XmATTACH_FORM,
			     XmNleftOffset, 10,
			     XmNrightAttachment, XmATTACH_FORM,
			     XmNrightOffset, 10,
			     NULL);
  button1 = XtVaCreateManagedWidget("Show All Projections",
				    xmPushButtonGadgetClass, buttons,
				    NULL);
  button2 = XtVaCreateManagedWidget("Hide All Projections",
				    xmPushButtonGadgetClass, buttons,
				    NULL);
  button3 = XtVaCreateManagedWidget("Show All Manifolds",
				    xmPushButtonGadgetClass, buttons,
				    NULL);
  button4 = XtVaCreateManagedWidget("Hide All Manifolds",
				    xmPushButtonGadgetClass, buttons,
				    NULL);
  XtManageChild(buttons);

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 2,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, buttons,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   XmNbottomOffset, 20,
			   NULL);

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form2,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 0,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 1,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_POSITION,
			   XmNtopPosition, 0,
			   XmNbottomAttachment, XmATTACH_POSITION,
			   XmNbottomPosition, 2,
			   NULL);
  label1 = XtVaCreateManagedWidget("Visible Objects: (Select to Hide)",
				   xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  list1 = XmCreateScrolledList(form3, "list", NULL, 0);
  XtVaSetValues(list1,
		XmNselectionPolicy, XmBROWSE_SELECT,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtVaSetValues(XtParent(list1),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label1,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillListWithVisible(list1);
  XtManageChild(list1);
  XtManageChild(form3);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form2,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 1,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 2,
			   XmNtopAttachment, XmATTACH_POSITION,
			   XmNtopPosition, 0,
			   XmNbottomAttachment, XmATTACH_POSITION,
			   XmNbottomPosition, 2,
			   NULL);
  label2 = XtVaCreateManagedWidget("Hidden Objects: (Select to Show)",
				   xmLabelGadgetClass, form4,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  list2 = XmCreateScrolledList(form4, "list", NULL, 0);
  XtVaSetValues(list2,
		XmNselectionPolicy, XmBROWSE_SELECT,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list2, XmNbrowseSelectionCallback, hideListSel_cb, list1);
  XtAddCallback(list1, XmNbrowseSelectionCallback, showListSel_cb, list2);
  XtVaSetValues(XtParent(list2),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label2,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillListWithInvisible(list2);
  XtManageChild(list2);
  XtManageChild(form4);

  XtManageChild(form2);
 
  XtManageChild(form1);
  XtManageChild(topshell);

  data -> d_viList = list1;
  data -> d_hdList = list2;

  XtAddCallback(button1, XmNactivateCallback, showAllProj_cb, data);
  XtAddCallback(button2, XmNactivateCallback, hideAllProj_cb, data);
  XtAddCallback(button3, XmNactivateCallback, showAllMfold_cb, data);
  XtAddCallback(button4, XmNactivateCallback, hideAllMfold_cb, data);
}

Widget create_pref_dialog(Widget w)
{
  char buf[256];
  Widget topshell, form1, form2, form3, form4, form5, button1, button2,
  label1, list1, label2, frame1, frame2, text1, arrow1, arrow2, form6, form7,
  form8, form9, dtype, menu, form10, form11, form12;
  XmString str1;
  Arg args[11];
  static PrefCbLocal data;
  ExposeCbLocal *data2;
  
  topshell = XtVaCreatePopupShell("Preferences...",
				  xmDialogShellWidgetClass, XtParent(w),
				  NULL);
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button2 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form4,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, destroy3_cb, 0);
  XtManageChild(form4);
				  
  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, form4,
			   XmNbottomOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Manifold Parameters", xmLabelGadgetClass, form2,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);

  form12 = XtVaCreateWidget("form", xmFormWidgetClass, frame1,
			    NULL);

  form7 = XtVaCreateWidget("form", xmFormWidgetClass, form12,
			   XmNfractionBase, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Apply", xmPushButtonGadgetClass, form7,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, mparChange_cb, &data);
  XtManageChild(form7);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form12,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, form7,
			   XmNbottomOffset, 10,
			   NULL);
  
  form10 = XtVaCreateWidget("form", xmFormWidgetClass, form4,
			    XmNtopAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NULL);
  form7 = XtVaCreateWidget("form", xmFormWidgetClass, form10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Selection",
				   xmLabelGadgetClass, form7,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form7,
			    XmNshadowType, XmSHADOW_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);
  str1 = XmStringCreateSimple(" ");
  label2 = XtVaCreateManagedWidget("label", xmLabelGadgetClass, frame2,
				   XmNlabelString, str1,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   //XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  data.d_selLabel = label2;
  XmStringFree(str1);
  XtManageChild(frame2);
  XtManageChild(form7);

  form8 = XtVaCreateWidget("form", xmFormWidgetClass, form10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form7,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Parameter 1",
				   xmLabelGadgetClass, form8,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form8,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);
  form11 = XtVaCreateWidget("form", xmFormWidgetClass, frame2,
			    NULL);
  form9 = XtVaCreateWidget("form", xmFormWidgetClass, form11,
			   XmNfractionBase, 2,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNtopOffset, 5,
			   XmNbottomOffset, 5,
			   XmNrightOffset, 5,
			   NULL);
  label1 = XtVaCreateManagedWidget("Samples:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 1,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form9,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 2000,
				  XmNsensitive, False,
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 1,
				  NULL);
  data.d_paramText[0] = text1;
  label1 = XtVaCreateManagedWidget("Dimension:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 1,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 2,
				   NULL);
  dtype = XmCreatePulldownMenu(form9, "options", NULL, 0);
  XtVaSetValues(dtype, XmNuserData, &data, NULL);
  data.d_optionType[0] = dtype;
  XtSetArg(args[0], XmNsubMenuId, dtype);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_POSITION);
  XtSetArg(args[3], XmNtopPosition, 1);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_POSITION);
  XtSetArg(args[5], XmNleftPosition, 1);
  XtSetArg(args[6], XmNrightAttachment, XmATTACH_POSITION);
  XtSetArg(args[7], XmNrightPosition, 2);
  XtSetArg(args[8], XmNbottomAttachment, XmATTACH_POSITION);
  XtSetArg(args[9], XmNbottomPosition, 2);
  XtSetArg(args[10], XmNsensitive, False);
  menu = XmCreateOptionMenu(form9, "typeoption", args, 11);
  data.d_optionMenu[0] = menu;
  XtVaCreateManagedWidget("0", xmPushButtonGadgetClass, dtype,
			  XmNsensitive, False,
			  NULL);
  XtManageChild(menu);
  XtManageChild(form9);
  XtManageChild(form11);
  XtManageChild(frame2);
  label1 = XtVaCreateManagedWidget("Parameter 2",
				   xmLabelGadgetClass, form8,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, frame2,
				   XmNtopOffset, 10,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form8,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);
  form11 = XtVaCreateWidget("form", xmFormWidgetClass, frame2,
			    NULL);
  form9 = XtVaCreateWidget("form", xmFormWidgetClass, form11,
			   XmNfractionBase, 2,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNtopOffset, 5,
			   XmNbottomOffset, 5,
			   XmNrightOffset, 5,
			   NULL);
  label1 = XtVaCreateManagedWidget("Samples:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 1,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form9,
				  XmNsensitive, False,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 2000,
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 1,
				  NULL);
  data.d_paramText[1] = text1;
  label1 = XtVaCreateManagedWidget("Dimension:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 1,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 2,
				   NULL);
  dtype = XmCreatePulldownMenu(form9, "options", NULL, 0);
  XtVaSetValues(dtype, XmNuserData, &data, NULL);
  data.d_optionType[1] = dtype;
  XtSetArg(args[0], XmNsubMenuId, dtype);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_POSITION);
  XtSetArg(args[3], XmNtopPosition, 1);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_POSITION);
  XtSetArg(args[5], XmNleftPosition, 1);
  XtSetArg(args[6], XmNrightAttachment, XmATTACH_POSITION);
  XtSetArg(args[7], XmNrightPosition, 2);
  XtSetArg(args[8], XmNbottomAttachment, XmATTACH_POSITION);
  XtSetArg(args[9], XmNbottomPosition, 2);
  XtSetArg(args[10], XmNsensitive, False);
  menu = XmCreateOptionMenu(form9, "typeoption", args, 11);
  data.d_optionMenu[1] = menu;
  XtVaCreateManagedWidget("0", xmPushButtonGadgetClass, dtype,
			  XmNsensitive, False,
			  NULL);
  XtManageChild(menu);
  XtManageChild(form9);
  XtManageChild(form11);
  XtManageChild(frame2);
  label1 = XtVaCreateManagedWidget("Parameter N",
				   xmLabelGadgetClass, form8,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, frame2,
				   XmNtopOffset, 10,
				   NULL);
  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form8,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);
  form11 = XtVaCreateWidget("form", xmFormWidgetClass, frame2,
			    NULL);
  form9 = XtVaCreateWidget("form", xmFormWidgetClass, form11,
			   XmNfractionBase, 2,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNtopOffset, 5,
			   XmNbottomOffset, 5,
			   XmNrightOffset, 5,
			   NULL);
  label1 = XtVaCreateManagedWidget("Value:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 1,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form9,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 2000,
				  XmNsensitive, False,
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 1,
				  NULL);
  data.d_paramText[2] = text1;
  label1 = XtVaCreateManagedWidget("Parameter:", xmLabelGadgetClass, form9,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 1,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 2,
				   NULL);
  dtype = XmCreatePulldownMenu(form9, "options", NULL, 0);
  XtVaSetValues(dtype, XmNuserData, &data, NULL);
  data.d_optionType[2] = dtype;
  XtSetArg(args[0], XmNsubMenuId, dtype);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_POSITION);
  XtSetArg(args[3], XmNtopPosition, 1);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_POSITION);
  XtSetArg(args[5], XmNleftPosition, 1);
  XtSetArg(args[6], XmNrightAttachment, XmATTACH_POSITION);
  XtSetArg(args[7], XmNrightPosition, 2);
  XtSetArg(args[8], XmNbottomAttachment, XmATTACH_POSITION);
  XtSetArg(args[9], XmNbottomPosition, 2);
  XtSetArg(args[10], XmNsensitive, False);
  menu = XmCreateOptionMenu(form9, "typeoption", args, 11);
  data.d_optionMenu[2] = menu;
  XtVaCreateManagedWidget("0", xmPushButtonGadgetClass, dtype,
			  XmNsensitive, False,
			  NULL);
  XtManageChild(menu);
  XtManageChild(form9);
  XtManageChild(form11);
  XtManageChild(frame2);
  XtManageChild(form8);
  XtManageChild(form10);

  form6 = XtVaCreateWidget("form", xmFormWidgetClass, form4,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_WIDGET,
			   XmNrightWidget, form10,
			   XmNrightOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("In Memory",
				   xmLabelGadgetClass, form6,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   NULL);
  list1 = XmCreateScrolledList(form6, "list", NULL, 0);
  XtVaSetValues(list1,
		XmNselectionPolicy, XmBROWSE_SELECT,
		XmNscrollBarDisplayPolicy, XmAS_NEEDED,
		XmNvisibleItemCount, 7,
		NULL);
  XtAddCallback(list1, XmNbrowseSelectionCallback, prefListSel_cb, &data);
  XtVaSetValues(XtParent(list1),
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, label1,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
  fillList(list1, Global::d_manifold);
  XtManageChild(list1);
  XtManageChild(form6);
  XtManageChild(form4);
  XtManageChild(form12);
  
  XtManageChild(frame1);
  XtManageChild(form2);
  XtManageChild(form5);

  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, form5,
			   XmNbottomOffset, 15,
			   NULL);

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("Axis Dimension", xmLabelGadgetClass, form2,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNrightAttachment, XmATTACH_FORM,
			    NULL);
  form6 = XtVaCreateWidget("form", xmFormWidgetClass, frame1,
			   NULL);

  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form6,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopOffset, 10,
			   XmNbottomOffset, 10,
			   NULL);
  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form4,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  label2 = XtVaCreateManagedWidget("Axis 1:",
				   xmLabelGadgetClass, form3,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_dim1);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNvalue, buf,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1000,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label2,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_axisText[0] = text1;
  arrow1 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_UP,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, text1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow1, XmNarmCallback, pref_arrow_up_cb, (XtPointer)text1);
  arrow2 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_DOWN,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, arrow1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow2, XmNarmCallback, pref_arrow_down_cb, (XtPointer)text1);
  XtManageChild(form3);

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form4,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  label2 = XtVaCreateManagedWidget("Axis 2:",
				   xmLabelGadgetClass, form3,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_dim2);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNvalue, buf,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1000,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label2,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_axisText[1] = text1;
  arrow1 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_UP,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, text1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow1, XmNarmCallback, pref_arrow_up_cb, (XtPointer)text1);
  arrow2 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_DOWN,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, arrow1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow2, XmNarmCallback, pref_arrow_down_cb, (XtPointer)text1);
  XtManageChild(form3);

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form4,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  label2 = XtVaCreateManagedWidget("Axis 3:",
				   xmLabelGadgetClass, form3,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_dim3);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNvalue, buf,
				  XmNunitType, Xm100TH_FONT_UNITS,
				  XmNwidth, 1000,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label2,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL);
  data.d_axisText[2] = text1;
  arrow1 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_UP,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, text1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow1, XmNarmCallback, pref_arrow_up_cb, (XtPointer)text1);
  arrow2 = XtVaCreateManagedWidget("arrow", xmArrowButtonGadgetClass, form3,
				   XmNarrowDirection, XmARROW_DOWN,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, arrow1,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtAddCallback(arrow2, XmNarmCallback, pref_arrow_down_cb, (XtPointer)text1);
  XtManageChild(form3);
  XtManageChild(form4);

  form7 = XtVaCreateWidget("form", xmFormWidgetClass, form6,
			   XmNfractionBase, 9,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_WIDGET,
			   XmNleftWidget, form4,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Apply", xmPushButtonGadgetClass, form7,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 8,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 6,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, axisChange_cb, &data);
  XtManageChild(form7);

  XtManageChild(form6);
  XtManageChild(frame1);
  XtManageChild(form2);

  XtManageChild(form5);

  XtVaGetValues(Global::d_darea, XmNuserData, &data2, NULL);
  button1 = XtVaCreateManagedWidget("View Labels", xmToggleButtonGadgetClass, form1,
				    XmNset, data2 -> d_viewLabels,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNleftOffset, 10,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNtopOffset, 10,
				    XmNbottomAttachment, XmATTACH_WIDGET,
				    XmNbottomWidget, form5,
				    XmNbottomOffset, 15,
				    NULL);
  XtAddCallback(button1, XmNvalueChangedCallback, labelToggle_cb, 0);
    
  XtManageChild(form1);
  XtManageChild(topshell);

  return topshell;
}

Widget create_print_dialog(Widget w)
{
  static PrintBoxLocal data;
  Widget topshell, topwin, label1, button1, button2, text1, form1, form2, sep1;
  
  topshell = XtVaCreatePopupShell("Print...", xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Ok", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 2,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, printbox_ok_cb, &data);
  button2 = XtVaCreateManagedWidget("Cancel", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, pulldown3_cb, 0);
  XtManageChild(form1);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form1,
				 NULL);

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   XmNbottomOffset, 10,
			   NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, form2,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  label1 = XtVaCreateManagedWidget("PostScript Printer:", xmLabelGadgetClass, form1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form1,
				  XmNvalue, getenv("PRINTER"),
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, label1,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text1 = text1;
  XtManageChild(form1);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, form2,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form1,
			   XmNtopOffset, 10,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Print to File:",
				    xmToggleButtonGadgetClass, form1,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNbottomAttachment, XmATTACH_FORM,
				    NULL);
  data.d_bpressed = False;
  XtAddCallback(button1, XmNvalueChangedCallback, printBoxToggle_cb, &data);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form1,
				  XmNsensitive, False,
				  XmNvalue, "spool.ps",
				  XmNleftAttachment, XmATTACH_WIDGET,
				  XmNleftWidget, button1,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);
  data.d_text2 = text1;
  XtManageChild(form1);

  XtManageChild(form2);
  
  XtManageChild(topwin);
  XtManageChild(topshell);
  return topshell;
}

void create_extent_dialog(Widget w)
{
  char buf[65536];
  int i;
  Widget topshell, topwin, button1, text1, form1, sep1;
  Arg args[15];
  PEXCoord min, max;
  ExposeCbLocal *data;
  
  topshell = XtVaCreatePopupShell("Extents...", xmDialogShellWidgetClass, w,
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 8,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 5,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 7,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, destroy3_cb, NULL);
  XtManageChild(form1);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNshadowType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form1,
				 NULL);

  XtVaGetValues(Global::d_darea, XmNuserData, &data, NULL);

  sprintf(buf, "Axis Extents\n----------\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n\n", Global::d_dim1, data -> d_tx2 - data -> d_sx, Global::d_dim1, data -> d_tx2 + data -> d_sx, Global::d_dim2, data -> d_ty2 - data -> d_sy, Global::d_dim2, data -> d_ty2 + data -> d_sy, Global::d_dim3, data -> d_tz2 - data -> d_sz, Global::d_dim3, data -> d_tz2 + data -> d_sz);
  i = strlen(buf);

  for(ListIter<NamedDataSet* > it1(Global::d_proj); it1; ++it1) {
    it1() -> getExtents(&min, &max);
    sprintf(&buf[i], "Extents(Projection: %s):\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n\n", it1() -> dataName(), Global::d_dim1, min.x, Global::d_dim1, max.x, Global::d_dim2, min.y, Global::d_dim2, max.y, Global::d_dim3, min.z, Global::d_dim3, max.z);
    i += strlen(&buf[i]);
  }

  for(ListIter<NamedInterpolation* > it2(Global::d_manifold); it2; ++it2) {
    it2() -> getExtents(&min, &max);
    sprintf(&buf[i], "Extents(Manifold: %s):\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n-e%u:  %lf\t+e%u: %lf\n\n", it2() -> dataName(), Global::d_dim1, min.x, Global::d_dim1, max.x, Global::d_dim2, min.y, Global::d_dim2, max.y, Global::d_dim3, min.z, Global::d_dim3, max.z);
    i += strlen(&buf[i]);
  }

  XtSetArg(args[0], XmNeditable, False);
  XtSetArg(args[1], XmNeditMode, XmMULTI_LINE_EDIT);
  XtSetArg(args[2], XmNrows, 12);
  XtSetArg(args[3], XmNcolumns, 40);
  XtSetArg(args[4], XmNvalue, buf);
  XtSetArg(args[5], XmNcursorPositionVisible, False);
  XtSetArg(args[6], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[7], XmNtopOffset, 15);
  XtSetArg(args[8], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[9], XmNleftOffset, 15);
  XtSetArg(args[10], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(args[11], XmNrightOffset, 15);
  XtSetArg(args[12], XmNbottomAttachment, XmATTACH_WIDGET);
  XtSetArg(args[13], XmNbottomWidget, sep1);
  XtSetArg(args[14], XmNbottomOffset, 15);
  
  text1 = XmCreateScrolledText(topwin, "text", args, 15);

  XtManageChild(text1);

  XtManageChild(topwin);
  XtManageChild(topshell);
}

Widget create_ortho_dialog(Widget w)
{
  char buf[256];
  static OrthoCbLocal data;
  Widget topshell, topwin, form1, form2, form3, text1, label1, button1, sep1,
  button2;

  topshell = XtVaCreatePopupShell("Orthogonalize...",
				  xmDialogShellWidgetClass, XtParent(w),
				  NULL);
  topwin = XtVaCreateWidget("form", xmFormWidgetClass, topshell, NULL);

  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("Orthogonalize", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 2,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button1, XmNactivateCallback, orthobox_ok_cb, &data);
  button2 = XtVaCreateManagedWidget("Cancel", xmPushButtonGadgetClass, form1,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 4,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 4,
				    NULL);
  XtAddCallback(button2, XmNactivateCallback, destroy3_cb, 0);
  XtManageChild(form1);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, topwin,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form1,
				 NULL);
  
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("Primary Eigenvector:",
				   xmLabelGadgetClass, form1,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form1,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text3_p[0],
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, loadEigenVector_cb, 0);
  XtManageChild(form1);
  Global::d_text4[0] = text1;

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form1,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("Secondary Eigenvector:",
				   xmLabelGadgetClass, form2,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form2,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form2,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text3_p[1],
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, loadEigenVector_cb, XtPointer(1));
  XtManageChild(form2);
  Global::d_text4[1] = text1;

  form3 = XtVaCreateWidget("form", xmFormWidgetClass, topwin,
			   XmNfractionBase, 3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form2,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   XmNbottomAttachment, XmATTACH_WIDGET,
			   XmNbottomWidget, sep1,
			   XmNbottomOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("Output Eigenvector:",
				   xmLabelGadgetClass, form3,
				   XmNalignment, XmALIGNMENT_BEGINNING,
				   XmNtopAttachment, XmATTACH_POSITION,
				   XmNtopPosition, 0,
				   XmNleftAttachment, XmATTACH_POSITION,
				   XmNleftPosition, 0,
				   XmNrightAttachment, XmATTACH_POSITION,
				   XmNrightPosition, 1,
				   XmNbottomAttachment, XmATTACH_POSITION,
				   XmNbottomPosition, 3,
				   NULL);
  button1 = XtVaCreateManagedWidget("Select...", xmPushButtonGadgetClass,
				    form3,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 0,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 2,
				    XmNleftOffset, 10,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 3,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 3,
				    NULL);
  text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
				  XmNeditable, False,
				  XmNcursorPositionVisible, False,
				  XmNvalue, Global::d_text3_p[2],
				  XmNtopAttachment, XmATTACH_POSITION,
				  XmNtopPosition, 0,
				  XmNleftAttachment, XmATTACH_POSITION,
				  XmNleftPosition, 1,
				  XmNleftOffset, 10,
				  XmNrightAttachment, XmATTACH_POSITION,
				  XmNrightPosition, 2,
				  XmNbottomAttachment, XmATTACH_POSITION,
				  XmNbottomPosition, 3,
				  NULL);
  XtAddCallback(button1, XmNactivateCallback, saveEigenVector_cb, 0);
  XtManageChild(form3);
  Global::d_text4[2] = text1;

  XtManageChild(topwin);
  XtManageChild(topshell);

  return topshell;
}

int main(int argc, char **argv)
{
  char buf[256];
  int i, depth, num_cmaps;
  ExposeCbLocal data;
  XtAppContext app;
  XtActionsRec actions;
  static String translations = "<Btn1Motion>: change_view(b1m)\n<Btn1Down>: change_view(b1d)\n<Btn3Motion>: change_view(b3m)\n<Btn3Down>: change_view(b3d)\n<Btn2Motion>: change_view(b2m)\n<Btn2Down>: change_view(b2d)";
  Widget topshell, menubar, fmenu, smenu, omenu, hmenu, form1, frame2, label1, sep1;
  Visual *visual;
  XVisualInfo vinfo, *visuals;
  XStandardColormap *std_cmaps, *cmap_info;
  XEvent event;
  XmString str1, str2, str3, str4;
  XSetWindowAttributes attributes;
  Atom property;
  PEXExtensionInfo *pexinfo;
  PEXColorApproxEntry capx_info;
  PEXRendererAttributes attrs;
  PEXListOfVertex cube[4];

  topshell = XtAppInitialize(&app, "xmanifold", NULL, 0, &argc, argv, NULL,
			     (ArgList)NULL, (Cardinal)0);
  Global::d_topshell = topshell;
  Global::d_display = XtDisplay(topshell);
  visual = DefaultVisual(Global::d_display,
			 DefaultScreen(Global::d_display));
  depth = DefaultDepth(Global::d_display,
		       DefaultScreen(Global::d_display));

  if(PEXInitialize(Global::d_display, &pexinfo, 256, buf) != 0) {
    cout << "Cannot Start PEX" << endl;
    Global::d_pexavail = False;
  }

  if(Global::d_pexavail == True) {
    vinfo.visualid = XVisualIDFromVisual(visual);
    visuals = XGetVisualInfo(Global::d_display, VisualIDMask, &vinfo, &i);

    if(i == 0) {
      cout << "xmanifold: Fatal Error. Could not find visual." << endl;
      exit(1);
    }

    vinfo = visuals[0];

    switch(vinfo.c_class) {
    case TrueColor:
    case StaticColor:
      property = XA_RGB_BEST_MAP;
      break;
    case PseudoColor:
    case DirectColor:
      property = XA_RGB_DEFAULT_MAP;
      break;
    case StaticGray:
    case GrayScale:
      property = XA_RGB_GRAY_MAP;
    };

    if(XmuLookupStandardColormap(Global::d_display, vinfo.screen,
				 vinfo.visualid, depth, property, False, True)
       != 0)
      if(XGetRGBColormaps(Global::d_display, RootWindow(Global::d_display,
							vinfo.screen),
							&std_cmaps, &num_cmaps,
							property) != 0) {
	for(i = 0; i < num_cmaps; ++i)
	  if(XVisualIDFromVisual(visual) == std_cmaps[i].visualid) {
	    cmap_info = &std_cmaps[i];
	    break;
	  }
	if(i == num_cmaps) {
	  cout << "Cannot Start PEX. Colormap Problem" << endl;
	  Global::d_pexavail = False;
	}
      }
      else {
	cout << "Cannot Start PEX. Colormap Problem" << endl;
	Global::d_pexavail = False;
      }
    else {
      cout << "Cannot Start PEX. Colormap Problem" << endl;
      Global::d_pexavail = False;
    }

    if(Global::d_pexavail == True) {
      actions.string = "change_view";
      actions.proc = (XtActionProc)change_view;
      XtAppAddActions(app, &actions, 1);
    }
  }

  form1 = XtVaCreateWidget("mainform", xmFormWidgetClass, topshell,
			   NULL);

  str1 = XmStringCreateSimple("File");
  str2 = XmStringCreateSimple("View");
  str3 = XmStringCreateSimple("Options");
  str4 = XmStringCreateSimple("Help");
  menubar = XmVaCreateSimpleMenuBar(form1, "menubar",
				    XmVaCASCADEBUTTON, str1, 'F',
				    XmVaCASCADEBUTTON, str2, 'V',
				    XmVaCASCADEBUTTON, str3, 'O',
				    XmVaCASCADEBUTTON, str4, 'H',
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    NULL);
  Global::d_menubar = menubar;
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4);

  str1 = XmStringCreateSimple("Load...");
  str2 = XmStringCreateSimple("Save...");
  str3 = XmStringCreateSimple("Print...");
  str4 = XmStringCreateSimple("Quit");
  fmenu = XmVaCreateSimplePulldownMenu(menubar, "fmenu",
				       0, fmenu_cb,
				       XmVaPUSHBUTTON, str1, 'L', NULL, NULL,
				       XmVaPUSHBUTTON, str2, 'S', NULL, NULL,
				       XmVaPUSHBUTTON, str3, 'P', NULL, NULL,
				       XmVaPUSHBUTTON, str4, 'Q', NULL, NULL,
				       NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4); 

  str1 = XmStringCreateSimple("Show/Hide...");
  str2 = XmStringCreateSimple("Extents...");
  str4 = XmStringCreateSimple("Preferences...");
  smenu = XmVaCreateSimplePulldownMenu(menubar, "smenu",
				       1, smenu_cb,
				       XmVaPUSHBUTTON, str1, 'S', NULL, NULL,
				       XmVaPUSHBUTTON, str4, 'P', NULL, NULL,
				       XmVaPUSHBUTTON, str2, 'E', NULL, NULL,
				       NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str4);

  str1 = XmStringCreateSimple("Project...");
  str2 = XmStringCreateSimple("Fit Manifold...");
  str3 = XmStringCreateSimple("Sample Manifold...");
  str4 = XmStringCreateSimple("Orthogonalize...");
  omenu = XmVaCreateSimplePulldownMenu(menubar, "omenu",
				       2, omenu_cb,
				       XmVaPUSHBUTTON, str1, 'P', NULL, NULL,
				       XmVaPUSHBUTTON, str2, 'F', NULL, NULL,
				       XmVaPUSHBUTTON, str3, 'S', NULL, NULL,
				       XmVaPUSHBUTTON, str4, 'O', NULL, NULL,
				       NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4);

  str1 = XmStringCreateSimple("About...");
  hmenu = XmVaCreateSimplePulldownMenu(menubar, "hmenu",
				       3, hmenu_cb,
				       XmVaPUSHBUTTON, str1, 'A', NULL, NULL,
				       NULL);
  XmStringFree(str1);

  XtManageChild(menubar);

  label1 = XtVaCreateManagedWidget("SLAM - Sameer A. Nene, Shree K. Nayar, Hiroshi Murase",
				   xmLabelGadgetClass, form1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNbottomOffset, 5,
				   NULL);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, label1,
				 XmNbottomOffset, 5,
				 NULL);

  frame2 = XtVaCreateWidget("frame", xmFrameWidgetClass, form1,
			    XmNshadowType, XmSHADOW_IN,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNleftOffset, 10,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, menubar,
			    XmNtopOffset, 10,
			    XmNbottomAttachment, XmATTACH_WIDGET,
			    XmNbottomWidget, sep1,
			    XmNbottomOffset, 10,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNrightOffset, 10,
			    NULL);
  Global::d_darea = XtVaCreateManagedWidget("draw",
					    xmDrawingAreaWidgetClass,
					    frame2,
					    XmNwidth, 640,
					    XmNheight, 640,
					    XmNtranslations, XtParseTranslationTable(translations),
					    XmNuserData, &data,
					    NULL);
  
  XtManageChild(frame2);

  XtManageChild(form1);

  XtRealizeWidget(topshell);
  
  if(Global::d_pexavail == True) {
    attributes.background_pixel = BlackPixelOfScreen(XtScreen(topshell));
    attributes.border_pixel = BlackPixelOfScreen(XtScreen(topshell));
    attributes.colormap = cmap_info -> colormap;
    Global::d_drawin = XCreateWindow(Global::d_display,
				     XtWindow(Global::d_darea),
				     0, 0, 640, 640,
				     0, depth, InputOutput,
				     vinfo.visual,
				     CWColormap | CWBackPixel | CWBorderPixel,
				     &attributes);
    XSelectInput(Global::d_display, Global::d_drawin, ExposureMask);
    XMapWindow(Global::d_display, Global::d_drawin);
  }

  Global::d_sfreq[0] = Global::d_sfreq[1] = Global::d_sfreq[2] = 20;

  if(Global::d_pexavail != 0) {
    XtAddCallback(Global::d_darea, XmNresizeCallback, resize_cb, NULL);
    switch(vinfo.c_class) {
    case PseudoColor:
    case StaticColor:
    case DirectColor:
    case TrueColor:
      capx_info.type = PEXColorSpace;
      capx_info.model = PEXColorApproxRGB;
      capx_info.dither = PEXOff;
      capx_info.base_pixel = cmap_info -> base_pixel;
      capx_info.max1 = cmap_info -> red_max;
      capx_info.max2 = cmap_info -> green_max;
      capx_info.max3 = cmap_info -> blue_max;
      capx_info.weight1 = capx_info.weight2 = capx_info.weight3 = 0;
      capx_info.mult1 = cmap_info -> red_mult;
      capx_info.mult2 = cmap_info -> green_mult;
      capx_info.mult3 = cmap_info -> blue_mult;
      break;
    case GrayScale:
    case StaticGray:
      capx_info.type = PEXColorRange;
      capx_info.model = PEXColorApproxRGB;
      capx_info.dither = PEXOff;
      capx_info.base_pixel = cmap_info -> base_pixel;
      capx_info.max1 = cmap_info -> red_max;
      capx_info.max2 = capx_info.max3 = 0;
      capx_info.weight1 = 0.299;
      capx_info.weight2 = 0.587;
      capx_info.weight3 = 0.114;
      capx_info.mult1 = cmap_info -> red_mult;
      capx_info.mult2 = 0;
      capx_info.mult3 = 0;
    }

    attrs.color_approx_table = PEXCreateLookupTable(Global::d_display,
						    XtWindow(Global::d_darea),
						    PEXLUTColorApprox);
    PEXSetTableEntries(Global::d_display, attrs.color_approx_table, 0,
		       1, PEXLUTColorApprox, &capx_info);

    attrs.view_table = PEXCreateLookupTable(Global::d_display,
					    XtWindow(Global::d_darea),
					    PEXLUTView);
    data.d_view_table = attrs.view_table;
    data.d_phi = 45. * M_PI / 180.;
    data.d_theta = 45. * M_PI / 180.;
    data.d_alpha = 0.;
    data.d_tx = data.d_ty = data.d_tz = 0.;
    compute_view(data.d_theta, data.d_phi, data.d_alpha, data.d_tx, data.d_ty,
		 data.d_tz, data.d_view.orientation);

    data.d_prp.x = data.d_prp.y = 0.;
    data.d_prp.z = 10.;
    data.d_vwin[0].x = data.d_vwin[0].y = -2.;
    data.d_vwin[1].x = data.d_vwin[1].y = 2.;
    data.d_vport.min.x = data.d_vport.min.y = data.d_vport.min.z = 0.;
    data.d_vport.max.x = data.d_vport.max.y = data.d_vport.max.z = 1.;

    data.d_view.clip_flags = PEXClippingAll;
    data.d_view.clip_limits = data.d_vport;

    /*
    clip.min.x = clip.min.y = clip.min.z = -1.;
    clip.max.x = clip.max.y = clip.max.z = 2.;
    */

    PEXViewMappingMatrix(data.d_vwin, &data.d_vport, True, &data.d_prp, 0.,
			 -2, 2., data.d_view.mapping);

    data.d_view.clip_flags = 0;
    PEXSetTableEntries(Global::d_display, attrs.view_table, 1, 1,
		       PEXLUTView, (PEXPointer)&data.d_view);
    
    data.renderer = PEXCreateRenderer(Global::d_display,
				      XtWindow(Global::d_darea),
				      PEXRAColorApproxTable | PEXRAViewTable,
				      &attrs);

    data.axisSid = PEXCreateStructure(Global::d_display);
    data.labelsSid = PEXCreateStructure(Global::d_display);

    data.d_sx = data.d_sy = data.d_sz = 1.;
    data.d_tx2 = data.d_ty2 = data.d_tz2 = 0.;

    createAxis(data.axisSid);

    data.d_viewLabels = True;
    createLabels(data.labelsSid);

    data.d_min.x = data.d_min.y = data.d_min.z = -1.;
    data.d_max.x = data.d_max.y = data.d_max.z = 1.;
  }

  strcpy(Global::d_text1 = new char[1], "");
  strcpy(Global::d_text2 = new char[1], "");
  strcpy(Global::d_text3_p[0] = new char[1], "");

  Global::d_loadbox = create_load_dialog(topshell);
  Global::d_savebox = create_save_dialog(topshell);
  Global::d_loadVectorSetBox = create_loadVectorSet_dialog(topshell);
  Global::d_loadVectorBox = create_loadVector_dialog(topshell);
  Global::d_loadEigenVectorBox = create_loadEigenVector_dialog(topshell);
  Global::d_saveEigenVectorBox = create_saveEigenVector_dialog(topshell);
  Global::d_printBox = create_print_dialog(topshell);

  if(Global::d_pexavail == 0)
    XtAppMainLoop(app);
  else {
    while(1) {
      XtAppNextEvent(app, &event);
      XtDispatchEvent(&event);
      if(event.xexpose.window == Global::d_drawin && event.xexpose.count == 0)
	redraw();
    }
  }

  return 0;
}
