// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// ximgtool.C
//
// Author:               Sameer Nene
// Date:                 09/12/94
// Version:              1.0.0
// Modification History:
//
// ToDo:
//   Fix core dump which occurs when attempting to view a vector smaller in
//   dimension than disk vector.
//
// Notes:
//   X module for visualization/manipulation of images/vector/eigenvectors
//   
// ----------------------------------------------------------------------------

#define NO_XMSTRINGS

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/MessageB.h>
#include <Xm/MenuShell.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/Xm.h>
#include "fileiter.h"
#include "image.h"
#include "imageutil.h"
#include "vector.h"
#include "ximgtool.h"

extern void it_next_image();
extern void it_next_vector();
extern void it_next_eigenvector();
extern void pulldown_cb(Widget w, XtPointer, XtPointer);
extern void toggled_cb(Widget w, XtPointer p1, XtPointer);
extern void tmenu_cb(Widget, XtPointer, XtPointer);
extern void filesel_cb(Widget w, XtPointer, XtPointer p1);
extern void fileselnomatch_cb(Widget, XtPointer, XtPointer);
extern void viewv_cb(Widget, XtPointer p1, XtPointer);
extern void smenu_cb(Widget w, XtPointer p1, XtPointer);
extern void fmenu_cb(Widget w, XtPointer p1, XtPointer);
extern void omenu_cb(Widget, XtPointer p1, XtPointer);
extern void hmenu_cb(Widget w, XtPointer, XtPointer);
extern void rewind_cb(Widget w, XtPointer, XtPointer);
extern void fastfwd_cb(Widget w, XtPointer, XtPointer);
extern void stepback_cb(Widget w, XtPointer, XtPointer);
extern void stepfront_cb(Widget w, XtPointer, XtPointer);
extern void filesel_load_cb(Widget w, XtPointer, XtPointer p1);
extern void filesel_save_cb(Widget w, XtPointer, XtPointer p1);
extern void selboxok_cb(Widget w, XtPointer p1, XtPointer);
extern void animateStepFront_cb(Widget w, XtPointer p1, XtPointer);
extern void animateStepBack_cb(Widget w, XtPointer p1, XtPointer);
extern void typeoption_cb(Widget w, XtPointer p1, XtPointer);
extern void prefbox_cb(Widget w, XtPointer p1, XtPointer);
extern void aspectRatioToggle_cb(Widget, XtPointer p1, XtPointer);
extern void adjust_ximage(const Image &img);
extern void paint(Widget, XtPointer, XtPointer);

Widget Global::d_darea, Global::d_label1, Global::d_label2, Global::d_label3,
Global::d_buttons, Global::d_text1, Global::d_text2, Global::d_text3,
Global::d_text4, Global::d_loadrbox, Global::d_saverbox,
Global::d_optionType[2], Global::d_optionMenu[2], Global::d_sizeArea,
Global::d_loadbox, Global::d_savebox, Global::d_segButton,
Global::d_sizeButton, Global::d_normButton, Global::d_prefButton,
Global::d_selectBox, Global::d_selectList, Global::d_text5, Global::d_text6,
Global::d_prefBox, Global::d_text7, Global::d_topshell;
XtCallbackProc Global::d_defFileSearchProc;
XtAppContext Global::d_app;
int Global::d_ldsel = 0, Global::d_seg = 0, Global::d_nsize = 0,
Global::d_nbright = 0, Global::d_vapos = 0, Global::d_viewv = ~0,
Global::d_vxsize = 128, Global::d_vysize = 128, Global::d_ldsvflg,
Global::d_svsel = 0, Global::d_ldtstat = 0, Global::d_svtstat = 0,
Global::d_ldftype = 0, Global::d_svftype = 0, Global::d_nxsize = 128,
Global::d_nysize = 128, Global::d_thresh = 20,
Global::d_aspect = ImageUtil::NOPRESERVE_ASPECT;
char *Global::d_name = 0, *Global::d_dir = 0;
GC Global::d_gc;
Display *Global::d_display;
XVisualInfo Global::d_vinfo;
XImage *Global::d_ximage;
Window Global::d_drawin;
Image *Global::d_image;
FileList *Global::d_fl = 0;
FileListIter *Global::d_flit = 0;
Vector *Global::d_vec_p = 0;
VectAry *Global::d_va = 0;
unsigned long Global::d_ctrans[256];
unsigned char Global::d_surf[] = { 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2, 
 12,  12,  12,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  24,  36,  45,  53,  59, 
 64,  69,  69,  69,  69,  69,  53,  53,  36,   2,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   2,  36,  59,  69,  69,  69,  77,  80, 
 83,  86,  89,  89,  92,  92,  92,  92,  89,  89,  86,  77,  24,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  24,  53,  80,  94,  99,  86,  83,  92,  94, 
 97,  99, 102, 105, 105, 107, 107, 109, 107, 107, 105, 105, 102,  99,  92, 
 45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   2,  24,  64,  86, 105, 115, 121, 102,  94, 102, 103, 
107, 111, 111, 115, 116, 118, 118, 120, 120, 121, 118, 120, 118, 116, 116, 
113, 109, 107,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  24,  69,  97,  99, 102, 103, 113, 118, 103, 107, 111, 
115, 118, 120, 123, 124, 126, 128, 128, 129, 130, 130, 130, 130, 129, 128, 
126, 126, 123, 120, 116, 111,  53,   2,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  12,  59,  69,  73,  80,  86,  92,  99, 105, 109, 113, 118, 
120, 123, 126, 128, 130, 132, 133, 135, 136, 137, 137, 137, 139, 137, 137, 
137, 137, 136, 133, 130, 128, 124, 121, 115,  53,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  36,  59,  69,  80,  86,  92,  99, 102, 109, 113, 118, 121, 
126, 128, 130, 133, 135, 137, 139, 140, 141, 141, 143, 143, 144, 144, 145, 
145, 144, 144, 141, 140, 139, 135, 133, 130, 126, 123, 120,  24,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  12,  45,  69,  77,  86,  92,  99, 103, 107, 113, 118, 121, 126, 
128, 132, 135, 137, 139, 141, 141, 144, 146, 146, 148, 149, 149, 150, 150, 
151, 150, 150, 149, 148, 146, 145, 143, 141, 139, 135, 133, 130, 128, 123, 
 53,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  24,  59,  69,  83,  92,  97, 103, 107, 111, 116, 121, 126, 130, 
132, 136, 137, 140, 143, 144, 146, 148, 150, 150, 152, 152, 153, 154, 154, 
155, 156, 155, 155, 154, 153, 151, 151, 149, 147, 146, 143, 141, 139, 137, 
133, 129, 126,  59,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   2,  45,  64,  77,  86,  94, 102, 105, 111, 115, 120, 124, 128, 132, 
135, 139, 140, 143, 145, 147, 149, 150, 152, 153, 155, 156, 156, 157, 158, 
159, 159, 160, 160, 159, 158, 157, 156, 155, 154, 152, 151, 150, 147, 146, 
143, 141, 139, 136, 133, 129,  69,   2,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  12,  53,  69,  80,  92,  99, 103, 109, 113, 118, 123, 126, 130, 133, 
139, 140, 143, 145, 147, 149, 151, 153, 155, 156, 157, 159, 159, 160, 161, 
161, 162, 163, 163, 163, 163, 161, 161, 160, 160, 159, 156, 156, 155, 154, 
152, 151, 149, 147, 145, 143, 139, 137, 133,  64,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  24,  59,  73,  86,  94,  99, 107, 111, 116, 120, 124, 128, 132, 136, 
139, 141, 145, 148, 149, 151, 153, 155, 156, 158, 160, 161, 161, 163, 164, 
165, 166, 166, 166, 166, 166, 165, 165, 164, 164, 163, 161, 161, 161, 160, 
158, 158, 156, 154, 153, 152, 149, 148, 145, 143, 139, 136,  89,   2,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  36,  64,  77,  89,  97, 103, 109, 113, 118, 121, 126, 130, 135, 137, 
141, 145, 147, 149, 152, 154, 156, 158, 159, 160, 161, 163, 164, 165, 166, 
167, 168, 168, 169, 169, 169, 168, 168, 168, 167, 167, 167, 166, 165, 164, 
164, 163, 161, 161, 160, 159, 158, 157, 154, 152, 151, 148, 147, 143, 140, 
 97,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  36,  69,  80,  89,  99, 105, 111, 118, 120, 124, 128, 132, 136, 140, 
143, 146, 149, 151, 153, 155, 157, 158, 160, 161, 163, 164, 166, 167, 168, 
168, 169, 170, 170, 171, 170, 170, 170, 170, 170, 170, 170, 169, 169, 168, 
168, 168, 167, 166, 165, 164, 163, 161, 161, 160, 159, 157, 155, 153, 152, 
149, 146, 143,  92,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,  45,  69,  86,  94, 102, 107, 113, 118, 121, 126, 129, 133, 139, 141, 
144, 147, 150, 152, 154, 157, 158, 160, 161, 163, 164, 166, 167, 168, 169, 
170, 170, 172, 173, 173, 173, 173, 173, 173, 173, 172, 173, 172, 173, 170, 
170, 170, 170, 170, 169, 169, 168, 167, 166, 165, 165, 164, 161, 161, 159, 
158, 156, 154, 152, 152, 148, 126,  12,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  45,  73,  86,  94, 102, 111, 115, 120, 124, 128, 130, 135, 139, 143, 
146, 149, 151, 154, 155, 158, 160, 161, 163, 165, 166, 167, 168, 169, 170, 
170, 172, 173, 174, 174, 174, 174, 174, 174, 175, 174, 174, 174, 174, 174, 
174, 174, 174, 174, 173, 173, 172, 172, 170, 170, 170, 169, 168, 167, 166, 
165, 164, 162, 160, 160, 158, 157, 155, 153, 129,  12,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  24,  73,  86,  97, 103, 111, 116, 121, 126, 129, 133, 136, 140, 144, 
147, 149, 152, 155, 157, 159, 161, 163, 164, 166, 167, 169, 169, 170, 172, 
173, 173, 174, 174, 176, 176, 177, 176, 177, 177, 177, 177, 176, 177, 176, 
177, 177, 177, 176, 176, 176, 175, 174, 174, 174, 174, 174, 173, 172, 171, 
170, 169, 169, 168, 167, 166, 166, 164, 163, 163, 160, 158, 148,  77,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  24,  73,  86,  97, 105, 111, 118, 123, 128, 130, 135, 137, 141, 145, 
147, 151, 153, 155, 158, 160, 161, 164, 165, 167, 168, 169, 170, 170, 173, 
174, 174, 176, 176, 177, 177, 177, 179, 179, 179, 179, 179, 179, 179, 178, 
179, 179, 179, 178, 179, 177, 178, 177, 177, 177, 177, 177, 176, 176, 174, 
174, 174, 174, 173, 173, 172, 172, 170, 170, 169, 169, 167, 166, 164, 162, 
145, 103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  12,  73,  86,  97, 105, 113, 118, 124, 128, 132, 135, 139, 141, 145, 
148, 151, 154, 156, 159, 160, 163, 164, 166, 167, 168, 170, 170, 173, 174, 
174, 176, 177, 177, 177, 179, 180, 180, 180, 180, 180, 180, 180, 180, 180, 
180, 180, 181, 181, 180, 181, 180, 180, 180, 180, 180, 179, 179, 179, 179, 
178, 177, 177, 177, 176, 177, 177, 176, 176, 175, 176, 174, 174, 173, 170, 
170, 168, 167, 165,  59,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   2,  73,  86,  97, 107, 113, 120, 124, 130, 133, 136, 139, 143, 146, 
149, 152, 154, 157, 159, 161, 163, 165, 167, 168, 170, 170, 173, 174, 174, 
176, 176, 177, 178, 179, 180, 181, 181, 181, 181, 182, 181, 182, 182, 182, 
182, 182, 182, 183, 182, 183, 183, 183, 182, 183, 183, 182, 182, 182, 182, 
182, 181, 181, 180, 181, 180, 181, 180, 180, 181, 180, 181, 179, 179, 178, 
178, 177, 176, 174, 173, 170, 169, 118,  12,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  64,  86,  99, 107, 113, 120, 126, 130, 133, 137, 141, 143, 146, 
150, 152, 155, 157, 160, 161, 164, 165, 168, 169, 170, 171, 173, 174, 174, 
176, 177, 178, 179, 180, 181, 182, 182, 182, 183, 182, 183, 183, 183, 183, 
183, 184, 184, 184, 184, 184, 184, 185, 185, 185, 185, 185, 185, 185, 184, 
185, 184, 183, 183, 183, 183, 183, 184, 184, 184, 185, 185, 185, 184, 184, 
184, 184, 183, 182, 181, 180, 179, 177, 176, 174, 163,  24,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  45,  86,  97, 105, 113, 120, 126, 130, 135, 139, 141, 144, 147, 
150, 153, 155, 158, 160, 162, 164, 166, 168, 169, 170, 173, 174, 174, 175, 
177, 177, 179, 180, 181, 181, 182, 183, 183, 183, 184, 185, 185, 185, 185, 
185, 185, 185, 185, 186, 186, 186, 186, 186, 186, 187, 186, 187, 187, 186, 
186, 186, 186, 186, 186, 186, 186, 187, 187, 188, 188, 188, 188, 188, 188, 
188, 188, 188, 188, 187, 187, 186, 185, 184, 183, 182, 180, 177, 168,  59, 
 12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  24,  83,  97, 107, 115, 120, 126, 130, 135, 139, 143, 145, 147, 
151, 154, 156, 159, 161, 162, 164, 167, 168, 169, 171, 173, 174, 175, 177, 
177, 178, 179, 180, 181, 182, 183, 184, 184, 184, 185, 185, 185, 185, 186, 
186, 186, 187, 187, 187, 187, 188, 188, 188, 188, 188, 188, 188, 188, 188, 
188, 188, 188, 188, 188, 188, 188, 188, 189, 190, 191, 191, 191, 192, 192, 
192, 193, 193, 192, 191, 191, 191, 191, 190, 189, 188, 188, 187, 185, 183, 
182, 180,  99,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  77,  94, 105, 113, 120, 126, 130, 136, 139, 143, 145, 148, 
150, 154, 156, 159, 161, 163, 165, 167, 169, 170, 170, 173, 174, 176, 177, 
177, 179, 180, 181, 182, 182, 183, 185, 185, 185, 186, 186, 186, 186, 187, 
187, 187, 188, 188, 188, 188, 188, 188, 188, 188, 188, 190, 190, 189, 189, 
190, 190, 190, 190, 191, 190, 190, 191, 191, 192, 193, 193, 193, 193, 195, 
195, 195, 195, 195, 195, 195, 195, 197, 195, 195, 195, 195, 193, 192, 192, 
191, 190, 188, 187, 185, 128,  53,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  45,  94, 105, 113, 120, 126, 130, 136, 139, 143, 146, 149, 
151, 154, 157, 159, 161, 163, 165, 167, 169, 170, 172, 173, 174, 176, 177, 
177, 180, 180, 181, 182, 183, 183, 185, 185, 186, 187, 186, 187, 187, 188, 
188, 188, 188, 188, 188, 190, 189, 190, 190, 190, 191, 191, 191, 191, 191, 
191, 192, 192, 192, 192, 192, 192, 192, 193, 193, 194, 194, 195, 197, 196, 
197, 197, 198, 198, 198, 198, 198, 200, 199, 200, 200, 199, 198, 198, 197, 
197, 197, 195, 194, 193, 192, 189, 188, 186,  64,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  24,  92, 102, 111, 120, 126, 130, 136, 140, 143, 147, 149, 
151, 154, 157, 160, 161, 164, 165, 168, 169, 170, 173, 174, 174, 176, 177, 
179, 180, 181, 182, 182, 183, 184, 185, 186, 187, 187, 187, 188, 188, 188, 
188, 188, 189, 190, 190, 191, 191, 191, 191, 192, 192, 192, 193, 192, 193, 
193, 193, 193, 193, 193, 193, 193, 193, 193, 195, 195, 196, 197, 197, 198, 
199, 200, 200, 201, 202, 202, 202, 203, 203, 203, 203, 203, 202, 203, 202, 
202, 202, 201, 200, 200, 198, 198, 197, 195, 193, 192, 191, 105,  24,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  83, 102, 111, 118, 126, 130, 136, 140, 143, 146, 149, 
152, 154, 157, 159, 161, 164, 166, 168, 169, 170, 173, 174, 176, 176, 177, 
179, 180, 181, 182, 183, 183, 184, 185, 186, 187, 187, 188, 188, 188, 189, 
188, 190, 191, 191, 191, 191, 191, 192, 193, 193, 193, 193, 193, 193, 193, 
193, 194, 195, 195, 194, 195, 195, 195, 195, 196, 197, 197, 198, 199, 200, 
201, 202, 202, 203, 204, 204, 205, 205, 205, 206, 206, 206, 206, 206, 207, 
207, 206, 206, 206, 205, 205, 205, 204, 203, 201, 200, 199, 198, 197, 195, 
155,  86,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  45,  99, 109, 118, 125, 130, 136, 140, 143, 147, 150, 
152, 154, 157, 159, 161, 164, 166, 167, 169, 170, 173, 174, 175, 176, 177, 
179, 180, 181, 182, 183, 184, 184, 185, 187, 187, 187, 188, 188, 188, 190, 
190, 191, 191, 191, 192, 192, 193, 193, 193, 193, 193, 193, 194, 195, 195, 
195, 195, 195, 195, 197, 195, 196, 196, 197, 197, 198, 198, 199, 201, 201, 
202, 203, 203, 204, 205, 206, 206, 207, 208, 208, 208, 209, 209, 210, 209, 
210, 210, 209, 210, 209, 209, 209, 209, 209, 207, 207, 206, 206, 204, 203, 
202, 200, 198, 197, 139,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  12,  97, 109, 116, 123, 130, 135, 140, 143, 147, 150, 
153, 155, 157, 160, 161, 165, 166, 168, 170, 170, 172, 174, 175, 176, 177, 
180, 180, 181, 182, 183, 184, 185, 186, 187, 187, 188, 188, 189, 188, 190, 
191, 191, 191, 192, 193, 193, 193, 193, 195, 194, 195, 195, 195, 195, 196, 
197, 197, 197, 197, 197, 197, 197, 197, 197, 197, 198, 200, 200, 202, 202, 
203, 204, 205, 206, 206, 207, 208, 209, 209, 210, 210, 210, 211, 212, 212, 
212, 213, 213, 213, 213, 213, 213, 213, 213, 213, 212, 211, 211, 211, 210, 
209, 208, 207, 206, 205, 204, 202, 190,  89,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  92, 105, 115, 123, 130, 135, 139, 143, 147, 150, 
152, 155, 157, 159, 161, 165, 166, 168, 169, 170, 173, 174, 175, 177, 177, 
179, 180, 181, 182, 183, 184, 185, 186, 187, 187, 188, 188, 190, 190, 191, 
191, 192, 192, 192, 193, 193, 193, 195, 195, 195, 195, 195, 197, 197, 197, 
197, 197, 198, 197, 198, 198, 199, 199, 199, 200, 200, 200, 202, 203, 204, 
204, 205, 206, 207, 207, 209, 209, 210, 211, 212, 212, 212, 213, 213, 214, 
214, 214, 215, 215, 216, 216, 216, 216, 216, 216, 216, 216, 216, 215, 215, 
214, 214, 213, 212, 212, 210, 209, 208, 207, 206, 204, 143,  59,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  45, 103, 115, 123, 130, 135, 139, 143, 146, 150, 
153, 155, 158, 160, 161, 165, 166, 168, 169, 170, 173, 174, 174, 177, 177, 
179, 180, 182, 183, 184, 184, 185, 186, 187, 188, 188, 189, 190, 190, 191, 
191, 192, 192, 193, 193, 194, 194, 195, 195, 195, 196, 197, 197, 197, 197, 
197, 198, 198, 199, 199, 199, 200, 200, 200, 201, 201, 202, 202, 203, 205, 
206, 206, 207, 207, 209, 209, 210, 211, 212, 213, 213, 214, 214, 215, 215, 
216, 216, 217, 217, 218, 217, 217, 219, 219, 219, 219, 219, 219, 219, 217, 
219, 217, 217, 217, 217, 216, 215, 214, 214, 214, 212, 210, 208, 208, 195, 
103,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   2,  99, 113, 121, 128, 133, 139, 143, 147, 150, 
152, 155, 158, 160, 161, 164, 166, 167, 170, 170, 173, 174, 176, 177, 178, 
180, 180, 182, 183, 183, 185, 186, 186, 187, 188, 188, 190, 189, 191, 191, 
192, 193, 193, 193, 193, 194, 195, 195, 195, 196, 197, 197, 197, 198, 198, 
198, 199, 200, 200, 200, 200, 201, 201, 201, 202, 202, 202, 203, 204, 205, 
206, 207, 208, 209, 209, 210, 211, 212, 213, 214, 214, 215, 216, 216, 217, 
217, 219, 219, 219, 220, 220, 221, 221, 221, 221, 222, 222, 222, 222, 221, 
222, 222, 221, 221, 221, 221, 220, 220, 219, 219, 217, 217, 216, 215, 213, 
212, 211, 208, 187, 103,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  73, 111, 120, 128, 133, 137, 144, 146, 150, 
153, 155, 158, 159, 161, 164, 166, 168, 169, 170, 173, 174, 176, 177, 179, 
179, 180, 182, 183, 183, 185, 185, 186, 187, 188, 188, 190, 190, 191, 191, 
192, 192, 193, 193, 193, 195, 195, 195, 197, 197, 197, 197, 198, 198, 199, 
200, 200, 200, 201, 201, 201, 202, 202, 202, 203, 203, 204, 204, 204, 205, 
207, 208, 209, 209, 210, 211, 212, 213, 214, 214, 215, 216, 216, 217, 219, 
219, 219, 220, 221, 221, 221, 222, 222, 223, 223, 224, 224, 225, 224, 225, 
225, 225, 225, 225, 224, 224, 225, 224, 223, 224, 223, 222, 222, 221, 220, 
220, 217, 217, 215, 214, 212, 210, 198, 113,  12,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  12, 107, 118, 126, 133, 137, 143, 146, 150, 
153, 155, 157, 159, 161, 164, 166, 167, 170, 170, 173, 174, 176, 177, 178, 
179, 180, 182, 183, 183, 185, 186, 186, 187, 188, 188, 188, 190, 191, 191, 
192, 193, 193, 193, 195, 195, 195, 195, 197, 197, 197, 198, 198, 199, 200, 
200, 200, 201, 202, 202, 202, 202, 203, 203, 204, 204, 204, 205, 206, 206, 
208, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 217, 217, 218, 219, 
220, 221, 221, 222, 222, 223, 223, 224, 225, 225, 226, 226, 226, 226, 227, 
227, 227, 227, 227, 227, 227, 227, 228, 227, 228, 227, 226, 226, 225, 225, 
225, 224, 223, 222, 221, 220, 219, 217, 215, 213, 211, 146,  94,  24,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  92, 116, 125, 132, 139, 141, 146, 149, 
152, 155, 157, 160, 161, 164, 166, 167, 169, 170, 172, 174, 174, 176, 177, 
179, 180, 182, 183, 183, 184, 186, 186, 187, 188, 188, 188, 190, 191, 191, 
192, 193, 193, 194, 195, 195, 196, 197, 197, 197, 198, 198, 199, 200, 201, 
201, 201, 202, 202, 202, 203, 203, 204, 204, 204, 205, 205, 206, 206, 207, 
208, 209, 209, 211, 212, 212, 213, 214, 215, 216, 217, 217, 217, 220, 220, 
221, 221, 222, 223, 223, 224, 224, 226, 226, 227, 227, 227, 228, 228, 229, 
229, 229, 229, 229, 229, 230, 230, 230, 230, 230, 230, 230, 229, 229, 230, 
229, 228, 228, 227, 227, 225, 225, 224, 222, 221, 219, 217, 214, 213, 210, 
177,  83,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  36, 111, 123, 130, 136, 140, 145, 149, 
152, 155, 157, 159, 161, 163, 166, 167, 169, 170, 173, 174, 174, 176, 177, 
179, 180, 182, 183, 184, 185, 186, 186, 187, 188, 188, 189, 190, 191, 192, 
192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 198, 198, 199, 201, 200, 
202, 202, 202, 203, 203, 204, 204, 204, 205, 205, 206, 206, 206, 206, 207, 
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 217, 219, 220, 221, 220, 
222, 222, 223, 223, 225, 225, 226, 226, 227, 227, 228, 228, 229, 230, 230, 
230, 230, 231, 231, 231, 232, 232, 232, 232, 232, 233, 232, 233, 232, 232, 
232, 232, 232, 232, 231, 231, 229, 229, 228, 227, 226, 224, 223, 221, 219, 
217, 215, 212, 210, 207, 113,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0, 107, 121, 129, 135, 140, 145, 148, 
152, 155, 156, 159, 161, 163, 165, 167, 169, 170, 173, 174, 175, 177, 177, 
179, 181, 181, 183, 183, 185, 185, 187, 187, 188, 188, 188, 190, 191, 191, 
193, 193, 193, 194, 195, 195, 196, 197, 197, 198, 198, 200, 200, 200, 201, 
202, 202, 202, 203, 204, 204, 204, 205, 206, 206, 206, 206, 207, 207, 207, 
208, 209, 211, 211, 213, 213, 214, 216, 216, 217, 219, 219, 220, 221, 222, 
223, 223, 224, 225, 225, 226, 227, 228, 228, 229, 229, 230, 230, 230, 231, 
232, 232, 232, 232, 233, 233, 233, 234, 235, 235, 233, 235, 235, 235, 235, 
235, 235, 235, 235, 233, 234, 233, 233, 232, 232, 231, 230, 229, 227, 226, 
226, 222, 221, 219, 217, 215, 213, 209, 207, 144,  36,  12,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  59, 118, 128, 133, 140, 144, 148, 
151, 154, 156, 159, 161, 163, 165, 166, 169, 170, 172, 173, 174, 176, 177, 
179, 180, 182, 182, 183, 185, 185, 187, 187, 188, 188, 190, 190, 191, 192, 
192, 193, 193, 195, 195, 195, 197, 197, 197, 198, 198, 200, 201, 201, 201, 
202, 203, 204, 204, 204, 204, 205, 205, 206, 207, 207, 207, 207, 208, 208, 
209, 209, 211, 212, 213, 214, 215, 216, 217, 217, 219, 220, 220, 222, 222, 
223, 224, 225, 225, 227, 227, 228, 228, 229, 230, 230, 230, 231, 231, 232, 
233, 233, 233, 233, 234, 234, 235, 236, 236, 236, 237, 237, 237, 237, 238, 
238, 238, 238, 237, 237, 237, 237, 237, 236, 236, 235, 235, 233, 233, 232, 
231, 229, 228, 226, 225, 223, 220, 219, 217, 214, 212, 209, 207, 183, 102, 
 24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 113, 124, 133, 139, 143, 148, 
151, 153, 156, 159, 161, 163, 164, 166, 168, 170, 172, 173, 174, 176, 177, 
179, 180, 181, 182, 183, 185, 185, 186, 188, 188, 188, 190, 190, 191, 192, 
193, 193, 193, 195, 195, 195, 197, 197, 198, 198, 200, 200, 200, 202, 202, 
202, 203, 204, 204, 205, 205, 206, 206, 206, 207, 207, 208, 208, 208, 209, 
209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 221, 221, 222, 223, 
223, 225, 225, 226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 
233, 234, 235, 235, 236, 236, 237, 237, 237, 238, 238, 238, 238, 239, 239, 
239, 239, 240, 239, 239, 240, 240, 240, 240, 239, 238, 238, 238, 236, 236, 
235, 234, 233, 232, 231, 229, 228, 225, 224, 222, 220, 217, 216, 213, 212, 
209, 206, 202, 182,  89,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  73, 121, 132, 137, 143, 146, 
151, 154, 156, 159, 160, 161, 164, 166, 168, 169, 170, 173, 174, 175, 177, 
179, 180, 181, 182, 183, 185, 185, 187, 187, 188, 188, 190, 190, 191, 191, 
192, 193, 193, 193, 195, 197, 197, 197, 197, 198, 199, 200, 201, 202, 202, 
202, 203, 204, 204, 205, 206, 206, 207, 207, 207, 208, 209, 209, 209, 209, 
210, 210, 211, 212, 213, 214, 216, 217, 217, 217, 220, 220, 222, 223, 223, 
224, 225, 226, 227, 228, 228, 229, 229, 230, 231, 232, 232, 233, 233, 233, 
234, 235, 235, 236, 237, 237, 238, 238, 238, 239, 239, 239, 240, 240, 240, 
241, 241, 241, 241, 241, 242, 241, 242, 242, 242, 242, 241, 241, 240, 240, 
239, 238, 238, 237, 236, 234, 233, 232, 230, 229, 227, 225, 223, 222, 219, 
217, 215, 213, 210, 208, 205, 203, 200, 179,  99,  24,  24,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  12, 118, 128, 136, 141, 147, 
150, 153, 155, 158, 160, 163, 164, 166, 168, 169, 170, 172, 174, 175, 177, 
177, 180, 180, 182, 183, 184, 185, 186, 187, 188, 188, 188, 191, 191, 192, 
192, 193, 193, 193, 195, 195, 197, 197, 197, 198, 199, 200, 201, 202, 203, 
203, 204, 204, 204, 206, 206, 207, 207, 207, 208, 208, 209, 209, 210, 210, 
211, 211, 212, 212, 213, 214, 215, 216, 217, 219, 219, 220, 221, 222, 224, 
224, 225, 226, 227, 228, 229, 230, 230, 231, 232, 232, 233, 233, 234, 235, 
235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 240, 240, 241, 241, 241, 
242, 243, 243, 243, 243, 243, 243, 244, 243, 244, 243, 243, 244, 243, 243, 
243, 242, 241, 241, 240, 239, 238, 237, 236, 235, 233, 231, 230, 228, 227, 
224, 222, 220, 219, 216, 213, 212, 209, 207, 206, 202, 200, 197, 195,  97, 
 69,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  99, 126, 135, 140, 145, 
148, 152, 155, 158, 159, 161, 164, 165, 167, 169, 170, 172, 174, 174, 177, 
177, 179, 181, 182, 183, 184, 185, 186, 187, 188, 188, 189, 190, 191, 191, 
193, 193, 193, 193, 195, 195, 197, 197, 198, 198, 200, 200, 201, 202, 202, 
203, 204, 204, 204, 206, 206, 207, 208, 208, 208, 209, 209, 210, 210, 211, 
211, 211, 212, 212, 214, 214, 215, 217, 217, 219, 220, 221, 221, 222, 224, 
225, 226, 226, 227, 228, 229, 230, 231, 231, 232, 232, 233, 233, 235, 236, 
236, 237, 237, 238, 239, 238, 239, 239, 240, 240, 241, 242, 242, 242, 243, 
243, 244, 244, 244, 244, 244, 245, 245, 245, 245, 245, 245, 245, 245, 245, 
244, 245, 244, 243, 243, 242, 241, 241, 240, 239, 238, 236, 235, 233, 232, 
230, 229, 226, 225, 223, 220, 217, 217, 215, 213, 211, 209, 206, 204, 202, 
199, 197, 193, 182, 113,  83,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24, 123, 133, 139, 144, 
149, 151, 155, 157, 159, 161, 164, 165, 167, 168, 170, 170, 173, 174, 176, 
177, 179, 180, 182, 182, 184, 185, 186, 187, 188, 188, 188, 190, 191, 191, 
193, 193, 193, 193, 195, 195, 196, 197, 197, 198, 200, 201, 202, 202, 202, 
203, 204, 204, 205, 206, 206, 207, 207, 208, 209, 209, 209, 210, 210, 211, 
211, 212, 212, 212, 213, 214, 216, 217, 217, 219, 220, 221, 222, 223, 224, 
225, 226, 227, 228, 229, 229, 230, 231, 232, 233, 233, 233, 234, 235, 236, 
237, 238, 238, 238, 239, 239, 240, 241, 241, 241, 242, 242, 243, 244, 244, 
244, 244, 245, 245, 246, 246, 246, 246, 246, 246, 246, 247, 247, 247, 247, 
247, 247, 246, 246, 245, 245, 244, 244, 243, 243, 241, 241, 239, 238, 236, 
235, 233, 232, 231, 229, 227, 225, 223, 221, 220, 217, 216, 214, 211, 209, 
208, 206, 203, 201, 198, 196, 192, 188, 185, 164, 126,  24,  12,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 102, 129, 137, 143, 
147, 151, 154, 157, 159, 161, 163, 164, 167, 168, 169, 170, 172, 174, 176, 
177, 179, 180, 181, 182, 184, 185, 186, 186, 188, 188, 189, 190, 191, 191, 
193, 193, 193, 193, 195, 195, 196, 197, 197, 198, 199, 200, 201, 202, 202, 
203, 204, 205, 205, 206, 206, 207, 208, 208, 209, 209, 210, 210, 211, 211, 
212, 212, 213, 213, 213, 214, 216, 216, 217, 219, 220, 221, 222, 223, 224, 
225, 226, 227, 228, 229, 230, 231, 231, 232, 233, 233, 235, 236, 236, 236, 
237, 238, 238, 239, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, 244, 
245, 245, 245, 246, 246, 247, 247, 248, 248, 248, 248, 248, 249, 249, 249, 
248, 249, 249, 248, 248, 248, 247, 247, 246, 245, 245, 244, 243, 242, 241, 
240, 238, 237, 235, 233, 232, 230, 229, 227, 225, 223, 221, 220, 217, 216, 
214, 212, 210, 208, 206, 204, 201, 197, 195, 192, 188, 185, 181, 176, 165, 
144,  53,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24, 128, 136, 141, 
147, 151, 153, 156, 159, 161, 163, 165, 166, 167, 169, 170, 173, 174, 176, 
177, 177, 179, 181, 182, 183, 184, 186, 186, 188, 188, 189, 190, 191, 191, 
192, 193, 193, 193, 195, 195, 197, 197, 197, 198, 199, 200, 201, 202, 202, 
203, 204, 204, 205, 206, 207, 207, 208, 208, 209, 210, 210, 211, 211, 211, 
212, 212, 213, 214, 214, 214, 215, 216, 217, 219, 220, 221, 222, 223, 224, 
225, 226, 227, 228, 229, 229, 231, 231, 233, 233, 233, 235, 236, 236, 237, 
238, 238, 239, 240, 241, 241, 242, 242, 243, 243, 243, 244, 244, 244, 245, 
246, 246, 247, 246, 247, 248, 248, 248, 249, 249, 249, 250, 249, 250, 250, 
250, 250, 250, 250, 250, 250, 250, 249, 249, 248, 248, 247, 246, 245, 244, 
243, 242, 241, 239, 238, 237, 235, 233, 232, 230, 229, 227, 225, 223, 222, 
220, 217, 216, 214, 212, 210, 208, 206, 203, 200, 197, 194, 191, 188, 184, 
180, 176, 172, 165, 160, 141,  77,  24,  12,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 107, 133, 141, 
146, 149, 153, 155, 158, 160, 161, 164, 166, 167, 168, 170, 170, 173, 174, 
176, 177, 179, 180, 181, 183, 184, 185, 186, 187, 188, 188, 190, 191, 192, 
192, 193, 193, 193, 195, 195, 195, 197, 197, 198, 198, 200, 201, 202, 202, 
203, 204, 205, 206, 206, 207, 208, 208, 208, 209, 210, 210, 211, 212, 212, 
212, 213, 214, 214, 215, 215, 216, 217, 217, 219, 220, 220, 222, 223, 223, 
225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 235, 236, 237, 238, 
238, 238, 239, 240, 241, 242, 242, 242, 243, 243, 244, 244, 245, 246, 246, 
246, 247, 248, 248, 248, 248, 249, 250, 249, 249, 250, 250, 250, 250, 250, 
250, 250, 250, 252, 252, 250, 252, 250, 250, 250, 250, 249, 249, 248, 247, 
247, 245, 244, 244, 242, 240, 239, 238, 236, 234, 233, 231, 229, 228, 226, 
225, 222, 221, 219, 217, 216, 214, 211, 209, 207, 204, 202, 199, 195, 193, 
190, 187, 182, 177, 174, 170, 164, 159, 153, 148, 129,  69,  45,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24, 130, 139, 
145, 150, 152, 155, 158, 160, 161, 164, 165, 167, 168, 169, 170, 173, 174, 
176, 177, 179, 180, 181, 183, 183, 185, 186, 187, 188, 188, 190, 191, 191, 
192, 193, 193, 193, 195, 195, 195, 197, 197, 198, 199, 200, 201, 202, 202, 
203, 204, 204, 205, 206, 207, 207, 208, 209, 209, 210, 210, 211, 212, 212, 
212, 214, 214, 214, 215, 215, 216, 216, 217, 219, 220, 221, 222, 222, 224, 
225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 234, 236, 236, 237, 237, 
238, 240, 240, 240, 241, 242, 242, 243, 244, 244, 245, 245, 246, 246, 246, 
248, 248, 248, 248, 248, 249, 250, 250, 250, 250, 250, 252, 252, 252, 252, 
252, 252, 253, 253, 252, 253, 253, 252, 253, 252, 252, 252, 250, 250, 250, 
249, 248, 247, 246, 245, 244, 242, 241, 240, 238, 237, 236, 233, 232, 230, 
229, 227, 225, 224, 222, 220, 218, 216, 214, 213, 210, 208, 205, 203, 200, 
197, 193, 191, 187, 183, 180, 176, 171, 167, 160, 156, 152, 147, 143, 135, 
 92,  36,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 111, 137, 
143, 149, 152, 155, 158, 160, 161, 164, 165, 167, 168, 169, 170, 172, 173, 
176, 177, 177, 180, 181, 182, 183, 184, 186, 186, 188, 188, 189, 191, 191, 
191, 192, 193, 194, 194, 195, 195, 197, 197, 198, 198, 200, 201, 202, 203, 
203, 204, 205, 206, 206, 207, 208, 208, 209, 210, 210, 210, 211, 212, 212, 
213, 214, 214, 215, 215, 215, 216, 217, 217, 219, 219, 220, 222, 223, 224, 
225, 226, 226, 228, 229, 230, 231, 231, 232, 233, 233, 236, 236, 237, 237, 
238, 240, 240, 240, 242, 242, 242, 244, 244, 245, 245, 245, 246, 247, 247, 
247, 248, 249, 249, 250, 250, 250, 250, 250, 252, 252, 252, 252, 252, 253, 
253, 253, 253, 254, 254, 254, 254, 253, 254, 254, 253, 253, 253, 252, 252, 
250, 250, 249, 249, 248, 247, 245, 245, 243, 242, 240, 239, 238, 236, 235, 
233, 231, 230, 228, 226, 224, 223, 221, 219, 217, 216, 213, 211, 209, 207, 
204, 201, 197, 195, 192, 188, 185, 181, 177, 173, 167, 164, 159, 156, 151, 
146, 140, 135, 128, 116,  64,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36, 135, 
141, 147, 151, 155, 156, 159, 161, 164, 165, 166, 167, 169, 170, 170, 173, 
174, 176, 177, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
191, 193, 193, 193, 195, 195, 195, 196, 197, 197, 198, 199, 200, 202, 202, 
203, 204, 205, 206, 206, 207, 207, 208, 209, 209, 210, 211, 212, 212, 213, 
214, 214, 214, 215, 215, 216, 217, 217, 217, 219, 220, 220, 221, 222, 224, 
224, 225, 226, 228, 229, 230, 231, 231, 232, 233, 234, 235, 236, 238, 238, 
238, 240, 241, 241, 242, 243, 243, 244, 244, 245, 245, 246, 247, 247, 248, 
248, 248, 249, 250, 250, 250, 250, 252, 252, 252, 252, 253, 253, 254, 254, 
254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 253, 
253, 252, 252, 250, 250, 249, 248, 247, 246, 245, 243, 243, 241, 240, 238, 
236, 235, 233, 231, 230, 228, 226, 225, 223, 221, 220, 217, 216, 214, 211, 
209, 206, 204, 201, 198, 195, 193, 188, 186, 181, 177, 174, 169, 165, 161, 
158, 154, 150, 144, 139, 133, 125, 118, 102,  69,   2,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 121, 
140, 146, 150, 154, 157, 159, 161, 163, 165, 166, 168, 169, 170, 170, 173, 
174, 175, 177, 178, 179, 181, 182, 183, 185, 186, 187, 188, 188, 190, 191, 
192, 192, 193, 193, 195, 195, 195, 196, 197, 197, 198, 200, 200, 202, 202, 
203, 204, 204, 205, 206, 207, 207, 208, 209, 209, 210, 211, 211, 212, 213, 
214, 214, 214, 215, 216, 216, 216, 217, 217, 217, 219, 220, 221, 222, 224, 
224, 225, 227, 228, 229, 230, 230, 231, 232, 233, 233, 236, 236, 238, 238, 
239, 240, 240, 241, 242, 243, 243, 244, 244, 245, 246, 246, 247, 248, 248, 
249, 249, 249, 250, 250, 252, 252, 252, 252, 253, 253, 254, 254, 254, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
254, 254, 253, 253, 252, 252, 250, 249, 249, 247, 246, 245, 244, 243, 241, 
239, 238, 236, 235, 232, 231, 230, 228, 226, 225, 223, 221, 220, 217, 215, 
213, 211, 209, 207, 204, 201, 197, 195, 192, 188, 185, 182, 177, 174, 170, 
166, 163, 160, 156, 151, 147, 141, 136, 129, 123, 113, 105,  86,  24,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36, 
139, 145, 150, 153, 156, 159, 160, 163, 164, 166, 167, 169, 169, 170, 171, 
173, 174, 177, 177, 179, 180, 182, 183, 184, 186, 186, 187, 188, 190, 191, 
191, 192, 193, 193, 193, 195, 195, 196, 197, 197, 198, 199, 201, 201, 202, 
202, 203, 204, 205, 206, 206, 207, 208, 209, 209, 210, 211, 211, 212, 213, 
213, 214, 214, 215, 216, 216, 217, 217, 217, 217, 219, 220, 221, 223, 223, 
225, 225, 226, 227, 229, 230, 230, 231, 232, 233, 235, 235, 236, 237, 238, 
239, 239, 240, 242, 242, 242, 243, 244, 245, 245, 246, 246, 247, 248, 249, 
249, 250, 250, 250, 252, 250, 252, 253, 253, 253, 253, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 254, 253, 252, 250, 250, 250, 248, 248, 246, 245, 243, 
243, 241, 239, 238, 236, 234, 232, 231, 229, 228, 226, 225, 223, 221, 220, 
217, 215, 213, 211, 208, 206, 204, 200, 197, 194, 191, 188, 185, 182, 178, 
173, 170, 167, 164, 161, 158, 153, 149, 143, 139, 132, 125, 118, 107,  97, 
 77,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
118, 143, 149, 152, 155, 158, 160, 161, 164, 165, 166, 168, 169, 170, 171, 
173, 174, 176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 188, 190, 
191, 192, 193, 193, 193, 195, 195, 195, 197, 197, 197, 199, 200, 200, 202, 
202, 204, 204, 205, 206, 207, 208, 208, 209, 209, 211, 211, 211, 212, 213, 
213, 214, 215, 215, 216, 217, 217, 217, 217, 218, 219, 220, 221, 222, 223, 
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 
238, 240, 240, 241, 242, 243, 244, 244, 245, 245, 246, 247, 247, 248, 248, 
250, 250, 250, 250, 252, 252, 253, 253, 253, 254, 254, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 254, 254, 253, 253, 252, 250, 250, 249, 247, 246, 
244, 244, 242, 240, 238, 237, 235, 233, 233, 230, 229, 227, 226, 224, 223, 
220, 219, 216, 215, 212, 210, 208, 205, 202, 199, 197, 195, 191, 188, 185, 
181, 177, 174, 170, 168, 165, 161, 158, 154, 150, 145, 140, 135, 128, 120, 
111, 102,  83,  45,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 24, 143, 148, 151, 155, 158, 160, 161, 164, 165, 167, 168, 169, 170, 170, 
173, 174, 175, 177, 178, 180, 181, 182, 183, 185, 186, 187, 188, 188, 190, 
191, 191, 193, 193, 193, 195, 195, 195, 197, 197, 197, 198, 199, 201, 202, 
202, 203, 204, 205, 206, 206, 207, 208, 209, 209, 210, 211, 211, 213, 213, 
214, 214, 214, 216, 216, 217, 217, 217, 217, 219, 220, 220, 221, 222, 223, 
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 235, 235, 236, 237, 238, 
238, 239, 240, 241, 242, 243, 243, 244, 245, 246, 246, 247, 248, 248, 249, 
249, 250, 250, 252, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 252, 250, 250, 249, 
247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 231, 230, 229, 227, 225, 
224, 222, 220, 217, 216, 214, 212, 209, 207, 205, 202, 198, 196, 193, 191, 
187, 184, 180, 177, 174, 170, 168, 165, 161, 159, 155, 151, 146, 141, 135, 
129, 121, 115, 105,  86,  53,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0, 128, 147, 151, 154, 157, 160, 161, 163, 165, 166, 168, 169, 170, 170, 
172, 173, 174, 176, 177, 179, 180, 181, 183, 185, 185, 186, 188, 188, 189, 
191, 191, 193, 193, 193, 194, 195, 195, 197, 197, 197, 198, 199, 200, 201, 
202, 203, 204, 205, 206, 207, 207, 208, 208, 209, 210, 210, 212, 212, 213, 
213, 214, 215, 216, 216, 217, 217, 217, 217, 219, 219, 220, 220, 222, 222, 
223, 225, 225, 227, 228, 228, 229, 231, 232, 232, 233, 235, 236, 236, 238, 
238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 246, 247, 248, 248, 249, 
250, 250, 250, 252, 252, 253, 253, 254, 254, 254, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 252, 250, 
249, 248, 246, 245, 244, 242, 241, 239, 238, 236, 234, 232, 231, 229, 228, 
226, 224, 223, 220, 219, 217, 215, 213, 211, 208, 206, 203, 200, 197, 195, 
192, 188, 186, 183, 179, 176, 174, 170, 168, 165, 162, 159, 155, 151, 147, 
141, 136, 130, 123, 115, 105,  86,  45,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  24, 147, 150, 154, 157, 159, 161, 163, 165, 167, 167, 169, 169, 170, 
171, 173, 174, 175, 177, 179, 180, 181, 183, 184, 185, 186, 187, 188, 188, 
191, 191, 192, 193, 193, 194, 195, 195, 197, 197, 197, 198, 199, 200, 201, 
202, 203, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 211, 212, 213, 
214, 214, 215, 215, 216, 217, 217, 217, 217, 219, 220, 220, 220, 221, 222, 
223, 225, 225, 227, 228, 229, 230, 230, 232, 233, 233, 235, 235, 237, 238, 
238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 246, 247, 248, 248, 249, 
250, 250, 250, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 250, 249, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 
229, 227, 225, 223, 221, 220, 217, 216, 214, 211, 209, 207, 204, 202, 199, 
196, 193, 190, 188, 184, 181, 177, 175, 173, 170, 168, 165, 161, 158, 155, 
150, 146, 141, 135, 130, 123, 115, 103,  83,  36,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0, 123, 150, 153, 157, 159, 161, 163, 164, 166, 168, 169, 169, 170, 
170, 173, 174, 174, 177, 177, 179, 181, 182, 183, 184, 186, 187, 188, 188, 
190, 191, 192, 192, 193, 193, 195, 195, 197, 197, 197, 197, 198, 200, 200, 
202, 202, 203, 204, 204, 206, 206, 207, 208, 209, 210, 211, 211, 212, 212, 
214, 214, 214, 215, 216, 217, 217, 217, 217, 219, 219, 220, 220, 221, 223, 
223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 235, 235, 236, 237, 
238, 239, 240, 241, 242, 243, 244, 244, 244, 245, 246, 247, 248, 249, 249, 
250, 250, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 
253, 252, 250, 250, 248, 247, 245, 244, 242, 241, 239, 238, 235, 235, 232, 
231, 230, 228, 226, 224, 223, 220, 219, 216, 215, 213, 210, 208, 205, 203, 
201, 197, 195, 192, 189, 186, 183, 180, 177, 174, 173, 170, 167, 164, 161, 
158, 154, 150, 146, 140, 135, 129, 123, 115,  99,  80,  24,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  12, 148, 153, 156, 159, 161, 163, 164, 166, 167, 168, 169, 170, 
170, 173, 173, 174, 176, 177, 179, 180, 182, 183, 184, 185, 186, 188, 188, 
189, 190, 191, 192, 193, 193, 193, 195, 196, 196, 197, 197, 198, 198, 201, 
201, 202, 203, 204, 204, 205, 207, 207, 208, 209, 210, 210, 211, 212, 212, 
213, 214, 214, 215, 216, 217, 217, 217, 219, 219, 219, 220, 221, 221, 222, 
223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 236, 237, 
238, 239, 239, 241, 242, 242, 243, 244, 245, 245, 247, 247, 248, 248, 249, 
250, 250, 252, 252, 253, 253, 253, 255, 254, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 253, 253, 252, 250, 248, 247, 246, 244, 243, 242, 239, 238, 237, 235, 
233, 231, 230, 228, 227, 225, 223, 222, 220, 217, 215, 213, 211, 209, 207, 
204, 201, 198, 195, 193, 190, 187, 184, 181, 179, 176, 174, 172, 169, 167, 
163, 160, 157, 153, 149, 144, 139, 133, 128, 121, 109,  99,  80,   2,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0, 133, 152, 155, 158, 160, 163, 164, 166, 167, 168, 169, 170, 
170, 172, 173, 173, 176, 176, 178, 179, 181, 182, 183, 185, 186, 187, 188, 
188, 190, 191, 192, 193, 193, 193, 195, 195, 197, 197, 197, 198, 199, 200, 
200, 202, 203, 203, 205, 205, 206, 207, 208, 209, 209, 211, 211, 212, 212, 
213, 214, 214, 216, 216, 216, 217, 217, 217, 219, 220, 220, 220, 221, 222, 
222, 224, 224, 226, 227, 228, 229, 229, 230, 231, 233, 233, 234, 236, 237, 
238, 238, 239, 240, 241, 242, 243, 244, 245, 245, 246, 247, 248, 249, 249, 
250, 250, 252, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 254, 253, 252, 250, 249, 247, 246, 245, 244, 242, 240, 238, 237, 
235, 233, 233, 231, 229, 227, 225, 223, 222, 220, 217, 216, 214, 212, 210, 
207, 205, 202, 199, 197, 193, 191, 188, 185, 182, 180, 177, 175, 173, 170, 
168, 165, 161, 159, 155, 152, 147, 143, 139, 133, 126, 118, 107,  92,  64, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  12, 151, 155, 158, 160, 161, 164, 166, 167, 168, 169, 170, 
170, 172, 173, 174, 174, 177, 177, 179, 181, 182, 183, 184, 186, 187, 188, 
188, 189, 190, 191, 192, 193, 193, 195, 195, 196, 197, 197, 198, 199, 200, 
200, 201, 203, 203, 204, 204, 206, 206, 207, 209, 209, 210, 211, 212, 212, 
213, 213, 214, 215, 215, 217, 217, 217, 219, 219, 219, 220, 220, 222, 222, 
223, 223, 224, 225, 226, 227, 228, 229, 230, 232, 233, 233, 233, 236, 237, 
237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 246, 248, 248, 249, 
250, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 254, 253, 252, 250, 250, 248, 246, 246, 244, 243, 241, 239, 
238, 236, 235, 233, 231, 229, 228, 226, 224, 222, 221, 219, 216, 214, 213, 
210, 208, 206, 202, 200, 197, 195, 192, 188, 186, 183, 180, 179, 176, 174, 
172, 169, 167, 164, 161, 157, 153, 150, 146, 141, 136, 130, 123, 115, 103, 
 89,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0, 128, 155, 157, 160, 161, 164, 165, 166, 168, 169, 170, 
170, 172, 173, 173, 174, 176, 177, 179, 180, 181, 183, 183, 185, 186, 187, 
188, 188, 190, 191, 192, 193, 193, 194, 195, 195, 197, 197, 198, 198, 199, 
200, 201, 202, 203, 204, 204, 206, 206, 207, 208, 209, 209, 211, 211, 212, 
213, 214, 214, 215, 216, 216, 217, 217, 217, 219, 219, 220, 221, 221, 221, 
222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 235, 
237, 238, 239, 239, 241, 242, 243, 244, 244, 245, 246, 247, 247, 248, 249, 
250, 250, 250, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 254, 252, 250, 250, 249, 247, 246, 244, 243, 241, 
240, 238, 237, 234, 233, 231, 231, 228, 227, 225, 223, 221, 219, 217, 215, 
213, 211, 208, 205, 203, 201, 197, 195, 193, 189, 186, 183, 181, 179, 177, 
174, 173, 170, 168, 165, 162, 159, 155, 152, 148, 143, 139, 133, 128, 120, 
111,  94,  83,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  12, 153, 157, 160, 161, 163, 165, 166, 168, 169, 170, 
170, 171, 173, 174, 174, 174, 176, 177, 180, 181, 182, 183, 185, 186, 187, 
188, 189, 190, 191, 192, 192, 193, 194, 195, 195, 197, 197, 198, 198, 198, 
200, 201, 202, 202, 203, 205, 205, 206, 207, 208, 209, 209, 210, 211, 212, 
212, 214, 214, 214, 215, 216, 217, 217, 219, 219, 219, 220, 221, 221, 222, 
222, 223, 224, 225, 226, 227, 228, 229, 229, 230, 231, 232, 233, 235, 235, 
237, 238, 238, 239, 240, 242, 242, 243, 244, 245, 246, 246, 247, 248, 248, 
250, 250, 252, 252, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 254, 252, 252, 250, 249, 247, 246, 244, 243, 
242, 240, 238, 237, 235, 233, 232, 230, 229, 227, 225, 223, 222, 220, 217, 
215, 213, 211, 209, 206, 204, 201, 198, 195, 193, 190, 187, 184, 182, 179, 
177, 176, 174, 170, 169, 166, 163, 160, 157, 154, 150, 145, 141, 137, 130, 
124, 116, 105,  83,  45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  99, 156, 159, 161, 164, 165, 166, 168, 169, 169, 
170, 170, 172, 173, 174, 174, 176, 177, 179, 181, 181, 183, 184, 185, 187, 
187, 188, 190, 191, 191, 193, 193, 193, 195, 195, 197, 197, 197, 198, 198, 
199, 200, 201, 202, 203, 204, 205, 206, 206, 208, 208, 209, 210, 211, 211, 
212, 213, 214, 214, 215, 216, 217, 217, 217, 218, 220, 220, 220, 221, 222, 
222, 223, 224, 225, 225, 227, 227, 228, 230, 231, 231, 232, 233, 234, 235, 
236, 237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 247, 248, 249, 
249, 250, 250, 252, 253, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 246, 245, 
243, 242, 240, 239, 237, 236, 233, 232, 231, 229, 228, 225, 224, 222, 220, 
217, 216, 214, 211, 209, 206, 204, 202, 198, 195, 193, 190, 188, 185, 182, 
180, 177, 176, 174, 172, 169, 167, 164, 161, 158, 155, 151, 147, 143, 139, 
133, 128, 121, 111,  97,  73,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  12, 155, 159, 161, 163, 164, 166, 168, 168, 170, 
170, 171, 173, 174, 174, 174, 175, 177, 179, 180, 181, 183, 184, 185, 186, 
187, 188, 189, 190, 191, 192, 193, 193, 195, 195, 197, 197, 197, 198, 198, 
199, 200, 201, 202, 203, 204, 204, 206, 207, 207, 208, 209, 210, 211, 211, 
212, 213, 214, 214, 215, 215, 216, 217, 217, 217, 220, 220, 220, 221, 222, 
222, 223, 223, 225, 225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 
235, 237, 238, 239, 239, 241, 242, 242, 244, 244, 245, 246, 247, 247, 248, 
249, 250, 250, 250, 253, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 246, 
244, 244, 242, 240, 238, 238, 235, 235, 232, 231, 229, 227, 226, 224, 222, 
220, 219, 216, 214, 212, 209, 207, 204, 202, 198, 195, 193, 191, 188, 185, 
182, 180, 178, 176, 174, 172, 170, 168, 164, 161, 158, 156, 152, 149, 145, 
140, 136, 130, 124, 115, 103,  86,  36,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  69, 157, 160, 163, 164, 166, 168, 169, 169, 
170, 171, 173, 173, 174, 174, 174, 176, 177, 179, 181, 182, 183, 185, 186, 
187, 188, 189, 190, 191, 191, 193, 193, 194, 195, 195, 197, 197, 197, 198, 
199, 200, 201, 202, 202, 204, 204, 205, 206, 207, 208, 208, 209, 210, 211, 
211, 212, 214, 214, 215, 215, 216, 217, 217, 217, 219, 220, 220, 221, 221, 
222, 223, 224, 224, 225, 226, 227, 228, 229, 230, 230, 231, 232, 233, 233, 
236, 237, 237, 238, 239, 240, 241, 242, 243, 244, 244, 246, 246, 247, 248, 
249, 250, 250, 250, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 252, 250, 249, 248, 
247, 245, 243, 242, 240, 239, 238, 236, 233, 232, 231, 229, 228, 226, 224, 
223, 221, 219, 216, 214, 212, 209, 207, 204, 202, 200, 197, 193, 191, 188, 
185, 182, 180, 179, 176, 174, 172, 170, 168, 165, 161, 159, 156, 153, 150, 
146, 141, 139, 132, 126, 118, 109,  94,  69,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0, 156, 160, 161, 164, 166, 167, 169, 169, 
170, 171, 173, 173, 174, 174, 174, 176, 177, 179, 180, 182, 183, 185, 186, 
187, 188, 188, 189, 191, 192, 192, 193, 193, 195, 195, 195, 197, 197, 198, 
198, 200, 200, 201, 202, 203, 204, 205, 206, 206, 207, 209, 209, 209, 210, 
211, 212, 213, 214, 214, 215, 216, 217, 217, 219, 219, 219, 220, 221, 221, 
222, 223, 224, 224, 225, 226, 226, 227, 228, 229, 230, 231, 232, 233, 235, 
235, 237, 237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 247, 248, 
249, 249, 250, 250, 252, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 
248, 247, 245, 244, 242, 241, 239, 237, 236, 235, 233, 231, 229, 228, 227, 
224, 222, 220, 219, 216, 214, 211, 210, 207, 205, 202, 199, 197, 193, 191, 
188, 185, 183, 181, 177, 177, 174, 173, 170, 168, 166, 163, 160, 157, 154, 
151, 147, 143, 139, 133, 129, 123, 113, 102,  80,  24,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  45, 158, 161, 164, 166, 167, 168, 169, 
170, 171, 173, 173, 174, 174, 174, 175, 176, 177, 180, 182, 183, 184, 185, 
186, 187, 188, 188, 190, 191, 193, 193, 193, 193, 195, 195, 197, 197, 198, 
198, 199, 200, 201, 202, 202, 204, 204, 205, 206, 207, 207, 209, 209, 210, 
211, 212, 213, 213, 214, 215, 216, 216, 217, 217, 217, 219, 220, 221, 221, 
222, 222, 223, 224, 224, 225, 226, 226, 228, 229, 230, 231, 231, 233, 233, 
235, 236, 237, 238, 239, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
248, 249, 250, 250, 252, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 252, 250, 
249, 248, 246, 245, 244, 242, 241, 239, 237, 236, 234, 232, 231, 230, 228, 
227, 224, 222, 220, 219, 216, 214, 212, 210, 207, 205, 202, 199, 197, 193, 
191, 188, 185, 182, 180, 179, 176, 174, 172, 170, 168, 165, 163, 160, 158, 
154, 151, 148, 143, 140, 135, 130, 124, 118, 105,  89,  59,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0, 141, 161, 163, 165, 167, 168, 169, 
170, 170, 172, 173, 174, 174, 174, 175, 176, 177, 179, 181, 182, 183, 185, 
186, 187, 188, 188, 189, 191, 191, 193, 193, 193, 195, 195, 197, 197, 198, 
198, 199, 200, 201, 201, 202, 203, 204, 205, 206, 206, 208, 208, 209, 210, 
211, 211, 212, 213, 214, 214, 216, 216, 217, 217, 217, 219, 220, 220, 221, 
222, 222, 223, 223, 224, 225, 226, 226, 227, 229, 229, 230, 232, 232, 233, 
234, 235, 236, 237, 238, 239, 241, 242, 242, 243, 244, 244, 245, 246, 247, 
248, 249, 250, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 249, 248, 246, 245, 244, 242, 241, 239, 237, 236, 235, 232, 231, 229, 
228, 226, 225, 222, 220, 217, 216, 214, 212, 209, 208, 204, 202, 199, 197, 
194, 192, 188, 185, 182, 180, 177, 176, 174, 172, 170, 168, 165, 163, 161, 
158, 155, 152, 148, 144, 140, 136, 132, 126, 120, 109,  97,  73,  12,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  45, 159, 162, 164, 166, 168, 169, 
170, 170, 172, 173, 173, 174, 174, 176, 176, 177, 179, 180, 181, 183, 184, 
186, 186, 187, 188, 190, 191, 192, 193, 193, 194, 195, 195, 195, 197, 197, 
198, 198, 200, 200, 201, 202, 203, 203, 204, 206, 206, 207, 208, 208, 209, 
210, 211, 212, 213, 213, 214, 215, 216, 216, 217, 217, 219, 219, 220, 221, 
221, 222, 223, 223, 224, 225, 225, 226, 228, 228, 229, 230, 231, 232, 233, 
234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 245, 246, 247, 
248, 248, 250, 250, 250, 252, 253, 253, 254, 254, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 
252, 250, 249, 248, 246, 245, 243, 242, 240, 239, 237, 236, 233, 232, 231, 
230, 228, 226, 224, 222, 220, 217, 216, 214, 211, 209, 207, 204, 202, 198, 
196, 193, 191, 188, 185, 182, 180, 178, 176, 174, 173, 170, 168, 166, 163, 
160, 158, 155, 152, 148, 145, 141, 139, 132, 128, 121, 113, 102,  83,  24, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 135, 161, 164, 166, 168, 169, 
170, 170, 172, 173, 173, 174, 174, 176, 176, 176, 177, 180, 181, 182, 184, 
185, 186, 187, 188, 189, 191, 191, 192, 193, 193, 194, 195, 195, 197, 197, 
198, 198, 199, 201, 201, 202, 202, 203, 204, 205, 206, 207, 207, 208, 209, 
210, 211, 211, 213, 213, 214, 215, 216, 217, 217, 217, 219, 219, 220, 220, 
221, 222, 222, 224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 232, 232, 
233, 235, 236, 237, 238, 238, 240, 240, 242, 243, 243, 244, 245, 246, 247, 
248, 249, 249, 250, 250, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 
253, 252, 250, 249, 247, 246, 245, 243, 242, 240, 238, 237, 235, 233, 233, 
231, 229, 228, 226, 223, 222, 220, 217, 216, 214, 211, 209, 206, 204, 202, 
198, 197, 193, 191, 187, 185, 181, 180, 177, 175, 174, 172, 169, 167, 166, 
163, 160, 158, 155, 152, 149, 146, 141, 137, 133, 128, 121, 115, 105,  92, 
 59,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  12, 159, 163, 165, 167, 168, 
170, 170, 171, 173, 174, 174, 174, 174, 175, 176, 177, 179, 180, 182, 183, 
185, 186, 187, 188, 188, 189, 191, 191, 193, 193, 193, 195, 195, 197, 197, 
197, 198, 199, 200, 200, 201, 202, 203, 203, 204, 205, 207, 207, 208, 209, 
209, 210, 211, 211, 213, 214, 214, 215, 216, 217, 217, 219, 219, 219, 220, 
221, 221, 222, 223, 223, 225, 225, 225, 227, 227, 228, 230, 230, 231, 232, 
233, 234, 236, 236, 237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 
247, 248, 249, 250, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
253, 253, 250, 250, 249, 247, 246, 244, 243, 241, 239, 238, 237, 235, 233, 
232, 230, 229, 227, 225, 224, 222, 220, 217, 215, 213, 211, 209, 206, 204, 
201, 198, 195, 193, 190, 187, 185, 181, 179, 177, 174, 173, 172, 170, 167, 
165, 163, 160, 158, 155, 152, 149, 146, 141, 139, 133, 129, 123, 118, 107, 
 97,  73,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 103, 161, 164, 167, 168, 
169, 170, 171, 173, 173, 174, 174, 174, 175, 176, 177, 177, 180, 181, 182, 
184, 186, 186, 188, 188, 190, 191, 192, 192, 193, 193, 195, 195, 197, 197, 
197, 198, 199, 200, 200, 201, 201, 202, 204, 204, 205, 206, 207, 207, 208, 
209, 210, 211, 211, 212, 213, 214, 215, 216, 216, 217, 217, 219, 219, 220, 
220, 221, 222, 222, 223, 224, 225, 225, 226, 227, 228, 229, 230, 231, 232, 
233, 234, 235, 236, 237, 237, 239, 240, 241, 242, 243, 243, 244, 245, 246, 
247, 248, 249, 250, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
254, 253, 252, 250, 250, 248, 247, 245, 244, 243, 241, 240, 237, 237, 235, 
233, 231, 230, 229, 227, 225, 223, 221, 219, 217, 215, 212, 210, 208, 206, 
203, 201, 197, 195, 193, 190, 187, 184, 181, 177, 177, 174, 173, 171, 169, 
167, 165, 162, 160, 158, 155, 151, 149, 145, 141, 137, 133, 130, 124, 118, 
111,  99,  80,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 159, 163, 166, 167, 
170, 170, 171, 173, 173, 174, 174, 174, 176, 176, 177, 177, 179, 181, 182, 
183, 185, 186, 188, 188, 188, 190, 191, 192, 193, 193, 194, 195, 196, 197, 
197, 198, 198, 199, 200, 201, 202, 202, 203, 204, 205, 206, 206, 207, 208, 
208, 210, 210, 211, 212, 213, 214, 214, 216, 216, 217, 217, 217, 219, 220, 
220, 221, 222, 222, 223, 224, 224, 225, 226, 227, 227, 228, 229, 231, 231, 
232, 233, 235, 236, 237, 238, 238, 239, 241, 242, 242, 243, 244, 245, 246, 
247, 248, 248, 249, 250, 250, 252, 252, 253, 253, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 253, 252, 250, 250, 248, 247, 246, 244, 242, 240, 239, 237, 236, 
234, 232, 231, 230, 228, 226, 224, 222, 220, 219, 216, 214, 212, 209, 208, 
205, 203, 200, 197, 195, 192, 188, 186, 183, 180, 177, 176, 174, 173, 170, 
169, 167, 164, 162, 160, 157, 154, 151, 149, 145, 141, 137, 133, 130, 125, 
118, 111, 102,  89,  45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45, 161, 165, 167, 
169, 170, 170, 173, 173, 174, 174, 175, 174, 176, 177, 177, 177, 180, 182, 
183, 185, 186, 187, 188, 188, 190, 191, 192, 193, 193, 193, 195, 195, 197, 
197, 197, 198, 199, 200, 200, 201, 202, 202, 203, 204, 205, 205, 206, 208, 
208, 209, 210, 211, 211, 212, 214, 214, 214, 215, 216, 217, 217, 219, 219, 
220, 220, 221, 222, 222, 224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 
232, 233, 233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 
246, 248, 248, 249, 249, 250, 252, 252, 253, 253, 254, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 254, 253, 252, 250, 249, 248, 246, 244, 243, 241, 241, 238, 237, 
235, 233, 232, 231, 229, 227, 226, 224, 222, 220, 217, 216, 214, 212, 209, 
207, 205, 202, 200, 197, 195, 192, 188, 186, 183, 180, 177, 175, 174, 172, 
170, 168, 166, 164, 161, 159, 157, 154, 151, 148, 145, 141, 137, 133, 129, 
125, 120, 113, 105,  92,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 143, 163, 165, 
168, 169, 171, 173, 173, 174, 174, 174, 176, 176, 176, 177, 177, 179, 180, 
182, 184, 185, 186, 188, 188, 188, 191, 191, 193, 193, 193, 195, 195, 195, 
197, 197, 198, 198, 200, 200, 201, 202, 202, 203, 204, 204, 205, 206, 207, 
208, 209, 210, 211, 211, 212, 213, 213, 214, 215, 216, 216, 217, 217, 219, 
219, 220, 221, 222, 222, 223, 223, 225, 225, 225, 226, 227, 229, 229, 230, 
231, 232, 233, 235, 235, 237, 238, 239, 240, 241, 242, 242, 243, 244, 245, 
246, 247, 247, 249, 250, 250, 250, 252, 252, 253, 254, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 253, 253, 252, 250, 249, 247, 245, 244, 243, 241, 240, 238, 
237, 234, 233, 231, 230, 229, 227, 225, 223, 221, 219, 217, 216, 213, 210, 
209, 206, 204, 202, 198, 197, 193, 191, 188, 185, 182, 179, 176, 174, 173, 
170, 170, 168, 166, 163, 161, 159, 156, 153, 151, 148, 144, 141, 137, 133, 
129, 126, 120, 113, 105,  94,  73,   2,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12, 161, 164, 
167, 169, 170, 172, 173, 174, 174, 174, 176, 176, 177, 177, 177, 178, 180, 
182, 183, 184, 186, 187, 188, 188, 190, 191, 193, 193, 193, 194, 195, 196, 
196, 197, 198, 198, 199, 200, 200, 201, 202, 203, 204, 204, 205, 206, 207, 
208, 209, 209, 210, 211, 211, 212, 213, 214, 215, 216, 216, 217, 217, 219, 
219, 220, 220, 222, 222, 223, 223, 224, 225, 225, 226, 227, 228, 229, 230, 
231, 232, 233, 235, 235, 237, 237, 238, 239, 240, 241, 242, 243, 244, 245, 
246, 246, 248, 248, 250, 250, 250, 252, 253, 253, 254, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 253, 252, 250, 249, 248, 246, 245, 243, 242, 241, 239, 
237, 235, 233, 232, 231, 229, 228, 226, 225, 223, 221, 217, 216, 214, 212, 
210, 208, 205, 203, 201, 198, 195, 193, 190, 187, 184, 182, 179, 176, 174, 
173, 170, 169, 167, 164, 163, 160, 158, 155, 152, 150, 147, 143, 140, 137, 
133, 128, 124, 120, 113, 107,  94,  80,  24,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 111, 163, 
166, 169, 170, 171, 173, 173, 174, 174, 176, 176, 177, 177, 177, 177, 179, 
180, 182, 183, 185, 186, 188, 188, 189, 191, 192, 193, 193, 194, 195, 195, 
197, 197, 197, 198, 198, 200, 200, 201, 201, 202, 203, 204, 204, 206, 206, 
207, 208, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 217, 217, 
219, 219, 220, 220, 222, 222, 223, 224, 225, 225, 226, 226, 227, 228, 229, 
230, 231, 233, 233, 235, 235, 237, 238, 239, 240, 241, 241, 243, 244, 244, 
245, 246, 247, 248, 248, 250, 250, 252, 252, 253, 254, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 246, 245, 243, 241, 240, 
238, 236, 235, 233, 231, 230, 229, 227, 225, 224, 222, 220, 217, 216, 213, 
211, 209, 207, 205, 203, 199, 197, 195, 192, 188, 187, 183, 180, 177, 174, 
174, 172, 169, 168, 166, 164, 161, 160, 157, 155, 152, 149, 146, 143, 139, 
135, 132, 128, 124, 120, 115, 107,  97,  83,  36,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 159, 
164, 167, 169, 170, 173, 173, 174, 174, 175, 177, 176, 177, 177, 177, 178, 
180, 182, 183, 184, 186, 187, 188, 189, 191, 191, 192, 193, 193, 195, 195, 
195, 197, 197, 197, 198, 200, 200, 200, 202, 202, 203, 203, 204, 205, 206, 
207, 208, 208, 209, 210, 211, 212, 213, 213, 214, 214, 215, 217, 216, 217, 
219, 219, 220, 220, 221, 222, 222, 223, 224, 225, 225, 226, 227, 227, 229, 
230, 231, 233, 233, 233, 236, 236, 238, 239, 239, 240, 241, 242, 243, 244, 
245, 246, 246, 248, 248, 249, 250, 250, 252, 252, 253, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 254, 253, 250, 250, 248, 247, 245, 244, 242, 241, 
239, 238, 236, 233, 232, 231, 229, 228, 226, 225, 222, 221, 217, 217, 215, 
213, 211, 209, 206, 204, 201, 198, 196, 193, 191, 188, 185, 183, 180, 177, 
174, 173, 170, 169, 168, 165, 163, 161, 159, 156, 154, 151, 148, 146, 141, 
139, 135, 132, 128, 123, 118, 113, 107,  99,  86,  53,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24, 
161, 166, 169, 170, 172, 173, 174, 174, 176, 176, 176, 177, 177, 177, 178, 
179, 180, 182, 184, 185, 186, 187, 188, 189, 191, 192, 193, 193, 194, 195, 
196, 197, 197, 197, 198, 200, 200, 201, 201, 202, 203, 203, 204, 205, 205, 
206, 207, 208, 209, 210, 210, 211, 212, 213, 214, 214, 215, 216, 216, 217, 
217, 218, 220, 220, 221, 222, 222, 223, 224, 224, 225, 225, 226, 227, 228, 
229, 231, 231, 232, 233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 
244, 246, 247, 247, 248, 249, 250, 250, 252, 252, 253, 254, 254, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 246, 245, 244, 241, 
240, 239, 237, 235, 233, 232, 230, 229, 227, 225, 224, 222, 220, 217, 216, 
214, 211, 210, 208, 205, 203, 201, 197, 195, 193, 190, 188, 185, 182, 179, 
176, 174, 170, 170, 168, 166, 165, 161, 160, 158, 155, 153, 151, 148, 144, 
141, 137, 133, 130, 126, 121, 118, 113, 107,  99,  86,  59,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
141, 163, 167, 169, 170, 173, 174, 174, 176, 177, 176, 177, 177, 177, 177, 
179, 180, 182, 183, 184, 186, 187, 188, 188, 190, 191, 192, 193, 194, 195, 
195, 197, 197, 197, 198, 198, 199, 200, 201, 202, 202, 202, 204, 204, 205, 
206, 206, 208, 208, 209, 210, 210, 211, 212, 213, 214, 215, 215, 216, 217, 
217, 219, 219, 219, 220, 221, 222, 222, 223, 224, 224, 225, 226, 227, 227, 
229, 230, 231, 232, 233, 234, 235, 236, 238, 238, 239, 241, 242, 243, 244, 
244, 246, 246, 247, 248, 249, 249, 250, 252, 252, 253, 254, 254, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 254, 253, 252, 250, 250, 248, 247, 245, 244, 243, 
241, 240, 238, 236, 235, 232, 231, 229, 228, 226, 225, 223, 221, 219, 217, 
215, 213, 211, 209, 207, 204, 202, 199, 197, 195, 192, 188, 187, 183, 180, 
177, 174, 173, 170, 169, 168, 166, 163, 161, 160, 157, 155, 152, 149, 146, 
143, 140, 137, 133, 129, 125, 121, 118, 111, 107,  99,  86,  64,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 12, 159, 164, 169, 170, 173, 174, 174, 174, 176, 176, 177, 177, 177, 178, 
179, 179, 180, 182, 183, 185, 186, 187, 188, 189, 191, 192, 193, 193, 193, 
195, 197, 197, 197, 198, 198, 199, 200, 201, 201, 202, 202, 203, 203, 205, 
206, 206, 207, 208, 208, 209, 210, 211, 212, 212, 213, 214, 215, 216, 217, 
217, 217, 219, 220, 220, 221, 221, 222, 223, 223, 224, 225, 225, 226, 227, 
228, 229, 230, 231, 232, 233, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
244, 244, 246, 247, 247, 248, 249, 250, 250, 252, 253, 253, 254, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 247, 246, 244, 244, 
242, 240, 239, 238, 235, 233, 232, 230, 229, 227, 225, 223, 222, 220, 217, 
216, 214, 212, 210, 208, 206, 203, 201, 198, 195, 193, 191, 188, 185, 183, 
180, 177, 174, 171, 170, 169, 166, 164, 163, 160, 159, 155, 153, 151, 148, 
146, 141, 139, 136, 132, 128, 124, 120, 116, 111, 105,  99,  89,  69,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  53, 160, 166, 169, 171, 173, 174, 174, 176, 176, 177, 177, 177, 178, 
178, 179, 180, 181, 183, 185, 186, 187, 188, 188, 190, 192, 192, 193, 193, 
195, 195, 196, 197, 197, 198, 198, 200, 201, 201, 202, 202, 203, 204, 204, 
205, 206, 206, 207, 208, 209, 210, 211, 212, 212, 213, 214, 214, 215, 216, 
216, 217, 217, 219, 220, 220, 221, 222, 222, 223, 224, 224, 225, 225, 226, 
227, 228, 229, 231, 232, 233, 233, 235, 237, 238, 238, 239, 240, 242, 243, 
243, 244, 245, 246, 247, 248, 249, 250, 250, 252, 252, 253, 254, 254, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 253, 252, 250, 250, 248, 247, 245, 244, 
243, 241, 240, 238, 236, 235, 233, 231, 229, 227, 226, 224, 222, 221, 219, 
217, 215, 213, 211, 209, 206, 204, 202, 199, 197, 194, 192, 190, 187, 185, 
182, 179, 176, 173, 170, 169, 167, 166, 164, 161, 159, 157, 155, 152, 150, 
147, 144, 140, 137, 133, 130, 126, 123, 118, 115, 111, 105,  99,  89,  69, 
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0, 140, 161, 166, 170, 173, 174, 174, 176, 177, 177, 177, 177, 177, 
178, 179, 179, 181, 182, 183, 185, 187, 187, 188, 188, 190, 191, 193, 193, 
195, 195, 195, 197, 197, 198, 198, 200, 200, 200, 202, 202, 202, 203, 203, 
205, 205, 206, 207, 208, 208, 209, 210, 211, 211, 212, 213, 214, 214, 216, 
216, 217, 217, 217, 219, 220, 220, 221, 222, 223, 223, 224, 224, 225, 226, 
226, 227, 229, 230, 231, 232, 233, 235, 236, 237, 238, 239, 240, 241, 242, 
243, 244, 245, 246, 247, 247, 248, 249, 250, 250, 252, 253, 253, 254, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 246, 245, 
243, 242, 240, 238, 237, 235, 233, 231, 230, 228, 226, 225, 223, 222, 220, 
217, 216, 214, 212, 209, 208, 205, 203, 200, 197, 195, 193, 191, 188, 186, 
183, 180, 177, 174, 172, 170, 168, 166, 165, 162, 160, 158, 156, 153, 151, 
149, 146, 143, 140, 136, 132, 129, 124, 121, 118, 113, 109, 105,  97,  89, 
 69,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  12, 157, 163, 168, 170, 173, 174, 176, 176, 177, 177, 177, 178, 
178, 178, 179, 180, 181, 183, 184, 185, 187, 188, 188, 190, 191, 192, 193, 
193, 195, 195, 195, 197, 197, 198, 199, 200, 201, 201, 202, 202, 203, 203, 
204, 205, 206, 207, 208, 209, 209, 210, 211, 212, 212, 213, 213, 215, 215, 
216, 217, 217, 217, 219, 219, 220, 221, 222, 222, 223, 223, 224, 225, 225, 
226, 227, 228, 229, 230, 231, 232, 233, 235, 236, 238, 238, 240, 241, 242, 
243, 244, 244, 245, 246, 247, 248, 249, 250, 250, 252, 252, 253, 253, 254, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 253, 252, 250, 250, 248, 247, 245, 
244, 242, 241, 239, 238, 236, 235, 232, 231, 229, 227, 225, 224, 222, 220, 
219, 217, 215, 212, 211, 208, 206, 204, 202, 199, 197, 195, 193, 189, 188, 
185, 182, 179, 177, 174, 170, 169, 167, 165, 163, 161, 159, 157, 155, 152, 
150, 148, 145, 141, 139, 135, 130, 128, 123, 118, 116, 111, 107, 103,  97, 
 86,  69,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  69, 159, 164, 168, 170, 173, 174, 176, 177, 177, 177, 177, 
179, 179, 179, 180, 181, 182, 183, 184, 186, 187, 188, 188, 191, 192, 192, 
193, 195, 195, 195, 197, 197, 198, 198, 199, 200, 201, 202, 202, 202, 203, 
203, 204, 205, 206, 207, 208, 209, 209, 210, 211, 211, 212, 213, 214, 215, 
216, 216, 216, 217, 219, 219, 220, 221, 221, 221, 222, 223, 224, 225, 225, 
226, 227, 227, 228, 229, 231, 232, 233, 234, 236, 237, 238, 239, 240, 241, 
242, 243, 244, 245, 246, 246, 248, 249, 250, 250, 250, 252, 252, 253, 254, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 250, 250, 249, 248, 246, 
245, 243, 242, 240, 239, 236, 235, 233, 231, 230, 228, 226, 224, 222, 221, 
220, 217, 215, 213, 212, 209, 207, 206, 203, 200, 198, 195, 193, 191, 188, 
186, 184, 181, 177, 176, 173, 170, 168, 166, 164, 163, 161, 158, 156, 154, 
151, 149, 146, 143, 140, 137, 133, 129, 126, 121, 118, 113, 111, 107, 102, 
 97,  86,  69,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0, 139, 160, 166, 169, 170, 174, 176, 177, 177, 177, 179, 
178, 179, 179, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 191, 191, 
192, 193, 194, 195, 196, 197, 197, 197, 199, 200, 200, 201, 202, 202, 203, 
203, 204, 205, 205, 206, 207, 208, 209, 209, 211, 211, 212, 213, 214, 214, 
215, 216, 216, 217, 217, 219, 219, 220, 220, 221, 222, 222, 224, 224, 225, 
225, 226, 226, 227, 229, 230, 231, 233, 233, 235, 236, 237, 238, 239, 240, 
242, 242, 243, 244, 245, 247, 247, 248, 249, 250, 250, 252, 253, 253, 253, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 248, 247, 
245, 244, 243, 241, 239, 238, 236, 233, 232, 230, 229, 227, 225, 223, 222, 
220, 217, 217, 214, 212, 210, 208, 206, 204, 202, 199, 197, 195, 193, 190, 
187, 185, 182, 180, 177, 174, 171, 169, 167, 165, 163, 161, 159, 157, 155, 
152, 150, 147, 144, 141, 139, 135, 130, 128, 124, 118, 116, 113, 109, 105, 
 99,  94,  86,  69,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  12, 154, 161, 166, 169, 172, 174, 176, 177, 177, 178, 
177, 179, 179, 180, 179, 180, 182, 183, 184, 186, 187, 188, 188, 190, 191, 
193, 193, 193, 195, 195, 197, 197, 197, 198, 200, 200, 201, 201, 202, 202, 
203, 204, 204, 205, 206, 207, 208, 208, 209, 210, 211, 212, 212, 214, 213, 
215, 215, 216, 216, 217, 217, 219, 220, 220, 221, 221, 222, 223, 223, 224, 
225, 226, 226, 227, 228, 229, 230, 231, 233, 233, 235, 237, 238, 239, 240, 
240, 242, 243, 244, 245, 246, 246, 248, 248, 250, 250, 252, 252, 253, 254, 
254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 250, 250, 249, 247, 
246, 244, 243, 242, 240, 238, 237, 235, 233, 231, 229, 228, 226, 224, 223, 
221, 219, 217, 215, 213, 211, 209, 207, 205, 203, 201, 198, 195, 193, 191, 
188, 186, 183, 181, 178, 176, 173, 170, 168, 166, 164, 161, 160, 158, 155, 
154, 151, 149, 146, 143, 140, 137, 133, 130, 126, 121, 118, 113, 111, 107, 
103,  99,  92,  86,  69,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  77, 156, 161, 167, 169, 172, 174, 176, 177, 177, 
179, 179, 179, 180, 180, 180, 181, 182, 183, 185, 186, 187, 188, 189, 191, 
191, 193, 193, 193, 195, 197, 197, 197, 198, 198, 200, 201, 201, 202, 202, 
203, 204, 204, 205, 206, 206, 207, 208, 209, 209, 210, 211, 212, 212, 213, 
214, 215, 216, 216, 217, 217, 219, 219, 220, 221, 221, 222, 222, 223, 224, 
225, 225, 225, 226, 227, 228, 229, 231, 232, 233, 234, 236, 237, 238, 239, 
240, 241, 243, 244, 244, 245, 246, 247, 248, 249, 250, 250, 252, 252, 253, 
254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 252, 252, 250, 249, 248, 
247, 245, 244, 242, 241, 239, 237, 236, 233, 232, 230, 228, 226, 225, 223, 
221, 219, 217, 216, 214, 212, 210, 208, 205, 204, 202, 199, 196, 195, 192, 
190, 188, 185, 182, 180, 177, 174, 171, 169, 166, 165, 162, 160, 159, 156, 
155, 152, 149, 147, 144, 141, 139, 135, 132, 128, 124, 118, 115, 111, 109, 
105, 102,  97,  92,  83,  64,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0, 128, 158, 163, 167, 170, 173, 174, 176, 177, 
177, 179, 180, 179, 179, 180, 180, 181, 183, 184, 185, 187, 188, 188, 190, 
191, 192, 193, 193, 195, 195, 196, 197, 197, 198, 199, 200, 201, 201, 202, 
203, 203, 203, 204, 205, 206, 206, 208, 208, 209, 210, 211, 211, 212, 212, 
213, 214, 215, 216, 216, 217, 217, 218, 219, 220, 221, 221, 222, 222, 224, 
224, 225, 225, 226, 226, 227, 229, 230, 231, 232, 233, 235, 236, 237, 238, 
240, 241, 242, 243, 244, 244, 246, 247, 247, 249, 250, 250, 252, 252, 253, 
254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253, 250, 249, 249, 
246, 245, 244, 243, 241, 240, 237, 236, 235, 233, 231, 229, 227, 225, 223, 
221, 220, 219, 216, 214, 213, 210, 209, 207, 204, 202, 200, 197, 195, 193, 
191, 188, 186, 183, 182, 178, 176, 173, 170, 168, 165, 163, 161, 159, 158, 
155, 153, 151, 148, 146, 143, 140, 137, 133, 130, 126, 121, 118, 113, 111, 
107, 103,  99,  94,  89,  80,  59,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0, 152, 159, 164, 167, 170, 172, 174, 176, 
177, 178, 179, 179, 180, 180, 180, 180, 182, 183, 185, 186, 186, 188, 188, 
190, 191, 192, 193, 193, 195, 195, 197, 197, 197, 198, 200, 200, 201, 202, 
202, 202, 203, 204, 205, 206, 206, 207, 208, 209, 209, 210, 211, 211, 212, 
213, 214, 214, 215, 216, 217, 217, 217, 219, 220, 220, 221, 221, 222, 223, 
224, 225, 225, 225, 226, 227, 228, 229, 231, 232, 233, 235, 235, 237, 238, 
238, 240, 241, 242, 243, 244, 245, 246, 247, 249, 249, 250, 250, 252, 253, 
253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253, 252, 250, 248, 
248, 246, 244, 243, 241, 240, 238, 237, 235, 233, 231, 230, 228, 225, 224, 
222, 221, 218, 217, 215, 213, 211, 209, 208, 205, 203, 201, 198, 197, 194, 
192, 188, 188, 185, 183, 180, 177, 174, 171, 169, 166, 164, 161, 160, 158, 
156, 154, 151, 149, 146, 144, 141, 139, 135, 132, 128, 123, 120, 115, 111, 
107, 105, 102,  99,  94,  86,  77,  36,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  36, 153, 160, 164, 168, 170, 173, 174, 
176, 177, 177, 179, 180, 180, 180, 180, 181, 182, 184, 185, 186, 187, 188, 
188, 191, 191, 192, 193, 193, 195, 195, 197, 197, 197, 198, 200, 200, 201, 
202, 202, 203, 203, 204, 205, 206, 207, 208, 208, 209, 209, 211, 211, 212, 
213, 213, 214, 215, 216, 217, 217, 217, 219, 220, 220, 220, 221, 222, 223, 
223, 224, 224, 225, 225, 226, 227, 228, 229, 231, 232, 233, 235, 236, 237, 
238, 239, 240, 241, 243, 244, 244, 245, 246, 247, 248, 249, 250, 250, 252, 
253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 
248, 246, 245, 243, 242, 241, 239, 237, 236, 233, 232, 230, 229, 227, 225, 
223, 221, 219, 217, 216, 214, 211, 210, 208, 206, 204, 202, 200, 197, 195, 
193, 191, 188, 186, 183, 181, 178, 176, 173, 170, 167, 165, 163, 160, 159, 
156, 154, 152, 150, 148, 145, 143, 139, 136, 132, 130, 126, 121, 118, 113, 
109, 105, 103,  99,  94,  89,  83,  73,  24,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  83, 154, 160, 164, 168, 170, 173, 
174, 175, 177, 177, 179, 180, 180, 180, 181, 182, 183, 184, 185, 186, 187, 
188, 188, 191, 191, 193, 193, 195, 195, 195, 197, 197, 198, 199, 200, 200, 
201, 202, 202, 203, 203, 204, 205, 206, 207, 208, 208, 210, 210, 211, 211, 
212, 213, 214, 215, 215, 216, 217, 217, 217, 219, 220, 220, 221, 221, 222, 
222, 223, 224, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 235, 236, 
238, 238, 239, 241, 242, 243, 244, 245, 246, 247, 248, 248, 249, 250, 252, 
252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 249, 
248, 247, 245, 244, 243, 241, 239, 238, 236, 235, 233, 231, 229, 228, 225, 
224, 221, 220, 217, 216, 215, 213, 211, 208, 207, 204, 202, 200, 197, 196, 
193, 191, 189, 187, 184, 182, 179, 176, 174, 170, 169, 166, 164, 161, 160, 
157, 155, 153, 151, 148, 146, 143, 141, 139, 133, 132, 128, 124, 120, 115, 
111, 107, 103,  99,  97,  94,  86,  80,  69,   2,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0, 141, 155, 160, 165, 168, 169, 
173, 174, 174, 177, 177, 179, 180, 180, 180, 181, 182, 183, 185, 186, 187, 
188, 188, 190, 191, 192, 193, 193, 195, 195, 197, 197, 197, 198, 199, 200, 
201, 202, 202, 203, 203, 204, 204, 205, 206, 207, 208, 209, 209, 211, 211, 
212, 212, 213, 215, 215, 216, 216, 217, 217, 217, 219, 219, 220, 221, 221, 
222, 223, 224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 232, 233, 235, 
237, 238, 238, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 250, 
252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 250, 
249, 247, 246, 244, 243, 241, 240, 238, 237, 235, 233, 232, 230, 228, 226, 
224, 222, 220, 217, 216, 214, 213, 211, 209, 207, 206, 204, 201, 198, 197, 
195, 192, 190, 188, 186, 183, 181, 178, 176, 173, 170, 167, 165, 161, 159, 
158, 156, 153, 151, 149, 147, 144, 141, 139, 135, 132, 129, 126, 121, 118, 
111, 109, 105, 102,  99,  94,  89,  86,  77,  64,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   2, 149, 155, 160, 164, 167, 
170, 172, 174, 176, 177, 177, 178, 180, 180, 180, 182, 183, 183, 184, 186, 
187, 188, 188, 190, 191, 192, 193, 193, 195, 195, 195, 197, 197, 198, 199, 
200, 200, 202, 202, 202, 203, 204, 205, 206, 207, 208, 208, 209, 209, 211, 
211, 212, 213, 213, 214, 215, 216, 216, 217, 217, 217, 219, 220, 220, 221, 
222, 222, 223, 224, 224, 225, 226, 226, 227, 228, 229, 231, 232, 233, 234, 
236, 237, 238, 239, 240, 242, 242, 244, 245, 245, 246, 248, 248, 249, 250, 
250, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253, 252, 250, 
249, 248, 246, 244, 244, 241, 241, 238, 237, 236, 233, 232, 230, 228, 227, 
224, 223, 221, 219, 217, 215, 213, 211, 209, 208, 206, 204, 202, 200, 197, 
195, 193, 191, 188, 186, 184, 181, 179, 176, 174, 170, 169, 166, 163, 160, 
159, 156, 154, 152, 150, 147, 144, 143, 139, 136, 133, 130, 126, 123, 118, 
115, 111, 105, 102,  99,  97,  92,  86,  80,  73,  59,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  64, 151, 156, 160, 164, 
168, 169, 172, 173, 174, 176, 177, 179, 179, 180, 180, 181, 183, 184, 185, 
186, 187, 188, 188, 190, 191, 192, 193, 193, 195, 195, 196, 197, 198, 198, 
199, 200, 201, 201, 202, 202, 203, 204, 206, 206, 207, 207, 208, 209, 210, 
211, 211, 212, 213, 214, 214, 216, 216, 217, 217, 218, 219, 219, 220, 220, 
222, 222, 222, 223, 224, 225, 225, 225, 226, 227, 229, 230, 231, 232, 233, 
235, 236, 237, 238, 240, 240, 242, 243, 244, 244, 246, 247, 247, 248, 250, 
250, 252, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
249, 248, 246, 245, 244, 243, 241, 239, 237, 236, 233, 232, 230, 229, 227, 
226, 224, 221, 220, 217, 216, 214, 212, 210, 208, 207, 205, 203, 200, 198, 
197, 193, 191, 190, 188, 185, 182, 180, 177, 174, 173, 170, 167, 164, 161, 
158, 156, 154, 152, 150, 148, 145, 143, 140, 137, 135, 130, 128, 124, 120, 
116, 113, 107, 103,  99,  97,  94,  89,  83,  80,  69,  36,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  73, 151, 156, 160, 
163, 167, 169, 170, 174, 174, 176, 177, 177, 179, 180, 181, 182, 183, 185, 
185, 186, 188, 188, 188, 190, 191, 192, 193, 193, 195, 195, 197, 197, 197, 
198, 199, 201, 201, 202, 202, 203, 204, 204, 205, 206, 207, 208, 209, 210, 
211, 211, 212, 213, 213, 214, 214, 216, 216, 217, 217, 217, 219, 220, 221, 
221, 222, 222, 223, 224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 233, 
233, 235, 236, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 
250, 250, 252, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
250, 248, 247, 245, 244, 243, 241, 240, 238, 236, 235, 233, 231, 230, 228, 
226, 224, 222, 220, 217, 216, 214, 212, 211, 209, 207, 205, 204, 201, 198, 
197, 195, 193, 191, 188, 186, 183, 181, 179, 176, 174, 170, 168, 165, 162, 
160, 157, 155, 153, 151, 149, 146, 143, 141, 137, 135, 132, 129, 126, 121, 
118, 113, 109, 105,  99,  97,  94,  92,  86,  83,  77,  64,   2,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 130, 151, 156, 
160, 164, 166, 169, 170, 172, 174, 176, 177, 177, 178, 180, 181, 182, 183, 
184, 185, 187, 187, 188, 189, 191, 191, 193, 193, 193, 195, 195, 197, 197, 
198, 198, 200, 200, 201, 202, 202, 203, 204, 205, 206, 207, 207, 208, 209, 
210, 211, 211, 212, 213, 214, 215, 215, 216, 216, 217, 217, 218, 219, 220, 
220, 221, 222, 223, 223, 224, 224, 225, 225, 227, 227, 228, 229, 231, 232, 
233, 235, 236, 236, 238, 238, 240, 242, 242, 243, 244, 245, 247, 248, 248, 
249, 250, 250, 250, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
250, 249, 247, 245, 244, 243, 241, 240, 239, 237, 235, 233, 232, 230, 228, 
226, 225, 223, 220, 219, 216, 215, 213, 211, 209, 208, 206, 204, 202, 199, 
197, 195, 193, 191, 188, 187, 185, 182, 179, 177, 174, 171, 169, 166, 164, 
161, 158, 155, 153, 151, 149, 146, 144, 141, 139, 136, 133, 130, 126, 123, 
120, 116, 111, 107, 102,  99,  94,  92,  89,  83,  77,  69,  53,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 146, 151, 
155, 160, 163, 165, 168, 170, 172, 173, 174, 176, 177, 179, 179, 181, 182, 
183, 185, 186, 187, 187, 188, 189, 191, 192, 193, 193, 193, 195, 195, 197, 
197, 198, 199, 200, 200, 201, 202, 202, 203, 204, 205, 206, 207, 207, 209, 
209, 210, 211, 212, 213, 213, 214, 214, 216, 216, 217, 217, 217, 219, 220, 
220, 221, 222, 222, 223, 223, 224, 224, 225, 226, 227, 227, 228, 230, 231, 
232, 233, 234, 236, 237, 238, 239, 240, 242, 243, 244, 244, 246, 247, 248, 
248, 249, 250, 252, 252, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253, 250, 
250, 249, 248, 246, 245, 243, 242, 240, 239, 237, 235, 233, 232, 230, 228, 
227, 225, 223, 221, 220, 217, 215, 213, 211, 210, 208, 206, 205, 202, 200, 
197, 195, 193, 191, 190, 187, 185, 182, 180, 177, 174, 172, 170, 167, 165, 
161, 159, 156, 153, 152, 149, 146, 145, 141, 139, 137, 133, 130, 128, 124, 
121, 116, 113, 109, 105,  99,  97,  92,  89,  86,  80,  73,  64,  24,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12, 146, 
151, 155, 159, 163, 165, 167, 170, 170, 173, 174, 176, 177, 177, 180, 180, 
182, 183, 184, 185, 187, 188, 188, 189, 191, 191, 193, 193, 195, 195, 196, 
197, 197, 198, 199, 200, 200, 201, 202, 203, 203, 204, 205, 206, 207, 208, 
209, 209, 211, 211, 212, 212, 213, 214, 215, 216, 216, 217, 217, 219, 219, 
220, 220, 221, 221, 222, 223, 223, 224, 225, 225, 226, 227, 228, 229, 230, 
231, 232, 233, 235, 236, 237, 238, 240, 241, 242, 243, 244, 245, 246, 246, 
247, 249, 250, 250, 250, 252, 253, 253, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
250, 249, 247, 246, 245, 244, 242, 241, 239, 237, 236, 234, 232, 231, 229, 
227, 225, 223, 222, 220, 217, 216, 214, 211, 210, 208, 207, 205, 203, 201, 
198, 197, 195, 192, 190, 188, 186, 183, 181, 178, 176, 173, 170, 168, 165, 
163, 160, 157, 154, 152, 150, 147, 144, 141, 140, 137, 135, 130, 129, 125, 
121, 118, 113, 111, 105, 102,  97,  94,  89,  86,  83,  77,  69,  59,   2, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  53, 
146, 150, 154, 159, 161, 165, 167, 169, 171, 173, 174, 176, 177, 177, 179, 
180, 182, 183, 184, 186, 187, 188, 188, 190, 191, 191, 193, 193, 195, 195, 
195, 197, 197, 197, 198, 200, 200, 202, 202, 203, 204, 205, 205, 206, 207, 
208, 209, 210, 210, 211, 212, 212, 214, 214, 215, 216, 216, 217, 217, 219, 
220, 220, 221, 221, 222, 222, 223, 224, 225, 225, 226, 226, 227, 228, 230, 
230, 231, 233, 233, 235, 237, 237, 239, 240, 241, 242, 243, 244, 245, 246, 
247, 248, 249, 250, 250, 252, 252, 253, 253, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 252, 252, 
250, 249, 248, 246, 245, 244, 243, 241, 239, 238, 236, 235, 233, 231, 229, 
228, 226, 224, 222, 220, 219, 216, 214, 212, 211, 209, 207, 205, 203, 201, 
199, 197, 195, 193, 191, 188, 186, 184, 182, 179, 177, 174, 172, 169, 167, 
164, 161, 158, 155, 152, 150, 148, 145, 143, 140, 139, 135, 132, 129, 126, 
123, 118, 115, 111, 107, 103,  99,  94,  92,  89,  83,  80,  73,  64,  45, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 77, 145, 150, 153, 157, 160, 164, 166, 168, 170, 173, 174, 174, 176, 177, 
179, 180, 181, 183, 184, 185, 187, 188, 188, 190, 191, 191, 193, 193, 193, 
195, 196, 197, 197, 198, 199, 200, 201, 201, 202, 202, 203, 204, 206, 207, 
207, 208, 209, 210, 211, 211, 212, 214, 214, 215, 216, 217, 217, 217, 219, 
219, 220, 220, 221, 222, 222, 223, 223, 224, 225, 225, 226, 226, 227, 228, 
229, 231, 232, 233, 233, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 
246, 247, 248, 249, 250, 250, 252, 253, 253, 254, 254, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 249, 248, 246, 245, 244, 243, 241, 240, 238, 237, 235, 233, 231, 230, 
228, 226, 224, 222, 220, 219, 217, 215, 213, 211, 209, 208, 206, 204, 202, 
200, 197, 195, 193, 192, 190, 187, 185, 183, 180, 177, 176, 173, 170, 167, 
164, 162, 159, 156, 153, 150, 148, 145, 143, 141, 139, 135, 132, 129, 128, 
123, 120, 116, 113, 109, 103,  99,  94,  92,  89,  86,  80,  73,  69,  59, 
 12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0, 133, 145, 148, 152, 156, 160, 163, 165, 167, 170, 171, 173, 174, 176, 
177, 177, 180, 182, 183, 184, 185, 186, 188, 188, 190, 191, 192, 193, 193, 
194, 195, 196, 197, 197, 198, 198, 200, 201, 201, 202, 202, 203, 205, 206, 
206, 208, 208, 210, 210, 211, 212, 213, 213, 214, 215, 216, 216, 217, 217, 
219, 219, 220, 220, 221, 222, 222, 223, 224, 224, 225, 226, 226, 227, 228, 
229, 230, 231, 232, 233, 234, 236, 237, 238, 239, 240, 242, 243, 243, 244, 
245, 247, 247, 248, 249, 250, 250, 252, 253, 253, 254, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 249, 248, 247, 245, 244, 242, 242, 240, 239, 237, 235, 233, 232, 230, 
229, 227, 224, 223, 221, 219, 217, 215, 214, 211, 209, 208, 206, 204, 202, 
200, 197, 195, 194, 192, 190, 188, 185, 183, 181, 179, 176, 174, 170, 168, 
165, 163, 160, 157, 154, 151, 149, 146, 143, 141, 139, 135, 133, 130, 128, 
123, 121, 118, 113, 109, 105, 102,  97,  92,  89,  86,  80,  77,  69,  59, 
 45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0, 133, 144, 148, 152, 155, 159, 161, 164, 167, 169, 170, 173, 174, 
174, 176, 178, 180, 181, 183, 183, 185, 186, 188, 188, 190, 191, 192, 193, 
193, 194, 195, 195, 196, 197, 198, 198, 200, 200, 201, 202, 202, 203, 204, 
206, 207, 208, 208, 209, 211, 211, 212, 213, 214, 214, 215, 216, 217, 217, 
217, 219, 220, 220, 221, 221, 222, 223, 223, 224, 225, 225, 225, 226, 227, 
228, 229, 230, 232, 232, 233, 235, 236, 237, 238, 240, 240, 242, 243, 244, 
244, 246, 246, 247, 249, 249, 250, 250, 252, 253, 253, 254, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 250, 248, 247, 246, 244, 244, 241, 240, 238, 237, 236, 233, 232, 231, 
228, 227, 225, 223, 221, 219, 217, 215, 214, 212, 210, 208, 206, 204, 203, 
200, 198, 197, 195, 193, 190, 188, 186, 183, 182, 179, 177, 174, 172, 169, 
167, 164, 161, 158, 155, 152, 148, 146, 144, 141, 139, 136, 133, 130, 128, 
124, 121, 118, 115, 111, 107, 102,  99,  94,  89,  86,  80,  77,  69,  64, 
 53,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  12, 139, 143, 147, 150, 154, 157, 160, 163, 166, 168, 169, 170, 
174, 174, 176, 177, 179, 181, 183, 183, 185, 186, 188, 188, 189, 191, 191, 
193, 193, 193, 195, 195, 197, 197, 198, 199, 200, 200, 201, 202, 203, 204, 
205, 206, 207, 208, 209, 210, 210, 212, 212, 213, 214, 215, 216, 216, 217, 
217, 219, 219, 219, 221, 221, 222, 222, 223, 224, 224, 224, 226, 226, 227, 
227, 228, 229, 230, 232, 233, 233, 236, 237, 238, 239, 240, 241, 242, 243, 
244, 244, 246, 246, 247, 249, 249, 250, 252, 252, 252, 253, 254, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 250, 248, 247, 246, 244, 243, 242, 240, 239, 237, 236, 233, 232, 231, 
229, 227, 225, 223, 222, 220, 217, 216, 214, 212, 210, 209, 206, 205, 203, 
201, 198, 197, 195, 193, 191, 188, 187, 184, 182, 180, 177, 174, 173, 170, 
167, 165, 161, 158, 156, 152, 149, 147, 144, 141, 139, 136, 133, 130, 128, 
124, 121, 118, 115, 111, 107, 102,  99,  94,  89,  86,  80,  77,  73,  64, 
 59,  45,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  12, 137, 143, 146, 149, 152, 156, 159, 161, 165, 167, 169, 
170, 172, 173, 176, 177, 179, 181, 182, 183, 184, 186, 187, 188, 188, 190, 
191, 193, 193, 194, 195, 195, 196, 197, 198, 198, 200, 200, 201, 202, 203, 
204, 205, 206, 207, 208, 209, 209, 211, 212, 212, 213, 214, 215, 215, 216, 
217, 217, 219, 220, 220, 220, 221, 222, 222, 224, 224, 224, 225, 226, 226, 
227, 228, 228, 230, 231, 232, 233, 235, 235, 236, 238, 239, 239, 241, 242, 
243, 244, 245, 246, 247, 248, 249, 249, 250, 250, 252, 253, 254, 254, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 253, 252, 
250, 249, 248, 247, 246, 245, 243, 242, 241, 239, 237, 236, 234, 232, 231, 
229, 228, 225, 224, 222, 220, 219, 216, 214, 213, 211, 208, 207, 205, 203, 
201, 199, 197, 195, 193, 191, 189, 187, 185, 183, 181, 177, 176, 173, 170, 
168, 165, 163, 160, 156, 154, 150, 147, 144, 141, 139, 136, 133, 130, 128, 
124, 121, 118, 115, 111, 107, 103,  99,  94,  89,  86,  83,  77,  73,  69, 
 59,  53,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  24, 135, 141, 145, 148, 151, 155, 158, 161, 163, 166, 
168, 170, 170, 173, 176, 177, 178, 180, 181, 183, 184, 186, 186, 188, 188, 
191, 192, 193, 193, 193, 195, 195, 197, 197, 198, 198, 200, 200, 201, 202, 
204, 205, 205, 206, 208, 208, 209, 210, 211, 212, 212, 213, 214, 215, 216, 
216, 217, 217, 219, 219, 220, 221, 221, 222, 223, 223, 224, 225, 225, 225, 
226, 227, 228, 229, 230, 231, 233, 233, 235, 236, 237, 238, 239, 240, 241, 
242, 243, 244, 245, 246, 246, 248, 249, 249, 250, 250, 252, 253, 253, 254, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 
250, 250, 248, 247, 246, 245, 244, 242, 240, 239, 238, 236, 233, 233, 231, 
229, 228, 226, 224, 222, 220, 218, 216, 214, 212, 211, 209, 207, 205, 203, 
202, 199, 197, 195, 193, 192, 190, 188, 185, 183, 181, 179, 176, 174, 170, 
169, 166, 163, 161, 158, 155, 152, 148, 145, 141, 139, 136, 133, 130, 128, 
124, 121, 118, 115, 111, 107, 103,  99,  94,  92,  86,  80,  77,  73,  69, 
 64,  53,  36,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  36, 133, 140, 144, 148, 150, 153, 156, 159, 163, 
164, 167, 168, 170, 173, 174, 176, 177, 180, 181, 183, 184, 185, 186, 187, 
188, 189, 191, 192, 193, 194, 195, 195, 196, 197, 197, 198, 199, 200, 201, 
202, 203, 204, 206, 206, 207, 208, 209, 210, 211, 212, 213, 213, 215, 215, 
216, 216, 217, 218, 219, 220, 221, 221, 221, 222, 223, 224, 224, 225, 225, 
225, 226, 227, 228, 229, 230, 231, 233, 233, 235, 236, 238, 238, 239, 240, 
241, 242, 243, 244, 245, 246, 247, 247, 249, 249, 250, 250, 252, 253, 253, 
254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 250, 
250, 249, 248, 246, 246, 244, 243, 242, 240, 239, 238, 235, 235, 232, 231, 
229, 228, 226, 224, 222, 220, 219, 217, 215, 213, 211, 209, 208, 205, 203, 
202, 200, 197, 196, 195, 192, 190, 188, 186, 185, 182, 179, 177, 174, 172, 
170, 167, 164, 161, 158, 155, 152, 148, 146, 141, 139, 136, 133, 130, 128, 
124, 121, 118, 115, 111, 107, 103,  99,  97,  92,  86,  80,  77,  73,  69, 
 64,  53,  45,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  59, 132, 139, 143, 146, 149, 152, 155, 159, 
161, 163, 166, 168, 170, 172, 173, 176, 177, 179, 180, 182, 183, 185, 186, 
187, 188, 190, 190, 192, 193, 193, 195, 195, 197, 197, 197, 198, 200, 200, 
201, 202, 203, 204, 206, 207, 208, 208, 209, 210, 211, 212, 213, 214, 215, 
215, 216, 217, 217, 219, 219, 220, 220, 222, 222, 222, 223, 224, 224, 225, 
226, 226, 226, 227, 228, 230, 230, 231, 233, 233, 235, 237, 238, 238, 239, 
240, 241, 242, 243, 244, 245, 246, 247, 248, 248, 250, 250, 252, 252, 253, 
253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
250, 249, 248, 246, 245, 244, 243, 241, 240, 239, 237, 235, 233, 232, 231, 
230, 227, 226, 224, 222, 220, 219, 217, 215, 213, 211, 209, 207, 205, 203, 
202, 200, 197, 197, 194, 192, 190, 188, 186, 184, 182, 179, 177, 174, 172, 
170, 167, 164, 161, 158, 155, 152, 149, 146, 141, 139, 135, 132, 130, 128, 
124, 121, 118, 115, 111, 107, 103,  99,  97,  92,  86,  83,  77,  73,  69, 
 64,  59,  45,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  59, 129, 137, 141, 145, 148, 151, 153, 
157, 160, 161, 165, 167, 169, 170, 173, 174, 177, 179, 180, 182, 183, 184, 
186, 187, 188, 188, 190, 191, 193, 193, 195, 195, 197, 197, 197, 198, 199, 
200, 201, 202, 204, 204, 205, 207, 208, 208, 210, 210, 212, 212, 213, 214, 
215, 216, 216, 217, 217, 219, 220, 220, 220, 221, 222, 223, 223, 224, 224, 
225, 225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 237, 237, 238, 
239, 241, 241, 243, 243, 244, 245, 246, 247, 248, 249, 250, 250, 252, 252, 
253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 250, 
250, 248, 247, 246, 245, 244, 242, 241, 240, 238, 237, 236, 233, 232, 230, 
229, 227, 226, 224, 222, 221, 219, 217, 214, 213, 211, 209, 207, 205, 203, 
202, 200, 197, 196, 193, 192, 191, 188, 186, 184, 182, 180, 177, 174, 173, 
169, 167, 165, 161, 159, 156, 153, 149, 146, 143, 139, 135, 132, 130, 126, 
124, 121, 118, 115, 111, 107, 103,  99,  97,  92,  86,  83,  77,  73,  69, 
 64,  59,  45,  36,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  59, 128, 135, 140, 144, 147, 150, 
152, 155, 158, 161, 164, 165, 168, 170, 172, 174, 176, 177, 180, 181, 183, 
184, 185, 186, 188, 188, 190, 191, 192, 193, 193, 195, 195, 197, 197, 198, 
198, 200, 201, 202, 204, 205, 206, 207, 208, 209, 210, 211, 211, 212, 214, 
214, 215, 216, 217, 217, 217, 219, 220, 220, 221, 221, 222, 223, 224, 224, 
224, 225, 226, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 237, 237, 
238, 239, 241, 241, 243, 243, 244, 245, 246, 247, 248, 248, 249, 250, 250, 
252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 250, 250, 
250, 248, 248, 246, 244, 243, 243, 240, 239, 238, 237, 235, 233, 232, 230, 
228, 227, 226, 224, 222, 220, 219, 217, 214, 212, 211, 209, 207, 205, 203, 
202, 199, 197, 195, 193, 192, 190, 188, 187, 184, 182, 179, 177, 176, 173, 
170, 167, 165, 161, 159, 156, 153, 150, 146, 143, 139, 135, 132, 129, 126, 
123, 120, 118, 113, 111, 107, 103,  99,  97,  92,  86,  83,  77,  73,  69, 
 64,  59,  53,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  83, 124, 133, 139, 143, 146, 
149, 151, 154, 157, 160, 163, 164, 167, 169, 172, 174, 176, 177, 179, 181, 
182, 183, 185, 186, 187, 188, 189, 190, 191, 193, 193, 195, 195, 197, 197, 
198, 198, 200, 201, 203, 204, 205, 206, 207, 208, 209, 210, 211, 211, 212, 
214, 214, 215, 216, 216, 217, 217, 219, 220, 220, 221, 222, 222, 223, 223, 
224, 225, 225, 226, 227, 227, 228, 229, 230, 231, 232, 233, 235, 236, 237, 
238, 238, 239, 240, 242, 243, 243, 244, 245, 246, 247, 248, 248, 249, 250, 
250, 252, 252, 253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 250, 250, 
250, 248, 247, 245, 244, 243, 242, 241, 239, 238, 237, 235, 233, 232, 231, 
228, 226, 225, 223, 222, 220, 217, 216, 214, 212, 211, 209, 207, 205, 203, 
201, 199, 197, 195, 193, 192, 190, 188, 186, 183, 182, 180, 177, 174, 173, 
170, 167, 165, 161, 159, 156, 152, 149, 146, 143, 140, 136, 132, 128, 126, 
123, 120, 118, 113, 111, 107, 103,  99,  97,  92,  89,  83,  77,  73,  69, 
 64,  59,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  73, 123, 130, 137, 141, 
144, 147, 150, 152, 155, 159, 161, 163, 166, 168, 170, 173, 174, 177, 178, 
180, 181, 183, 184, 186, 186, 188, 188, 190, 192, 192, 193, 194, 195, 196, 
197, 198, 199, 200, 201, 202, 204, 205, 206, 207, 208, 209, 210, 211, 212, 
213, 214, 214, 215, 216, 217, 217, 217, 219, 220, 221, 221, 222, 223, 223, 
224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 232, 233, 233, 235, 236, 
237, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 247, 247, 249, 249, 
250, 250, 252, 253, 253, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 252, 252, 250, 
249, 248, 247, 245, 244, 242, 242, 241, 239, 238, 236, 235, 233, 231, 230, 
229, 227, 225, 223, 221, 220, 217, 216, 214, 212, 211, 209, 207, 205, 203, 
201, 199, 197, 195, 193, 192, 190, 188, 186, 183, 181, 179, 177, 174, 173, 
170, 168, 165, 161, 159, 156, 153, 150, 146, 143, 139, 136, 132, 128, 125, 
121, 120, 116, 113, 111, 107, 103,  99,  97,  92,  86,  83,  80,  73,  69, 
 64,  59,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  69, 118, 129, 135, 
139, 143, 146, 149, 151, 153, 156, 159, 161, 164, 167, 170, 172, 174, 176, 
177, 180, 181, 182, 184, 185, 186, 188, 188, 190, 191, 192, 193, 193, 195, 
195, 197, 197, 198, 200, 201, 202, 204, 205, 206, 207, 208, 209, 211, 211, 
212, 213, 214, 215, 216, 216, 217, 217, 218, 219, 220, 220, 222, 222, 222, 
223, 224, 224, 225, 226, 227, 227, 228, 229, 230, 231, 232, 233, 233, 235, 
236, 237, 238, 239, 240, 240, 242, 243, 243, 244, 245, 246, 247, 247, 248, 
249, 250, 250, 252, 252, 253, 253, 254, 254, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 252, 250, 250, 
249, 247, 246, 245, 244, 243, 241, 240, 238, 237, 235, 234, 232, 231, 230, 
228, 226, 225, 223, 221, 219, 217, 216, 214, 212, 210, 209, 206, 205, 202, 
201, 198, 197, 195, 193, 191, 188, 188, 186, 183, 181, 179, 177, 174, 172, 
169, 167, 164, 161, 158, 156, 153, 150, 146, 143, 140, 136, 132, 128, 124, 
121, 118, 115, 113, 109, 107, 103,  99,  94,  92,  86,  83,  80,  73,  69, 
 59,  59,  53,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  59, 116, 126, 
133, 139, 141, 145, 148, 150, 152, 155, 157, 160, 164, 167, 169, 171, 174, 
175, 177, 179, 180, 182, 183, 185, 186, 187, 188, 188, 190, 191, 192, 193, 
194, 195, 197, 197, 198, 200, 201, 203, 204, 206, 206, 207, 209, 209, 211, 
211, 212, 213, 214, 215, 215, 216, 217, 217, 219, 220, 220, 221, 221, 222, 
223, 223, 224, 225, 225, 226, 227, 227, 228, 229, 230, 231, 232, 233, 234, 
235, 236, 238, 238, 239, 240, 241, 242, 243, 244, 244, 245, 246, 247, 248, 
248, 249, 250, 250, 250, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 252, 250, 249, 
248, 247, 245, 244, 243, 242, 240, 240, 239, 237, 235, 233, 232, 231, 229, 
228, 226, 224, 223, 221, 219, 217, 215, 213, 211, 209, 208, 206, 205, 203, 
201, 198, 196, 193, 193, 191, 188, 187, 185, 183, 181, 179, 176, 174, 172, 
169, 167, 164, 161, 158, 155, 153, 150, 147, 143, 140, 136, 132, 128, 124, 
121, 118, 115, 111, 109, 105, 102,  99,  94,  92,  86,  83,  77,  73,  69, 
 59,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45, 111, 
123, 130, 136, 139, 143, 146, 148, 151, 153, 156, 159, 162, 165, 168, 170, 
172, 174, 176, 177, 179, 181, 182, 184, 185, 186, 187, 188, 190, 191, 192, 
193, 193, 195, 197, 197, 197, 200, 202, 203, 204, 206, 206, 207, 208, 210, 
211, 211, 212, 213, 214, 215, 216, 217, 217, 217, 219, 220, 220, 221, 222, 
223, 223, 224, 224, 225, 225, 226, 227, 227, 229, 229, 230, 231, 232, 233, 
235, 235, 236, 237, 238, 239, 240, 241, 241, 243, 244, 245, 245, 246, 246, 
248, 248, 249, 250, 250, 250, 252, 252, 253, 253, 254, 255, 254, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 254, 254, 253, 253, 252, 250, 250, 249, 
248, 246, 245, 244, 243, 242, 240, 239, 237, 236, 235, 233, 232, 230, 229, 
227, 225, 224, 222, 220, 219, 216, 215, 213, 211, 209, 208, 206, 204, 202, 
200, 198, 195, 195, 193, 191, 188, 187, 184, 183, 180, 179, 176, 174, 171, 
169, 167, 164, 161, 158, 155, 153, 149, 146, 143, 139, 136, 133, 128, 124, 
120, 118, 115, 111, 107, 105, 102,  99,  94,  89,  86,  83,  77,  73,  69, 
 59,  53,  45,  36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36, 
107, 121, 128, 133, 139, 141, 144, 147, 149, 152, 154, 157, 161, 164, 167, 
169, 172, 174, 176, 177, 178, 181, 181, 183, 184, 186, 187, 188, 188, 190, 
191, 192, 193, 194, 195, 197, 198, 200, 201, 203, 204, 205, 206, 207, 209, 
209, 211, 212, 212, 214, 214, 215, 216, 217, 217, 218, 219, 220, 221, 221, 
222, 222, 223, 224, 224, 225, 226, 226, 227, 228, 229, 229, 231, 231, 232, 
233, 235, 236, 236, 238, 238, 239, 240, 241, 242, 243, 243, 244, 245, 246, 
246, 247, 248, 249, 249, 250, 250, 250, 252, 252, 253, 254, 254, 254, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 254, 253, 253, 252, 250, 250, 250, 249, 
248, 246, 245, 244, 242, 241, 240, 238, 237, 236, 233, 233, 231, 230, 229, 
227, 225, 223, 222, 220, 217, 216, 215, 213, 211, 209, 207, 205, 204, 202, 
200, 197, 195, 193, 192, 190, 188, 186, 185, 182, 180, 177, 176, 173, 170, 
169, 166, 164, 161, 158, 155, 152, 149, 146, 143, 139, 136, 132, 128, 124, 
120, 116, 113, 111, 107, 103, 102,  97,  94,  89,  86,  83,  77,  73,  69, 
 59,  53,  45,  36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 24, 102, 118, 126, 132, 136, 140, 143, 146, 148, 151, 153, 156, 160, 163, 
166, 168, 170, 172, 174, 176, 179, 179, 181, 183, 183, 185, 186, 188, 188, 
188, 191, 191, 193, 193, 195, 195, 197, 199, 202, 203, 205, 205, 207, 207, 
209, 210, 211, 211, 213, 213, 214, 215, 216, 217, 217, 218, 220, 220, 220, 
221, 222, 222, 223, 224, 224, 225, 225, 226, 227, 228, 229, 230, 231, 232, 
233, 233, 235, 235, 236, 237, 238, 239, 240, 241, 242, 242, 244, 244, 245, 
246, 246, 247, 248, 248, 249, 249, 250, 250, 252, 252, 252, 253, 253, 254, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 254, 253, 253, 253, 252, 250, 250, 249, 248, 
247, 246, 244, 243, 241, 241, 240, 238, 237, 236, 233, 232, 231, 229, 228, 
226, 224, 223, 222, 220, 217, 216, 214, 213, 211, 209, 207, 205, 203, 201, 
199, 197, 195, 193, 191, 190, 188, 186, 184, 182, 180, 177, 176, 173, 170, 
168, 165, 162, 160, 157, 155, 152, 148, 145, 143, 139, 136, 132, 128, 124, 
120, 116, 111, 109, 107, 103,  99,  97,  94,  89,  86,  83,  77,  73,  64, 
 59,  53,  45,  36,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  12,  97, 113, 123, 129, 133, 139, 141, 144, 147, 149, 151, 155, 158, 
161, 165, 167, 169, 172, 174, 175, 177, 179, 181, 182, 183, 184, 185, 187, 
188, 188, 190, 191, 192, 193, 194, 195, 197, 199, 201, 202, 204, 205, 207, 
208, 209, 210, 211, 211, 213, 214, 214, 216, 216, 217, 217, 219, 219, 220, 
221, 221, 222, 223, 223, 224, 225, 225, 226, 226, 227, 228, 229, 230, 231, 
231, 233, 233, 235, 236, 237, 237, 238, 239, 240, 241, 242, 242, 244, 244, 
245, 245, 246, 247, 248, 248, 249, 249, 250, 250, 252, 252, 253, 253, 253, 
253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 254, 254, 253, 253, 252, 252, 250, 250, 250, 248, 247, 
247, 246, 244, 243, 241, 241, 239, 237, 236, 235, 233, 232, 231, 229, 228, 
226, 224, 222, 221, 220, 217, 215, 214, 212, 210, 208, 206, 205, 202, 200, 
198, 196, 194, 193, 191, 188, 187, 185, 183, 180, 179, 176, 174, 172, 170, 
168, 165, 163, 159, 157, 154, 151, 148, 145, 141, 139, 135, 132, 128, 124, 
120, 116, 111, 109, 105, 102,  99,  97,  92,  89,  86,  80,  77,  73,  64, 
 59,  53,  45,  36,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   2,  89, 109, 120, 128, 132, 136, 139, 141, 145, 148, 150, 153, 
157, 160, 163, 166, 169, 170, 173, 174, 176, 177, 180, 181, 182, 184, 185, 
186, 187, 188, 188, 190, 192, 193, 193, 195, 197, 198, 201, 202, 204, 206, 
207, 208, 209, 210, 211, 212, 213, 213, 215, 216, 216, 217, 217, 219, 220, 
220, 220, 221, 222, 222, 223, 224, 225, 225, 225, 227, 227, 229, 229, 230, 
231, 232, 233, 233, 235, 236, 237, 237, 239, 239, 240, 241, 241, 243, 243, 
244, 244, 245, 246, 247, 247, 248, 248, 249, 250, 250, 250, 250, 252, 252, 
253, 253, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 254, 254, 254, 253, 253, 252, 252, 252, 250, 250, 249, 248, 247, 
246, 245, 244, 243, 241, 240, 238, 237, 236, 234, 233, 231, 230, 229, 227, 
225, 224, 222, 220, 219, 217, 215, 213, 212, 210, 208, 206, 204, 202, 201, 
198, 195, 195, 193, 190, 188, 186, 184, 182, 181, 178, 176, 174, 172, 170, 
167, 164, 161, 159, 157, 153, 151, 148, 145, 141, 139, 135, 132, 128, 124, 
118, 116, 111, 107, 105, 102,  99,  94,  92,  89,  83,  80,  77,  73,  64, 
 59,  53,  45,  36,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  80, 105, 118, 125, 130, 133, 137, 140, 143, 146, 149, 
152, 155, 159, 163, 165, 167, 169, 170, 174, 176, 176, 179, 180, 182, 182, 
184, 185, 186, 188, 188, 190, 191, 192, 193, 193, 196, 197, 200, 202, 204, 
205, 206, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217, 217, 217, 
220, 220, 221, 221, 222, 223, 223, 224, 225, 225, 226, 227, 227, 229, 229, 
230, 231, 232, 233, 235, 235, 236, 237, 238, 238, 239, 240, 241, 242, 243, 
243, 244, 244, 245, 246, 246, 247, 248, 249, 249, 250, 250, 250, 250, 252, 
252, 252, 253, 253, 253, 254, 254, 254, 254, 254, 254, 255, 254, 255, 254, 
254, 254, 254, 253, 253, 253, 252, 252, 252, 250, 250, 249, 249, 248, 247, 
246, 244, 243, 242, 241, 239, 238, 237, 235, 233, 232, 231, 229, 228, 226, 
225, 223, 222, 220, 219, 217, 214, 213, 211, 209, 207, 205, 204, 202, 199, 
197, 195, 193, 191, 190, 188, 185, 184, 182, 180, 177, 176, 173, 170, 169, 
166, 164, 161, 159, 155, 153, 151, 148, 144, 141, 139, 133, 130, 128, 124, 
118, 115, 111, 107, 103, 102,  97,  94,  89,  86,  83,  80,  77,  69,  64, 
 59,  53,  45,  36,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  73, 102, 113, 121, 128, 132, 135, 139, 141, 144, 
146, 151, 154, 158, 161, 164, 167, 168, 170, 173, 174, 176, 177, 179, 180, 
182, 183, 184, 186, 187, 188, 188, 191, 191, 193, 193, 195, 197, 200, 202, 
203, 205, 206, 208, 209, 210, 211, 212, 213, 214, 215, 215, 216, 217, 217, 
219, 219, 220, 221, 222, 222, 223, 223, 224, 225, 226, 226, 227, 228, 228, 
229, 230, 231, 232, 233, 233, 235, 235, 237, 238, 238, 239, 240, 241, 242, 
243, 243, 244, 244, 245, 246, 246, 247, 248, 248, 248, 249, 250, 250, 250, 
252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 253, 
253, 253, 253, 253, 252, 252, 252, 252, 250, 250, 249, 249, 248, 247, 246, 
245, 244, 243, 242, 241, 239, 238, 236, 235, 233, 232, 231, 229, 228, 226, 
224, 222, 221, 219, 217, 216, 214, 212, 211, 209, 207, 205, 203, 201, 199, 
197, 195, 193, 191, 189, 187, 185, 183, 181, 179, 176, 174, 173, 170, 168, 
166, 163, 161, 158, 155, 153, 150, 146, 144, 141, 137, 135, 130, 128, 123, 
118, 116, 111, 105, 103,  99,  97,  94,  89,  86,  83,  80,  73,  69,  64, 
 59,  53,  45,  36,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  64,  94, 111, 118, 125, 129, 133, 136, 140, 
143, 145, 149, 153, 156, 160, 162, 165, 167, 169, 171, 173, 174, 177, 177, 
180, 181, 183, 183, 185, 186, 187, 188, 189, 191, 191, 193, 195, 197, 199, 
201, 203, 204, 206, 207, 209, 211, 212, 212, 213, 214, 215, 216, 216, 217, 
217, 219, 219, 220, 220, 222, 222, 223, 224, 224, 225, 225, 226, 227, 228, 
229, 230, 230, 231, 233, 233, 233, 235, 236, 236, 237, 238, 239, 240, 241, 
242, 242, 243, 244, 244, 245, 245, 246, 246, 247, 248, 248, 249, 249, 250, 
250, 250, 250, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 
253, 253, 253, 253, 252, 252, 252, 250, 250, 250, 249, 248, 247, 246, 245, 
245, 243, 242, 242, 239, 238, 237, 236, 233, 233, 231, 229, 228, 227, 225, 
223, 222, 221, 219, 217, 215, 213, 212, 210, 208, 207, 205, 202, 200, 198, 
197, 194, 193, 191, 188, 187, 185, 183, 181, 177, 176, 174, 172, 170, 167, 
165, 163, 160, 157, 154, 151, 149, 146, 143, 140, 137, 133, 130, 128, 123, 
118, 115, 111, 107, 102,  99,  94,  92,  89,  86,  83,  77,  73,  69,  64, 
 59,  53,  45,  36,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  45,  89, 105, 116, 123, 128, 132, 135, 
137, 140, 144, 148, 151, 155, 158, 161, 164, 166, 168, 170, 173, 174, 175, 
177, 179, 180, 181, 182, 184, 185, 186, 187, 188, 189, 191, 193, 195, 197, 
198, 200, 203, 204, 205, 207, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
217, 217, 219, 220, 220, 221, 222, 222, 223, 224, 224, 225, 226, 227, 227, 
228, 228, 229, 231, 231, 232, 233, 233, 235, 235, 237, 238, 238, 239, 240, 
240, 241, 242, 243, 244, 244, 245, 245, 246, 246, 247, 248, 248, 248, 249, 
249, 250, 250, 250, 250, 250, 252, 252, 252, 252, 253, 252, 253, 252, 252, 
252, 252, 252, 252, 252, 250, 250, 250, 250, 249, 248, 248, 246, 245, 245, 
244, 243, 242, 241, 239, 238, 237, 235, 233, 232, 230, 229, 227, 226, 224, 
223, 222, 220, 217, 217, 215, 213, 211, 209, 208, 206, 204, 202, 199, 197, 
196, 193, 193, 190, 188, 186, 184, 182, 179, 177, 176, 173, 171, 169, 167, 
164, 161, 159, 156, 154, 151, 148, 145, 143, 139, 136, 133, 129, 126, 121, 
118, 113, 111, 105, 102,  97,  94,  92,  89,  83,  80,  77,  73,  69,  64, 
 59,  53,  45,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  24,  83, 103, 113, 120, 125, 129, 
133, 136, 139, 141, 146, 150, 154, 157, 160, 162, 165, 167, 170, 170, 173, 
174, 176, 177, 179, 180, 182, 183, 184, 185, 186, 188, 188, 191, 193, 194, 
197, 198, 200, 202, 203, 205, 206, 208, 210, 211, 212, 213, 214, 215, 216, 
216, 217, 217, 219, 220, 220, 221, 222, 223, 223, 224, 224, 225, 226, 226, 
227, 228, 229, 229, 230, 232, 232, 233, 234, 235, 236, 236, 237, 238, 239, 
240, 241, 241, 242, 242, 243, 244, 244, 245, 245, 246, 246, 247, 248, 248, 
248, 249, 250, 249, 250, 250, 250, 250, 250, 252, 252, 252, 252, 252, 250, 
252, 252, 252, 250, 250, 250, 250, 249, 249, 249, 248, 246, 246, 245, 244, 
243, 242, 242, 240, 238, 237, 236, 234, 233, 231, 230, 228, 227, 225, 224, 
222, 221, 219, 217, 215, 214, 212, 211, 209, 207, 205, 203, 202, 198, 197, 
195, 193, 191, 188, 187, 185, 183, 181, 179, 177, 174, 172, 170, 168, 166, 
164, 161, 159, 156, 154, 151, 148, 145, 141, 139, 135, 132, 128, 125, 121, 
118, 113, 111, 105, 102,  97,  94,  89,  86,  83,  80,  77,  73,  69,  64, 
 59,  59,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  77,  99, 109, 116, 123, 
126, 130, 133, 137, 140, 145, 148, 152, 155, 158, 161, 163, 165, 168, 169, 
170, 174, 174, 176, 177, 179, 180, 182, 183, 185, 185, 186, 188, 190, 192, 
193, 195, 197, 199, 201, 203, 204, 206, 208, 209, 210, 212, 213, 214, 215, 
216, 216, 217, 217, 219, 220, 220, 221, 222, 223, 223, 224, 225, 225, 225, 
226, 227, 228, 229, 230, 231, 231, 233, 233, 233, 235, 235, 236, 237, 238, 
239, 239, 240, 241, 241, 242, 243, 243, 244, 244, 245, 246, 246, 247, 247, 
248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, 250, 250, 
250, 250, 250, 250, 250, 249, 249, 249, 248, 247, 246, 246, 245, 244, 244, 
243, 241, 241, 239, 238, 236, 236, 233, 232, 230, 229, 228, 227, 224, 224, 
221, 220, 219, 217, 215, 213, 212, 210, 208, 207, 205, 203, 200, 198, 197, 
194, 193, 191, 188, 187, 185, 183, 180, 179, 176, 174, 171, 169, 168, 165, 
162, 160, 157, 155, 152, 150, 146, 144, 141, 139, 135, 130, 128, 124, 120, 
116, 113, 109, 105,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 64,  53,  53,  45,  36,  36,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  64,  92, 105, 113, 
120, 124, 128, 132, 135, 139, 143, 146, 151, 153, 156, 160, 163, 164, 166, 
169, 170, 172, 174, 174, 177, 177, 180, 181, 182, 183, 185, 186, 187, 188, 
192, 193, 195, 196, 198, 200, 202, 204, 206, 207, 208, 209, 212, 212, 214, 
214, 216, 217, 217, 217, 219, 220, 221, 221, 222, 223, 224, 224, 225, 225, 
226, 226, 227, 228, 229, 230, 231, 231, 233, 233, 233, 234, 236, 237, 237, 
238, 239, 239, 240, 241, 242, 242, 243, 243, 244, 244, 244, 245, 245, 246, 
246, 247, 247, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, 
250, 249, 249, 249, 249, 248, 248, 248, 247, 247, 246, 245, 244, 244, 243, 
242, 241, 240, 238, 238, 237, 235, 233, 231, 231, 228, 227, 225, 224, 223, 
221, 220, 217, 216, 214, 212, 211, 209, 208, 205, 204, 202, 200, 198, 197, 
193, 192, 190, 188, 186, 183, 182, 180, 177, 175, 174, 170, 168, 166, 164, 
161, 159, 157, 154, 152, 149, 146, 143, 140, 137, 133, 130, 126, 123, 120, 
116, 111, 107, 103,  99,  94,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 59,  59,  53,  45,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45,  86, 102, 
111, 118, 121, 125, 129, 132, 136, 140, 145, 148, 152, 155, 158, 160, 163, 
165, 167, 169, 170, 173, 174, 176, 177, 178, 180, 181, 182, 183, 185, 186, 
188, 191, 192, 193, 195, 198, 200, 202, 203, 205, 206, 207, 209, 210, 212, 
213, 214, 216, 216, 217, 217, 219, 220, 220, 221, 222, 222, 223, 223, 225, 
225, 225, 227, 227, 228, 229, 230, 230, 231, 232, 233, 233, 235, 235, 237, 
237, 237, 238, 239, 240, 241, 241, 241, 242, 242, 244, 244, 244, 244, 245, 
245, 246, 246, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 249, 249, 
249, 249, 249, 248, 248, 248, 248, 247, 246, 246, 245, 244, 244, 243, 243, 
241, 241, 239, 238, 237, 235, 233, 233, 231, 230, 228, 227, 225, 223, 222, 
220, 219, 217, 215, 214, 212, 211, 209, 207, 205, 203, 202, 199, 197, 195, 
193, 192, 188, 188, 186, 183, 181, 179, 177, 174, 172, 170, 168, 166, 163, 
161, 158, 156, 153, 150, 148, 145, 141, 139, 136, 132, 130, 126, 123, 118, 
115, 111, 107, 103,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 64,  59,  53,  45,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24,  80, 
 97, 107, 113, 118, 123, 128, 130, 135, 139, 143, 147, 150, 153, 157, 159, 
161, 164, 166, 168, 170, 170, 173, 174, 176, 177, 179, 180, 182, 183, 184, 
186, 187, 190, 191, 193, 195, 197, 198, 201, 203, 204, 206, 207, 209, 210, 
211, 212, 214, 215, 217, 217, 217, 219, 220, 220, 221, 221, 222, 223, 224, 
224, 225, 225, 226, 227, 228, 229, 230, 230, 231, 232, 233, 233, 235, 235, 
236, 237, 238, 238, 239, 239, 240, 241, 241, 242, 242, 243, 244, 244, 244, 
244, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248, 248, 249, 248, 248, 
248, 248, 248, 248, 247, 247, 246, 247, 246, 245, 244, 244, 243, 242, 241, 
240, 239, 238, 237, 236, 235, 233, 232, 230, 229, 228, 225, 224, 222, 221, 
220, 217, 217, 215, 213, 211, 210, 208, 206, 204, 203, 201, 198, 197, 195, 
193, 191, 188, 187, 185, 183, 180, 177, 177, 174, 172, 169, 167, 164, 162, 
160, 157, 155, 152, 149, 146, 144, 141, 139, 136, 132, 128, 125, 121, 118, 
113,  94, 107, 103,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 59,  59,  53,  53,  59,  45,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2, 
 69,  92, 103, 111, 116, 120, 124, 128, 132, 136, 141, 145, 148, 151, 155, 
158, 160, 163, 165, 166, 169, 169, 170, 173, 174, 176, 177, 179, 180, 181, 
183, 185, 187, 188, 191, 193, 195, 196, 198, 200, 202, 203, 206, 207, 209, 
209, 211, 212, 213, 214, 216, 217, 217, 219, 220, 221, 221, 221, 222, 223, 
224, 225, 225, 226, 227, 228, 228, 229, 230, 230, 231, 232, 233, 233, 235, 
235, 236, 236, 237, 238, 238, 239, 240, 241, 241, 242, 242, 243, 243, 244, 
244, 244, 245, 245, 245, 246, 246, 246, 246, 247, 247, 247, 248, 247, 248, 
248, 247, 247, 247, 247, 246, 246, 246, 245, 244, 244, 243, 243, 242, 241, 
240, 239, 238, 237, 235, 235, 233, 231, 230, 229, 227, 225, 223, 222, 220, 
219, 217, 215, 214, 212, 211, 209, 207, 206, 204, 202, 200, 198, 196, 194, 
192, 191, 188, 186, 184, 182, 180, 177, 176, 173, 170, 169, 176, 164, 161, 
159, 157, 154, 151, 148, 146, 143, 140, 137, 133, 130, 128, 124, 121, 118, 
113, 111, 107, 103,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  69, 
 59,  59,  53,  64,  59,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  59,  86,  99, 107, 113, 118, 121, 126, 130, 135, 139, 141, 146, 150, 
153, 156, 159, 161, 164, 165, 167, 168, 170, 172, 174, 174, 176, 177, 179, 
180, 182, 183, 186, 188, 190, 192, 193, 195, 197, 198, 201, 203, 204, 206, 
208, 209, 210, 211, 213, 214, 216, 216, 217, 219, 220, 220, 221, 221, 222, 
223, 224, 224, 225, 226, 226, 227, 228, 229, 230, 230, 231, 232, 233, 233, 
234, 235, 235, 236, 237, 238, 238, 239, 239, 240, 241, 241, 242, 242, 243, 
243, 243, 244, 244, 244, 245, 245, 245, 246, 246, 246, 247, 246, 246, 246, 
246, 247, 246, 246, 246, 246, 245, 245, 244, 244, 243, 242, 242, 241, 240, 
239, 238, 237, 237, 235, 233, 232, 231, 229, 228, 227, 225, 222, 221, 220, 
217, 217, 215, 213, 211, 210, 208, 207, 205, 203, 201, 199, 197, 195, 193, 
191, 189, 188, 186, 184, 181, 179, 177, 174, 173, 170, 168, 165, 255, 255, 
239, 188, 152, 150, 148, 145, 141, 139, 136, 133, 130, 126, 123, 120, 116, 
113, 111, 107, 103,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 59,  59,  77,  69,  59,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  36,  80,  94, 105, 111, 115, 118, 123, 128, 132, 137, 140, 144, 
148, 152, 154, 157, 159, 161, 164, 166, 167, 168, 170, 172, 173, 174, 176, 
177, 179, 180, 183, 185, 187, 188, 191, 193, 195, 197, 198, 200, 202, 204, 
205, 207, 208, 209, 211, 212, 214, 215, 216, 217, 217, 219, 220, 220, 221, 
222, 223, 223, 224, 224, 225, 226, 228, 228, 229, 229, 230, 231, 231, 233, 
233, 233, 235, 235, 236, 236, 237, 238, 238, 239, 239, 240, 240, 241, 242, 
242, 242, 243, 243, 244, 244, 244, 244, 244, 245, 245, 245, 245, 246, 246, 
245, 246, 245, 245, 245, 245, 244, 244, 244, 243, 243, 242, 241, 240, 240, 
238, 238, 236, 235, 235, 233, 232, 230, 229, 228, 226, 224, 222, 220, 219, 
217, 216, 215, 212, 211, 209, 208, 206, 204, 203, 201, 198, 197, 195, 193, 
191, 188, 187, 185, 182, 181, 178, 176, 174, 172, 169, 167, 165, 161, 255, 
255, 255, 255, 255, 207, 177, 146, 139, 135, 132, 130, 126, 124, 120, 116, 
113, 111, 107, 103,  99,  97,  92,  89,  86,  83,  80,  77,  73,  69,  64, 
 83,  89,  83,  69,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  12,  69,  89, 102, 107, 111, 116, 120, 124, 130, 133, 139, 
141, 146, 149, 152, 155, 158, 160, 162, 164, 165, 167, 169, 170, 172, 173, 
174, 176, 177, 180, 182, 184, 186, 188, 190, 192, 193, 195, 197, 199, 202, 
203, 205, 206, 207, 208, 210, 211, 213, 214, 216, 216, 217, 219, 219, 220, 
221, 222, 223, 223, 224, 225, 226, 226, 227, 228, 228, 229, 230, 231, 231, 
233, 233, 233, 234, 235, 235, 237, 237, 237, 238, 238, 239, 240, 240, 240, 
241, 241, 242, 242, 242, 243, 244, 244, 243, 244, 244, 244, 244, 245, 244, 
245, 245, 244, 244, 245, 244, 244, 243, 243, 243, 242, 241, 240, 240, 239, 
238, 237, 236, 235, 233, 232, 231, 230, 228, 227, 225, 224, 222, 220, 219, 
217, 215, 214, 212, 210, 209, 207, 205, 203, 202, 200, 197, 196, 193, 193, 
190, 188, 187, 185, 182, 180, 177, 176, 174, 170, 169, 167, 164, 161, 197, 
255, 255, 255, 255, 255, 253, 249, 246, 243, 207, 177, 141, 133, 120, 118, 
113, 111, 107, 103,  99,  97,  94,  89,  86,  80,  80,  83,  94, 118, 118, 
107,  94,  83,  69,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   2,  59,  83,  97, 105, 109, 113, 118, 123, 128, 130, 
135, 140, 143, 147, 150, 154, 156, 158, 161, 163, 165, 166, 167, 169, 170, 
172, 173, 175, 177, 178, 181, 183, 185, 187, 188, 191, 193, 195, 197, 198, 
200, 202, 203, 205, 207, 208, 209, 210, 212, 214, 215, 215, 217, 217, 219, 
220, 221, 221, 222, 223, 224, 224, 226, 226, 227, 228, 228, 229, 230, 231, 
231, 231, 233, 233, 233, 235, 235, 235, 236, 237, 238, 238, 238, 239, 239, 
240, 240, 241, 241, 242, 242, 242, 242, 242, 243, 243, 243, 244, 243, 244, 
244, 244, 244, 243, 244, 243, 243, 242, 242, 241, 241, 241, 240, 239, 238, 
237, 236, 236, 234, 233, 232, 231, 229, 228, 227, 225, 224, 222, 220, 217, 
216, 215, 213, 212, 210, 208, 206, 205, 203, 202, 198, 197, 195, 193, 192, 
190, 188, 186, 184, 182, 180, 177, 174, 173, 170, 169, 166, 164, 161, 159, 
252, 255, 255, 255, 254, 250, 247, 244, 241, 237, 233, 230, 226, 222, 217, 
212, 203, 197, 188, 181, 175, 156, 162, 156, 152, 147, 140, 132, 123, 113, 
103,  92,  83,  69,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  36,  77,  92, 102, 107, 111, 113, 118, 124, 
128, 133, 137, 141, 145, 149, 151, 155, 157, 160, 161, 163, 165, 166, 168, 
169, 170, 172, 174, 174, 177, 179, 182, 184, 186, 188, 190, 192, 193, 195, 
197, 199, 201, 202, 204, 206, 208, 209, 210, 211, 212, 214, 215, 216, 217, 
219, 219, 220, 220, 221, 222, 223, 225, 225, 226, 227, 227, 228, 229, 230, 
230, 231, 231, 232, 233, 233, 233, 235, 235, 236, 237, 237, 237, 238, 238, 
239, 239, 240, 240, 240, 241, 241, 241, 242, 242, 242, 242, 242, 242, 243, 
243, 242, 243, 242, 242, 242, 242, 241, 241, 241, 240, 239, 239, 238, 238, 
237, 236, 235, 233, 233, 231, 230, 229, 227, 226, 224, 223, 221, 219, 217, 
215, 214, 212, 211, 209, 208, 207, 204, 203, 200, 198, 197, 195, 193, 191, 
189, 187, 186, 183, 182, 179, 177, 174, 173, 170, 168, 166, 161, 160, 158, 
170, 255, 255, 255, 252, 249, 245, 243, 238, 235, 231, 227, 223, 219, 215, 
210, 206, 198, 195, 188, 182, 174, 168, 161, 153, 144, 136, 128, 121, 111, 
 99,  92,  77,  64,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   2,  80,  86,  97, 103, 109, 111, 116, 
120, 126, 130, 135, 139, 141, 146, 150, 152, 155, 157, 160, 161, 163, 165, 
166, 168, 169, 170, 172, 174, 176, 177, 180, 183, 185, 187, 188, 191, 193, 
195, 196, 198, 200, 202, 203, 204, 206, 208, 209, 210, 211, 213, 214, 215, 
216, 217, 218, 220, 220, 221, 222, 223, 224, 225, 225, 227, 227, 228, 229, 
229, 230, 231, 231, 232, 232, 233, 233, 234, 235, 235, 236, 237, 237, 238, 
238, 238, 239, 239, 239, 240, 240, 240, 241, 241, 241, 242, 241, 241, 242, 
242, 242, 242, 241, 241, 242, 241, 240, 241, 240, 240, 239, 238, 238, 237, 
236, 235, 235, 233, 231, 231, 229, 228, 227, 225, 225, 222, 221, 219, 217, 
216, 214, 212, 210, 209, 207, 205, 204, 202, 200, 198, 196, 195, 193, 191, 
188, 187, 185, 183, 181, 179, 177, 174, 172, 170, 168, 165, 162, 160, 158, 
155, 242, 255, 253, 250, 247, 243, 240, 236, 232, 228, 223, 220, 216, 212, 
208, 202, 197, 192, 185, 179, 172, 165, 158, 150, 143, 133, 124, 118, 107, 
 99,  89,  77,  64,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  77,  94,  92,  99, 105, 111, 
113, 118, 123, 128, 132, 136, 140, 143, 148, 151, 153, 155, 158, 160, 161, 
164, 165, 166, 168, 169, 170, 173, 174, 176, 179, 182, 183, 185, 188, 189, 
191, 193, 195, 197, 198, 200, 202, 204, 206, 207, 208, 209, 211, 212, 214, 
214, 216, 217, 217, 219, 220, 220, 221, 222, 223, 224, 225, 226, 227, 227, 
229, 229, 229, 231, 231, 231, 232, 233, 233, 233, 235, 235, 236, 236, 236, 
237, 237, 238, 238, 238, 239, 239, 239, 240, 240, 240, 240, 240, 240, 240, 
240, 241, 241, 241, 240, 241, 240, 240, 240, 239, 238, 238, 237, 237, 236, 
235, 233, 233, 232, 231, 230, 229, 228, 226, 225, 224, 222, 220, 219, 217, 
215, 213, 211, 210, 208, 206, 204, 203, 202, 199, 197, 195, 193, 192, 190, 
188, 187, 185, 183, 181, 177, 176, 174, 171, 169, 167, 164, 161, 160, 157, 
154, 157, 255, 252, 248, 245, 241, 238, 233, 229, 226, 222, 217, 213, 209, 
205, 198, 193, 190, 182, 176, 170, 162, 154, 148, 139, 132, 121, 113, 105, 
 97,  86,  77,  64,  53,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24, 115, 111,  97, 103, 
107, 111, 115, 118, 124, 129, 133, 139, 141, 145, 148, 152, 153, 157, 159, 
160, 162, 164, 165, 166, 168, 169, 170, 173, 176, 177, 180, 183, 184, 186, 
188, 191, 192, 193, 195, 197, 199, 201, 202, 204, 206, 207, 209, 210, 211, 
212, 213, 215, 216, 217, 217, 219, 219, 221, 221, 223, 224, 225, 226, 226, 
227, 228, 229, 229, 230, 231, 231, 231, 232, 233, 233, 233, 235, 235, 236, 
236, 236, 236, 237, 237, 238, 238, 238, 239, 239, 239, 239, 240, 240, 240, 
239, 240, 240, 240, 239, 239, 239, 238, 238, 238, 238, 237, 237, 236, 235, 
233, 233, 233, 232, 231, 229, 228, 227, 226, 224, 223, 221, 220, 217, 216, 
214, 213, 211, 209, 208, 206, 204, 202, 202, 199, 197, 195, 193, 192, 190, 
188, 186, 185, 182, 179, 177, 175, 173, 170, 169, 167, 164, 161, 159, 157, 
154, 151, 221, 250, 246, 243, 239, 235, 231, 227, 222, 219, 215, 210, 207, 
202, 195, 192, 185, 179, 173, 165, 160, 152, 144, 136, 128, 120, 111, 103, 
 94,  83,  73,  64,  53,  36,  24,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  83, 144, 145, 
 99, 105, 109, 113, 116, 121, 126, 130, 135, 139, 143, 146, 149, 152, 154, 
157, 159, 161, 163, 164, 165, 166, 167, 169, 170, 174, 176, 178, 181, 183, 
185, 187, 189, 191, 193, 195, 197, 197, 200, 201, 203, 204, 206, 208, 208, 
210, 212, 212, 214, 215, 216, 217, 217, 219, 219, 221, 222, 223, 224, 224, 
225, 227, 228, 228, 229, 230, 230, 231, 231, 232, 232, 233, 233, 233, 235, 
235, 235, 236, 236, 236, 237, 237, 237, 237, 238, 238, 238, 238, 238, 238, 
239, 239, 239, 238, 238, 238, 238, 238, 237, 237, 237, 236, 236, 235, 234, 
233, 233, 231, 231, 229, 229, 228, 226, 225, 224, 222, 220, 220, 217, 216, 
214, 213, 211, 209, 207, 205, 204, 202, 201, 198, 197, 195, 193, 191, 189, 
187, 186, 184, 182, 179, 177, 174, 173, 170, 168, 166, 163, 161, 159, 156, 
153, 152, 164, 248, 244, 240, 237, 232, 228, 223, 220, 214, 210, 207, 203, 
197, 193, 188, 182, 176, 170, 163, 157, 149, 141, 133, 126, 118, 109,  99, 
 92,  83,  73,  64,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36, 121, 
166, 188, 133, 107, 111, 113, 118, 123, 128, 132, 136, 141, 144, 147, 150, 
152, 155, 157, 159, 161, 162, 164, 165, 166, 168, 170, 172, 174, 177, 179, 
182, 184, 186, 187, 190, 192, 193, 195, 197, 198, 200, 202, 204, 205, 207, 
208, 209, 210, 211, 212, 214, 215, 216, 217, 217, 219, 220, 221, 222, 223, 
224, 225, 226, 227, 228, 228, 229, 229, 230, 231, 231, 232, 232, 233, 233, 
233, 233, 234, 235, 235, 235, 236, 236, 237, 237, 237, 237, 237, 237, 238, 
238, 237, 237, 237, 237, 237, 237, 237, 236, 236, 236, 235, 235, 233, 233, 
233, 232, 231, 230, 229, 228, 227, 226, 225, 222, 222, 220, 219, 217, 215, 
214, 212, 210, 208, 206, 204, 203, 202, 199, 197, 196, 195, 192, 190, 188, 
187, 185, 183, 181, 179, 176, 174, 173, 169, 168, 165, 163, 160, 158, 155, 
153, 151, 148, 241, 242, 239, 235, 229, 225, 221, 216, 212, 207, 203, 198, 
193, 190, 185, 180, 173, 167, 160, 154, 146, 140, 132, 123, 113, 107,  99, 
 89,  80,  69,  59,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2, 
 89, 146, 176, 182, 103, 109, 111, 115, 120, 124, 129, 133, 137, 141, 145, 
148, 150, 154, 155, 158, 159, 161, 163, 164, 165, 167, 168, 170, 173, 175, 
177, 180, 182, 184, 186, 188, 191, 192, 193, 195, 197, 199, 201, 202, 204, 
205, 207, 208, 209, 211, 211, 213, 214, 215, 216, 217, 218, 219, 220, 221, 
222, 223, 224, 225, 226, 227, 228, 228, 229, 229, 230, 231, 231, 231, 232, 
233, 233, 233, 233, 234, 234, 235, 235, 235, 235, 235, 236, 236, 236, 236, 
237, 236, 237, 236, 236, 236, 236, 236, 236, 235, 235, 234, 233, 233, 233, 
231, 231, 230, 229, 228, 227, 226, 225, 224, 222, 220, 220, 217, 216, 214, 
213, 211, 210, 208, 206, 204, 202, 201, 198, 197, 195, 193, 192, 190, 188, 
186, 184, 182, 180, 177, 176, 174, 172, 169, 167, 165, 163, 160, 157, 155, 
152, 150, 147, 194, 241, 237, 233, 227, 223, 219, 215, 208, 204, 201, 195, 
191, 187, 183, 176, 169, 164, 158, 152, 143, 135, 128, 120, 113, 105,  97, 
 89,  77,  69,  59,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  36, 115, 158, 186, 102, 105, 111, 113, 116, 121, 126, 130, 135, 139, 
141, 146, 148, 151, 154, 155, 158, 160, 161, 162, 164, 165, 168, 169, 170, 
174, 176, 177, 180, 183, 185, 187, 188, 191, 193, 193, 197, 197, 199, 201, 
202, 204, 205, 207, 208, 209, 210, 211, 213, 214, 215, 216, 217, 217, 219, 
220, 221, 222, 223, 224, 225, 226, 226, 227, 228, 229, 229, 230, 231, 231, 
231, 232, 232, 232, 233, 233, 233, 233, 234, 235, 235, 235, 235, 235, 235, 
235, 235, 235, 235, 235, 236, 235, 234, 234, 233, 233, 233, 232, 233, 231, 
231, 230, 229, 229, 227, 227, 225, 224, 223, 221, 220, 219, 217, 216, 214, 
212, 211, 209, 207, 205, 203, 202, 199, 198, 197, 194, 193, 191, 189, 188, 
186, 183, 182, 180, 177, 176, 173, 170, 169, 167, 164, 161, 160, 157, 154, 
152, 149, 147, 163, 240, 234, 230, 225, 220, 215, 211, 205, 201, 196, 192, 
188, 183, 178, 173, 167, 161, 155, 148, 141, 133, 126, 120, 111, 102,  94, 
 86,  77,  69,  59,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  83, 141, 170, 105, 102, 107, 111, 115, 118, 123, 128, 132, 
136, 140, 143, 146, 149, 151, 154, 156, 158, 160, 161, 163, 165, 166, 169, 
170, 172, 174, 176, 179, 181, 183, 185, 187, 188, 191, 193, 195, 196, 197, 
199, 201, 202, 205, 206, 207, 208, 209, 211, 211, 212, 214, 215, 216, 217, 
217, 219, 220, 221, 222, 223, 224, 225, 225, 226, 227, 228, 229, 229, 229, 
230, 231, 231, 231, 232, 232, 233, 232, 233, 233, 233, 233, 233, 233, 233, 
233, 233, 235, 233, 233, 233, 233, 233, 233, 233, 232, 232, 232, 231, 231, 
230, 229, 228, 228, 226, 225, 224, 223, 222, 221, 219, 217, 216, 215, 213, 
212, 210, 208, 206, 205, 203, 201, 199, 197, 195, 193, 192, 190, 188, 187, 
185, 183, 180, 179, 177, 174, 172, 170, 167, 166, 164, 161, 159, 156, 154, 
151, 149, 146, 144, 222, 233, 228, 223, 217, 212, 208, 203, 197, 193, 188, 
184, 180, 174, 170, 164, 158, 151, 145, 139, 130, 124, 116, 107,  99,  92, 
 83,  73,  64,  59,  45,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  36, 111, 153, 146,  99, 105, 109, 113, 116, 120, 124, 
128, 133, 137, 140, 143, 146, 149, 152, 154, 156, 158, 159, 161, 164, 166, 
167, 169, 170, 173, 174, 177, 179, 181, 183, 185, 188, 189, 191, 193, 194, 
197, 198, 199, 201, 203, 204, 205, 207, 208, 209, 210, 211, 212, 214, 215, 
216, 217, 219, 219, 220, 221, 222, 222, 224, 225, 225, 226, 227, 227, 228, 
229, 230, 230, 230, 230, 231, 231, 231, 232, 232, 232, 233, 232, 233, 233, 
233, 233, 233, 233, 233, 232, 233, 232, 232, 232, 232, 231, 230, 230, 230, 
229, 228, 227, 227, 226, 224, 223, 223, 222, 220, 219, 217, 216, 214, 213, 
211, 210, 208, 206, 204, 202, 200, 198, 196, 195, 193, 192, 189, 188, 186, 
184, 182, 181, 177, 176, 174, 172, 170, 167, 165, 163, 160, 158, 156, 153, 
151, 148, 146, 143, 202, 231, 226, 221, 216, 211, 206, 200, 195, 190, 185, 
180, 176, 172, 167, 161, 155, 150, 143, 135, 130, 121, 113, 107,  99,  89, 
 83,  73,  64,  53,  45,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   2,  83, 133, 161,  94, 102, 107, 111, 113, 118, 
121, 126, 130, 133, 139, 141, 145, 148, 150, 152, 154, 156, 158, 160, 163, 
164, 166, 168, 169, 170, 173, 174, 177, 180, 182, 184, 186, 188, 188, 191, 
193, 195, 197, 198, 200, 201, 203, 204, 206, 207, 208, 209, 210, 212, 212, 
214, 215, 216, 217, 217, 219, 219, 220, 221, 223, 223, 224, 224, 225, 227, 
227, 227, 228, 229, 229, 230, 230, 231, 230, 231, 231, 232, 231, 232, 232, 
231, 232, 232, 232, 232, 231, 231, 231, 231, 231, 230, 230, 229, 229, 228, 
228, 227, 227, 226, 225, 224, 222, 222, 220, 219, 217, 217, 215, 213, 212, 
210, 209, 207, 205, 203, 202, 199, 197, 195, 193, 192, 191, 188, 187, 186, 
183, 182, 179, 177, 175, 173, 170, 169, 167, 165, 161, 160, 157, 155, 152, 
150, 147, 145, 141, 153, 230, 225, 219, 213, 208, 203, 197, 192, 187, 182, 
177, 173, 168, 164, 159, 152, 146, 139, 133, 126, 118, 111, 103,  97,  89, 
 80,  69,  64,  53,  45,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  24, 103, 144, 102,  99, 103, 107, 111, 
115, 118, 121, 128, 130, 135, 139, 141, 145, 148, 150, 152, 154, 156, 159, 
161, 163, 165, 167, 169, 170, 172, 173, 174, 177, 180, 182, 184, 186, 188, 
189, 191, 193, 195, 196, 198, 200, 202, 202, 204, 206, 206, 208, 209, 210, 
211, 212, 214, 214, 215, 216, 217, 219, 219, 220, 221, 222, 222, 223, 225, 
225, 225, 226, 227, 227, 228, 229, 229, 229, 230, 230, 230, 231, 230, 230, 
231, 231, 230, 231, 230, 230, 230, 230, 230, 229, 230, 229, 229, 228, 227, 
227, 226, 225, 224, 224, 223, 222, 220, 220, 219, 217, 215, 215, 213, 211, 
210, 208, 206, 205, 203, 201, 198, 197, 195, 193, 192, 190, 188, 186, 184, 
182, 180, 179, 177, 174, 173, 170, 168, 166, 164, 161, 159, 156, 154, 152, 
149, 147, 144, 141, 139, 228, 223, 217, 211, 206, 200, 195, 188, 184, 179, 
173, 169, 166, 160, 155, 150, 144, 137, 130, 124, 116, 109, 102,  94,  86, 
 77,  69,  59,  53,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  69, 123, 141,  94,  99, 105, 
109, 113, 116, 118, 123, 128, 132, 136, 139, 143, 145, 148, 150, 153, 155, 
157, 159, 161, 163, 165, 167, 169, 170, 173, 173, 176, 177, 180, 182, 185, 
186, 188, 190, 192, 193, 195, 197, 198, 199, 202, 203, 204, 206, 206, 208, 
209, 210, 211, 212, 213, 214, 215, 216, 217, 217, 219, 220, 221, 221, 222, 
223, 223, 224, 225, 225, 226, 226, 227, 227, 228, 228, 229, 229, 229, 229, 
229, 229, 230, 229, 229, 229, 229, 229, 229, 229, 228, 228, 228, 227, 227, 
226, 225, 224, 223, 222, 221, 221, 220, 219, 217, 216, 215, 213, 212, 210, 
209, 208, 206, 204, 202, 200, 198, 196, 195, 193, 191, 188, 187, 185, 183, 
182, 179, 177, 175, 174, 170, 169, 167, 165, 162, 161, 158, 156, 154, 151, 
148, 146, 144, 140, 139, 217, 221, 214, 210, 204, 197, 192, 186, 181, 176, 
170, 166, 161, 157, 152, 146, 140, 133, 128, 121, 113, 107,  99,  92,  83, 
 77,  69,  59,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24,  97, 133,  92,  97, 
102, 105, 111, 113, 116, 120, 124, 129, 133, 136, 139, 143, 145, 148, 150, 
153, 155, 158, 160, 161, 164, 166, 168, 170, 170, 173, 174, 176, 177, 180, 
183, 185, 187, 188, 190, 192, 193, 195, 196, 198, 200, 201, 202, 203, 205, 
206, 207, 208, 209, 211, 211, 213, 214, 215, 216, 216, 217, 219, 219, 220, 
221, 221, 223, 223, 223, 224, 224, 225, 226, 226, 227, 226, 227, 227, 228, 
228, 228, 228, 229, 228, 228, 228, 228, 228, 227, 227, 226, 226, 226, 225, 
225, 224, 223, 222, 222, 221, 220, 219, 217, 216, 215, 214, 213, 211, 210, 
208, 207, 205, 203, 201, 199, 197, 195, 193, 191, 190, 188, 187, 185, 183, 
181, 179, 177, 174, 173, 170, 168, 167, 164, 161, 159, 157, 155, 152, 150, 
147, 145, 143, 140, 137, 193, 220, 214, 208, 201, 197, 189, 184, 179, 173, 
168, 163, 159, 154, 149, 144, 137, 132, 125, 118, 111, 105,  97,  89,  83, 
 73,  64,  59,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  53, 109, 109, 
 92,  99, 103, 107, 111, 115, 118, 121, 124, 129, 133, 137, 141, 143, 146, 
148, 151, 154, 156, 159, 161, 163, 165, 166, 168, 170, 171, 173, 174, 176, 
178, 180, 182, 185, 186, 188, 190, 191, 193, 195, 196, 197, 199, 200, 201, 
203, 204, 205, 207, 208, 209, 211, 212, 212, 214, 214, 215, 216, 217, 217, 
219, 219, 220, 220, 222, 222, 223, 223, 224, 224, 224, 225, 225, 226, 226, 
226, 226, 226, 227, 227, 227, 227, 227, 226, 226, 226, 226, 225, 225, 224, 
224, 223, 222, 221, 221, 220, 219, 217, 217, 216, 214, 213, 212, 211, 209, 
208, 206, 204, 203, 200, 198, 197, 195, 193, 191, 188, 187, 185, 183, 181, 
180, 177, 176, 174, 172, 169, 168, 166, 164, 161, 159, 156, 154, 152, 149, 
147, 144, 143, 139, 137, 160, 217, 212, 205, 199, 193, 188, 182, 176, 170, 
166, 160, 155, 151, 147, 141, 135, 129, 123, 116, 109, 103,  94,  86,  80, 
 73,  64,  53,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  80, 
123,  86,  94,  99, 105, 109, 111, 116, 118, 121, 126, 130, 133, 137, 141, 
143, 146, 149, 152, 155, 157, 159, 161, 163, 165, 167, 169, 170, 172, 174, 
174, 176, 179, 181, 182, 185, 187, 188, 190, 191, 193, 195, 195, 197, 198, 
200, 201, 203, 204, 205, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 
216, 217, 217, 217, 219, 220, 221, 221, 222, 222, 222, 222, 224, 224, 224, 
224, 225, 225, 225, 225, 224, 225, 225, 225, 224, 224, 225, 225, 224, 223, 
222, 221, 221, 220, 220, 219, 217, 217, 216, 214, 214, 212, 211, 209, 208, 
207, 205, 203, 201, 200, 198, 197, 193, 193, 190, 188, 186, 184, 183, 181, 
177, 177, 175, 173, 170, 169, 167, 165, 162, 160, 158, 156, 153, 151, 149, 
146, 143, 141, 139, 135, 137, 217, 211, 204, 197, 191, 185, 179, 173, 168, 
161, 158, 153, 149, 144, 139, 133, 128, 121, 115, 107,  99,  94,  86,  77, 
 69,  59,  53,  45,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 36,  97, 109,  89,  97, 102, 105, 111, 113, 116, 120, 123, 128, 130, 135, 
137, 141, 144, 147, 150, 153, 155, 157, 160, 161, 164, 166, 167, 169, 170, 
172, 173, 176, 176, 178, 180, 182, 184, 186, 188, 189, 191, 193, 194, 195, 
197, 198, 199, 201, 202, 204, 204, 206, 207, 208, 209, 210, 211, 212, 213, 
214, 214, 215, 216, 217, 217, 219, 219, 219, 220, 220, 220, 221, 222, 221, 
222, 222, 222, 223, 223, 223, 223, 223, 223, 223, 223, 223, 223, 222, 222, 
222, 221, 220, 219, 219, 217, 217, 216, 215, 214, 212, 211, 210, 208, 207, 
206, 204, 203, 201, 198, 197, 195, 193, 191, 189, 187, 185, 183, 182, 180, 
177, 176, 174, 170, 169, 168, 165, 164, 161, 159, 157, 155, 152, 150, 147, 
145, 141, 140, 137, 135, 137, 207, 209, 201, 195, 188, 182, 176, 170, 165, 
159, 155, 150, 146, 141, 136, 130, 124, 118, 111, 105,  99,  92,  83,  77, 
 69,  59,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  64, 109,  83,  92,  97, 103, 107, 111, 113, 118, 120, 123, 128, 
132, 135, 139, 141, 145, 148, 150, 153, 155, 158, 160, 162, 164, 166, 167, 
169, 170, 172, 174, 175, 177, 178, 180, 182, 183, 186, 187, 188, 191, 192, 
193, 195, 197, 197, 198, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
211, 212, 213, 214, 214, 215, 215, 216, 217, 217, 217, 219, 219, 219, 219, 
220, 220, 220, 220, 221, 221, 221, 221, 222, 221, 221, 221, 221, 221, 220, 
219, 219, 219, 218, 217, 217, 216, 215, 214, 213, 211, 211, 209, 208, 207, 
205, 203, 201, 200, 197, 196, 195, 192, 191, 188, 187, 185, 182, 180, 179, 
177, 174, 173, 170, 169, 167, 165, 163, 160, 158, 155, 154, 151, 149, 146, 
145, 141, 139, 137, 133, 132, 205, 207, 200, 193, 187, 180, 173, 168, 163, 
158, 152, 147, 144, 139, 135, 128, 123, 115, 109, 103,  97,  89,  83,  73, 
 64,  59,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  12,  80, 102,  86,  94,  99, 103, 107, 111, 115, 118, 121, 
124, 128, 132, 136, 139, 141, 145, 149, 151, 154, 156, 159, 160, 161, 165, 
167, 168, 169, 170, 173, 174, 176, 177, 179, 180, 182, 183, 186, 187, 188, 
191, 191, 193, 194, 195, 197, 198, 200, 201, 202, 203, 205, 206, 207, 207, 
209, 209, 210, 211, 212, 212, 213, 214, 215, 215, 216, 217, 216, 217, 217, 
217, 217, 219, 219, 219, 219, 220, 219, 219, 219, 219, 219, 219, 219, 217, 
217, 217, 217, 217, 216, 215, 214, 214, 212, 212, 211, 209, 208, 207, 205, 
204, 203, 201, 199, 197, 195, 193, 192, 190, 188, 187, 184, 181, 180, 177, 
176, 174, 172, 170, 168, 166, 163, 161, 159, 157, 155, 152, 151, 148, 145, 
143, 141, 139, 136, 133, 130, 170, 205, 198, 191, 183, 177, 170, 166, 160, 
155, 150, 145, 140, 137, 130, 126, 120, 113, 107, 102,  94,  86,  80,  73, 
 64,  53,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  36,  94,  80,  89,  94,  99, 105, 107, 111, 115, 
118, 121, 125, 129, 132, 136, 140, 143, 147, 149, 152, 154, 157, 159, 160, 
163, 165, 167, 168, 169, 170, 173, 174, 176, 177, 178, 180, 182, 183, 185, 
186, 188, 189, 191, 193, 193, 195, 196, 197, 198, 200, 201, 202, 204, 205, 
206, 207, 207, 208, 209, 210, 211, 211, 212, 212, 213, 213, 214, 215, 215, 
216, 216, 216, 216, 216, 216, 216, 217, 217, 217, 217, 217, 217, 217, 216, 
216, 216, 216, 215, 214, 214, 212, 212, 211, 211, 209, 208, 207, 206, 204, 
203, 201, 200, 198, 197, 193, 193, 191, 188, 187, 185, 183, 180, 179, 177, 
174, 173, 170, 169, 167, 164, 163, 160, 158, 156, 153, 151, 149, 146, 145, 
141, 139, 137, 135, 132, 130, 151, 203, 193, 188, 181, 176, 169, 161, 157, 
152, 147, 143, 139, 135, 129, 123, 118, 111, 105,  99,  92,  83,  77,  69, 
 59,  53,  36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   2,  53,  94,  83,  89,  97,  99, 105, 109, 
113, 116, 118, 123, 125, 130, 133, 137, 140, 144, 147, 150, 152, 155, 157, 
159, 161, 163, 165, 167, 168, 169, 171, 173, 174, 175, 177, 177, 180, 181, 
182, 184, 186, 187, 188, 190, 192, 193, 194, 195, 197, 197, 199, 200, 201, 
202, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 211, 212, 212, 212, 
212, 214, 213, 214, 214, 214, 215, 214, 214, 214, 214, 215, 214, 215, 214, 
214, 214, 213, 212, 212, 211, 211, 211, 209, 208, 207, 206, 206, 204, 203, 
201, 200, 198, 197, 195, 193, 192, 190, 188, 186, 185, 182, 180, 177, 174, 
173, 172, 170, 168, 165, 164, 161, 159, 157, 155, 152, 150, 147, 145, 143, 
140, 139, 136, 133, 130, 128, 137, 200, 193, 186, 179, 172, 166, 160, 155, 
149, 144, 141, 136, 132, 126, 121, 115, 109, 102,  97,  89,  83,  73,  64, 
 59,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  12,  69,  80,  83,  92,  97, 102, 
105, 109, 113, 116, 118, 123, 126, 130, 135, 139, 141, 145, 148, 150, 152, 
155, 158, 160, 161, 163, 165, 166, 168, 170, 171, 173, 174, 175, 177, 177, 
180, 180, 182, 183, 185, 186, 188, 189, 190, 191, 193, 193, 195, 197, 198, 
199, 200, 201, 202, 203, 204, 205, 206, 207, 207, 208, 208, 209, 209, 210, 
210, 211, 211, 211, 212, 211, 212, 213, 212, 212, 213, 212, 212, 212, 213, 
212, 211, 211, 211, 210, 209, 209, 208, 207, 207, 206, 205, 203, 202, 202, 
200, 197, 197, 195, 193, 192, 190, 188, 187, 185, 183, 181, 179, 176, 174, 
172, 170, 169, 167, 165, 161, 160, 157, 156, 153, 151, 149, 147, 144, 141, 
140, 137, 135, 133, 130, 128, 128, 199, 191, 183, 176, 170, 163, 157, 152, 
146, 141, 137, 133, 129, 125, 118, 113, 107,  99,  94,  86,  80,  73,  64, 
 53,  45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24,  80,  80,  86,  92, 
 99, 103, 107, 111, 113, 118, 120, 123, 126, 132, 135, 139, 141, 145, 148, 
151, 153, 155, 158, 159, 161, 163, 165, 166, 168, 170, 170, 173, 174, 174, 
176, 177, 179, 181, 182, 183, 184, 186, 187, 188, 189, 191, 193, 193, 195, 
195, 197, 197, 198, 200, 201, 202, 203, 203, 204, 204, 205, 206, 207, 207, 
208, 208, 208, 209, 209, 209, 209, 210, 210, 210, 210, 210, 210, 210, 209, 
209, 209, 209, 209, 208, 208, 207, 206, 206, 205, 204, 203, 202, 201, 200, 
198, 197, 195, 193, 192, 191, 189, 188, 185, 184, 182, 180, 177, 175, 173, 
170, 169, 167, 165, 163, 161, 158, 157, 155, 152, 150, 148, 145, 143, 141, 
139, 136, 133, 132, 128, 126, 124, 192, 188, 181, 174, 167, 161, 155, 150, 
145, 140, 135, 130, 128, 123, 118, 111, 105,  99,  92,  83,  77,  69,  59, 
 53,  36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45,  86,  80, 
 89,  94,  99, 103, 107, 111, 113, 118, 120, 124, 128, 132, 136, 140, 143, 
146, 148, 151, 152, 155, 158, 159, 161, 163, 165, 166, 168, 169, 170, 173, 
174, 174, 177, 177, 178, 180, 181, 182, 183, 185, 186, 188, 188, 190, 191, 
193, 193, 194, 195, 197, 197, 197, 199, 200, 201, 202, 202, 203, 203, 204, 
204, 205, 205, 206, 206, 206, 207, 207, 208, 207, 207, 208, 207, 207, 207, 
208, 207, 207, 206, 206, 206, 205, 204, 203, 203, 202, 201, 200, 198, 197, 
197, 195, 195, 192, 191, 190, 188, 186, 184, 182, 180, 177, 176, 174, 172, 
169, 168, 165, 163, 161, 159, 158, 155, 154, 151, 149, 146, 144, 141, 140, 
137, 135, 132, 130, 128, 126, 123, 175, 187, 179, 170, 166, 159, 152, 147, 
143, 137, 133, 128, 124, 121, 115, 109, 102,  94,  89,  83,  73,  64,  59, 
 45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  53, 
 80,  80,  89,  94,  99, 103, 105, 111, 115, 118, 121, 124, 129, 133, 136, 
140, 143, 146, 148, 150, 153, 155, 157, 159, 161, 163, 165, 166, 168, 169, 
170, 172, 173, 174, 176, 176, 177, 179, 180, 182, 182, 183, 185, 186, 188, 
188, 190, 191, 193, 193, 193, 195, 195, 196, 197, 198, 199, 200, 200, 201, 
201, 202, 202, 203, 203, 203, 204, 204, 205, 204, 204, 205, 205, 204, 205, 
205, 205, 204, 203, 203, 203, 203, 202, 201, 200, 200, 198, 197, 197, 195, 
193, 193, 191, 191, 188, 188, 186, 185, 182, 180, 179, 177, 174, 173, 170, 
168, 166, 164, 162, 160, 158, 156, 154, 152, 149, 148, 145, 143, 140, 139, 
136, 133, 132, 128, 128, 124, 121, 176, 183, 176, 168, 161, 157, 151, 144, 
139, 133, 130, 126, 121, 118, 111, 105,  99,  92,  86,  77,  69,  64,  53, 
 45,  36,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,  64,  77,  83,  89,  94,  99, 103, 107, 111, 113, 118, 123, 126, 130, 
133, 137, 140, 143, 146, 148, 151, 153, 155, 157, 159, 160, 161, 164, 166, 
167, 169, 170, 170, 173, 174, 174, 176, 177, 178, 179, 181, 181, 183, 183, 
185, 186, 187, 188, 189, 190, 192, 193, 193, 193, 195, 195, 197, 197, 197, 
197, 198, 199, 200, 201, 201, 201, 201, 201, 202, 202, 202, 202, 202, 202, 
202, 202, 202, 202, 201, 200, 200, 199, 198, 198, 197, 197, 195, 194, 193, 
193, 191, 190, 188, 187, 186, 184, 183, 181, 179, 177, 175, 173, 170, 169, 
167, 164, 162, 160, 158, 156, 155, 152, 151, 148, 146, 144, 141, 139, 137, 
135, 132, 130, 128, 125, 123, 121, 152, 181, 174, 165, 160, 153, 146, 141, 
137, 132, 128, 123, 120, 116, 111, 103,  99,  92,  83,  77,  69,  59,  53, 
 36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,  12,  73,  73,  83,  89,  94,  99, 103, 107, 111, 115, 120, 124, 
128, 130, 135, 137, 140, 143, 146, 148, 151, 153, 155, 157, 158, 160, 161, 
163, 165, 167, 168, 170, 170, 172, 173, 174, 176, 176, 177, 178, 180, 181, 
182, 183, 184, 185, 186, 187, 188, 188, 190, 191, 191, 192, 193, 193, 195, 
195, 195, 195, 197, 197, 197, 197, 198, 198, 198, 198, 198, 198, 199, 199, 
198, 198, 198, 198, 198, 198, 197, 197, 197, 195, 195, 193, 193, 193, 191, 
191, 189, 188, 187, 185, 184, 183, 181, 180, 177, 175, 174, 172, 170, 167, 
165, 164, 161, 159, 157, 155, 153, 151, 149, 147, 145, 143, 140, 139, 136, 
133, 130, 129, 126, 124, 121, 120, 149, 177, 170, 164, 158, 150, 145, 140, 
133, 130, 126, 121, 118, 113, 107, 102,  94,  89,  80,  73,  64,  53,  45, 
 36,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,  24,  77,  77,  83,  89,  94,  99, 103, 107, 111, 116, 
120, 125, 128, 130, 135, 137, 140, 143, 146, 148, 150, 152, 155, 156, 158, 
160, 161, 163, 164, 165, 167, 169, 170, 170, 172, 174, 174, 175, 177, 177, 
179, 180, 181, 182, 183, 183, 185, 185, 186, 187, 188, 188, 189, 190, 191, 
191, 192, 193, 193, 193, 193, 193, 195, 195, 195, 195, 195, 197, 195, 195, 
197, 196, 195, 195, 195, 195, 195, 194, 193, 193, 193, 192, 191, 191, 188, 
188, 187, 186, 185, 183, 182, 180, 178, 177, 175, 174, 171, 169, 168, 166, 
163, 161, 159, 158, 155, 154, 152, 150, 147, 146, 144, 141, 139, 136, 135, 
132, 129, 128, 125, 123, 120, 118, 125, 174, 167, 160, 155, 149, 143, 136, 
132, 128, 124, 118, 115, 111, 105,  99,  94,  86,  77,  69,  64,  53,  45, 
 24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,  24,  73,  77,  83,  89,  94,  99, 103, 107, 
111, 118, 121, 125, 128, 132, 133, 137, 140, 143, 145, 147, 150, 152, 153, 
155, 157, 159, 160, 161, 164, 165, 166, 168, 169, 170, 170, 173, 174, 174, 
176, 177, 177, 179, 179, 180, 181, 182, 182, 183, 184, 185, 186, 187, 187, 
188, 188, 188, 189, 190, 191, 191, 192, 192, 192, 193, 193, 193, 193, 193, 
193, 193, 193, 193, 193, 193, 192, 191, 192, 191, 188, 190, 188, 187, 187, 
186, 185, 184, 182, 181, 180, 179, 177, 174, 173, 172, 170, 168, 166, 164, 
163, 159, 158, 155, 153, 151, 149, 148, 145, 143, 141, 139, 137, 135, 133, 
130, 128, 126, 124, 121, 118, 116, 120, 172, 164, 158, 151, 145, 140, 133, 
128, 124, 120, 116, 113, 109, 102,  97,  89,  83,  77,  64,  59,  45,  36, 
 24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,  36,  69,  77,  83,  89,  94,  99, 
103, 109, 113, 118, 121, 125, 128, 130, 133, 137, 139, 141, 144, 146, 149, 
151, 153, 155, 156, 158, 159, 161, 162, 164, 165, 166, 168, 169, 170, 170, 
173, 174, 174, 175, 176, 177, 177, 178, 179, 180, 180, 181, 182, 183, 183, 
184, 185, 186, 186, 186, 187, 188, 188, 188, 188, 189, 189, 190, 188, 190, 
190, 190, 190, 190, 189, 189, 188, 188, 188, 187, 187, 187, 186, 185, 185, 
183, 182, 181, 180, 178, 177, 177, 174, 173, 170, 170, 168, 166, 165, 161, 
160, 158, 156, 154, 152, 150, 148, 146, 143, 141, 140, 137, 135, 133, 130, 
129, 126, 124, 121, 120, 118, 115, 116, 167, 160, 154, 147, 143, 137, 130, 
128, 121, 118, 115, 111, 107,  99,  94,  86,  77,  73,  64,  53,  45,  24, 
 12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  36,  69,  77,  83,  89, 
 94,  99, 105, 109, 115, 118, 121, 126, 128, 130, 133, 137, 139, 141, 143, 
145, 148, 150, 151, 154, 155, 157, 158, 160, 161, 163, 164, 165, 167, 168, 
169, 169, 170, 172, 173, 174, 174, 176, 177, 177, 177, 178, 179, 180, 180, 
180, 181, 181, 182, 182, 183, 183, 184, 185, 185, 186, 186, 186, 186, 187, 
187, 186, 187, 187, 187, 186, 186, 186, 185, 185, 185, 183, 183, 183, 181, 
181, 180, 179, 177, 176, 176, 174, 172, 170, 169, 167, 166, 164, 162, 161, 
159, 156, 154, 152, 150, 148, 146, 144, 141, 140, 139, 136, 133, 132, 129, 
128, 125, 123, 120, 118, 116, 113, 113, 161, 157, 152, 145, 137, 133, 128, 
124, 120, 115, 111, 107, 103,  99,  92,  83,  77,  69,  59,  45,  36,  24, 
  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45,  69,  73, 
 83,  89,  94,  99, 105, 111, 113, 118, 121, 126, 128, 130, 133, 135, 137, 
141, 143, 144, 147, 148, 150, 152, 154, 155, 157, 159, 160, 161, 162, 164, 
165, 167, 167, 169, 169, 170, 170, 172, 173, 173, 174, 175, 176, 176, 177, 
177, 177, 179, 179, 179, 179, 180, 180, 181, 181, 182, 182, 182, 183, 183, 
183, 183, 183, 183, 183, 182, 183, 182, 182, 182, 181, 180, 180, 180, 179, 
177, 177, 176, 175, 174, 173, 170, 170, 169, 167, 165, 164, 161, 160, 159, 
157, 155, 152, 150, 148, 146, 144, 141, 141, 139, 135, 135, 132, 129, 128, 
126, 123, 121, 118, 118, 113, 111, 115, 157, 153, 147, 141, 135, 129, 125, 
121, 116, 113, 109, 105, 102,  94,  86,  80,  73,  64,  53,  45,  36,  12, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  45, 
 64,  73,  80,  89,  94,  99, 105, 111, 113, 118, 121, 124, 128, 130, 132, 
135, 137, 139, 141, 144, 146, 147, 149, 151, 152, 154, 155, 157, 158, 160, 
160, 161, 163, 165, 166, 167, 167, 169, 169, 170, 170, 170, 173, 173, 174, 
174, 174, 174, 176, 176, 176, 176, 176, 176, 177, 177, 177, 179, 178, 179, 
179, 179, 180, 179, 179, 179, 179, 179, 179, 179, 177, 177, 177, 176, 175, 
174, 174, 173, 173, 170, 169, 169, 168, 166, 165, 163, 161, 160, 158, 156, 
154, 152, 151, 148, 146, 144, 141, 140, 139, 136, 133, 132, 130, 128, 126, 
123, 121, 120, 116, 115, 111, 111, 111, 152, 149, 141, 135, 132, 126, 121, 
116, 111, 109, 105, 102,  97,  89,  83,  73,  69,  59,  45,  36,  24,   2, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,  45,  59,  73,  80,  89,  94,  99, 105, 111, 113, 118, 121, 124, 128, 
129, 132, 133, 136, 139, 139, 141, 144, 146, 148, 149, 151, 153, 154, 155, 
157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 168, 169, 169, 170, 
170, 172, 172, 173, 173, 174, 174, 174, 174, 174, 174, 174, 174, 174, 174, 
174, 175, 176, 175, 176, 176, 176, 176, 174, 174, 174, 174, 174, 173, 172, 
172, 170, 170, 169, 169, 167, 166, 165, 164, 161, 160, 160, 158, 156, 154, 
152, 150, 148, 146, 144, 143, 140, 137, 136, 133, 132, 130, 128, 126, 124, 
121, 120, 118, 115, 113, 111, 107, 107, 148, 144, 139, 133, 128, 121, 118, 
113, 109, 105, 102,  99,  92,  86,  80,  69,  64,  53,  45,  24,  12,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  45,  64,  73,  80,  89,  94,  99, 105, 109, 113, 118, 121, 
123, 126, 128, 130, 132, 133, 136, 139, 140, 143, 144, 146, 148, 150, 151, 
152, 153, 155, 156, 157, 158, 159, 160, 161, 163, 163, 165, 165, 166, 167, 
168, 169, 169, 169, 170, 170, 170, 170, 170, 170, 170, 171, 170, 171, 172, 
170, 171, 170, 170, 170, 172, 172, 170, 170, 170, 170, 170, 170, 169, 169, 
169, 168, 167, 166, 165, 164, 163, 161, 160, 160, 158, 156, 155, 153, 152, 
150, 148, 146, 144, 141, 140, 137, 136, 133, 132, 130, 128, 126, 124, 121, 
120, 118, 116, 113, 111, 107, 105, 111, 144, 140, 133, 128, 123, 118, 113, 
109, 105, 102,  97,  94,  89,  80,  73,  64,  53,  45,  36,  12,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  36,  59,  73,  80,  89,  94,  99, 105, 109, 113, 
116, 120, 123, 125, 128, 130, 130, 132, 135, 137, 139, 140, 143, 144, 145, 
147, 148, 150, 151, 152, 154, 155, 157, 158, 158, 159, 160, 161, 161, 164, 
164, 164, 165, 166, 166, 166, 167, 167, 168, 168, 168, 168, 168, 168, 168, 
169, 169, 168, 169, 168, 168, 167, 167, 168, 168, 167, 167, 166, 166, 165, 
165, 164, 163, 162, 163, 161, 160, 159, 158, 156, 155, 154, 152, 151, 149, 
147, 145, 143, 141, 140, 137, 136, 133, 132, 130, 128, 126, 124, 121, 120, 
118, 116, 113, 111, 109, 107, 103, 118, 141, 135, 128, 124, 118, 113, 109, 
103,  99,  97,  94,  89,  83,  77,  69,  59,  45,  36,  24,   2,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,  24,  59,  69,  80,  86,  94,  99, 103, 
107, 111, 115, 118, 121, 123, 126, 128, 130, 132, 133, 133, 136, 137, 140, 
141, 144, 144, 146, 147, 149, 150, 151, 152, 154, 155, 155, 156, 158, 158, 
160, 160, 161, 161, 162, 163, 164, 164, 164, 165, 165, 165, 165, 165, 165, 
165, 165, 165, 165, 165, 165, 164, 164, 164, 163, 163, 163, 163, 163, 161, 
160, 160, 160, 159, 158, 158, 156, 155, 154, 154, 152, 151, 150, 148, 147, 
145, 143, 141, 139, 137, 135, 133, 130, 128, 128, 126, 124, 121, 120, 118, 
115, 113, 111, 107, 107, 105, 102, 120, 136, 129, 124, 118, 113, 109, 103, 
 99,  97,  92,  89,  83,  77,  69,  59,  53,  36,  24,  12,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,  24,  59,  69,  77,  86,  92, 
 97, 102, 107, 111, 115, 118, 120, 121, 124, 126, 128, 130, 130, 133, 133, 
136, 137, 139, 141, 141, 143, 145, 146, 148, 149, 150, 151, 153, 154, 155, 
155, 156, 156, 158, 158, 159, 160, 160, 161, 161, 161, 161, 161, 161, 161, 
161, 161, 163, 161, 161, 161, 161, 161, 161, 161, 160, 160, 159, 158, 158, 
158, 157, 156, 155, 155, 154, 152, 152, 151, 150, 149, 148, 146, 145, 143, 
141, 140, 139, 137, 135, 133, 130, 128, 126, 125, 123, 121, 120, 118, 115, 
113, 111, 109, 107, 105, 102, 102, 129, 132, 125, 118, 113, 107, 103,  99, 
 94,  89,  86,  83,  77,  69,  64,  53,  45,  36,  12,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  59,  69,  77, 
 83,  92,  97, 102, 105, 111, 113, 116, 118, 121, 123, 125, 126, 128, 130, 
130, 132, 133, 135, 136, 137, 140, 141, 143, 143, 145, 146, 148, 149, 150, 
151, 151, 152, 153, 154, 155, 155, 156, 157, 157, 157, 158, 158, 158, 158, 
159, 159, 159, 159, 159, 159, 159, 158, 158, 157, 157, 157, 156, 155, 155, 
154, 154, 153, 152, 151, 150, 150, 148, 148, 147, 146, 144, 143, 141, 140, 
139, 137, 135, 133, 132, 130, 128, 126, 124, 121, 120, 118, 116, 115, 111, 
111, 107, 105, 103, 102,  99, 107, 130, 125, 118, 113, 109, 103,  99,  94, 
 89,  86,  83,  77,  69,  64,  53,  45,  36,  12,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  53, 
 64,  77,  83,  89,  94,  99, 103, 107, 111, 115, 116, 120, 121, 124, 124, 
126, 128, 128, 129, 130, 132, 133, 135, 137, 137, 140, 141, 141, 143, 145, 
145, 147, 148, 149, 149, 150, 151, 152, 152, 153, 153, 154, 154, 155, 155, 
155, 155, 155, 155, 155, 156, 155, 155, 154, 155, 154, 154, 153, 153, 152, 
152, 151, 150, 150, 149, 148, 147, 146, 145, 144, 143, 141, 140, 139, 137, 
136, 135, 133, 130, 129, 128, 126, 123, 121, 118, 118, 116, 113, 111, 111, 
107, 105, 103, 102,  99,  97, 111, 126, 118, 113, 107, 103,  99,  94,  89, 
 83,  80,  77,  73,  64,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,  45,  59,  73,  80,  89,  94,  99, 103, 105, 109, 111, 115, 118, 120, 
121, 123, 124, 126, 126, 128, 129, 129, 130, 132, 133, 135, 136, 137, 139, 
140, 141, 143, 143, 144, 145, 145, 147, 147, 148, 149, 150, 150, 150, 150, 
151, 151, 151, 152, 152, 152, 152, 152, 151, 152, 150, 151, 150, 150, 149, 
149, 148, 147, 146, 146, 145, 144, 143, 141, 141, 139, 139, 137, 135, 135, 
133, 132, 129, 128, 126, 125, 123, 120, 118, 118, 115, 113, 111, 109, 105, 
105, 102,  99,  99,  97,  94, 118, 118, 113, 107,  99,  97,  92,  86,  83, 
 77,  73,  69,  64,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  36,  59,  69,  77,  86,  92,  97,  99, 103, 107, 111, 113, 
115, 118, 118, 121, 123, 123, 124, 126, 128, 128, 128, 129, 130, 132, 133, 
135, 136, 136, 139, 139, 140, 141, 141, 141, 144, 144, 144, 145, 145, 147, 
146, 147, 147, 147, 147, 148, 148, 148, 148, 147, 148, 147, 147, 147, 146, 
146, 144, 144, 143, 143, 141, 141, 140, 139, 139, 137, 135, 133, 133, 132, 
130, 129, 128, 125, 124, 121, 120, 118, 116, 113, 111, 111, 107, 105, 103, 
102,  99,  97,  94,  92,  99, 118, 111, 107,  99,  94,  89,  83,  80,  77, 
 73,  69,  64,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,  24,  53,  64,  77,  83,  89,  94,  99, 102, 105, 
109, 111, 113, 115, 118, 118, 120, 121, 123, 123, 124, 125, 126, 128, 128, 
128, 129, 130, 132, 133, 135, 136, 137, 137, 139, 139, 139, 141, 141, 141, 
141, 141, 143, 143, 144, 143, 143, 144, 143, 144, 144, 144, 144, 143, 143, 
141, 141, 141, 140, 139, 139, 139, 137, 136, 135, 133, 132, 132, 130, 128, 
128, 125, 124, 121, 121, 118, 118, 115, 113, 111, 109, 107, 105, 102,  99, 
 99,  97,  94,  92,  92, 107, 113, 105,  99,  94,  86,  83,  77,  73,  69, 
 64,  59,  53,  45,  36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   2,  45,  59,  73,  77,  86,  92,  94, 
 99, 102, 105, 107, 111, 113, 113, 116, 118, 118, 120, 121, 121, 123, 123, 
124, 125, 126, 126, 128, 128, 129, 130, 132, 133, 133, 135, 136, 136, 137, 
137, 137, 139, 139, 139, 139, 140, 140, 140, 140, 139, 139, 139, 139, 139, 
139, 137, 137, 137, 136, 135, 133, 133, 133, 130, 130, 129, 128, 126, 125, 
124, 123, 120, 118, 118, 116, 113, 111, 109, 107, 105, 103, 102,  99,  97, 
 94,  92,  89,  86,  99, 111, 103,  97,  89,  86,  80,  77,  69,  64,  64, 
 59,  53,  45,  24,  12,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  24,  53,  64,  73,  83, 
 86,  92,  97,  99, 102, 105, 107, 109, 111, 113, 115, 116, 118, 118, 120, 
120, 120, 121, 121, 123, 124, 124, 124, 126, 126, 128, 128, 129, 130, 130, 
132, 132, 133, 133, 133, 133, 135, 135, 135, 135, 135, 135, 135, 135, 135, 
133, 133, 133, 132, 132, 130, 130, 129, 128, 128, 126, 126, 124, 123, 121, 
120, 118, 118, 115, 113, 111, 111, 107, 107, 103, 102,  99,  97,  94,  94, 
 89,  86,  86,  86, 107, 102,  94,  89,  83,  77,  69,  69,  64,  59,  53, 
 45,  36,  24,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  12,  45,  59, 
 69,  80,  83,  89,  94,  97,  99, 102, 103, 107, 109, 111, 111, 113, 113, 
115, 116, 118, 118, 118, 120, 120, 121, 121, 121, 123, 123, 123, 124, 126, 
128, 128, 128, 128, 128, 129, 130, 130, 130, 130, 130, 130, 130, 130, 130, 
129, 129, 129, 128, 128, 128, 126, 126, 124, 123, 123, 121, 120, 118, 118, 
116, 115, 113, 113, 111, 107, 107, 105, 102,  99,  99,  94,  94,  92,  86, 
 86,  83,  83,  99,  99,  94,  86,  80,  73,  69,  64,  59,  53,  45,  45, 
 36,  24,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 24,  53,  59,  73,  80,  83,  89,  94,  94,  99, 102, 103, 105, 107, 107, 
109, 111, 111, 113, 113, 115, 116, 116, 118, 118, 118, 118, 120, 120, 120, 
121, 121, 121, 123, 123, 123, 124, 124, 124, 125, 125, 126, 125, 125, 125, 
125, 124, 124, 124, 123, 123, 121, 121, 120, 120, 118, 118, 116, 115, 113, 
113, 111, 109, 107, 105, 103, 102,  99,  99,  97,  94,  92,  89,  86,  83, 
 80,  83,  94,  99,  89,  83,  77,  69,  64,  59,  53,  53,  45,  36,  24, 
 12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   2,  24,  53,  64,  73,  80,  86,  89,  92,  94,  97,  99, 102, 
103, 103, 105, 107, 107, 109, 111, 111, 111, 111, 113, 113, 115, 115, 116, 
116, 116, 116, 118, 118, 118, 118, 118, 118, 118, 120, 120, 120, 120, 120, 
120, 120, 120, 118, 118, 118, 118, 116, 116, 115, 113, 113, 111, 111, 109, 
107, 105, 105, 103, 102,  99,  97,  97,  94,  92,  89,  86,  83,  80,  77, 
 77,  89,  94,  89,  83,  73,  69,  64,  59,  53,  45,  45,  36,  24,   2, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   2,  36,  53,  64,  73,  77,  83,  86,  89,  92, 
 94,  97,  99,  99, 102, 103, 103, 105, 107, 107, 107, 109, 109, 111, 111, 
111, 111, 111, 113, 111, 113, 113, 113, 113, 113, 113, 113, 115, 115, 113, 
113, 115, 113, 113, 113, 113, 111, 111, 111, 109, 109, 107, 107, 105, 103, 
103,  99,  99,  97,  97,  94,  92,  89,  89,  86,  83,  80,  77,  77,  73, 
 86,  89,  83,  77,  69,  64,  59,  53,  45,  45,  36,  24,  12,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   2,  36,  53,  59,  69,  77,  80, 
 83,  86,  89,  92,  94,  94,  97,  99,  99,  99, 102, 102, 103, 103, 105, 
105, 107, 107, 107, 107, 107, 109, 109, 109, 109, 109, 109, 109, 109, 107, 
109, 109, 109, 107, 107, 107, 107, 105, 105, 103, 103, 102, 102,  99,  99, 
 97,  94,  94,  92,  89,  89,  86,  83,  83,  80,  77,  77,  73,  73,  83, 
 89,  80,  73,  64,  59,  53,  45,  45,  36,  24,  12,   2,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  24,  53,  53, 
 69,  73,  77,  80,  83,  86,  89,  89,  92,  94,  94,  97,  97,  97,  99, 
 99,  99,  99, 102, 102, 103, 103, 103, 103, 103, 103, 103, 103, 103, 105, 
103, 103, 103, 103, 103, 102, 102,  99,  99,  99,  97,  97,  94,  94,  92, 
 92,  89,  89,  86,  86,  83,  80,  80,  77,  73,  69,  69,  69,  80,  83, 
 77,  69,  59,  53,  45,  45,  36,  24,  12,   2,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
 12,  36,  53,  59,  64,  73,  73,  80,  80,  83,  83,  86,  86,  89,  89, 
 92,  92,  94,  94,  94,  94,  94,  97,  97,  97,  97,  97,  99,  99,  97, 
 97,  99,  99,  97,  97,  97,  94,  94,  94,  92,  92,  92,  89,  89,  86, 
 86,  83,  83,  80,  77,  77,  73,  73,  69,  64,  64,  73,  86,  77,  69, 
 59,  53,  45,  45,  36,  24,  12,   2,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   2,  24,  36,  53,  59,  64,  69,  69,  73,  77,  80,  80, 
 83,  83,  83,  86,  86,  89,  89,  89,  89,  89,  89,  92,  92,  92,  89, 
 92,  92,  92,  92,  89,  89,  89,  89,  86,  86,  86,  83,  83,  83,  80, 
 80,  77,  77,  73,  73,  69,  69,  64,  64,  69,  83,  80,  69,  59,  53, 
 45,  36,  24,  24,  12,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   2,  24,  36,  45,  53,  59,  64,  64, 
 69,  69,  73,  73,  77,  77,  77,  80,  80,  80,  80,  80,  83,  83,  83, 
 83,  83,  83,  83,  83,  83,  83,  80,  80,  80,  80,  77,  77,  77,  73, 
 73,  73,  69,  69,  64,  64,  59,  64,  77,  80,  69,  59,  53,  45,  36, 
 24,  12,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  24,  36, 
 45,  53,  59,  59,  59,  64,  64,  69,  69,  69,  69,  69,  69,  73,  73, 
 73,  73,  73,  73,  73,  73,  73,  73,  73,  69,  69,  69,  69,  69,  64, 
 64,  64,  59,  59,  59,  64,  77,  73,  69,  59,  45,  45,  36,  24,   2, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   2,  24,  36,  45,  45,  45,  53,  53,  53,  59,  59,  59,  59, 
 59,  64,  59,  64,  64,  64,  64,  59,  64,  64,  59,  59,  59,  59,  59, 
 53,  53,  59,  69,  73,  64,  59,  53,  45,  24,  24,  12,   2,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   2,  12,  24,  36,  36,  45,  45, 
 45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  53,  59,  59,  64, 
 59,  59,  53,  45,  36,  36,  24,  12,   2,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,   0,   2,  12,  12,  24,  24,  24,  24,  24,  24,  24,  24,  24,  12, 
 12,  12,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0}; 
  
void err_dlg(Widget parent, const char *s)
{
  XmString mesg = XmStringCreateSimple((char *)s);
  Widget dlg;

  dlg = XmCreateErrorDialog(parent, "Error", NULL, 0);
  XtVaSetValues(dlg,
		XmNmessageString, mesg,
		XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		NULL);
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dlg, XmDIALOG_HELP_BUTTON));

  XmStringFree(mesg);
  XtManageChild(dlg);
}


Widget create_loadsave_dialog(Widget w, Widget *radiobox, Widget *label5,
			      Widget *fileSelBox, Widget *text1, Widget *text2,
			      Widget *optionType, Widget *optionMenu,
			      const char *name, const char *lableName,
			      XtCallbackProc cb, WidgetClass wclass)
{
  Widget topshell;
  Arg args[6];
  XmString str1, str2, str3, str4, str5;
  Widget topwin, filesb, label1, label2, type1, type2, type3, form, form1,
  form2, frame1, form3, label3, label4, form4, form5;
  
  topshell = XtVaCreatePopupShell(name, xmDialogShellWidgetClass, w,
				  XmNmappedWhenManaged, False,
				  NULL);
  topwin = XtVaCreateWidget("fopenform", xmFormWidgetClass, topshell,
			    XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
			    NULL);
  
  form = XtVaCreateWidget("fopenform", xmFormWidgetClass, topwin,
			  XmNfractionBase, 2,
			  XmNleftAttachment, XmATTACH_FORM,
			  XmNtopAttachment, XmATTACH_FORM,
			  XmNrightAttachment, XmATTACH_FORM,
			  NULL);
  
  form1 = XtVaCreateWidget("fopenform", xmFormWidgetClass, form,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 0,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_POSITION,
			   XmNtopPosition, 0,
			   XmNbottomAttachment, XmATTACH_POSITION,
			   XmNbottomPosition, 2,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 1,
			   XmNrightOffset, 10,
			   NULL);
  label1 = XtVaCreateManagedWidget("Entity:", xmLabelGadgetClass, form1,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form1,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, label1,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNbottomAttachment, XmATTACH_FORM,
			    NULL);
  str1 = XmStringCreateSimple("Image");
  str2 = XmStringCreateSimple("Image Set");
  str3 = XmStringCreateSimple("Vector");
  str4 = XmStringCreateSimple("Vector Set");
  str5 = XmStringCreateSimple("Eigenvectors");
  *radiobox = XmVaCreateSimpleRadioBox(frame1, "Entity", 0, toggled_cb,
				       XmVaRADIOBUTTON, str1, NULL, NULL, NULL,
				       XmVaRADIOBUTTON, str2, NULL, NULL, NULL,
				       XmVaRADIOBUTTON, str3, NULL, NULL, NULL,
				       XmVaRADIOBUTTON, str4, NULL, NULL, NULL,
				       XmVaRADIOBUTTON, str5, NULL, NULL, NULL,
				       NULL);
  XtManageChild(*radiobox);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4);
  XmStringFree(str5);
  XtManageChild(frame1);
  XtManageChild(form1);

  form2 = XtVaCreateWidget("fopenform", xmFormWidgetClass, form,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 1,
			   XmNtopAttachment, XmATTACH_POSITION,
			   XmNtopPosition, 0,
			   XmNbottomAttachment, XmATTACH_POSITION,
			   XmNbottomPosition, 2,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 2,
			   XmNrightOffset, 10,
			   NULL);
  label2 = XtVaCreateManagedWidget("File type:", xmLabelGadgetClass, form2,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  *optionType = XmCreatePulldownMenu(form2, "options", NULL, 0);
  XtSetArg(args[0], XmNsubMenuId, *optionType);
  XtSetArg(args[1], XmNlabelString, NULL);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[3], XmNtopWidget, label2);
  XtSetArg(args[4], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[5], XmNrightAttachment, XmATTACH_FORM);
  *optionMenu = XmCreateOptionMenu(form2, "typeoption", args, 6);
  XtManageChild(*optionMenu);
  type1 = XtVaCreateManagedWidget("PGM",
				  xmPushButtonGadgetClass,
				  *optionType,
				  NULL);
  XtAddCallback(type1, XmNactivateCallback, typeoption_cb, (XtPointer)0);
  type2 = XtVaCreateManagedWidget("SLAM Binary",
				  xmPushButtonGadgetClass,
				  *optionType,
				  XmNsensitive, False,
				  NULL);
  XtAddCallback(type2, XmNactivateCallback, typeoption_cb, (XtPointer)1);
  type3 = XtVaCreateManagedWidget("Text",
				  xmPushButtonGadgetClass,
				  *optionType,
				  XmNsensitive, False,
				  NULL);
  XtAddCallback(type3, XmNactivateCallback, typeoption_cb, (XtPointer)2);
  
  frame1 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_ETCHED_IN,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, *optionMenu,
			    XmNtopOffset, 20,
			    XmNleftAttachment, XmATTACH_FORM,
			    NULL);
  form3 = XtVaCreateWidget("form", xmFormWidgetClass, frame1,
			   NULL);
  *label5 = XtVaCreateManagedWidget(lableName, wclass, form3,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNleftOffset, 5,
				    NULL);
  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form3,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, *label5,
			   XmNtopOffset, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   NULL);
  label3 = XtVaCreateManagedWidget("X Size:", xmLabelGadgetClass, form4,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  *text1 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form4,
				   XmNvalue, "128",
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, label3,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtManageChild(form4);
  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form3,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form4,
			   XmNtopOffset, 5,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNbottomAttachment, XmATTACH_FORM,
			   XmNbottomOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   NULL);
  label4 = XtVaCreateManagedWidget("Y Size:", xmLabelGadgetClass, form5,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  *text2 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form5,
				   XmNvalue, "128",
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, label4,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  XtManageChild(form5);
  XtManageChild(form3);
  XtManageChild(frame1);
  XtManageChild(form2);

  XtManageChild(form);

  str1 = XmStringCreateSimple("*.pgm");
  filesb = XtVaCreateManagedWidget("File Selection", xmFileSelectionBoxWidgetClass, topwin,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, form,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNpattern, str1,
				   NULL);
  XtAddCallback(filesb, XmNokCallback, cb, NULL);
  *fileSelBox = filesb;
  XmStringFree(str1);
  XtAddCallback(filesb, XmNcancelCallback, pulldown_cb, NULL);
  XtUnmanageChild(XmSelectionBoxGetChild(filesb, XmDIALOG_HELP_BUTTON));
  XtSetArg(args[0], XmNfileSearchProc, &Global::d_defFileSearchProc);
  XtGetValues(filesb, args, 1);
  XtManageChild(topwin);
  return topshell;
}

int main(int argc, char **argv)
{
  char buf[256];
  int i, j, k;
  XColor defs, colors[256];
  XSetWindowAttributes attributes;
  Colormap colormapTopLevel, colormapDrawingArea;
  XtAppContext app;
  Widget topshell, menubar, fmenu, smenu, omenu, hmenu, form1, buttons,
  button1, button2, button3, button4, button5, button6, button7, frame2, form2,
  frame3, frame4, frame5, label, fileSelBox, form3, form4, label1, label2,
  sep1, form5;
  WidgetList wlist;
  Arg arg[3];
  XmString str1, str2, str3, str4;
  XEvent event;
  
  topshell = XtAppInitialize(&app, "xeigen", NULL, 0, &argc, argv, NULL,
			     (ArgList)NULL, (Cardinal)0);
  Global::d_app = app;
  Global::d_display = XtDisplay(topshell);
  Global::d_topshell = topshell;
  if(XMatchVisualInfo(Global::d_display,
		      DefaultScreen(Global::d_display), 8, PseudoColor,
		      &Global::d_vinfo) == 0) {
    cout << "Pseudo Color Visual not found" << endl;
    if(XMatchVisualInfo(Global::d_display,
			DefaultScreen(Global::d_display), 8, GrayScale,
			&Global::d_vinfo) == 0) {
      cout << "Gray Scale Visual not found" << endl;
      if(XMatchVisualInfo(Global::d_display,
			  DefaultScreen(Global::d_display), 8, StaticGray,
			  &Global::d_vinfo) == 0) {
	cout << "Static Gray Visual not found" << endl;
	exit(1);
      }
    }
  }

  colormapTopLevel = XCreateColormap(Global::d_display,
				     RootWindowOfScreen(XtScreen(topshell)),
				     DefaultVisual(Global::d_display, DefaultScreen(Global::d_display)),
				     AllocNone);
  
  if(DefaultDepth(Global::d_display, DefaultScreen(Global::d_display)) == 8)
    XtVaSetValues(topshell,
		  XmNcolormap, colormapTopLevel,
		  NULL);

  form1 = XtVaCreateWidget("mainform", xmFormWidgetClass, topshell,
			   NULL);

  str1 = XmStringCreateSimple("File");
  str2 = XmStringCreateSimple("View");
  str3 = XmStringCreateSimple("Options");
  str4 = XmStringCreateSimple("Help");
  menubar = XmVaCreateSimpleMenuBar(form1, "menubar",
				    XmVaCASCADEBUTTON, str1, 'F',
				    XmVaCASCADEBUTTON, str2, 'V',
				    XmVaCASCADEBUTTON, str3, 'O',
				    XmVaCASCADEBUTTON, str4, 'H',
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4);

  XtVaGetValues(menubar, XmNchildren, &wlist, NULL);

  str1 = XmStringCreateSimple("Load...");
  str2 = XmStringCreateSimple("Save");
  str3 = XmStringCreateSimple("Save As...");
  str4 = XmStringCreateSimple("Quit");
  fmenu = XmVaCreateSimplePulldownMenu(menubar, "fmenu",
				       0, fmenu_cb,
				       XmVaPUSHBUTTON, str1, 'L', NULL, NULL,
				       XmVaPUSHBUTTON, str2, 'S', NULL, NULL,
				       XmVaPUSHBUTTON, str3, 'A', NULL, NULL,
				       XmVaPUSHBUTTON, str4, 'Q', NULL, NULL,
				       NULL);
  XmStringFree(str1);
  XmStringFree(str2);
  XmStringFree(str3);
  XmStringFree(str4); 

  str1 = XmStringCreateSimple("Select...");
  smenu = XmVaCreateSimplePulldownMenu(menubar, "smenu",
				       1, smenu_cb,
				       XmVaPUSHBUTTON, str1, 'S', NULL, NULL,
				       NULL);
  XmStringFree(str1);

  omenu = XmCreatePulldownMenu(menubar, "omenu", NULL, 0);
  XtVaSetValues(wlist[2], XmNsubMenuId, omenu, NULL);
  Global::d_segButton = XtVaCreateManagedWidget("Segmentation",
						xmToggleButtonGadgetClass,
						omenu,
						XmNindicatorType, XmN_OF_MANY,
						NULL);
  XtAddCallback(Global::d_segButton, XmNvalueChangedCallback, omenu_cb,
		(XtPointer)0);
  Global::d_sizeButton = XtVaCreateManagedWidget("Normalize Size",
						 xmToggleButtonGadgetClass,
						 omenu,
						 XmNindicatorType, XmN_OF_MANY,
						 NULL);
  XtAddCallback(Global::d_sizeButton, XmNvalueChangedCallback, omenu_cb,
		(XtPointer)1);
  Global::d_normButton = XtVaCreateManagedWidget("Normalize Brightness",
						 xmToggleButtonGadgetClass,
						 omenu,
						 XmNindicatorType, XmN_OF_MANY,
						 NULL);
  XtAddCallback(Global::d_normButton, XmNvalueChangedCallback, omenu_cb,
		(XtPointer)2);
  XtVaCreateManagedWidget("Separator",
			  xmSeparatorGadgetClass,
			  omenu,
			  XmNorientation, XmHORIZONTAL,
			  XmNseparatorType, XmSHADOW_ETCHED_IN,
			  NULL);
  Global::d_prefButton = XtVaCreateManagedWidget("Preferences...",
						 xmPushButtonGadgetClass,
						 omenu,
						 NULL);
  XtAddCallback(Global::d_prefButton, XmNactivateCallback, omenu_cb,
		(XtPointer)3);

  str1 = XmStringCreateSimple("About...");
  hmenu = XmVaCreateSimplePulldownMenu(menubar, "hmenu",
				       3, hmenu_cb,
				       XmVaPUSHBUTTON, str1, 'A', NULL, NULL,
				       NULL);
  XmStringFree(str1);

  XtManageChild(menubar);

  Global::d_image = new Image(256, 256);
  for(i = k = 0; i < 256; ++i)
    for(j = 0; j < 256; ++j, ++k)
      Global::d_image -> set(j, i, Global::d_surf[k]);
  strcpy(Global::d_dir = new char[3], "./");
  strcpy(Global::d_name = new char[9], "surf.pgm");
  Global::d_ximage = XCreateImage(Global::d_display,
				  Global::d_vinfo.visual,
				  8, ZPixmap, 0, 0,
				  Global::d_image -> getXSize(),
				  Global::d_image -> getYSize(),
				  8,
				  Global::d_image -> getXSize());

  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 3,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 10,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, menubar,
			   XmNtopOffset, 10,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 10,
			   NULL);
  frame3 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_IN,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 0,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNtopPosition, 0,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNrightPosition, 1,
			    XmNbottomAttachment, XmATTACH_POSITION,
			    XmNbottomPosition, 3,
			    NULL);
  Global::d_label1 = XtVaCreateManagedWidget("surf.pgm",
					     xmLabelGadgetClass, frame3,
					     NULL);
  XtManageChild(frame3);
  frame4 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_IN,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 1,
			    XmNleftOffset, 2,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNtopPosition, 0,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNrightPosition, 2,
			    XmNbottomAttachment, XmATTACH_POSITION,
			    XmNbottomPosition, 3,
			    NULL);
  Global::d_label2 = XtVaCreateManagedWidget(NULL,
					     xmLabelGadgetClass, frame4,
					     NULL);
  XtManageChild(frame4);
  frame5 = XtVaCreateWidget("frame", xmFrameWidgetClass, form2,
			    XmNshadowType, XmSHADOW_IN,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNleftPosition, 2,
			    XmNleftOffset, 2,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNtopPosition, 0,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNrightPosition, 3,
			    XmNbottomAttachment, XmATTACH_POSITION,
			    XmNbottomPosition, 3,
			    NULL);
  sprintf(buf, "%u x %u", Global::d_image -> getXSize(),
	  Global::d_image -> getYSize());
  Global::d_label3 = XtVaCreateManagedWidget(buf,
					     xmLabelGadgetClass, frame5,
					     NULL);
  XtManageChild(frame5);
  XtManageChild(form2);

  label1 = XtVaCreateManagedWidget("SLAM - Sameer A. Nene, Shree K. Nayar, Hiroshi Murase",
				   xmLabelGadgetClass, form1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNbottomOffset, 5,
				   NULL);

  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, label1,
				 XmNbottomOffset, 5,
				 NULL);
  
  buttons = XtVaCreateWidget("buttons", xmRowColumnWidgetClass, form1,
			     XmNorientation, XmHORIZONTAL,
			     XmNleftAttachment, XmATTACH_FORM,
			     XmNleftOffset, 10,
			     XmNrightAttachment, XmATTACH_FORM,
			     XmNrightOffset, 10,
			     XmNbottomAttachment, XmATTACH_WIDGET,
			     XmNbottomWidget, sep1,
			     XmNbottomOffset, 10,
			     NULL);
  Global::d_buttons = buttons;
  button1 = XtVaCreateManagedWidget("<<", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button1, XmNarmCallback, animateStepBack_cb, (XtPointer)1);
  XtAddCallback(button1, XmNdisarmCallback, animateStepBack_cb, (XtPointer)0);
  button3 = XtVaCreateManagedWidget("<", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button3, XmNarmCallback, animateStepBack_cb, (XtPointer)50);
  XtAddCallback(button3, XmNdisarmCallback, animateStepBack_cb, (XtPointer)0);
  button5 = XtVaCreateManagedWidget(">", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button5, XmNarmCallback, animateStepFront_cb, (XtPointer)50);
  XtAddCallback(button5, XmNdisarmCallback, animateStepFront_cb, (XtPointer)0);
  button2 = XtVaCreateManagedWidget(">>", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button2, XmNarmCallback, animateStepFront_cb, (XtPointer)1);
  XtAddCallback(button2, XmNdisarmCallback, animateStepFront_cb, (XtPointer)0);
  button6 = XtVaCreateManagedWidget("|<<", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button6, XmNactivateCallback, stepback_cb, NULL);
  button7 = XtVaCreateManagedWidget(">>|", xmPushButtonGadgetClass, buttons,
				    XmNsensitive, False,
				    NULL);
  XtAddCallback(button7, XmNactivateCallback, stepfront_cb, NULL);
  XtManageChild(buttons);

  frame2 = XtVaCreateWidget("frame", xmScrolledWindowWidgetClass, form1,
			    XmNwidth, 440,
			    XmNheight, 260,
			    XmNscrollBarDisplayPolicy, XmAS_NEEDED,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNleftOffset, 10,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, form2,
			    XmNtopOffset, 10,
			    XmNbottomAttachment, XmATTACH_WIDGET,
			    XmNbottomWidget, buttons,
			    XmNbottomOffset, 10,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNrightOffset, 10,
			    NULL);

  Global::d_darea = XtVaCreateManagedWidget("draw",
					    xmDrawingAreaWidgetClass,
					    frame2,
					    NULL);
  
  XtManageChild(frame2);

  XtManageChild(form1);

  XtRealizeWidget(topshell);

  for(i = 0; i < 256; ++i) {
    defs.red = defs.blue = defs.green = i << 8;
    defs.flags = DoRed | DoGreen | DoBlue;
    if(XAllocColor(Global::d_display, colormapTopLevel, &defs) == 0) {
      Global::d_ctrans[i] = Global::d_ctrans[i - 1];
      cout << "Could not allocate gray " << i << endl;
    }
    else
      Global::d_ctrans[i] = defs.pixel;
    colors[i].pixel = i;
  }

  colormapDrawingArea = XCreateColormap(Global::d_display,
					RootWindowOfScreen(XtScreen(topshell)),
					Global::d_vinfo.visual,
					AllocAll);
  
  XQueryColors(Global::d_display, colormapTopLevel, colors, 256);
  XStoreColors(Global::d_display, colormapDrawingArea, colors, 256);

  attributes.background_pixel = 0;
  attributes.border_pixel = 0;
  attributes.colormap = colormapDrawingArea;

  Global::d_drawin = XCreateWindow(Global::d_display,
				   XtWindow(Global::d_darea),
				   0, 0, 512, 480,
				   0, 8, InputOutput,
				   Global::d_vinfo.visual,
				   CWColormap | CWBackPixel | CWBorderPixel,
				   &attributes);
  XSelectInput(Global::d_display, Global::d_drawin, ExposureMask);
  XMapWindow(Global::d_display, Global::d_drawin);
  
  Global::d_gc = XCreateGC(Global::d_display, Global::d_drawin, 0, 0);

  Global::d_loadbox = create_loadsave_dialog(topshell, &Global::d_loadrbox,
					     &Global::d_sizeArea,
					     &fileSelBox, &Global::d_text1,
					     &Global::d_text2,
					     &Global::d_optionType[0],
					     &Global::d_optionMenu[0],
					     "Load...",
					     "View Vectors",
					     filesel_load_cb,
					     xmToggleButtonGadgetClass);
  XtAddCallback(Global::d_sizeArea, XmNvalueChangedCallback, viewv_cb, NULL);
  XtVaSetValues(Global::d_sizeArea,
		XmNset, True,
		XmNsensitive, False,
		NULL);
  XtVaSetValues(Global::d_text1, XmNsensitive, False, NULL);
  XtVaSetValues(Global::d_text2, XmNsensitive, False, NULL);
  XtVaSetValues(Global::d_loadrbox, XmNuserData, fileSelBox, NULL);
  Global::d_savebox = create_loadsave_dialog(menubar, &Global::d_saverbox,
					     &label, &fileSelBox,
					     &Global::d_text3,
					     &Global::d_text4,
					     &Global::d_optionType[1],
					     &Global::d_optionMenu[1],
					     "Save As...",
					     "Image Size:",
					     filesel_save_cb,
					     xmLabelGadgetClass);
  XtVaSetValues(Global::d_saverbox, XmNuserData, fileSelBox, NULL);
  XtVaSetValues(Global::d_text3, XmNsensitive, False, NULL);
  XtVaSetValues(Global::d_text4, XmNsensitive, False, NULL);

  str1 = XmStringCreateSimple("Select:");
  XtSetArg(arg[0], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
  XtSetArg(arg[1], XmNlistLabelString, str1);
  Global::d_selectBox = XmCreateSelectionDialog(menubar, "Select", arg, 2);
  XtUnmanageChild(XmSelectionBoxGetChild(Global::d_selectBox,
					 XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmSelectionBoxGetChild(Global::d_selectBox, XmDIALOG_TEXT));
  XtUnmanageChild(XmSelectionBoxGetChild(Global::d_selectBox,
					 XmDIALOG_SELECTION_LABEL));
  XtAddCallback(Global::d_selectBox, XmNokCallback, selboxok_cb, NULL);
  XtAddCallback(Global::d_selectBox, XmNapplyCallback, selboxok_cb, NULL);
  XmStringFree(str1);

  Global::d_prefBox = XtVaCreatePopupShell("Preferences...",
					   xmDialogShellWidgetClass, menubar,
					   XmNmappedWhenManaged, False,
					   NULL);
  form1 = XtVaCreateWidget("form", xmFormWidgetClass, Global::d_prefBox,
			   XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
			   NULL);
  form2 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNfractionBase, 19,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);
  button1 = XtVaCreateManagedWidget("OK", xmPushButtonGadgetClass, form2,
				    XmNshowAsDefault, True,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 1,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 6,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 18,
				    NULL);
  button2 = XtVaCreateManagedWidget("Apply", xmPushButtonGadgetClass, form2,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 7,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 12,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 18,
				    NULL);
  button3 = XtVaCreateManagedWidget("Dismiss", xmPushButtonGadgetClass, form2,
				    XmNshowAsDefault, False,
				    XmNdefaultButtonShadowThickness, 1,
				    XmNleftAttachment, XmATTACH_POSITION,
				    XmNleftPosition, 13,
				    XmNtopAttachment, XmATTACH_POSITION,
				    XmNtopPosition, 1,
				    XmNrightAttachment, XmATTACH_POSITION,
				    XmNrightPosition, 18,
				    XmNbottomAttachment, XmATTACH_POSITION,
				    XmNbottomPosition, 18,
				    NULL);
  button4 = XtVaCreateManagedWidget("Preserve Aspect Ratio",
				    xmToggleButtonGadgetClass, form1,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNleftOffset, 5,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNtopOffset, 5,
				    NULL);
  label2 = XtVaCreateManagedWidget("Normalize to size:", xmLabelGadgetClass,
				   form1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNleftOffset, 5,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, button4,
				   XmNtopOffset, 5,
				   NULL);
  form3 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, label2,
			   XmNtopOffset, 5,
			   NULL);
  label1 = XtVaCreateManagedWidget("X:", xmLabelGadgetClass, form3,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_nxsize);
  Global::d_text5 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form3,
					    XmNvalue, buf,
					    XmNleftAttachment, XmATTACH_WIDGET,
					    XmNleftWidget, label1,
					    XmNtopAttachment, XmATTACH_FORM,
					    XmNbottomAttachment, XmATTACH_FORM,
					    NULL);
  XtManageChild(form3);
  form4 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, form3,
			   XmNtopOffset, 5,
			   NULL);
  label2 = XtVaCreateManagedWidget("Y:", xmLabelGadgetClass, form4,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_nysize);
  Global::d_text6 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form4,
					    XmNvalue, buf,
					    XmNleftAttachment, XmATTACH_WIDGET,
					    XmNleftWidget, label2,
					    XmNtopAttachment, XmATTACH_FORM,
					    XmNbottomAttachment, XmATTACH_FORM,
					    NULL);
  XtManageChild(form4);
  XtAddCallback(button4, XmNvalueChangedCallback, aspectRatioToggle_cb, Global::d_text6);
  
  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopWidget, form4,
				 XmNtopOffset, 10,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 NULL);
  
  label2 = XtVaCreateManagedWidget("Threshold for Segmentation:",
				   xmLabelGadgetClass,
				   form1,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNleftOffset, 5,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, sep1, 
				   XmNtopOffset, 10,
				   NULL);
  form5 = XtVaCreateWidget("form", xmFormWidgetClass, form1,
			   XmNleftAttachment, XmATTACH_FORM,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_FORM,
			   XmNrightOffset, 5,
			   XmNtopAttachment, XmATTACH_WIDGET,
			   XmNtopWidget, label2,
			   XmNtopOffset, 5,
			   NULL);
  label2 = XtVaCreateManagedWidget("Value:", xmLabelGadgetClass, form5,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);
  sprintf(buf, "%u", Global::d_thresh);
  Global::d_text7 = XtVaCreateManagedWidget("text", xmTextFieldWidgetClass, form5,
					    XmNvalue, buf,
					    XmNleftAttachment, XmATTACH_WIDGET,
					    XmNleftWidget, label2,
					    XmNtopAttachment, XmATTACH_FORM,
					    XmNbottomAttachment, XmATTACH_FORM,
					    NULL);
  XtManageChild(form5);
  sep1 = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass, form1,
				 XmNorientation, XmHORIZONTAL,
				 XmNseparatorType, XmSHADOW_ETCHED_IN,
				 XmNleftAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNtopAttachment, XmATTACH_WIDGET,
				 XmNtopOffset, 15,
				 XmNtopWidget, form5,
				 XmNbottomAttachment, XmATTACH_WIDGET,
				 XmNbottomWidget, form2,
				 NULL);
  XtAddCallback(button1, XmNactivateCallback, prefbox_cb, (XtPointer)0);
  XtAddCallback(button2, XmNactivateCallback, prefbox_cb, (XtPointer)1);
  XtAddCallback(button3, XmNactivateCallback, prefbox_cb, (XtPointer)2);
  XtManageChild(form2);
  XtManageChild(form1);
  
  adjust_ximage(*Global::d_image);

  while(1) {
    XtAppNextEvent(app, &event);
    switch(event.type) {
    case Expose:
      if(event.xexpose.window == Global::d_drawin && event.xexpose.count == 0) {
	paint(0, 0, 0);
	break;
      }
    default:
      XtDispatchEvent(&event);
    }
  }

  return 0;
}
