// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// stringary.C
//
// Author:               Sameer Nene
// Date:                 05/24/94
// Version:              1.0
// Modification History:
// Bugs:
//   Coredumps if an attempt to access a string beyond the number currently
//   present.
//
//   There are no out of memory checks.
//
// Classes:
//   StringAry
//
// Notes:
//   This module contains implementation of classes declared in stringary.h
//   
// ----------------------------------------------------------------------------

#include <memory.h>
#include <string.h>
#include "stringary.h"

StringAry::StringAry(int size) : d_data_p(new char* [size]), d_size(size)
{
  memset(d_data_p, 0, size * sizeof(char *));
}

StringAry::~StringAry()
{
  for(int i = 0; i < d_size; ++i)
    delete[] d_data_p[i];
  delete[] d_data_p;
}

void StringAry::set(int i, const char *str)
{
  delete[] d_data_p[i];
  strcpy(d_data_p[i] = new char [strlen(str) + 1], str);
}

int StringAry::getSize() const
{
  return d_size;
}

char* StringAry::operator[](int i) const
{
  return d_data_p[i];
}
