// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// searchutil.C
//
// Author:               Sameer Nene
// Date:                 05/26/94
// Version:              1.0
// Modification History:
//   08/18/94: Fixed incorrect casting of Persistent to SearchScheme. The
//             typecast *has* to be done via PersistentSearchScheme::safeCast
//
// Bugs:
//
// Classes:
//   SearchUtil
//
// Notes:
//   This module contains implementation of classes declared in searchutil.h
//
// ----------------------------------------------------------------------------

#include "errorscope.h"
#include "ioutil.h"
#include "vector.h"
#include "persscheme.h"
#include "searchutil.h"

ErrorScope::Error SearchUtil::setScheme(const char *filename)
{
  Error error;

  if((error = IOUtil::get(&d_scheme, filename)) != OK)
    return error;

  if(PersistentSearchScheme::safeCast(d_scheme()) == 0)
    return ErrorScope::INCORRECT_FORMAT;
  
  return OK;
}

const VectAry& SearchUtil::getData() const
{
  return (PersistentSearchScheme::safeCast(d_scheme())) -> getData();
}

Vector SearchUtil::search(const Vector &v) const
{
  return (PersistentSearchScheme::safeCast(d_scheme())) -> search(v);
}

void SearchUtil::setSearchParameters(const Vector &v) const
{
  (PersistentSearchScheme::safeCast(d_scheme())) -> setSearchParameters(v);
}
