// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// perscheme.h
//
// Author:               Sameer Nene
// Date:                 06/26/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   PersistentSearchScheme
//
// Notes:
//   
// ----------------------------------------------------------------------------
#ifndef PERSISTENTSEARCHSCHEME_INCLUDED
#define PERSISTENTSEARCHSCHEME_INCLUDED

#ifndef SEARCHSCHEME_INCLUDED
#include "searchscheme.h"
#endif

#ifndef PERSISTENT_INCLUDED
#include "persistent.h"
#endif

class PersistentSearchScheme : public SearchScheme, public Persistent {
  
  // Private Members

  static void* d_protocol;

  // Protected Members
  
protected:

  virtual int hasProtocol(void* protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

public:
  
  // Destructor
  
  virtual ~PersistentSearchScheme() {}

  // Accessor
  
  static PersistentSearchScheme* safeCast(Persistent*);
  // Converts Persistent pointer to a PersistentSearchScheme pointer if the
  // object pointed to by Persistent is in fact a PersistentSearchScheme

};

#endif
