// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// persinterp.h
//
// Author:               Sameer Nene
// Date:                 06/26/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   PersistentInterpolation
//
// Notes:
//   
// ----------------------------------------------------------------------------
#ifndef PERSISTENTINTERPOLATION_INCLUDED
#define PERSISTENTINTERPOLATION_INCLUDED

#ifndef INTERPOLATION_INCLUDED
#include "interpolation.h"
#endif

#ifndef PERSISTENT_INCLUDED
#include "persistent.h"
#endif

class PersistentInterpolation : public Interpolation, public Persistent {
  
  // Private Members

  static void* d_protocol;
  static void *d_ipProtocol;

  // Protected Members
  
protected:

  virtual int hasInterpolationProtocol(void *protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

  virtual int hasProtocol(void* protocol) const;
  // returns 1 if this object is of type(protocol) protocol OR is derived
  // from an object of type(protocol) protocol

public:
  
  // Destructor
  
  virtual ~PersistentInterpolation() {}

  // Accessor
  
  static PersistentInterpolation* safeCast(Persistent*);
  // Converts Persistent pointer to a PersistentInterpolation pointer if the
  // object pointed to by Persistent is in fact a PersistentInterpolation

  static PersistentInterpolation* safeCast(Interpolation*);
  // Converts Interpolation pointer to a PersistentInterpolation pointer if the
  // object pointed to by Interpolation is also a PersistentInterpolation

};

#endif
