// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// persinterp.C
//
// Author:               Sameer Nene
// Date:                 06/26/94
// Version:              1.0
// Modification History:
// Bugs:
//
// Classes:
//   PersistentInterpolation
//
// Notes:
//   
// ----------------------------------------------------------------------------
#include "interpolation.h"
#include "persistent.h"
#include "persinterp.h"

void* PersistentInterpolation::d_protocol = &PersistentInterpolation::d_protocol;

void* PersistentInterpolation::d_ipProtocol = &PersistentInterpolation::d_ipProtocol;

int PersistentInterpolation::hasProtocol(void* protocol) const
{
  return d_protocol == protocol;
}

int PersistentInterpolation::hasInterpolationProtocol(void *protocol) const
{
  return d_ipProtocol == protocol;
}

PersistentInterpolation* PersistentInterpolation::safeCast(Persistent *p)
{
  return p -> hasProtocol(d_protocol) ? (PersistentInterpolation*)p : 0;
}

PersistentInterpolation* PersistentInterpolation::safeCast(Interpolation *ip)
{
  return ip -> hasInterpolationProtocol(d_ipProtocol) ? (PersistentInterpolation*)ip : 0;
}
