// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// ninterpolation.h
//
// Author:               Sameer Nene
// Date:                 08/28/94
// Version:              1.0
// Modification History:
//
// Bugs:
//
// Classes:
//   NamedInterpolation
//
// Notes:
//   Private class. Not for public use.
//   
// ----------------------------------------------------------------------------

#ifndef NAMEDINTERPOLATION_INCLUDED
#define NAMEDINTERPOLATION_INCLUDED

#ifndef INTERPOLATION_INCLUDED
#include "interpolation.h"
#endif

#ifndef VECTOR_INCLUDED
#include "vector.h"
#endif

#include <X11/PEX5/PEXlib.h>

class NamedInterpolation {

  char *d_name_p;
  int d_visible, d_dmap1, d_dmap2, d_sfreq1, d_sfreq2;
  Vector *d_param_p;
  Interpolation *d_ip;
  PEXStructure d_sid;
  PEXCoord d_min, d_max;

public:

  enum {INVISIBLE = 0, VISIBLE = 1};
  
  NamedInterpolation();
  NamedInterpolation(const char *name, Interpolation *ip);
  ~NamedInterpolation();

  void interpolation(Interpolation *ip);
  void rename(const char *name);
  void constructPEXStruct();
  void makeVisible();
  void makeInvisible();
  void setDimensionMap(int dmap1, int dmap2);
  void setSamplingFreq(int sfreq1, int sfreq2);
  void setSamplingParams(const Vector &param);

  const char* dataName() const;
  Interpolation* interpolation() const;
  PEXStructure getPEXStruct() const;
  int getVisibility() const;
  void getExtents(PEXCoord *min, PEXCoord *max) const;
  void getDimensionMap(int *dmap1, int *dmap2) const;
  void getSamplingFreq(int *sfreq1, int *sfreq2) const;
  Vector getSamplingParams() const;

};

extern void translate(const Vector &v, PEXCoord *pt);
extern void adjustRange(const PEXCoord &pt, PEXCoord *d_min, PEXCoord *d_max);
extern PEXColorRGB allocColor();

#endif
