// ----------------------------------------------------------------------------
//
// Copyright (C) Columbia University, 1994. All Rights Reserved.
// Sameer A. Nene, Shree K. Nayar, Hiroshi Murase
//
// See file LICENSE for details of software license agreement.
//
// ----------------------------------------------------------------------------
//
// ndataset.h
//
// Author:               Sameer Nene
// Date:                 08/28/94
// Version:              1.0
// Modification History:
//
// Bugs:
//
// Classes:
//   NamedDataSet
//
// Notes:
//   Private class. Not for public use.
//   
// ----------------------------------------------------------------------------

#ifndef NAMEDDATASET_INCLUDED
#define NAMEDDATASET_INCLUDED

#ifndef DATASET_INCLUDED
#include "dataset.h"
#endif

#include <X11/PEX5/PEXlib.h>

class NamedDataSet : public DataSet {
  
  char *d_name_p;
  int d_visible;
  PEXStructure d_sid;
  PEXCoord d_min, d_max;

  // NamedDataSets cannot be copied or assigned

  NamedDataSet(const NamedDataSet&);
  NamedDataSet& operator=(const NamedDataSet&);
  
public:

  enum {INVISIBLE = 0, VISIBLE = 1};
  
  NamedDataSet();
  NamedDataSet(const char *name, int n, int l);
  ~NamedDataSet();
  
  void rename(const char *name);
  void constructPEXStruct();
  void makeVisible();
  void makeInvisible();

  const char* dataName() const;
  PEXStructure getPEXStruct() const;
  int getVisibility() const;
  void getExtents(PEXCoord *min, PEXCoord *max) const;

};

extern void translate(const Vector &v, PEXCoord *pt);
extern void adjustRange(const PEXCoord &pt, PEXCoord *d_min, PEXCoord *d_max);
extern PEXColorRGB allocColor();

#endif
